/*************************************************************************
 *
 *  $RCSfile: access.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_ACCESS_CXX

#include <tools/debug.hxx>
#include <salwtype.hxx>
#include <svdata.hxx>
#include <access.hxx>
#include <window.hxx>
#include <menu.hxx>
#include <toolbox.hxx>
#include <button.hxx>
#include <tabctrl.hxx>
#include <svapp.hxx>
#include <windata.hxx>

// =======================================================================

#define ACCESS_DATA_TABPAGE 0x00000001L

// =======================================================================

AccessNotification::AccessNotification( ULONG nEvent, const Window* pWindow ) :
	mnEvent 	( nEvent ),
	mpWindow	( pWindow ),
	mpMenu		( NULL ),
	mpToolBox	( NULL ),
	mnData1 	( 0L ),
	mnData2 	( 0L ),
	mnData3 	( 0L )
{
}

// ------------------------------------------------------------------------

AccessNotification::AccessNotification( ULONG nEvent, const Menu* pMenu ) :
	mnEvent 	( nEvent ),
	mpWindow	( NULL ),
	mpMenu		( pMenu ),
	mpToolBox	( NULL ),
	mnData1 	( 0L ),
	mnData2 	( 0L ),
	mnData3 	( 0L )
{
}

// ------------------------------------------------------------------------

AccessNotification::AccessNotification( ULONG nEvent, const ToolBox* pToolBox ) :
	mnEvent 	( nEvent ),
	mpWindow	( NULL ),
	mpMenu		( NULL ),
	mpToolBox	( pToolBox ),
	mnData1 	( 0L ),
	mnData2 	( 0L ),
	mnData3 	( 0L )
{
}

// ------------------------------------------------------------------------

AccessNotification::AccessNotification( ULONG nEvent, long nData1, long nData2, long nData3 ) :
	mnEvent 	( nEvent ),
	mpWindow	( NULL ),
	mpMenu		( NULL ),
	mpToolBox	( NULL ),
	mnData1 	( nData1 ),
	mnData2 	( nData2 ),
	mnData3 	( nData3 )
{
}

// ------------------------------------------------------------------------

AccessNotification::~AccessNotification()
{
}

// ------------------------------------------------------------------------

AccessObjectRef AccessNotification::GetAccessObject()
{
	if( mpWindow )
		mpWindow->GetAccessObject( maDummyAcc );
	else if( mpMenu )
		mpMenu->GetAccessObject( maDummyAcc );
	else if( mpToolBox )
		mpToolBox->GetAccessObject( maDummyAcc );
	else if( ACCESS_EVENT_KEY == mnEvent )
		maDummyAcc = new AccessObject( NULL, ACCESS_TYPE_KEY, mnData1, mnData2, mnData3 );

	return maDummyAcc;
}

// =======================================================================

TYPEINIT0( AccessObject );

// ------------------------------------------------------------------------

AccessObject::AccessObject( void* pType, ULONG nType, long nData1, long nData2, long nData3 ) :
	mpType			( pType ),
	mnInternalType	( nType ),
	mnData1 		( nData1 ),
	mnData2 		( nData2 ),
	mnData3 		( nData3 )
{
}

// ------------------------------------------------------------------------

AccessObject::~AccessObject()
{
}

// ------------------------------------------------------------------------

AccessObjectRef AccessObject::Navigate( AccNavigate eNavigate )
{
	AccessObjectRef aAccRef;

	if ( ACC_NAVIGATE_SELF == eNavigate )
		aAccRef = new AccessObject( mpType, mnInternalType, mnData1, mnData2, mnData3 );
	else if ( mpType )
	{
		switch ( mnInternalType )
		{
			case ACCESS_TYPE_WND:
				{
				if ( ((Window*)mpType)->GetType() == WINDOW_TABCONTROL )
					aAccRef = ImplNavigateTabControl( (TabControl*)mpType, eNavigate );
				else
					aAccRef = ImplNavigateWnd( (Window*)mpType, eNavigate );
				}
				break;

			case ACCESS_TYPE_MENUBAR:
			case ACCESS_TYPE_MENU:
				aAccRef = ImplNavigateMenu( (Menu*)mpType, eNavigate );
				break;

			case ACCESS_TYPE_MENUITEM:
				aAccRef = ImplNavigateMenuItem( (Menu*)mpType, eNavigate );
				break;

			case ACCESS_TYPE_KEY:
				break;

			default:
				break;
		}
	}

	return aAccRef;
}

// ------------------------------------------------------------------------

AccessObjectRef AccessObject::ImplNavigateWnd( Window* pWin, AccNavigate eNavigate )
{
	AccessObjectRef aAcc;
	Window* 		pNewWin;

	switch ( eNavigate )
	{
		case ACC_NAVIGATE_PREV:
			pNewWin = pWin->GetWindow( WINDOW_PREV );
			break;
		case ACC_NAVIGATE_NEXT:
			pNewWin = pWin->GetWindow( WINDOW_NEXT );
			break;
		case ACC_NAVIGATE_PARENT:
			pNewWin = pWin->GetWindow( WINDOW_PARENT );
			break;
		case ACC_NAVIGATE_CHILD:
			pNewWin = pWin->GetWindow( WINDOW_FIRSTCHILD );
			break;

		default:
			pNewWin = NULL;
			break;
	}

	if ( pNewWin )
		aAcc = new AccessObject( pNewWin, ACCESS_TYPE_WND );

	return aAcc;
}

// ------------------------------------------------------------------------

AccessObjectRef AccessObject::ImplNavigateTabControl( TabControl* pTab, AccNavigate eNavigate )
{
	AccessObjectRef aAcc;

	if ( mnData1 )
	{
		const USHORT	nCount = pTab->GetPageCount();
		const USHORT	nId = (USHORT) mnData1;
		USHORT			nPos = pTab->GetPagePos( nId );

		if( ACC_NAVIGATE_NEXT == eNavigate )
		{
			if ( nCount && ( nPos < ( nCount - 1 ) ) )
				aAcc = new AccessObject( pTab, ACCESS_TYPE_WND, pTab->GetPageId( ++nPos ) );
		}
		else if( ACC_NAVIGATE_PREV == eNavigate )
		{
			if ( nCount && nPos )
				aAcc = new AccessObject( pTab, ACCESS_TYPE_WND, pTab->GetPageId( --nPos ) );
		}
		else if( ACC_NAVIGATE_CHILD == eNavigate )
		{
			if ( (pTab->GetCurPageId() == nId) && pTab->GetTabPage( nId ) )
				aAcc = ImplNavigateWnd( (Window*)pTab->GetTabPage( nId ), ACC_NAVIGATE_CHILD );
		}
		else
			aAcc = ImplNavigateWnd( pTab, ACC_NAVIGATE_PARENT );
	}
	else
	{
		if ( ACC_NAVIGATE_CHILD == eNavigate && pTab->GetPageCount() )
			aAcc = new AccessObject( pTab, ACCESS_TYPE_WND, pTab->GetPageId( 0 ) );
		else
			aAcc = ImplNavigateWnd( pTab, eNavigate );
	}

	return aAcc;
}

// ------------------------------------------------------------------------

AccessObjectRef AccessObject::ImplNavigateMenu( Menu* pMenu, AccNavigate eNavigate )
{
	AccessObjectRef aAcc;

	if ( (ACC_NAVIGATE_CHILD == eNavigate) && pMenu->GetItemCount() )
		aAcc = new AccessObject( pMenu, ACCESS_TYPE_MENUITEM, pMenu->GetItemId( 0 ) );

	return aAcc;
}

// ------------------------------------------------------------------------

AccessObjectRef AccessObject::ImplNavigateMenuItem( Menu* pMenu, AccNavigate eNavigate )
{
	AccessObjectRef aAccRef;
	USHORT			nPos = pMenu->GetItemPos( (USHORT) mnData1 );

	while ( ++nPos < pMenu->GetItemCount() )
	{
		// skip disabled items
		if ( !pMenu->IsItemEnabled( pMenu->GetItemId( nPos ) ) )
			continue;

		// iterate until we find the next string item
		const MenuItemType eType = pMenu->GetItemType( nPos );

		if ( MENUITEM_DONTKNOW == eType )
			break;
		else if ( (MENUITEM_STRING == eType) || (MENUITEM_STRINGIMAGE == eType) )
		{
			aAccRef = new AccessObject( pMenu,	ACCESS_TYPE_MENUITEM, pMenu->GetItemId( nPos ) );
			break;
		}
	}

	return aAccRef;
}

// ------------------------------------------------------------------------

void AccessObject::Execute( long nExternalData )
{
	switch ( mnInternalType )
	{
		case ACCESS_TYPE_MENUITEM:
			{
			if ( ((Menu*)mpType)->bIsMenuBar )
				((MenuBar*)mpType)->SelectEntry( (USHORT) mnData1 );
			else
				((PopupMenu*)mpType)->SelectEntry( (USHORT) mnData1 );
			}
			break;

		case ACCESS_TYPE_WND:
			{
			WindowType eType = ((Window*)mpType)->GetType();

			switch( eType )
			{
				case WINDOW_BUTTON:
				case WINDOW_PUSHBUTTON:
				case WINDOW_OKBUTTON:
				case WINDOW_CANCELBUTTON:
				case WINDOW_HELPBUTTON:
				case WINDOW_IMAGEBUTTON:
				case WINDOW_MENUBUTTON:
				case WINDOW_MOREBUTTON:
					((Button*)mpType)->Click();
					break;

				case WINDOW_RADIOBUTTON:
				case WINDOW_IMAGERADIOBUTTON:
					{
					RadioButton* mpRadio = (RadioButton*)mpType;
					if ( !mpRadio->IsChecked() )
						mpRadio->Check( TRUE );
					mpRadio->GrabFocus();
					}
					break;

				case WINDOW_CHECKBOX:
				case WINDOW_TRISTATEBOX:
					{
					CheckBox* mpCheck = (CheckBox*) mpType;
					mpCheck->Check( !mpCheck->IsChecked() );
					mpCheck->GrabFocus();
					}
					break;

				case WINDOW_FIXEDTEXT:
					{
					AccessObjectRef aNext = Navigate( ACC_NAVIGATE_NEXT );

					if ( aNext.Is() )
					{
						if ( aNext->mnInternalType == ACCESS_TYPE_WND )
						{
							Window* pWin = (Window*)aNext->mpType;

							if ( (pWin->GetStyle() & WB_TABSTOP) )
								pWin->GrabFocus();
						}
					}
					}
					break;

				case WINDOW_TABCONTROL:
					{
					if ( mnData1 )
					{
						TabControl* mpTab = (TabControl*)mpType;
						mpTab->SelectTabPage( (USHORT) mnData1 );
					}
					}
					break;

				case WINDOW_EDIT:
				case WINDOW_MULTILINEEDIT:
				case WINDOW_COMBOBOX:
				case WINDOW_LISTBOX:
				case WINDOW_PATTERNFIELD:
				case WINDOW_NUMERICFIELD:
				case WINDOW_METRICFIELD:
				case WINDOW_CURRENCYFIELD:
				case WINDOW_DATEFIELD:
				case WINDOW_TIMEFIELD:
					((Window*)mpType)->GrabFocus();
				break;

			}
			}
			break;

#ifndef REMOTE_APPSERVER
		case ACCESS_TYPE_KEY:
			{
			Window* pWin = Application::GetFocusWindow();

			if ( pWin )
			{
				const SalKeyEvent aKeyEvt = { Time::GetSystemTicks(), (USHORT)mnData1, 0, 1 };
				ImplWindowFrameProc( pWin, NULL, SALEVENT_KEYINPUT, &aKeyEvt );
				ImplWindowFrameProc( pWin, NULL, SALEVENT_KEYUP, &aKeyEvt );
			}
			}
		break;
#endif

		default:
		break;
	}
}

// ------------------------------------------------------------------------

XubString AccessObject::GetText()
{
	XubString aStr;

	switch ( mnInternalType )
	{
		case ACCESS_TYPE_WND:
			{
			Window* pWin = (Window*) mpType;
			if ( (pWin->GetType() == WINDOW_TABCONTROL) && mnData1 )
				aStr = ( (TabControl*) pWin )->GetPageText( (USHORT)mnData1 );
			else
				aStr = pWin->GetText();
			}
			break;

		case ACCESS_TYPE_TOOLBOX:
		case ACCESS_TYPE_TOOLBOXITEM:
		case ACCESS_TYPE_MENUBAR:
		case ACCESS_TYPE_MENU:
			break;

		case ACCESS_TYPE_MENUITEM:
			aStr = ((Menu*)mpType)->GetItemText( (USHORT)mnData1 );
			break;

		default:
			break;
	}

	return aStr;
}

// ------------------------------------------------------------------------

XubString AccessObject::GetDescription()
{
	XubString aStr;

/* Currently not used !!!
	switch ( mnInternalType )
	{
		case ACCESS_TYPE_WND:
		case ACCESS_TYPE_TOOLBOX:
		case ACCESS_TYPE_TOOLBOXITEM:
		case ACCESS_TYPE_MENUBAR:
		case ACCESS_TYPE_MENU:
		case ACCESS_TYPE_MENUITEM:
			break;

		default:
			break;
	}
*/

	return aStr;
}

// ------------------------------------------------------------------------

XubString AccessObject::GetQuickHelpText()
{
	XubString aStr;

	switch ( mnInternalType )
	{
		case ACCESS_TYPE_WND:
			aStr = ((Window*)mpType)->GetQuickHelpText();
			break;

		case ACCESS_TYPE_TOOLBOX:
		case ACCESS_TYPE_TOOLBOXITEM:
		case ACCESS_TYPE_MENUBAR:
		case ACCESS_TYPE_MENU:
			break;

		case ACCESS_TYPE_MENUITEM:
			aStr = ((Menu*)mpType)->GetHelpText( (USHORT)mnData1 );
			break;

		default:
			break;
	}

	return aStr;
}

// ------------------------------------------------------------------------

XubString AccessObject::GetHelpText()
{
	XubString aStr;

	switch ( mnInternalType )
	{
		case ACCESS_TYPE_WND:
			aStr = ((Window*)mpType)->GetHelpText();
			break;

		case ACCESS_TYPE_TOOLBOX:
		case ACCESS_TYPE_TOOLBOXITEM:
		case ACCESS_TYPE_MENUBAR:
		case ACCESS_TYPE_MENU:
			break;

		case ACCESS_TYPE_MENUITEM:
			aStr = ((Menu*)mpType)->GetHelpText( (USHORT) mnData1 );
			break;

		default:
			break;
	}

	return aStr;
}

// ------------------------------------------------------------------------

XubString AccessObject::GetType()
{
	const sal_Char* pStr = NULL;

	switch ( mnInternalType )
	{
		case ACCESS_TYPE_WND:
		{
			const WindowType eType = ((Window*)mpType)->GetType();

			switch ( eType )
			{
				case WINDOW_MESSBOX:			pStr = "MessBox"; break;
				case WINDOW_INFOBOX:			pStr = "InfoBox"; break;
				case WINDOW_WARNINGBOX: 		pStr = "WarningBox"; break;
				case WINDOW_ERRORBOX:			pStr = "ErrorBox"; break;
				case WINDOW_QUERYBOX:			pStr = "QueryBox"; break;
				case WINDOW_WINDOW: 			pStr = "Window"; break;
				case WINDOW_SYSWINDOW:			pStr = "SystemWindow"; break;
				case WINDOW_WORKWINDOW: 		pStr = "WorkWindow"; break;
				case WINDOW_FLOATINGWINDOW: 	pStr = "FloatingWindow"; break;
				case WINDOW_DIALOG: 			pStr = "Dialog"; break;
				case WINDOW_MODELESSDIALOG: 	pStr = "ModelessDialog"; break;
				case WINDOW_MODALDIALOG:		pStr = "ModalDialog"; break;
				case WINDOW_SYSTEMDIALOG:		pStr = "SystemDialog"; break;
				case WINDOW_PATHDIALOG: 		pStr = "PathDialog"; break;
				case WINDOW_FILEDIALOG: 		pStr = "FileDialog"; break;
				case WINDOW_PRINTERSETUPDIALOG: pStr = "PrinterSetupDialog"; break;
				case WINDOW_PRINTDIALOG:		pStr = "PrintDialog"; break;
				case WINDOW_COLORDIALOG:		pStr = "ColorDialog"; break;
				case WINDOW_FONTDIALOG: 		pStr = "FontDialog"; break;
				case WINDOW_CONTROL:			pStr = "Control"; break;
				case WINDOW_BUTTON: 			pStr = "Button"; break;
				case WINDOW_PUSHBUTTON: 		pStr = "PushButton"; break;
				case WINDOW_OKBUTTON:			pStr = "OKButton"; break;
				case WINDOW_CANCELBUTTON:		pStr = "CancelButton"; break;
				case WINDOW_HELPBUTTON: 		pStr = "HelpButton"; break;
				case WINDOW_IMAGEBUTTON:		pStr = "ImageButton"; break;
				case WINDOW_MENUBUTTON: 		pStr = "MenuButton"; break;
				case WINDOW_MOREBUTTON: 		pStr = "MoreButton"; break;
				case WINDOW_SPINBUTTON: 		pStr = "SpinButton"; break;
				case WINDOW_RADIOBUTTON:		pStr = "RadioButton"; break;
				case WINDOW_IMAGERADIOBUTTON:	pStr = "ImageRadioButton"; break;
				case WINDOW_CHECKBOX:			pStr = "CheckBox"; break;
				case WINDOW_TRISTATEBOX:		pStr = "TriStateBox"; break;
				case WINDOW_EDIT:				pStr = "Edit"; break;
				case WINDOW_MULTILINEEDIT:		pStr = "MultilineEdit"; break;
				case WINDOW_COMBOBOX:			pStr = "ComboBox"; break;
				case WINDOW_LISTBOX:			pStr = "ListBox"; break;
				case WINDOW_MULTILISTBOX:		pStr = "MultiListBox"; break;
				case WINDOW_FIXEDTEXT:			pStr = "FixedText"; break;
				case WINDOW_FIXEDLINE:			pStr = "FxedLine"; break;
				case WINDOW_FIXEDBITMAP:		pStr = "FixedBitmap"; break;
				case WINDOW_FIXEDIMAGE: 		pStr = "FixedImage"; break;
				case WINDOW_GROUPBOX:			pStr = "GroupBox"; break;
				case WINDOW_SCROLLBAR:			pStr = "Scrollbar"; break;
				case WINDOW_SCROLLBARBOX:		pStr = "ScrollbarBox"; break;
				case WINDOW_SPLITTER:			pStr = "Splitter"; break;
				case WINDOW_SPLITWINDOW:		pStr = "SplitWindow"; break;
				case WINDOW_SPINFIELD:			pStr = "SpinField"; break;
				case WINDOW_PATTERNFIELD:		pStr = "Patternfield"; break;
				case WINDOW_NUMERICFIELD:		pStr = "NumericField"; break;
				case WINDOW_METRICFIELD:		pStr = "MetricField"; break;
				case WINDOW_CURRENCYFIELD:		pStr = "CurrencyField"; break;
				case WINDOW_DATEFIELD:			pStr = "DateField"; break;
				case WINDOW_TIMEFIELD:			pStr = "TimeField"; break;
				case WINDOW_PATTERNBOX: 		pStr = "PatternBox"; break;
				case WINDOW_NUMERICBOX: 		pStr = "NumericBox"; break;
				case WINDOW_METRICBOX:			pStr = "MetricBox"; break;
				case WINDOW_CURRENCYBOX:		pStr = "CurrencyBox"; break;
				case WINDOW_DATEBOX:			pStr = "DateBox"; break;
				case WINDOW_TIMEBOX:			pStr = "TimeBox"; break;
				case WINDOW_LONGCURRENCYFIELD:	pStr = "LongCurrencyField"; break;
				case WINDOW_LONGCURRENCYBOX:	pStr = "LongCurrencyBox"; break;
				case WINDOW_TOOLBOX:			pStr = "Toolbox"; break;
				case WINDOW_DOCKINGWINDOW:		pStr = "DockingWindow"; break;
				case WINDOW_STATUSBAR:			pStr = "StatusBar"; break;
				case WINDOW_TABPAGE:			pStr = "TabPage"; break;
				case WINDOW_TABCONTROL: 		pStr = "TabControl"; break;
				case WINDOW_TABDIALOG:			pStr = "TabDialog"; break;
				case WINDOW_BORDERWINDOW:		pStr = "BorderWindow"; break;
				case WINDOW_BUTTONDIALOG:		pStr = "ButtonDialog"; break;
				case WINDOW_SYSTEMCHILDWINDOW:	pStr = "SystemChildWindow"; break;

				default:
					DBG_ERROR( "AccessObject::GetType(): unknown window type!" );
					break;
			}
		}
		break;

		case ACCESS_TYPE_TOOLBOX:
		case ACCESS_TYPE_TOOLBOXITEM:
			break;

		case ACCESS_TYPE_MENUBAR:
		case ACCESS_TYPE_MENU:
			{
			Menu* pMenu = (Menu*)mpType;

			if ( pMenu->bIsMenuBar )
				pStr = "MenuBar";
			else
				pStr = "Menu";
			}
			break;

		case ACCESS_TYPE_MENUITEM:
			{
			Menu* pMenu = (Menu*) mpType;

			switch( pMenu->GetItemType( pMenu->GetItemPos( (USHORT) mnData1 ) ) )
			{
				case MENUITEM_STRING:		pStr = "MenuItemString"; break;
				case MENUITEM_IMAGE:		pStr = "MenuItemImage"; break;
				case MENUITEM_STRINGIMAGE:	pStr = "MenuItemStringImage"; break;
				case MENUITEM_SEPARATOR:	pStr = "MenuItemSeparator"; break;

				default:
					pStr = "MenuItemDontKnow";
				break;
			}
			}
			break;

		default:
			break;
	}

	XubString aStr;
	if ( pStr )
		aStr.AssignAscii( pStr );
	return aStr;
}

// ------------------------------------------------------------------------

XubString AccessObject::GetState()
{
	return ImplGetSVEmptyStr();
}

// ------------------------------------------------------------------------

XubString AccessObject::GetValue()
{
	return ImplGetSVEmptyStr();
}
