/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_stgifc.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:05:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_L_STGIFC_HXX
#define ARY_STORE_L_STGIFC_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <cosv/ploc.hxx>


namespace ary
{

    namespace loc
    {
        class LocationRoot;
        class SubDirectory;
        class SourceCodeFile;
    }

namespace store
{
    class Locations;


class Locations_Ifc
{
  public:
	// LIFECYCLE
						Locations_Ifc(
                            ary::store::Locations &
                                                i_rLocStorage );
						~Locations_Ifc();

	// OPERATIONS
    void                Add_Root(
                            DYN ary::loc::LocationRoot &
                                                let_drRoot );
    void                Add_SubDirectory(
                            DYN ary::loc::SubDirectory &
                                                let_drDir );
    void                Add_File(
                            DYN ary::loc::SourceCodeFile &
                                                let_drFile );
    // INQUIRY

    // ACCESS
    ary::loc::LocationRoot *
                        Find_Root(
                            Lid                 i_nId );
    ary::loc::SubDirectory *
                        Find_SubDirectory(
                            Lid                 i_nId );
    ary::loc::SourceCodeFile *
                        Find_File(
                            Lid                 i_nId );
    ary::loc::LocationRoot *
                        Search_Root(
                            const csv::ploc::Path &
                                                i_rPath );
  private:
    struct CheshireCat;

    // DATA
    Dyn<CheshireCat>    pi;
};



// IMPLEMENTATION



}   // namespace store
}   // namespace ary



#endif

