/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtmode2.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:45:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _STREAM_HXX
// enable stream operators >>/<< for UniString (8 Bit !)
#ifndef ENABLE_STRING_STREAM_OPERATORS
#define ENABLE_STRING_STREAM_OPERATORS
#endif
#include <tools/stream.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>
#endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <svx/svdmark.hxx>

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _ZFORMAT_HXX //autogen
#include <svtools/zformat.hxx>
#endif
// header for getProcessServiceFactory
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "chmod3d.hxx" //SchRectObj

#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#define ITEMID_FONT        EE_CHAR_FONTINFO
#if SUPD > 364
#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>
#include <svx/fontitem.hxx>
#endif
#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "globfunc.hxx"
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_SCHIOCMP_HXX
#include "schiocmp.hxx"
#endif

#include "strings.hrc"
#include "glob.hrc"

#if SUPD > 364
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#include <svx/fontitem.hxx>
#else
#include <textitem.hxx>
#endif

#ifndef _TOOLS_TENCCVT_HXX
#include <tools/tenccvt.hxx>
#endif

#include "pairs.hxx"
#include "chaxis.hxx"

#include "chdescr.hxx"
#include "calculat.hxx"


/************************************************************************/
const USHORT nCompatAxisWhichPairs[] =
{
	SCHATTR_TEXT_START, SCHATTR_TEXT_END,
	SCHATTR_Y_AXIS_START, SCHATTR_Z_AXIS_END, //X-Z!
	SCHATTR_AXISTYPE, SCHATTR_AXISTYPE,
	SCHATTR_TEXT_DEGREES,SCHATTR_TEXT_DEGREES,
	SCHATTR_TEXT_OVERLAP, SCHATTR_TEXT_OVERLAP,
	SCHATTR_AXIS_START,SCHATTR_AXIS_END,
	XATTR_LINE_FIRST, XATTR_LINE_LAST,
	EE_ITEMS_START, EE_ITEMS_END,
	SID_TEXTBREAK, SID_TEXTBREAK,
	SID_ATTR_NUMBERFORMAT_VALUE, SID_ATTR_NUMBERFORMAT_VALUE, //10.585
   0
};
/************************************************************************/

enum ChartStyleV0
{
	CHART2D_LINE,
	CHART2D_STACKEDLINE,
	CHART2D_BAR,
	CHART2D_STACKEDBAR,
	CHART2D_COLUMN,
	CHART2D_STACKEDCOLUMN,
	CHART2D_AREA,
	CHART2D_STACKEDAREA,
	CHART2D_PIE,
	CHART3D_STRIPE,
	CHART3D_BAR,
	CHART3D_FLATBAR,
	CHART3D_STACKEDFLATBAR,
	CHART3D_AREA,
	CHART3D_STACKEDAREA,
	CHART3D_SURFACE,
	CHART3D_PIE
};

/*************************************************************************
|*
|* Datenbeschriftung erzeugen
|*
\************************************************************************/

//SdrObject*
void ChartModel::CreateDataDescr(DataDescription& rDescr,long nCol,long nRow,ChartAxis *pAxis,BOOL bRowDescr,BOOL bIsPercent)
{

	UINT32 nDescrFormat=       pAxis ? pAxis->GetNumFormat(FALSE) : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,FALSE);
	UINT32 nPercentDescrFormat=pAxis ? pAxis->GetNumFormat(TRUE)  : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,TRUE);
	String aText;
	Color* pDummy = NULL;


	if (pAxis && !bIsPercent && ((rDescr.eDescr == CHDESCR_PERCENT)
					 || (rDescr.eDescr == CHDESCR_TEXTANDPERCENT)))
		rDescr.fValue=pAxis->Data2Percent(rDescr.fValue,nCol,nRow);

	switch (rDescr.eDescr)
	{
		case CHDESCR_VALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_PERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_TEXT:
			aText = bRowDescr ? RowText(nRow) : ColText(nCol);
			break;

		case CHDESCR_TEXTANDPERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			aText.Insert( (sal_Unicode)(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_TEXTANDVALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			aText.Insert( sal_Unicode(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_NUMFORMAT_PERCENT: //SP3: #49905#
			if(IsAxisChart())
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			else //PieChart, hier wird getrickst, um fileformatkompatible den Formatter der X-Achse zu
				// missbrauchen, der NICHT auf Percent gesetzt werden kann, da Pie kein IsPercent()
				// liefert, dieses wird jedoch im Basic bei ...AxisX.Text ausgewertet
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_NUMFORMAT_VALUE: //SP3: #49905#
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;
	}

	SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow ));
	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(aDataPointAttr);

	SdrObject* pObj;

	// Objekte zuerst mit Position 0,0 anlegen, um dann die relative
	// Position zu setzen; rDescr.aTextPos2D wird dann als AnchorPos verwendet
	if( rDescr.bSymbol )
	{
		pObj = new SchObjGroup;
		pObj->InsertUserData(new SchObjectId( bRowDescr
											  ? CHOBJID_DIAGRAM_DESCR_ROW
											  : CHOBJID_DIAGRAM_DESCR_COL));
		SdrObjList* pObjList = pObj->GetSubList();
		SdrTextObj* pTextObj = CreateTextObj( CHOBJID_TEXT, Point(), aText,
											  aTextAttr, FALSE,
											  CHADJUST_TOP_LEFT,
											  -1);

		long nH = pTextObj->GetLogicRect().GetHeight();

		SfxItemSet aSymbolAttr(aDataPointAttr);
		GenerateSymbolAttr( aSymbolAttr, nRow, SYMBOLMODE_DESCRIPTION );

		SdrRectObj* pRect = new SdrRectObj( Rectangle(Point(), Size(nH, nH)) );
		pRect->SetModel( this );
		pObjList->NbcInsertObject( SetObjectAttr( pRect,
												  CHOBJID_DIAGRAM_DESCR_SYMBOL,
												  TRUE, TRUE, &aSymbolAttr));
		pTextObj->NbcMove(Size(nH + nH/2, 0));
		pObjList->NbcInsertObject(pTextObj);

		Rectangle aRect = pObj->GetLogicRect();
		AdjustRect(aRect, rDescr.eAdjust);
		pObj->NbcSetRelativePos(aRect.TopLeft());
		pObj->NbcSetAnchorPos(rDescr.aTextPos2D);
	}
	else
	{
		pObj = CreateTextObj( bRowDescr
							  ? CHOBJID_DIAGRAM_DESCR_ROW
							  : CHOBJID_DIAGRAM_DESCR_COL,
							  Point(), aText,
							  aTextAttr, FALSE, rDescr.eAdjust, -1);

		pObj->NbcSetRelativePos(pObj->GetLogicRect().TopLeft());
		pObj->NbcSetAnchorPos(rDescr.aTextPos2D);
	}

	if( bRowDescr )
		pObj->InsertUserData(new SchDataRow(nRow));
	else
		pObj->InsertUserData(new SchDataPoint(nCol, nRow));
	// #54870# nRow oben immer 0 (?)

	// return
	rDescr.pLabelObj = pObj;
}

USHORT ChartModel::GetRegressStrId( long nRow )
{

	const SfxItemSet& aDataRowAttr = GetDataRowAttr( nRow );
	USHORT nStringID = 0;

	switch (((const SfxInt32Item &) aDataRowAttr.Get (SCHATTR_STAT_REGRESSTYPE)).GetValue ())
	{
		case CHREGRESS_NONE :
			break;

		case CHREGRESS_LINEAR :
			nStringID = STR_REGRESSION_LINEAR;
			break;

		case CHREGRESS_LOG :
			nStringID = STR_REGRESSION_LOG;
			break;

		case CHREGRESS_EXP :
			nStringID = STR_REGRESSION_EXP;
			break;

		case CHREGRESS_POWER :
			nStringID = STR_REGRESSION_POWER;

	}
	return nStringID;
}
/*************************************************************************
|*
|* Diagrammlegende erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateLegend(const Rectangle &aRect)
{
	// Default ist, dass die Legende nicht breiter als 20% der gesamten Seitenbreite
	// verwenden darf, unter der Bedingung, dass sie links oder rechts vom Chart steht.
	// wenn sie ueber oder unter dem Chart steht, dann ist die Seitenbreite das Maximum

	//TVM: obiges ist nicht richtig, CreateLegend wurde stets ohne 2.Argument
	//aufgerufen, daher galt immer fMax...=0.2, ausserdem bezieht sich die maximale
	//Breite auf den Text in der Legende, nicht auf die Legende selbst
	//(Test: 1-Zeiliges Chart mit langem Text!)
	//Obiges klngt aber durchaus plausibel, also sollte man es mal bei Gelegenheit
	//einbauen (ToDo:-Liste)
	const double  fMaximumWidth=0.2;

	SvxChartLegendPos eLegendPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).
								GetValue();
	BOOL bWide = (eLegendPos == CHLEGEND_TOP || eLegendPos == CHLEGEND_BOTTOM);
	BOOL bRowLegend = !IsPieChart();
	BOOL bReverse = !bWide && IsStackedChart();
	BOOL bForceSolidLine = FALSE;

	SchObjGroup* pGroup = NULL;

	if (bLegendVisible)
	{

		List  aTextList;
		long i;
		long nRowCnt     = GetRowCount();
			// FG: nCnt ist die Anzahl Texte!
		long nCnt        = bRowLegend ? nRowCnt : GetColCount();
		long nMaxX        = 0;
		long nMaxY        = 0;

		long  nLineMaxY = 0; //#50082#

		long* pHeightOfEntry = new long[nCnt*2];    // FG: Wirkliche Hoehe der Zeilen
		long* pWidthOfEntry  = new long[nCnt*2];    // FG: Wirkliche Breite der Zeilen
		long nLines       = 0;                // Anzahl Zeilen
		long nActualColumn = 1; // FG: Zaehlt die Anzahl Spalten

		long* pRegressNr  = new long [nCnt];
		memset (pRegressNr, 0, sizeof (long) * nCnt);

		SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);

		aTextAttr.Put(*pLegendAttr);

		// FG: Hier wird einmal die Liste aller Texte durchgegangen um die maximale Hoehe und
		//     die maximale Breite zu bestimmen. Bei der Gelegenheit merkt man sich auch die
		//     Ausmasse der einzelnen Eintraege.
		for (i = 0; i < nCnt; i++)
		{
			// FG: Mehr als fMaximumWidth des Charts soll die Legende nie einnehmen
			SdrObject *pText = CreateTextObj(CHOBJID_TEXT, Point (),
									 bRowLegend ? RowText(i) : ColText(i),
									 aTextAttr,
									 FALSE,
									 CHADJUST_TOP_LEFT,  //FG: wie der Default
									 GetPage(0)->GetSize().Width() * fMaximumWidth);

            // the text in the legend may not be selected, as there is no valid
            // context menu (original comment by FG)
			pText->SetMarkProtect(TRUE);
			aTextList.Insert(pText, LIST_APPEND);

			pWidthOfEntry[i] = pText->GetLogicRect().GetWidth();
			pHeightOfEntry[i] = pText->GetLogicRect().GetHeight();
			nMaxX  = Max (nMaxX, pWidthOfEntry[i]);
			nMaxY  = Max (nMaxY, pHeightOfEntry[i]);
		}

		if (IsXYChart())
		{
			USHORT nStringID;
			for( i = 1; i < nCnt; i++ )
			{
				nStringID = GetRegressStrId( i );
				if( nStringID )
				{
					SchResId aRegId = SchResId( nStringID );
					String aRegressStr( aRegId );
					String aSeriesName( bRowLegend
										? RowText( i )
										: ColText( i ));
					String aLegendText( SchResId( STR_STATISTICS_IN_LEGEND ));

					aLegendText.SearchAndReplaceAscii( "$(STATTYP)", aRegressStr );
					aLegendText.SearchAndReplaceAscii( "$(ROWNAME)", aSeriesName );

					SdrObject *pText = CreateTextObj( CHOBJID_TEXT, Point(), aLegendText,
													  aTextAttr, FALSE,
													  CHADJUST_TOP_LEFT,
													  GetPage( 0 )->GetSize().Width() * fMaximumWidth );

					pText->SetMarkProtect( TRUE );
					aTextList.Insert(pText, LIST_APPEND);

					pWidthOfEntry[nLines+nCnt]  = pText->GetLogicRect().GetWidth();
					pHeightOfEntry[nLines+nCnt] = pText->GetLogicRect().GetHeight();
					nMaxX  = Max (nMaxX,  pWidthOfEntry[nLines+nCnt]);
					nMaxY  = Max (nMaxY, pHeightOfEntry[nLines+nCnt]);

				   // nMaxX  = Max (nMaxX, pText->GetLogicRect().GetWidth());
				   // nMaxY  = Max (nMaxY, pText->GetLogicRect().GetHeight());

					pRegressNr [nLines] = i;
					nLines ++;
				}
			}
		}

		if (IsXYChart ()) nCnt --;
		nLines += nCnt;

		long nTextRows    = 0;
		long nTextCols    = 0;
		long nShows       = 0;

		ULONG nLegendHeight = ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight();
		long nLittleSpace = nLegendHeight / 3;

		// FG: Hier wird berechnet wieviele Spalten und Zeilen die Legende haben soll
		if (!bWide)  // dann ist die Legende mit den Zeilen untereinander links oder rechts
		{
			// FG: Die Legende darf maximal 90% der Blatthoehe einnehmen und maximal 50% der Blattbreite
			if (nLines * (nMaxY + nLittleSpace) < (aRect.GetHeight() - 0.1 * aRect.GetHeight()))
			{
				nTextRows = nLines;
				nTextCols = 1;      // Also eine Spalte
			}
			else  // Es gibt also mehrere Spalten
			{
				nTextRows = (long) ((aRect.GetHeight() - 0.1 * aRect.GetHeight()) / (nMaxY + nLittleSpace));
				if(!nTextRows)
					nTextRows=1;
				nTextCols = (long) ((nLines % nTextRows) ? nLines / nTextRows + 1 : nLines / nTextRows);
				// FG: Falls die Legende zu breit (mehr als 50% der Chart-Breite) wird muss man nachregeln
				if (nTextCols * (nMaxX + nLittleSpace) > aRect.GetWidth())
				{
					nTextCols = (long) (aRect.GetWidth() * 0.5 / (nMaxX + nLittleSpace));
				}
			}
		}
		else  // die Legende befindet sich also unter oder ueber dem Chart (die wird noch beliebig gross)
		{
			nTextCols = (nLines * (nMaxX + 2*nLittleSpace + nLegendHeight) + nLittleSpace < aRect.GetWidth())
						 ? nLines : (aRect.GetWidth() - nLittleSpace) / (nMaxX + 2*nLittleSpace + nLegendHeight);
			nTextRows = nTextCols
						 ? ((nLines % nTextCols) ? nLines / nTextCols + 1 : nLines / nTextCols) : 0;
		}

		if (nTextRows > 0 && nTextCols > 0)
		{
			pGroup = new SchObjGroup;
			pGroup->InsertUserData(new SchObjectId(CHOBJID_LEGEND));
			// pGroup->SetResizeProtect(TRUE);
			SdrObject*  pObj;
			SdrObjList* pObjList = pGroup->GetSubList();

			Point aTextPos (nLittleSpace, nLegendHeight / 4);

			for (i = 0, nShows = 0;
				 i < nLines;
				 i++, nShows ++)
			{
				// FG: bReverse ist fuer gestapelte Diagramme gedacht, damit die Legendensymbole
				//     optisch der Reihenfolge des stapelns entsprechen.
			   long nIndex = (IsXYChart())
							   ?  i+1
							   : (bReverse)
								   ? nCnt - 1 - i
								   : i;

				if (i < nCnt)
				{
					BOOL bIsSymbol = FALSE;
					BOOL bIsLine   = FALSE;
					if(HasSymbols(nIndex))
					{
						bIsSymbol = TRUE;
						pObj = CreateSymbol (Point (aTextPos.X () + nLegendHeight / 2,
															aTextPos.Y () + nLegendHeight / 2 + nLittleSpace / 3),
											 nIndex, 0, (SfxItemSet &) GetDataRowAttr(nIndex), nLegendHeight, FALSE);
						if(pObj)
						{
							Rectangle aRect(pObj->GetSnapRect());
							if((aRect.GetHeight() > nLegendHeight) && nLegendHeight)
							{
								Fraction aFract(nLegendHeight,aRect.GetHeight());
								pObj->NbcResize(aRect.Center(),aFract,aFract);
							}
						}
						else //dann Linie als Legendensymbol, sonst geht evtl. garnix mehr
						{
							XPolygon aLine(2);
							aLine [0] =
							aLine [1] = aTextPos;
							aLine [1].X() += nLegendHeight;
							aLine [1].Y() += nLegendHeight;
							bIsLine = TRUE;
							pObj = new SdrPathObj(OBJ_PLIN, aLine);
						}
					}
					else if (IsLine(nIndex))
					{
						XPolygon aLine(2);

						aLine [0] =
						aLine [1] = aTextPos;
						aLine [1].X() += nLegendHeight;
						aLine [1].Y() += nLegendHeight;

						bIsLine = TRUE;
						pObj = new SdrPathObj(OBJ_PLIN, aLine);
					}
					else
					{
						// create rectangular shape as legend symbol
						pObj = new SdrRectObj(Rectangle(Point (aTextPos.X(),
															   aTextPos.Y() + nLittleSpace / 3),
														Size(nLegendHeight, nLegendHeight)));
						bForceSolidLine = TRUE;
					}
					// FG: setzen des Symbols neben dem Legendentext

					SfxItemSet *pSymbolAttr;

					if( bRowLegend )
					{
						pSymbolAttr = new SfxItemSet( GetDataRowAttr( nIndex ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, nIndex, SYMBOLMODE_LEGEND );
					}
					else
					{
						pSymbolAttr = new SfxItemSet( GetFullDataPointAttr( nIndex, 0 ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, 0, SYMBOLMODE_LEGEND );
					}

					if( bForceSolidLine )
					{
						XLineStyle eLineStyle =
							SAL_STATIC_CAST( const XLineStyleItem *, &(pSymbolAttr->Get( XATTR_LINESTYLE )) )->GetValue(); // bug in Win-C++ compiler: casting to pointer

						if( eLineStyle == XLINE_NONE )
						{
							pSymbolAttr->ClearItem( XATTR_LINESTYLE );
							pSymbolAttr->ClearItem( XATTR_LINEWIDTH );
							pSymbolAttr->ClearItem( XATTR_LINECOLOR );
						}
					}

//-/					pObj->NbcSetAttributes( *pSymbolAttr, FALSE );
					pObj->SetMergedItemSet(*pSymbolAttr);


					if(bRowLegend)
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_ROW));
						pObj->InsertUserData(new SchDataRow(nIndex));
					}
					else
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_COL));
						pObj->InsertUserData(new SchDataPoint(nIndex, 0));
					}

					pObj->SetMoveProtect(TRUE);
					pObj->SetResizeProtect(TRUE);
					pObjList->NbcInsertObject(pObj);

					SdrObject *pText = (SdrObject*)aTextList.GetObject(nIndex);

					pText->NbcMove(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
					pObjList->NbcInsertObject(pText);

					delete pSymbolAttr;
				}
				else //i >= nCnt
				{
					if (pRegressNr [i - nCnt])
					{
						XPolygon aLine(2);

						aLine [0] =
						aLine [1] = aTextPos;
						aLine [1].X () += nLegendHeight;
						aLine [1].Y () += nLegendHeight;

						pObj = new SdrPathObj(OBJ_PLIN, aLine);

						//	Set the object's user data so that the
						//	object can't be deleted via the GUI.
						pObj->InsertUserData(new SchObjectId (CHOBJID_LINE));

//-/						pObj->NbcSetAttributes(GetRegressAttr(pRegressNr[i-nCnt]), FALSE);
						pObj->SetMergedItemSet(GetRegressAttr(pRegressNr[i-nCnt]));


						pObj->SetMoveProtect(TRUE);
						pObj->SetResizeProtect(TRUE);
						pObjList->NbcInsertObject(pObj);

						SdrObject* pText = (SdrObject*)aTextList.GetObject(nIndex);

						pText->Move(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
						pObjList->NbcInsertObject(pText);
					}
				}

				// FG: Jetzt wird aTextPos fuer den naechsten Legendeneintrag gesetzt
			   if (bWide)
				{
					if (nShows >= nTextCols - 1)
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082# #NACHTRAG#
						aTextPos.Y () += nLineMaxY  + nLittleSpace;//#50082#
						aTextPos.X ()  = nLittleSpace;//nLegendHeight / 6;//SP3: #49906#
						nLineMaxY = 0; //#50082# #NACHTRAG#
						nShows = -1;
					}
					else
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082#
						aTextPos.X () += nMaxX +  2 * nLittleSpace + nLegendHeight;
					}
				}
				else if (nShows >= nTextRows - 1) // FG: Die Legende wird in mehrere Spalten umgebrochen
				{                                 //     also den Spaltenabstand setzen
					aTextPos.X () += nMaxX + nLittleSpace + nLegendHeight + 2*nLittleSpace;
					aTextPos.Y ()  = nLegendHeight / 4;
					nShows = -1;
					if (nActualColumn >= nTextCols)  // FG: Dann wird die Legende zu breit!
					{
						break;                       // aus der for-Schleife raus,
													 // es muessen noch Felder deleted werden.
					}
					nActualColumn++;
				}
				else
				{

					aTextPos.Y() += pHeightOfEntry[nIndex] + nLittleSpace;
				}
			}

				//FG: Jetzt wird das umschliessende Rechteck berechnet. Man fraegt erst das
				//    BoundingRect des Legenden-Gruppenobjektes ab und addiert an den Raendern ein
				//    wenig Platz dazu.
			Rectangle aLogRect = pGroup->GetLogicRect();
			aLogRect.Left() -= nLittleSpace;
			aLogRect.Right() += nLittleSpace;
			aLogRect.Top() -= nLittleSpace;
			aLogRect.Bottom() += nLittleSpace;
			SdrRectObj* pRectObj = new SchRectObj(aLogRect);
			// FG: Das hier soll verhindern dass das Rechteck um die Legende markiert werden kann
			pRectObj->SetMarkProtect(TRUE);
			pRectObj->SetModel( this );
			pObjList->NbcInsertObject(SetObjectAttr(pRectObj, CHOBJID_LEGEND_BACK,
													TRUE, TRUE, pLegendAttr), 0);
		}

		delete[] pRegressNr;
		delete[] pHeightOfEntry;
		delete[] pWidthOfEntry;
	}

	return pGroup;
}

/*************************************************************************
|*
|* Diagramm erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateChart(const Rectangle &rRect)
{
	if( pDocShell )
		pDocShell->SetWaitCursor( TRUE );

	Rectangle aRect( rRect );
	SdrObjGroup* pGroup;

	switch (eChartStyle)
	{
		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
			pGroup = Create2DRowLineChart(aRect);//neu, test!
			break;

		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_LINESYMBOLS :
		case CHSTYLE_2D_STACKEDLINESYM :
		case CHSTYLE_2D_PERCENTLINESYM :
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			pGroup = Create2DRowLineChart(aRect);
			break;

		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_2D_LINE_COLUMN:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			pGroup = Create2DColChart(aRect);
			break;

		case CHSTYLE_2D_PIE_SEGOF1:
		{
			for (short i = 1; i < nPieSegCount; i++)
				SetPieSegOfs(i, 0);
            SetPieSegOfs( 0, 10 );
			pGroup = Create2DPieChart(aRect);
			break;
		}

		case CHSTYLE_2D_PIE_SEGOFALL:
		{
			for (short i = 0; i < nPieSegCount; i++)
                SetPieSegOfs( i, 10 );
		}

		case CHSTYLE_2D_PIE:
			 pGroup = Create2DPieChart(aRect);
			break;

		case CHSTYLE_2D_DONUT1:  //DonutCharts haben jetzt eigenes Create
		case CHSTYLE_2D_DONUT2:
			pGroup = Create2DDonutChart(aRect);
			break;

		case CHSTYLE_2D_XYSYMBOLS :
		case CHSTYLE_2D_XY_LINE :
		case CHSTYLE_2D_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			pGroup = Create2DXYChart(aRect);
			break;

		case CHSTYLE_2D_NET:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			pGroup = Create2DNetChart(aRect);
			break;

		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_STRIPE:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_SURFACE:
			pGroup = Create3DDeepChart(aRect);
			break;

		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			pGroup = Create3DFlatChart(aRect);
			break;

		case CHSTYLE_3D_PIE:
			pGroup = Create3DNewPieChart(aRect);
			break;

		default:
			eChartStyle = CHSTYLE_2D_COLUMN;
			pGroup = Create2DColChart(aRect);
			break;
	}

	if( pDocShell )
		pDocShell->SetWaitCursor( FALSE );

	SdrPage* pPage=GetPage( 0 );
	SdrObject* pObj = GetObjWithId( CHOBJID_DIAGRAM_AREA, *pPage );
	if( pObj )
		pObj->SetMoveProtect( TRUE );

	return pGroup;
}

//BFS03void ChartModel::PrepareOld3DStorage()
//BFS03{
//BFS03	SfxItemSet aTmpSet(*pItemPool,nRowWhichPairs);
//BFS03	aTmpSet.Put(XLineStyleItem(XLINE_SOLID));
//BFS03	aTmpSet.Put(XLineWidthItem(0));
//BFS03	aTmpSet.Put(XLineColorItem(String(), RGBColor(COL_BLACK)));
//BFS03
//BFS03
//BFS03	long i,nCount=aDataRowAttrList.Count();
//BFS03	for (i=0;i<nCount;i++)
//BFS03	{
//BFS03		SfxItemSet *pDataRowAttr = new SfxItemSet (*pItemPool, nRowWhichPairs);
//BFS03		pDataRowAttr->Put(*(aDataRowAttrList.GetObject(i)));
//BFS03		pDataRowAttr->Put(aTmpSet);
//BFS03		aTmpDataRowAttrList.Insert (pDataRowAttr, LIST_APPEND);
//BFS03	}
//BFS03
//BFS03	SfxItemSet	*	pItemSet;
//BFS03	nCount=aDataPointAttrList.Count();
//BFS03	for (i=0;i<nCount;i++)
//BFS03	 {
//BFS03		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03		pItemSet = aDataPointAttrList.GetObject(i);
//BFS03		if (pItemSet != NULL)
//BFS03			pSet->Put(*pItemSet);
//BFS03		pSet->Put(aTmpSet);
//BFS03		aTmpDataPointAttrList.Insert (pSet, LIST_APPEND);
//BFS03	 }
//BFS03
//BFS03	nCount=aSwitchDataPointAttrList.Count();
//BFS03	for (i=0;i<nCount;i++)
//BFS03	 {
//BFS03		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03		pItemSet = aSwitchDataPointAttrList.GetObject(i);
//BFS03		if (pItemSet != NULL)
//BFS03			pSet->Put(*pItemSet);
//BFS03		pSet->Put(aTmpSet);
//BFS03		aTmpSwitchDataPointAttrList.Insert (pSet, LIST_APPEND);
//BFS03	 }
//BFS03}
//BFS03void ChartModel::CleanupOld3DStorage()
//BFS03{
//BFS03	long i,nCount = aTmpDataRowAttrList.Count();
//BFS03	for (i = 0 ; i < nCount; i++)
//BFS03		delete aTmpDataRowAttrList.GetObject(i);
//BFS03	aTmpDataRowAttrList.Clear();
//BFS03
//BFS03	nCount = aTmpDataPointAttrList.Count();
//BFS03	for (i = 0 ; i < nCount; i++)
//BFS03		delete aTmpDataPointAttrList.GetObject(i);
//BFS03	aTmpDataPointAttrList.Clear();
//BFS03
//BFS03	nCount = aTmpSwitchDataPointAttrList.Count();
//BFS03	for (i = 0 ; i < nCount; i++)
//BFS03		delete aTmpSwitchDataPointAttrList.GetObject(i);
//BFS03	aTmpSwitchDataPointAttrList.Clear();
//BFS03}
/*************************************************************************
|*
|* Chart-Attribute speichern

\************************************************************************/
//BFS03void ChartModel::PrepareAxisStorage()
//BFS03{
//BFS03	if(pTmpXItems)
//BFS03		delete pTmpXItems;
//BFS03	if(pTmpYItems)
//BFS03		delete pTmpYItems;
//BFS03	if(pTmpZItems)
//BFS03		delete pTmpZItems;
//BFS03	//Leider muss das ummappen vorm speichern des pools stattfinden
//BFS03	pTmpXItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);
//BFS03	pTmpYItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);
//BFS03	pTmpZItems = new SfxItemSet(*pItemPool,nCompatAxisWhichPairs);
//BFS03
//BFS03	pTmpXItems->Put(GetAttr(CHOBJID_DIAGRAM_X_AXIS));
//BFS03	AxisAttrNew2Old(*pTmpXItems,CHOBJID_DIAGRAM_X_AXIS,TRUE);
//BFS03
//BFS03	pTmpYItems->Put(GetAttr(CHOBJID_DIAGRAM_Y_AXIS));
//BFS03	AxisAttrNew2Old(*pTmpYItems,CHOBJID_DIAGRAM_Y_AXIS,TRUE);
//BFS03
//BFS03	pTmpZItems->Put(GetAttr(CHOBJID_DIAGRAM_Z_AXIS));
//BFS03	AxisAttrNew2Old(*pTmpZItems,CHOBJID_DIAGRAM_Z_AXIS,TRUE);
//BFS03
//BFS03
//BFS03	//Achse wird auf Attr-Basis gestreamt!
//BFS03	pChartXAxis->FillItemSet();
//BFS03	pChartYAxis->FillItemSet();
//BFS03	pChartZAxis->FillItemSet();
//BFS03	pChartBAxis->FillItemSet();
//BFS03	pChartAAxis->FillItemSet();
//BFS03}

//BFS03void ChartModel::StoreAttributes(SvStream& rOut) const
//BFS03{
//BFS03#ifdef DBG_UTIL
//BFS03	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
//BFS03	CHART_TRACE1( "ChartModel::StoreAttributes (%s)", aBStr.GetBuffer() );
//BFS03#endif
//BFS03
//BFS03	rtl_TextEncoding eSysSet = ::GetSOStoreTextEncoding( gsl_getSystemTextEncoding());
//BFS03	rOut.SetStreamCharSet( eSysSet );
//BFS03
//BFS03	SchIOCompat aIO(rOut, STREAM_WRITE, 17);
//BFS03	long nFileFormat = rOut.GetVersion ();
//BFS03
//BFS03	//#50116# 8->9
//BFS03	//#54870# ->10
//BFS03	//12: ChartAchsen
//BFS03	//13 Nachtrag: X-AchsenAttr-default bei XY-Charts (store unveraendert)
//BFS03	//14 Overlap , Gapwith der 2 Y-Achsen
//BFS03	//15 Neues 3D-Pie
//BFS03	//16 Items fuer Achse SCHATTR_AXIS_SHOWDESCR,SCHATTR_AXIS_SHOWAXIS aktiviert,
//BFS03	//    bisher nur von pChartBAxis genutzt!
//BFS03
//BFS03	//FG: 12 - seit 20.02.1997 - Umbruch ja/ein pro Achse hinzu
//BFS03	//FG: 13 - seit 09.03.1997 Alle Variablen mit Tag 13:
//BFS03	//DL: 14 - seit 11.03.1997 aSpotColor & aAmbientColor
//BFS03	//                         FG  + TextausPositionen
//BFS03	//FG: 15 - set  14.03.1997 Textausrichtung
//BFS03	//SOH:16 - seit 04.05.1997 NumberFormatter
//BFS03
//BFS03	//TODO: konvertieren der Attribute pChartAttr in eChartStyle (Fileversion >=10)
//BFS03
//BFS03	UINT32 nMoreData = 16;
//BFS03
//BFS03	short i, nCount;
//BFS03
//BFS03	rOut << aLightVec->X ();
//BFS03	rOut << aLightVec->Y ();
//BFS03	rOut << aLightVec->Z ();
//BFS03
//BFS03	if (pChartData)
//BFS03	{
//BFS03		INT16 ID = CHDATAID_MEMCHART;    // damit aeltere versionen damit fertig werden
//BFS03		rOut << (INT16) ID;
//BFS03		rOut << *(SchMemChart*)pChartData;
//BFS03	}
//BFS03	else
//BFS03	{
//BFS03		INT16 nInt16 = (INT16)CHDATAID_NONE; rOut << nInt16;
//BFS03	}
//BFS03
//BFS03	BOOL bDummy = TRUE;            // war frueher bOwnChart
//BFS03	rOut << bIsCopied;
//BFS03	rOut << fMinData;
//BFS03	rOut << (INT16)eChartStyle;
//BFS03
//BFS03	for (i = 0; i < LINE_POINT_COUNT; i++)
//BFS03		rOut << (INT16)eChartLinePoints[i];
//BFS03
//BFS03
//BFS03	// Das ehemalige Member aRowColors[]. Es wird hier simuliert, damit
//BFS03	// alte Codeversionen mit der hier geschriebenen Datei arbeiten koennen.
//BFS03	Color aRowColors[ROW_COLOR_COUNT];
//BFS03
//BFS03	aRowColors[0]   = Color(  0, 153, 255);
//BFS03	aRowColors[1]   = Color(255,  51, 102);
//BFS03	aRowColors[2]   = Color(102, 102, 102);
//BFS03	aRowColors[3]   = Color( 51, 204, 102);
//BFS03	aRowColors[4]   = Color(153, 102, 204);
//BFS03	aRowColors[5]   = Color(255, 153, 102);
//BFS03	aRowColors[6]   = Color(255, 204, 153);
//BFS03	aRowColors[7]   = Color(153, 204, 255);
//BFS03	aRowColors[8]   = Color(  0, 204, 204);
//BFS03	aRowColors[9]   = Color(153,   0, 153);
//BFS03	aRowColors[10]  = Color(255,  51,  51);
//BFS03
//BFS03	aRowColors[11]  = RGBColor(COL_WHITE);
//BFS03	for (i = 0; i < ROW_COLOR_COUNT; i++)
//BFS03		rOut << aRowColors[i];
//BFS03
//BFS03	const long nGapWidth  = 10;
//BFS03	const long nOverlap = 0;
//BFS03	rOut << (INT32)nGapWidth;
//BFS03	rOut << (INT32)nOverlap;
//BFS03	rOut << (INT32)nMarkLen; //entfaellt demnaechst! -> ChartAxis
//BFS03	rOut << aChartRect;
//BFS03	rOut << (INT32)nPieHeight;
//BFS03
//BFS03	rOut << (INT16)nPieSegCount;
//BFS03	for (i = 0; i < nPieSegCount; i++)
//BFS03		rOut << (INT32)pPieSegOfs[i];
//BFS03
//BFS03	INT16 nXA=nXAngle;
//BFS03	INT16 nYA=nYAngle;
//BFS03	INT16 nZA=nZAngle;
//BFS03	if(IsReal3D() && IsPieChart())
//BFS03	{
//BFS03		Vector3D aVRot,aVTrans,aVShear,aVScale;
//BFS03		aSceneMatrix.Decompose(aVScale,aVTrans,aVRot,aVShear);
//BFS03		long nAngle= (long)(aVRot.Z() * 1800.0 / F_PI);
//BFS03		nAngle -= 900;
//BFS03		nAngle += 3600;
//BFS03		nAngle %= 3600;
//BFS03		nYA = (INT16)nAngle;
//BFS03	}
//BFS03
//BFS03	rOut << (INT16)nXA;//anle;
//BFS03	rOut << (INT16)nYA;//ngle;
//BFS03	rOut << (INT16)nZA;//ngle;
//BFS03
//BFS03
//BFS03	//neu wegen Achsenrestrukturierung
//BFS03	BOOL bShowXAxis =pChartXAxis->IsVisible();
//BFS03	BOOL bShowXDescr=pChartXAxis->HasDescription();
//BFS03	BOOL bShowYAxis =pChartYAxis->IsVisible();
//BFS03	BOOL bShowYDescr=pChartYAxis->HasDescription();
//BFS03	BOOL bShowZAxis =pChartZAxis->IsVisible();
//BFS03	BOOL bShowZDescr=pChartZAxis->HasDescription();
//BFS03
//BFS03
//BFS03	// save unicode strings as ascii-strings for old binary format
//BFS03	rOut << (INT16)eSysSet;
//BFS03
//BFS03	rOut << bShowMainTitle;
//BFS03	rOut << aMainTitle;
//BFS03	rOut << bShowSubTitle;
//BFS03	rOut << aSubTitle;
//BFS03	rOut << bShowXAxisTitle;
//BFS03	rOut << aXAxisTitle;
//BFS03	rOut << bShowYAxisTitle;
//BFS03	rOut << aYAxisTitle;
//BFS03	rOut << bShowZAxisTitle;
//BFS03	rOut << aZAxisTitle;
//BFS03	rOut << bShowXAxis;
//BFS03	rOut << bShowXGridMain;
//BFS03	rOut << bShowXGridHelp;
//BFS03	rOut << bShowXDescr;
//BFS03	rOut << bShowYAxis;
//BFS03	rOut << bShowYGridMain;
//BFS03	rOut << bShowYGridHelp;
//BFS03	rOut << bShowYDescr;
//BFS03	rOut << bShowZAxis;
//BFS03	rOut << bShowZGridMain;
//BFS03	rOut << bShowZGridHelp;
//BFS03	rOut << bShowZDescr;
//BFS03
//BFS03	// In diesem Set koennten ungueltige Items vorhanden sein, da es
//BFS03	// das Set der allgemeinen TitleAttribute (aller Titel) ist
//BFS03	pTitleAttr->ClearInvalidItems();
//BFS03	pTitleAttr->Store(rOut);
//BFS03
//BFS03	pMainTitleAttr->Store(rOut);
//BFS03	pSubTitleAttr->Store(rOut);
//BFS03	pXAxisTitleAttr->Store(rOut);
//BFS03	pYAxisTitleAttr->Store(rOut);
//BFS03	pZAxisTitleAttr->Store(rOut);
//BFS03
//BFS03	pAxisAttr->ClearInvalidItems();
//BFS03
//BFS03	pAxisAttr->Store(rOut);
//BFS03
//BFS03
//BFS03
//BFS03
//BFS03
//BFS03	//Abwaertskompatibel speichern (this->PrepareAxisStorage())
//BFS03	pTmpXItems->Store(rOut);
//BFS03	pTmpYItems->Store(rOut);
//BFS03	pTmpZItems->Store(rOut);
//BFS03
//BFS03	pGridAttr->ClearInvalidItems();
//BFS03	pGridAttr->Store(rOut);
//BFS03	pXGridMainAttr->Store(rOut);
//BFS03	pYGridMainAttr->Store(rOut);
//BFS03	pZGridMainAttr->Store(rOut);
//BFS03	pXGridHelpAttr->Store(rOut);
//BFS03	pYGridHelpAttr->Store(rOut);
//BFS03	pZGridHelpAttr->Store(rOut);
//BFS03	pDiagramAreaAttr->Store(rOut);
//BFS03	pDiagramWallAttr->Store(rOut);
//BFS03	pDiagramFloorAttr->Store(rOut);
//BFS03	pLegendAttr->Store(rOut);
//BFS03
//BFS03
//BFS03
//BFS03	if (nFileFormat == SOFFICE_FILEFORMAT_31)
//BFS03	{
//BFS03
//BFS03		SfxItemSet aStoreAttr (*pItemPool, XATTR_LINE_FIRST, XATTR_LINE_LAST,
//BFS03										   XATTR_FILL_FIRST, XATTR_FILL_LAST,
//BFS03										   //EE_ITEMS_START, EE_ITEMS_END,
//BFS03										   SCHATTR_DATADESCR_START, SCHATTR_DATADESCR_END, 0),
//BFS03					aPoolItemSet (*pItemPool, nRowWhichPairs),
//BFS03					*pItemSet;
//BFS03
//BFS03		// FG: 25.2.97 Das Schreiben im 3.1 Format  geht schief wenn man
//BFS03		//     in globfunc.cxx die Routine CopyAttributesFrom40to31 verwendet.
//BFS03		//     Dort wurden die items per Invalidate und Set einzeln kopiert. (falsch)
//BFS03		nCount = (short)aDataRowAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			SfxItemSet* pSet = aStoreAttr.Clone();
//BFS03			pSet->Put( *aDataRowAttrList.GetObject(i), TRUE );
//BFS03			pSet->Store( rOut );
//BFS03			delete pSet;
//BFS03		}
//BFS03
//BFS03		nCount = (short)aDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			SfxItemSet* pSet = aStoreAttr.Clone();
//BFS03			pItemSet = aDataPointAttrList.GetObject(i);
//BFS03			if (pItemSet != NULL)
//BFS03				pSet->Put (*pItemSet, TRUE );
//BFS03			else
//BFS03				pSet->Put (aPoolItemSet, TRUE);
//BFS03			pSet->Store(rOut);
//BFS03			delete pSet;
//BFS03		}
//BFS03
//BFS03		nCount = (short)aSwitchDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			SfxItemSet* pSet = aStoreAttr.Clone();
//BFS03			pItemSet = aSwitchDataPointAttrList.GetObject(i);
//BFS03			if (pItemSet != NULL)
//BFS03				pSet->Put (*pItemSet, TRUE );
//BFS03			else
//BFS03				pSet->Put (aPoolItemSet, TRUE);
//BFS03			pSet->Store(rOut);
//BFS03			delete pSet;
//BFS03		}
//BFS03	}
//BFS03	else if(nFileFormat <= SOFFICE_FILEFORMAT_40 && IsReal3D()) //siehe auch DocShell, Save,SaveAs!!!!!
//BFS03	{
//BFS03
//BFS03		nCount = (short)aTmpDataRowAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aTmpDataRowAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03		nCount = (short)aTmpDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aTmpDataPointAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03		nCount = (short)aTmpSwitchDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aTmpSwitchDataPointAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03	}
//BFS03	else
//BFS03	{
//BFS03		SfxItemSet	aPoolItemSet (*pItemPool, nRowWhichPairs),
//BFS03				*	pItemSet;
//BFS03					
//BFS03		nCount = (short)aDataRowAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aDataRowAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03		nCount = (short)aDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			pItemSet = aDataPointAttrList.GetObject(i);
//BFS03			if (pItemSet != NULL)
//BFS03				pItemSet->Store(rOut);
//BFS03			else
//BFS03				aPoolItemSet.Store(rOut);
//BFS03		}
//BFS03		
//BFS03		nCount = (short)aSwitchDataPointAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			pItemSet = aSwitchDataPointAttrList.GetObject(i);
//BFS03			if (pItemSet != NULL)
//BFS03				pItemSet->Store(rOut);
//BFS03			else
//BFS03				aPoolItemSet.Store(rOut);
//BFS03		}
//BFS03	}
//BFS03
//BFS03	rOut << (INT16)eDataDescr;
//BFS03	rOut << bShowSym;
//BFS03	rOut << bSwitchData;
//BFS03
//BFS03	UINT32 nTmp;
//BFS03
//BFS03	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,FALSE);
//BFS03	rOut << nTmp;//nValFormat;
//BFS03	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,TRUE);
//BFS03	rOut << nTmp;//nPercentValFormat;
//BFS03	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_X_AXIS,FALSE);
//BFS03	rOut << nTmp;//nDescrFormat;
//BFS03	nTmp=((ChartModel*)this)->GetNumFmt(CHOBJID_DIAGRAM_X_AXIS,TRUE);
//BFS03	rOut << nTmp;//nPercentDescrFormat;
//BFS03
//BFS03	// Achtung : Gravierende Aenderungen an der Datei gegenueber der Auslieferungsversion
//BFS03	// es werden mehr Daten geschrieben : Die alte Version muss (!) das aber auch verkraften
//BFS03	// Die Reihenfolge muss (!!!!) eingehalten werden
//BFS03	pChartYAxis->StoreMemberCompat(rOut);
//BFS03	pChartXAxis->StoreMemberCompat(rOut);
//BFS03	pChartZAxis->StoreMemberCompat(rOut);
//BFS03
//BFS03	rOut << fMaxData;
//BFS03
//BFS03	rOut << nMoreData;
//BFS03
//BFS03	if (nMoreData >= 2)
//BFS03		if (pChartData)
//BFS03		{
//BFS03			rOut << pChartData->SomeData1();
//BFS03			rOut << pChartData->SomeData2();
//BFS03			rOut << pChartData->SomeData3();
//BFS03			rOut << pChartData->SomeData4();
//BFS03		}
//BFS03		else
//BFS03		{
//BFS03			String aEmpty;
//BFS03
//BFS03			rOut << aEmpty;
//BFS03			rOut << aEmpty;
//BFS03			rOut << aEmpty;
//BFS03			rOut << aEmpty;
//BFS03		}
//BFS03
//BFS03	if (nMoreData >= 3) rOut << fSpotIntensity;
//BFS03
//BFS03	if (nMoreData >= 4)
//BFS03	{
//BFS03		BOOL bDummy = TRUE;   // war frueher bIsRegression
//BFS03
//BFS03		rOut << bShowAverage;
//BFS03		rOut << (INT16)eErrorKind;
//BFS03		rOut << bDummy;
//BFS03		rOut << (INT16)eIndicate;
//BFS03		rOut << fIndicatePercent;
//BFS03		rOut << fIndicateBigError;
//BFS03		rOut << fIndicatePlus;
//BFS03		rOut << fIndicateMinus;
//BFS03	}
//BFS03
//BFS03	if (nMoreData >= 5) rOut << (INT16) eRegression;
//BFS03
//BFS03	if (nMoreData >= 6)
//BFS03	{
//BFS03		rOut << (INT32) nSplineDepth;
//BFS03		rOut << (INT32) nGranularity;
//BFS03	}
//BFS03
//BFS03	if (nMoreData >= 7)
//BFS03	{
//BFS03		rOut << bLegendVisible;
//BFS03	}
//BFS03
//BFS03	if (nMoreData >= 8)
//BFS03	{
//BFS03		nCount = (short)aRegressAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aRegressAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03		nCount = (short)aAverageAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aAverageAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03		nCount = (short)aErrorAttrList.Count();
//BFS03		rOut << (INT16)nCount;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03			aErrorAttrList.GetObject(i)->Store(rOut);
//BFS03
//BFS03	}
//BFS03
//BFS03	if (nMoreData >= 9) rOut << fAmbientIntensity;
//BFS03	if (nMoreData >= 10) rOut << bTextScalable;
//BFS03	if (nMoreData >= 11) rOut << aInitialSize;
//BFS03	if (nMoreData >= 12) // FG: Zusaetze wegen des Umruchs von Achsentext und Legendentext 20.02.97
//BFS03	{
//BFS03		// FG: Vielleicht etwas viel Speicher fuer BOOL, aber es macht nur 8 Byte pro Chart
//BFS03		rOut << (INT16) bFormatXAxisTextInMultipleLinesIfNecessary;
//BFS03		rOut << (INT16) bFormatYAxisTextInMultipleLinesIfNecessary;
//BFS03		rOut << (INT16) bFormatZAxisTextInMultipleLinesIfNecessary;
//BFS03		rOut << (INT16) bFormatLegendTextInMultipleLinesIfNecessary;
//BFS03	}
//BFS03	if (nMoreData >= 13) // FG: 9.3.1997 Zusaetze wegen einer freien Positionierung und einem freien
//BFS03	{                    //     Resize von Gruppenobjekten im Chart.
//BFS03		rOut << (INT16) nXAxisTextMaximumNumberOfLines;
//BFS03		rOut << (INT16) nYAxisTextMaximumNumberOfLines;
//BFS03		rOut << (INT16) nZAxisTextMaximumNumberOfLines;
//BFS03		rOut << (INT32) nWidthOfFirstXAxisText;
//BFS03		rOut << (INT32) nWidthOfLastXAxisText;
//BFS03		rOut << aTitleTopCenter;
//BFS03		rOut << aSubTitleTopCenter;
//BFS03		rOut << aDiagramRectangle;
//BFS03		rOut << aLegendTopLeft;
//BFS03		rOut << aTitleXAxisPosition;
//BFS03		rOut << aTitleYAxisPosition;
//BFS03		rOut << aTitleZAxisPosition;
//BFS03		rOut << (INT16) bUseRelativePositionsForChartGroups;
//BFS03		rOut << (INT16) bAdjustMarginsForLegend;
//BFS03		rOut << (INT16) bAdjustMarginsForMainTitle;
//BFS03		rOut << (INT16) bAdjustMarginsForSubTitle;
//BFS03		rOut << (INT16) bAdjustMarginsForXAxisTitle;
//BFS03		rOut << (INT16) bAdjustMarginsForYAxisTitle;
//BFS03		rOut << (INT16) bAdjustMarginsForZAxisTitle;
//BFS03	}
//BFS03	if (nMoreData >= 14)
//BFS03	{
//BFS03		rOut << aSpotColor;     // FG: Von DL, um sich die Farbeinstellungen der 3d-Lichter
//BFS03		rOut << aAmbientColor;  //     bei 3d-Charts merken zu koennen.
//BFS03
//BFS03		BOOL bTmp=bDiagramHasBeenMovedOrResized; //neu -> alt: dann immer rearrange
//BFS03		if(IsReal3D() && IsPieChart())
//BFS03			bTmp=FALSE;
//BFS03
//BFS03		rOut << bTmp; // FG: 12.3.97, Falls das Chart gespeichert wird
//BFS03		rOut << bMainTitleHasBeenMoved;        //     soll es immer noch die relativen Positionen
//BFS03		rOut << bSubTitleHasBeenMoved;         //     der Objektgruppen beachten, falls eine
//BFS03		rOut << bLegendHasBeenMoved;           //     dieser Gruppen bewegt worden ist.
//BFS03		rOut << bXAxisTitleHasBeenMoved;
//BFS03		rOut << bYAxisTitleHasBeenMoved;
//BFS03		rOut << bZAxisTitleHasBeenMoved;
//BFS03	}
//BFS03	if (nMoreData >= 15)  // FG: 14.3.97 Damit bei einem angefassten Text die Position sinnvoll gesetzt werden
//BFS03	{                     //     auch nach einer Schriftgroessenaenderung muss man sich merken wie die Ausrichtung war
//BFS03		rOut << (INT16) eAdjustXAxesTitle;
//BFS03		rOut << (INT16) eAdjustYAxesTitle;
//BFS03		rOut << (INT16) eAdjustZAxesTitle;
//BFS03	}
//BFS03	if (nMoreData >= 16) // NumberFormater waren bisher nicht persistent
//BFS03	{
//BFS03		pNumFormatter->Save( rOut );
//BFS03		pNumFormatter->Save( rOut );
//BFS03		pNumFormatter->Save( rOut );
//BFS03	}
//BFS03
//BFS03	rOut << (INT16) nBarPercentWidth; //#50116# ist ein long, aber Range von 0..100
//BFS03	rOut << (INT32) m_nDefaultColorSet;//#50149#
//BFS03
//BFS03	rOut << (INT32) nNumLinesInColChart;//#50212#
//BFS03
//BFS03 	// #74536# BM use these three former -1 dummies for
//BFS03 	// numberformat last set by CALC
//BFS03 	rOut << (INT32) nXLastNumFmt;
//BFS03 	rOut << (INT32) nYLastNumFmt;
//BFS03 	rOut << (INT32) nBLastNumFmt;
//BFS03
//BFS03	rOut << (INT32)(-1);		// dummy
//BFS03
//BFS03	//IOVer 11
//BFS03	pStockLineAttr->Store(rOut);
//BFS03	pStockLossAttr->Store(rOut);
//BFS03	pStockPlusAttr->Store(rOut);
//BFS03
//BFS03
//BFS03	//IOVer12:
//BFS03	//nAxisId ist die zu ladene/speichernde Achse,
//BFS03	//festgelegt sind in V12 nur 1=X, 2=Y,3=Z und 4=2.Y-Achse (B)
//BFS03	//neu: 5 = 2. X-Achse
//BFS03	//-1 bedeutet KEINE WEITEREN ACHSEN!
//BFS03	//Es MUSS keine Achse gestreamt werden (siehe Lade-Routine)
//BFS03	//Die Reihenfolge ist eigentlich auch egal, jedoch gilt beim Laden:
//BFS03	//erst die primaere und dann die sekundaere (X, bzw. evtl auch Y) Achse
//BFS03	//(um defaults aus der primaeren Achse heraus zu erzeugen)
//BFS03
//BFS03	INT32 nAxisId=CHART_AXIS_PRIMARY_X;
//BFS03	rOut << nAxisId;
//BFS03	GetAttr(CHOBJID_DIAGRAM_X_AXIS).Store(rOut);
//BFS03
//BFS03	nAxisId=CHART_AXIS_PRIMARY_Y;
//BFS03	rOut << nAxisId;
//BFS03	GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Store(rOut);
//BFS03
//BFS03	nAxisId=CHART_AXIS_PRIMARY_Z;
//BFS03	rOut << nAxisId;
//BFS03	GetAttr(CHOBJID_DIAGRAM_Z_AXIS).Store(rOut);
//BFS03
//BFS03	nAxisId=CHART_AXIS_SECONDARY_Y;
//BFS03	rOut << nAxisId;
//BFS03	GetAttr(CHOBJID_DIAGRAM_B_AXIS).Store(rOut);
//BFS03
//BFS03	nAxisId=CHART_AXIS_SECONDARY_X;
//BFS03	rOut << nAxisId;
//BFS03	GetAttr(CHOBJID_DIAGRAM_A_AXIS).Store(rOut);
//BFS03
//BFS03	//Elementar wichtig! Diesen Wert zu streamen ist absolutes Minimum
//BFS03	//die obigen derzeit 4 Achsen kann man dagegen getrost reduzieren oder aufstocken
//BFS03	//ohne dass die abwaertskompatiblitaet leidet! Genauso lassen sich beliebige
//BFS03	//Achsen mit einer Id>4 dazwischen haengen. In alten Versionen wird bei
//BFS03	//unbekannter id einfach ein Dummy geladen (und weggeschmissen)
//BFS03	nAxisId=-1;
//BFS03	rOut << nAxisId;
//BFS03	//Ende IOVersion 12
//BFS03
//BFS03	nTmp = aBarY1.GetGap();
//BFS03	rOut << nTmp;
//BFS03	nTmp = aBarY1.GetOverlap();
//BFS03	rOut << nTmp;
//BFS03	nTmp = aBarY2.GetGap();
//BFS03	rOut << nTmp;
//BFS03	nTmp = aBarY2.GetOverlap();
//BFS03	rOut << nTmp;
//BFS03
//BFS03
//BFS03 	// IOVersion 15
//BFS03	rOut << bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird
//BFS03}

/*************************************************************************
|*
|* Chart-Attribute laden
|*
\************************************************************************/

//BFS03void ChartModel::LoadAttributes(SvStream& rIn)
//BFS03{
//BFS03#ifdef DBG_UTIL
//BFS03	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
//BFS03	CHART_TRACE1( "ChartModel::LoadAttributes (%s)", aBStr.GetBuffer() );
//BFS03#endif
//BFS03
//BFS03    // aInfo is a member of SdrModel
//BFS03    // the SdrModel was read before this, so the value is set
//BFS03    rtl_TextEncoding eSysSet = ::GetSOLoadTextEncoding( aInfo.eLastReadCharSet, rIn.GetVersion());
//BFS03	rIn.SetStreamCharSet( eSysSet );
//BFS03    // Note: The CharSet is stored in the MemChart and later set again at the stream !
//BFS03
//BFS03	SchIOCompat aIO(rIn, STREAM_READ);
//BFS03
//BFS03	short       i, nCount;
//BFS03	INT16       nInt16, nCharSet;
//BFS03	INT32       nInt32;
//BFS03	SfxItemSet* pAttr;
//BFS03	BOOL        bNoMore = FALSE;
//BFS03	int			nVersion = aIO.GetVersion();
//BFS03
//BFS03	rIn >> aLightVec->X ();
//BFS03	rIn >> aLightVec->Y ();
//BFS03	rIn >> aLightVec->Z ();
//BFS03
//BFS03	if (nVersion >= 3)
//BFS03	{
//BFS03		rIn >> nInt16;
//BFS03
//BFS03		// fuer den fall, dass initial das diagrammfenster generiert wurde
//BFS03		delete pChartData;
//BFS03
//BFS03        // Note: The CharSet is stored in the MemChart and set there at the stream !
//BFS03		switch ((ChartDataId)nInt16)
//BFS03		{
//BFS03			case CHDATAID_MEMCHART_PLUS :
//BFS03				pChartData = new SchMemChart (CHDATAID_MEMCHART_PLUS);
//BFS03				rIn >> *(SchMemChart*)pChartData;
//BFS03				pChartData->IncreaseRefCount();
//BFS03				break;
//BFS03
//BFS03			case CHDATAID_DYNCHART:
//BFS03			case CHDATAID_MEMCHART:
//BFS03				pChartData = new SchMemChart (CHDATAID_MEMCHART);
//BFS03				rIn >> *(SchMemChart*)pChartData;
//BFS03				pChartData->IncreaseRefCount();
//BFS03				break;
//BFS03
//BFS03			default :
//BFS03				bNoMore = TRUE;
//BFS03		}
//BFS03
//BFS03		if (nVersion >= 5) rIn >> bIsCopied;
//BFS03
//BFS03		if (nVersion >= 8) rIn >> fMinData;
//BFS03		else if (pChartData)
//BFS03		{
//BFS03			long nColCnt = GetColCount();
//BFS03			long nRowCnt = GetRowCount();
//BFS03
//BFS03			for (short nCol = 0; nCol < nColCnt; nCol++)
//BFS03				for (short nRow = 0; nRow < nRowCnt; nRow++)
//BFS03				{
//BFS03					double fData = GetData(nCol, nRow);
//BFS03
//BFS03					if ((nCol == 0) && (nRow == 0))
//BFS03					{
//BFS03						pChartYAxis->SetMin(fData);
//BFS03						pChartYAxis->SetMax(fData);
//BFS03					}
//BFS03					if (fData < pChartYAxis->GetMin())
//BFS03						pChartYAxis->SetMin(fData);
//BFS03					if (fData > pChartYAxis->GetMax())
//BFS03						pChartYAxis->SetMax(fData);
//BFS03				}
//BFS03
//BFS03			bNoMore = TRUE;
//BFS03		}
//BFS03	}
//BFS03
//BFS03	rIn >> nInt16;
//BFS03	if (nVersion < 1)
//BFS03	{
//BFS03		switch ((ChartStyleV0)nInt16)
//BFS03		{
//BFS03			case CHART2D_LINE:
//BFS03				eChartStyle = CHSTYLE_2D_LINE;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_STACKEDLINE:
//BFS03				eChartStyle = CHSTYLE_2D_STACKEDLINE;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_BAR:
//BFS03				eChartStyle = CHSTYLE_2D_COLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_STACKEDBAR:
//BFS03				eChartStyle = CHSTYLE_2D_STACKEDCOLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_COLUMN:
//BFS03				eChartStyle = CHSTYLE_2D_BAR;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_STACKEDCOLUMN:
//BFS03				eChartStyle = CHSTYLE_2D_STACKEDBAR;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_AREA:
//BFS03				eChartStyle = CHSTYLE_2D_AREA;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_STACKEDAREA:
//BFS03				eChartStyle = CHSTYLE_2D_STACKEDAREA;
//BFS03				break;
//BFS03
//BFS03			case CHART2D_PIE:
//BFS03				eChartStyle = CHSTYLE_2D_PIE;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_STRIPE:
//BFS03				eChartStyle = CHSTYLE_3D_STRIPE;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_BAR:
//BFS03				eChartStyle = CHSTYLE_3D_COLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_FLATBAR:
//BFS03				eChartStyle = CHSTYLE_3D_FLATCOLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_STACKEDFLATBAR:
//BFS03				eChartStyle = CHSTYLE_3D_STACKEDFLATCOLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_AREA:
//BFS03				eChartStyle = CHSTYLE_3D_AREA;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_STACKEDAREA:
//BFS03				eChartStyle = CHSTYLE_3D_STACKEDAREA;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_SURFACE:
//BFS03				eChartStyle = CHSTYLE_3D_SURFACE;
//BFS03				break;
//BFS03
//BFS03			case CHART3D_PIE:
//BFS03				eChartStyle = CHSTYLE_3D_PIE;
//BFS03				break;
//BFS03
//BFS03			default :
//BFS03				eChartStyle = CHSTYLE_2D_COLUMN;
//BFS03				break;
//BFS03		}
//BFS03
//BFS03		bNoMore = TRUE;
//BFS03	}
//BFS03	else
//BFS03		eChartStyle = (SvxChartStyle)nInt16;
//BFS03
//BFS03	for (i = 0; i < LINE_POINT_COUNT; i++)
//BFS03	{
//BFS03		rIn >> nInt16; eChartLinePoints[i] = nInt16;
//BFS03	}
//BFS03
//BFS03	// Das ehemalige Member aRowColors[] wird eingelesen.
//BFS03	Color aDummyColor;
//BFS03	for (i = 0; i < ROW_COLOR_COUNT; i++)
//BFS03		rIn >> aDummyColor;
//BFS03
//BFS03	long nOverlap;
//BFS03	rIn >> nInt32; //nGapWidth = (long)nInt32;
//BFS03	rIn >> nInt32; nOverlap = (long)nInt32;
//BFS03	rIn >> nInt32;
//BFS03	DBG_ASSERT( nInt32 == 100, "LoadAttributes: nMarkLen's value differs from 100 in this stream" );
//BFS03
//BFS03	rIn >> aChartRect;
//BFS03	rIn >> nInt32; nPieHeight = (long)nInt32;
//BFS03
//BFS03	if (nVersion >= 6)
//BFS03	{
//BFS03		rIn >> nInt16; nPieSegCount = (short)nInt16;
//BFS03		pPieSegOfs = new long[nPieSegCount];
//BFS03
//BFS03		BOOL bNullify = (nVersion < 17) && eChartStyle == CHSTYLE_2D_PIE;
//BFS03
//BFS03		for( i = 0; i < nPieSegCount; i++ )
//BFS03		{
//BFS03			rIn >> nInt32;
//BFS03			pPieSegOfs[ i ] = bNullify? 0: (long)nInt32;
//BFS03		}
//BFS03	}
//BFS03
//BFS03	rIn >> nInt16; nXAngle = (short)nInt16;
//BFS03	rIn >> nInt16; nYAngle = (short)nInt16;
//BFS03	rIn >> nInt16; nZAngle = (short)nInt16;
//BFS03
//BFS03	rIn >> nCharSet;
//BFS03
//BFS03	/**************************************************************************
//BFS03	* So machts der Writer, und so muessen es alle machen:
//BFS03	* Bug 9714: Der CharSet an den Fonts muss geaendert werden, wenn
//BFS03	* es der globale CharSet ist (MT)
//BFS03	**************************************************************************/
//BFS03	SfxItemPool& rPool = GetItemPool();
//BFS03	USHORT nMaxItems = rPool.GetItemCount(EE_CHAR_FONTINFO);
//BFS03	SvxFontItem* pItem;
//BFS03
//BFS03	for (USHORT n = 0; n < nMaxItems; ++n)
//BFS03	{
//BFS03		pItem = (SvxFontItem*) rPool.GetItem(EE_CHAR_FONTINFO, n);
//BFS03		if (pItem && pItem->GetCharSet() == nCharSet)
//BFS03		{
//BFS03			pItem->GetCharSet() = eSysSet;
//BFS03		}
//BFS03	}
//BFS03
//BFS03
//BFS03	BOOL bShowXAxis;
//BFS03	BOOL bShowXDescr;
//BFS03	BOOL bShowYAxis;
//BFS03	BOOL bShowYDescr;
//BFS03	BOOL bShowZAxis;
//BFS03	BOOL bShowZDescr;
//BFS03
//BFS03	rIn >> bShowMainTitle;
//BFS03	rIn >> aMainTitle;
//BFS03	rIn >> bShowSubTitle;
//BFS03	rIn >> aSubTitle;
//BFS03	rIn >> bShowXAxisTitle;
//BFS03	rIn >> aXAxisTitle;
//BFS03	rIn >> bShowYAxisTitle;
//BFS03	rIn >> aYAxisTitle;
//BFS03	rIn >> bShowZAxisTitle;
//BFS03	rIn >> aZAxisTitle;
//BFS03	rIn >> bShowXAxis;
//BFS03	rIn >> bShowXGridMain;
//BFS03	rIn >> bShowXGridHelp;
//BFS03	rIn >> bShowXDescr;
//BFS03	rIn >> bShowYAxis;
//BFS03	rIn >> bShowYGridMain;
//BFS03	rIn >> bShowYGridHelp;
//BFS03	rIn >> bShowYDescr;
//BFS03	rIn >> bShowZAxis;
//BFS03	rIn >> bShowZGridMain;
//BFS03	rIn >> bShowZGridHelp;
//BFS03	rIn >> bShowZDescr;
//BFS03
//BFS03	/**************************************************************************
//BFS03	* Nun werden die Attribut-ItemSets geladen
//BFS03	* Die etwas umstaendliche Art und Weise ist notwendig, da fruehere Charts
//BFS03	* nicht alle Items weggeschrieben haben. Daher wird in ein leeres ItemSet
//BFS03	* gestreamt und dieses in das Default-ItemSet geputtet (damit keine
//BFS03	* Pool-Defaults zum Tragen kommen).
//BFS03	**************************************************************************/
//BFS03
//BFS03	SfxItemSet aTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pTitleAttr, aTitleAttr );
//BFS03
//BFS03	SfxItemSet aMainTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aMainTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pMainTitleAttr, aMainTitleAttr );
//BFS03
//BFS03	SfxItemSet aSubTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aSubTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pSubTitleAttr, aSubTitleAttr );
//BFS03
//BFS03	SfxItemSet aXAxisTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aXAxisTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pXAxisTitleAttr, aXAxisTitleAttr );
//BFS03
//BFS03	SfxItemSet aYAxisTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aYAxisTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pYAxisTitleAttr, aYAxisTitleAttr );
//BFS03
//BFS03	SfxItemSet aZAxisTitleAttr(*pItemPool, nTitleWhichPairs);
//BFS03	aZAxisTitleAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pZAxisTitleAttr, aZAxisTitleAttr );
//BFS03
//BFS03	SfxItemSet aAxisAttr(*pItemPool, nAllAxisWhichPairs);
//BFS03	aAxisAttr.Load(rIn);
//BFS03	pAxisAttr->Put(aAxisAttr);
//BFS03
//BFS03CHART_TRACE( "LoadAttributes: Debugging load of old axis attr BEFORE conversion" );
//BFS03	SfxItemSet aXAxisAttr(*pItemPool, nCompatAxisWhichPairs);//nXAxisWhich....
//BFS03	aXAxisAttr.Load(rIn);
//BFS03DBG_ITEMS(aXAxisAttr,(ChartModel*)this);
//BFS03	SfxItemSet aYAxisAttr(*pItemPool, nCompatAxisWhichPairs);
//BFS03	aYAxisAttr.Load(rIn);
//BFS03DBG_ITEMS(aYAxisAttr,(ChartModel*)this);
//BFS03	SfxItemSet aZAxisAttr(*pItemPool, nCompatAxisWhichPairs);
//BFS03	aZAxisAttr.Load(rIn);
//BFS03DBG_ITEMS(aZAxisAttr,(ChartModel*)this);
//BFS03
//BFS03	if(nVersion < 12) //sonst wirds eh uebergebuegelt:
//BFS03	{
//BFS03		//konvertieren:
//BFS03		AxisAttrOld2New(aXAxisAttr,TRUE,CHOBJID_DIAGRAM_X_AXIS);
//BFS03		AxisAttrOld2New(aYAxisAttr,TRUE,CHOBJID_DIAGRAM_Y_AXIS);
//BFS03		AxisAttrOld2New(aZAxisAttr,TRUE,CHOBJID_DIAGRAM_Z_AXIS);
//BFS03		pChartXAxis->SetAttributes(aXAxisAttr);
//BFS03		pChartYAxis->SetAttributes(aYAxisAttr);
//BFS03		pChartZAxis->SetAttributes(aZAxisAttr);
//BFS03CHART_TRACE( "LoadAttributes: Debugging AFTER conversion" );
//BFS03DBG_ITEMS(aXAxisAttr,(ChartModel*)this);
//BFS03DBG_ITEMS(aYAxisAttr,(ChartModel*)this);
//BFS03DBG_ITEMS(aZAxisAttr,(ChartModel*)this);
//BFS03	}
//BFS03
//BFS03	SfxItemSet aGridAttr(*pItemPool, nGridWhichPairs);
//BFS03	aGridAttr.Load(rIn);
//BFS03	pGridAttr->Put(aGridAttr);
//BFS03
//BFS03	SfxItemSet aXGridMainAttr(*pItemPool, nGridWhichPairs);
//BFS03	aXGridMainAttr.Load(rIn);
//BFS03	pXGridMainAttr->Put(aXGridMainAttr);
//BFS03
//BFS03	SfxItemSet aYGridMainAttr(*pItemPool, nGridWhichPairs);
//BFS03	aYGridMainAttr.Load(rIn);
//BFS03	pYGridMainAttr->Put(aYGridMainAttr);
//BFS03
//BFS03	SfxItemSet aZGridMainAttr(*pItemPool, nGridWhichPairs);
//BFS03	aZGridMainAttr.Load(rIn);
//BFS03	pZGridMainAttr->Put(aZGridMainAttr);
//BFS03
//BFS03	SfxItemSet aXGridHelpAttr(*pItemPool, nGridWhichPairs);
//BFS03	aXGridHelpAttr.Load(rIn);
//BFS03	pXGridHelpAttr->Put(aXGridHelpAttr);
//BFS03
//BFS03	SfxItemSet aYGridHelpAttr(*pItemPool, nGridWhichPairs);
//BFS03	aYGridHelpAttr.Load(rIn);
//BFS03	pYGridHelpAttr->Put(aYGridHelpAttr);
//BFS03
//BFS03	SfxItemSet aZGridHelpAttr(*pItemPool, nGridWhichPairs);
//BFS03	aZGridHelpAttr.Load(rIn);
//BFS03	pZGridHelpAttr->Put(aZGridHelpAttr);
//BFS03
//BFS03	SfxItemSet aDiagramAreaAttr(*pItemPool, nDiagramAreaWhichPairs);
//BFS03	aDiagramAreaAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pDiagramAreaAttr, aDiagramAreaAttr );
//BFS03
//BFS03	SfxItemSet aDiagramWallAttr(*pItemPool, nDiagramAreaWhichPairs);
//BFS03	aDiagramWallAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pDiagramWallAttr, aDiagramWallAttr );
//BFS03
//BFS03	SfxItemSet aDiagramFloorAttr(*pItemPool, nDiagramAreaWhichPairs);
//BFS03	aDiagramFloorAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pDiagramFloorAttr, aDiagramFloorAttr );
//BFS03
//BFS03	SfxItemSet aLegendAttr(*pItemPool, nLegendWhichPairs);
//BFS03	aLegendAttr.Load(rIn);
//BFS03	PutItemSetWithNameCreation( *pLegendAttr, aLegendAttr );
//BFS03
//BFS03	if (nVersion < 2)
//BFS03	{
//BFS03		pTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pMainTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pSubTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pXAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pYAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pZAxisTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pAxisAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03
//BFS03		//Achsen auch fuer V12+ OK, (ToDo: Hier ist recht viel Overhead! )
//BFS03		aXAxisAttr.ClearItem();
//BFS03		aYAxisAttr.ClearItem();
//BFS03		aZAxisAttr.ClearItem();
//BFS03		aXAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		aXAxisAttr.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
//BFS03		aYAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		aYAxisAttr.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
//BFS03		aZAxisAttr.Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
//BFS03		pChartXAxis->SetAttributes(aXAxisAttr);
//BFS03		pChartYAxis->SetAttributes(aYAxisAttr);
//BFS03		pChartZAxis->SetAttributes(aZAxisAttr);
//BFS03
//BFS03		bNoMore = TRUE;
//BFS03	}
//BFS03
//BFS03	if (nVersion < 7)
//BFS03	{
//BFS03		GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Put(SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN, TRUE));
//BFS03		GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Put(SvxDoubleItem(0.0, SCHATTR_AXIS_ORIGIN));
//BFS03
//BFS03		bNoMore = TRUE;
//BFS03	}
//BFS03
//BFS03	rIn >> nInt16; nCount = (short)nInt16;
//BFS03	for (i = 0; i < nCount; i++)
//BFS03	{
//BFS03		pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03
//BFS03		pAttr->Load(rIn);
//BFS03		aDataRowAttrList.Insert(pAttr, LIST_APPEND);
//BFS03
//BFS03//		Debug-Code
//BFS03//
//BFS03//  		SfxItemState sfx_test_state = aDataRowAttrList.GetObject(i)->GetItemState(XATTR_FILLSTYLE);
//BFS03//  		if (sfx_test_state >= SFX_ITEM_AVAILABLE)
//BFS03//  		{
//BFS03//  			XFillStyleItem& rTest_set = (XFillStyleItem&) aDataRowAttrList.GetObject(i)->Get(XATTR_FILLSTYLE);
//BFS03//  		}
//BFS03//  		sfx_test_state = aDataRowAttrList.GetObject(i)->GetItemState(XATTR_FILLCOLOR);
//BFS03//  		if (sfx_test_state >= SFX_ITEM_AVAILABLE)
//BFS03//  		{
//BFS03//  			XColorItem& rTest_set = (XColorItem&) aDataRowAttrList.GetObject(i)->Get(XATTR_FILLCOLOR);
//BFS03//  		}
//BFS03	}
//BFS03
//BFS03	rIn >> nInt16; nCount = (short)nInt16;
//BFS03	for (i = 0; i < nCount; i++)
//BFS03	{
//BFS03		pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03
//BFS03		pAttr->Load(rIn);
//BFS03		if (pAttr->Count() == 0)
//BFS03		{
//BFS03			delete pAttr;
//BFS03			pAttr = NULL;
//BFS03		}
//BFS03		aDataPointAttrList.Insert(pAttr, LIST_APPEND);
//BFS03	}
//BFS03
//BFS03	if (nVersion < 4)
//BFS03	{
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03//			SfxItemSet* pDataPointAttr =
//BFS03//				new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03			aSwitchDataPointAttrList.Insert(NULL, LIST_APPEND);
//BFS03		}
//BFS03
//BFS03		bNoMore = TRUE;
//BFS03	}
//BFS03	else
//BFS03	{
//BFS03		rIn >> nInt16; nCount = (short)nInt16;
//BFS03		for (i = 0; i < nCount; i++)
//BFS03		{
//BFS03			pAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);
//BFS03
//BFS03			pAttr->Load(rIn);
//BFS03			if (pAttr->Count() == 0)
//BFS03			{
//BFS03				delete pAttr;
//BFS03				pAttr = NULL;
//BFS03			}
//BFS03			aSwitchDataPointAttrList.Insert(pAttr, LIST_APPEND);
//BFS03		}
//BFS03	}
//BFS03
//BFS03	rIn >> nInt16; eDataDescr = (SvxChartDataDescr)nInt16;
//BFS03	rIn >> bShowSym;
//BFS03	rIn >> bSwitchData;
//BFS03
//BFS03	if (nVersion < 1)
//BFS03	{
//BFS03		BOOL bDataPercent;
//BFS03		rIn >> bDataPercent;
//BFS03
//BFS03		switch (eChartStyle)
//BFS03		{
//BFS03			case CHSTYLE_2D_LINE:
//BFS03				eChartStyle = CHSTYLE_2D_PERCENTLINE;
//BFS03				break;
//BFS03
//BFS03			case CHSTYLE_2D_COLUMN:
//BFS03				eChartStyle = CHSTYLE_2D_PERCENTCOLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHSTYLE_2D_BAR:
//BFS03				eChartStyle = CHSTYLE_2D_PERCENTBAR;
//BFS03				break;
//BFS03
//BFS03			case CHSTYLE_2D_AREA:
//BFS03				eChartStyle = CHSTYLE_2D_PERCENTAREA;
//BFS03				break;
//BFS03
//BFS03			case CHSTYLE_3D_FLATCOLUMN:
//BFS03				eChartStyle = CHSTYLE_3D_PERCENTFLATCOLUMN;
//BFS03				break;
//BFS03
//BFS03			case CHSTYLE_3D_AREA:
//BFS03				eChartStyle = CHSTYLE_3D_PERCENTAREA;
//BFS03				break;
//BFS03		}
//BFS03
//BFS03		bNoMore = TRUE;
//BFS03	}
//BFS03
//BFS03	UINT32 nTmp,nDescrFormat,nDescrPercentFormat;
//BFS03	rIn >> nTmp;//nValFo rmat;
//BFS03	SetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,nTmp,FALSE);
//BFS03	rIn >> nTmp;//nPerce ntValFormat;
//BFS03	SetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,nTmp,TRUE);
//BFS03	rIn >> nDescrFormat;
//BFS03	SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nDescrFormat,FALSE);
//BFS03	rIn >> nDescrPercentFormat;
//BFS03	SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nDescrPercentFormat,TRUE);
//BFS03
//BFS03	// Achtung : Gravierende Aenderungen an der Datei gegenueber der Auslieferungsversion
//BFS03	// es werden mehr Daten geschrieben : Die alte Version muss (!) das aber auch verkraften
//BFS03	// Die Reihenfolge muss (!!!!) eingehalten werden
//BFS03	pChartYAxis->LoadMemberCompat(rIn);
//BFS03	pChartXAxis->LoadMemberCompat(rIn);
//BFS03	pChartZAxis->LoadMemberCompat(rIn);
//BFS03
//BFS03	rIn >> fMaxData;
//BFS03
//BFS03	if (!bNoMore)
//BFS03	{
//BFS03		UINT32 nMoreData = 0;
//BFS03		rIn >> nMoreData;
//BFS03
//BFS03		// nMoreData soll als Weiche fuer zukuenftige Versionen dienen,
//BFS03		// insbesondere fuer den Fall, dass weitere Daten geschrieben werden
//BFS03		// muessen. Die Pools duerfen ab dem 19.01.1996 auf gar keinen Fall
//BFS03		// mehr modifiziert oder aufgebohrt werden !!!!
//BFS03		// nMoreData = 1     (Version vom 19.01.1996)
//BFS03		// nMoreData = 2     (Version vom 13.03.1996)
//BFS03		// nMoreData = 3     (Version vom 1.04.1996)
//BFS03		// nMoreData = 4     (Version vom 13.05.1996)
//BFS03		// nMoreData = 5     (Version vom 20.05.1996)
//BFS03		// nMoreData = 6     (Version vom 20.06.1996)
//BFS03		// nMoreData = 7     (Version vom 02.07.1996)
//BFS03		// nMoreData = 8     (Version vom 09.07.1996)
//BFS03		// nMoreData = 9     (Version vom 11.07.1996)
//BFS03		// ...
//BFS03		// nMoreData = 12    (Version vom 20.02.1997) FG (Vobis-Version 4.0)
//BFS03		// nMoreData = 13    (Version vom 9.3.1997) FG Cebit-Version
//BFS03		// .... siehe Text unten
//BFS03		// nMoreData = 15    (Version vom 14.3.1997)  FG V4.0 nach Cebit >= 358
//BFS03		if (nMoreData > 1)
//BFS03		{
//BFS03			ByteString aReadString;
//BFS03
//BFS03			rIn >> pChartData->SomeData1();
//BFS03			rIn >> pChartData->SomeData2();
//BFS03			rIn >> pChartData->SomeData3();
//BFS03			rIn >> pChartData->SomeData4();
//BFS03
//BFS03			if (nMoreData >= 3) rIn >> fSpotIntensity;
//BFS03			if (nMoreData <= 8) fAmbientIntensity = fSpotIntensity;
//BFS03
//BFS03			if (nMoreData >= 4)
//BFS03			{
//BFS03				BOOL bDummy;
//BFS03
//BFS03				rIn >> bShowAverage;
//BFS03				rIn >> nInt16; eErrorKind = (SvxChartKindError) nInt16;
//BFS03				rIn >> bDummy;
//BFS03				rIn >> nInt16; eIndicate = (SvxChartIndicate) nInt16;
//BFS03				rIn >> fIndicatePercent;
//BFS03				rIn >> fIndicateBigError;
//BFS03				rIn >> fIndicatePlus;
//BFS03				rIn >> fIndicateMinus;
//BFS03			}
//BFS03
//BFS03			if (nMoreData >= 5)
//BFS03			{
//BFS03				rIn >> nInt16; eRegression = (SvxChartRegress) nInt16;
//BFS03			}
//BFS03
//BFS03			if (nMoreData >= 6)
//BFS03			{
//BFS03				INT32 nInt32;
//BFS03				rIn >> nInt32; nSplineDepth = nInt32;
//BFS03				rIn >> nInt32; nGranularity = nInt32;
//BFS03			}
//BFS03
//BFS03			if (nMoreData >= 7)
//BFS03			{
//BFS03				rIn >> bLegendVisible;
//BFS03			}
//BFS03
//BFS03			if (nMoreData >= 8)
//BFS03			{
//BFS03				rIn >> nInt16; nCount = (short)nInt16;
//BFS03				for (i = 0; i < nCount; i++)
//BFS03				{
//BFS03					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
//BFS03
//BFS03					pAttr->Load(rIn);
//BFS03					aRegressAttrList.Insert(pAttr, LIST_APPEND);
//BFS03				}
//BFS03
//BFS03				rIn >> nInt16; nCount = (short)nInt16;
//BFS03				for (i = 0; i < nCount; i++)
//BFS03				{
//BFS03					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
//BFS03
//BFS03					pAttr->Load(rIn);
//BFS03					aAverageAttrList.Insert(pAttr, LIST_APPEND);
//BFS03				}
//BFS03
//BFS03				rIn >> nInt16; nCount = (short)nInt16;
//BFS03				for (i = 0; i < nCount; i++)
//BFS03				{
//BFS03					pAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
//BFS03
//BFS03					pAttr->Load(rIn);
//BFS03					aErrorAttrList.Insert(pAttr, LIST_APPEND);
//BFS03				}
//BFS03			}
//BFS03
//BFS03			if (nMoreData >= 9) rIn >> fAmbientIntensity;
//BFS03			if (nMoreData >= 10) rIn >> bTextScalable;
//BFS03			if (nMoreData >= 11) rIn >> aInitialSize;
//BFS03			if (nMoreData >= 12)     //FG: 20.2.1997
//BFS03			{
//BFS03				// FG: Vielleicht etwas viel Speicher fuer BOOL, aber es macht nur 16 Byte pro Chart
//BFS03				rIn >> nInt16;  bFormatXAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bFormatYAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bFormatZAxisTextInMultipleLinesIfNecessary = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bFormatLegendTextInMultipleLinesIfNecessary = (BOOL) nInt16;
//BFS03			}
//BFS03			if (nMoreData >= 13) // FG: 9.3.1997 Zusaetze wegen einer freien Positionierung und einem freien
//BFS03			{                    //     Resize von Gruppenobjekten im Chart.
//BFS03				rIn >> nInt16;  nXAxisTextMaximumNumberOfLines = nInt16;
//BFS03				rIn >> nInt16;  nYAxisTextMaximumNumberOfLines = nInt16;
//BFS03				rIn >> nInt16;  nZAxisTextMaximumNumberOfLines = nInt16;
//BFS03				rIn >> nInt32; nWidthOfFirstXAxisText = nInt32;
//BFS03				rIn >> nInt32; nWidthOfLastXAxisText = nInt32;
//BFS03				rIn >> aTitleTopCenter;
//BFS03				rIn >> aSubTitleTopCenter;
//BFS03				rIn >> aDiagramRectangle;
//BFS03				rIn >> aLegendTopLeft;
//BFS03				rIn >> aTitleXAxisPosition; // FG: welcher Punkt da jeweils gemeint ist findet
//BFS03				rIn >> aTitleYAxisPosition; //     bei nMoreData = 15
//BFS03				rIn >> aTitleZAxisPosition;
//BFS03				rIn >> nInt16;  bUseRelativePositionsForChartGroups = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForLegend = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForMainTitle = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForSubTitle = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForXAxisTitle = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForYAxisTitle = (BOOL) nInt16;
//BFS03				rIn >> nInt16;  bAdjustMarginsForZAxisTitle = (BOOL) nInt16;
//BFS03			}
//BFS03			if (nMoreData >= 14)
//BFS03			{
//BFS03				rIn >> aSpotColor;       // FG: Aenderung von DL damit sich das 3d-Chart die
//BFS03				rIn >> aAmbientColor;    //     Farbfilter-Einstellungen merkt.
//BFS03
//BFS03				rIn >> bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird
//BFS03				rIn >> bMainTitleHasBeenMoved;        //     soll es immer noch die relativen Positionen
//BFS03				rIn >> bSubTitleHasBeenMoved;         //     der Objektgruppen beachten, falls eine
//BFS03				rIn >> bLegendHasBeenMoved;           //     dieser Gruppen bewegt worden ist.
//BFS03				rIn >> bXAxisTitleHasBeenMoved;
//BFS03				rIn >> bYAxisTitleHasBeenMoved;
//BFS03				rIn >> bZAxisTitleHasBeenMoved;
//BFS03			}
//BFS03			if (nMoreData >= 15) // FG: 14.3.97 Es braucht noch die Information der Ausrichtung
//BFS03			{                    //             damit beim Resize die Texte richtig plaziert werden
//BFS03				rIn >> nInt16; eAdjustXAxesTitle = (ChartAdjust) nInt16;
//BFS03				rIn >> nInt16; eAdjustYAxesTitle = (ChartAdjust) nInt16;
//BFS03				rIn >> nInt16; eAdjustZAxesTitle = (ChartAdjust) nInt16;
//BFS03			}
//BFS03			if (nMoreData >= 16)
//BFS03			{
//BFS03				BOOL bNeedMerge=FALSE;
//BFS03				String aFmtStr;
//BFS03				ULONG nId;
//BFS03				if(nVersion <= 11)//ab V 12 X=Y=Z-Numberformatter!
//BFS03				{
//BFS03					SvNumberFormatter *pTmp = new SvNumberFormatter( ::comphelper::getProcessServiceFactory(),
//BFS03																	 LANGUAGE_SYSTEM );
//BFS03					pTmp->Load(rIn);
//BFS03					nId = IsPercentChart() ? nDescrPercentFormat : nDescrFormat;
//BFS03					const SvNumberformat* pFmt=pTmp->GetEntry(nId);
//BFS03
//BFS03					if(pFmt && (pFmt->GetType() & NUMBERFORMAT_DEFINED))
//BFS03					{
//BFS03						aFmtStr = pFmt->GetFormatstring();
//BFS03						bNeedMerge=TRUE;
//BFS03					}
//BFS03					delete pTmp;
//BFS03				}
//BFS03				else
//BFS03				{
//BFS03					pNumFormatter->SkipNumberFormatterInStream( rIn ); //Skip x
//BFS03				}
//BFS03				pOwnNumFormatter->Load( rIn );		// if not skipped load the own formatter ...
//BFS03				pNumFormatter = pOwnNumFormatter;	// ... and use it
//BFS03
//BFS03				// merge user formats of x axis formatter
//BFS03				if(bNeedMerge)
//BFS03				{
//BFS03					xub_StrLen nChk;
//BFS03					short nType;
//BFS03					pNumFormatter->PutEntry(aFmtStr,nChk,nType,nId,LANGUAGE_SYSTEM);
//BFS03					DBG_ASSERT(nChk==0,"Chart:: Converting X-Axis Numformat failed");
//BFS03					SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nId,IsPercentChart());
//BFS03				}
//BFS03
//BFS03				pNumFormatter->SkipNumberFormatterInStream(rIn);//aTmp.Load( rIn );//pNumFormatterZ //immer wegschmeissen, hatte nie userdef. formats
//BFS03			}
//BFS03		}
//BFS03		aLastDiagramRectangle = aDiagramRectangle;	// #68131# (#67459#)
//BFS03	}
//BFS03
//BFS03	// FG: Das ist notwendig damit in SchChartDocShell::Draw das Chart Initialisiert
//BFS03	//     wird, es also die wirkliche Groesse mitbekommt. Zum jetzigen Zeitpunkt nach dem
//BFS03	//     Laden gibt es ja noch kein Fenster. Ein Aufruf von BuildChart an dieser Stelle
//BFS03	//     geht also nicht. Bei einem Repaint wird in der oben genannten Methode abgefragt
//BFS03	//     ob das Chart bereits existiert (bNoBuildChart), falls nicht wird es neu angelegt.
//BFS03	//
//BFS03	//     bei den Versionen 4.0 oder hoeher wird die Initialisierung richtig gemacht
//BFS03	//     bei Charts die Inplace aus Versionen 3.1 verwendet werden passiert das schon
//BFS03	//     richtig.
//BFS03	//
//BFS03	//     Dies betrifft nur 3D-Charts, die im Format der Version 3.1 geschrieben wurden.
//BFS03	//
//BFS03	//     21.4. Aenderung: Das Chart kann ja aus allen gespeicheten Daten erzeugt werden.
//BFS03	//     um das File klein zu halten und da die Neuberechnung sehr viel schneller
//BFS03	//     geworden ist.
//BFS03	if (((rIn.GetVersion() <= SOFFICE_FILEFORMAT_31) && (Is3DChart())) ||
//BFS03		bUseRelativePositionsForChartGroups || (rIn.GetVersion() > SOFFICE_FILEFORMAT_31))
//BFS03	{
//BFS03		bNoBuildChart = TRUE;
//BFS03	}
//BFS03
//BFS03
//BFS03
//BFS03	if (nVersion >= 9)//#50116# Saeulenbreite
//BFS03	{
//BFS03		rIn >> nInt16; SetBarPercentWidth((long)nInt16);
//BFS03
//BFS03		rIn >> nInt32; m_nDefaultColorSet=nInt32;//#50149#
//BFS03
//BFS03		rIn >> nInt32;
//BFS03		// #78911# always set to 0 if charttype doesn't support lines
//BFS03		SetNumLinesColChart( ( eChartStyle == CHSTYLE_2D_LINE_COLUMN )? nInt32: 0 );
//BFS03
//BFS03		// #74536# BM use these three former -1 dummies for
//BFS03		// numberformat last set by CALC
//BFS03		rIn	>> nXLastNumFmt;
//BFS03		rIn	>> nYLastNumFmt;
//BFS03 		rIn	>> nBLastNumFmt;
//BFS03		rIn >> nInt32; // still dummy (-1)
//BFS03
//BFS03	}
//BFS03
//BFS03	if(nVersion >= 11)//10 existiert nicht (pChartAttr)
//BFS03	{
//BFS03
//BFS03		SfxItemSet aAttr(*pItemPool, nRowWhichPairs);
//BFS03		aAttr.Load(rIn);
//BFS03		pStockLineAttr->Put(aAttr);
//BFS03
//BFS03		aAttr.ClearItem();
//BFS03		aAttr.Load(rIn);
//BFS03		pStockLossAttr->Put(aAttr);
//BFS03
//BFS03		aAttr.ClearItem();
//BFS03		aAttr.Load(rIn);
//BFS03		pStockPlusAttr->Put(aAttr);
//BFS03	}
//BFS03
//BFS03	InitChartData(FALSE); //weia, beeinflusst die Achsen....also erst ab hier:
//BFS03
//BFS03
//BFS03	if(nVersion >= 12)
//BFS03	{
//BFS03		//Achse wird nur noch auf Attr-Basis gestreamt!
//BFS03
//BFS03		//nAxisId ist die zu ladene/speichernde Achse,
//BFS03		//festgelegt sind in V12 nur 1=X, 2=Y,3=Z und 4=B (2.Y-Achse)
//BFS03		//-1 bedeutet KEINE WEITEREN ACHSEN !!!!!!!!!!!
//BFS03		//Es MUSS keine Achse gestreamt werden (siehe Lade-Routine)
//BFS03		INT32 nAxisId=0;
//BFS03		SfxItemSet aAxisSet(*pItemPool,nAxisWhichPairs);
//BFS03		while(nAxisId != -1)//hier koennen beliebig viele, auch unbekannte Achsen kommen
//BFS03		{
//BFS03			aAxisSet.ClearItem();
//BFS03			rIn >> nAxisId;
//BFS03
//BFS03			switch(nAxisId)
//BFS03			{
//BFS03				case CHART_AXIS_PRIMARY_X:
//BFS03					aAxisSet.Load(rIn);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_X_AXIS,aAxisSet,FALSE);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_A_AXIS,aAxisSet,FALSE);//falls nicht spaeter geladen wird, hier neue defaults setzen
//BFS03					pChartAAxis->ShowAxis(FALSE); //default aus
//BFS03					pChartAAxis->ShowDescr(FALSE);
//BFS03					pChartXAxis->Update();	//Ab V12 kann jetzt der ganze LoadMemberCompat...Kram uebergebuegelt werden, in den Attr war alles drin!
//BFS03					pChartAAxis->Update();
//BFS03				break;
//BFS03				case CHART_AXIS_PRIMARY_Y:
//BFS03					aAxisSet.Load(rIn);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,aAxisSet,FALSE);
//BFS03					pChartYAxis->Update();
//BFS03				break;
//BFS03				case CHART_AXIS_PRIMARY_Z:
//BFS03					aAxisSet.Load(rIn);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_Z_AXIS,aAxisSet,FALSE);
//BFS03					pChartZAxis->Update();
//BFS03				break;
//BFS03				case CHART_AXIS_SECONDARY_Y:
//BFS03					aAxisSet.Load(rIn);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_B_AXIS,aAxisSet,FALSE);
//BFS03					pChartBAxis->Update();
//BFS03				break;
//BFS03				case CHART_AXIS_SECONDARY_X:
//BFS03					aAxisSet.Load(rIn);
//BFS03					SetAttributes(CHOBJID_DIAGRAM_A_AXIS,aAxisSet,FALSE);
//BFS03					pChartAAxis->Update();
//BFS03				break;
//BFS03				case -1: //Ende der Achsen!
//BFS03					break;
//BFS03				default: //Attrset kommt aus der Zukunft! Laden und vernichten:
//BFS03					{
//BFS03						aAxisSet.Load(rIn);
//BFS03					}
//BFS03					break;
//BFS03			}
//BFS03		}
//BFS03	}
//BFS03	else //defaults ergaenzen
//BFS03	{
//BFS03		SfxItemSet aSet(*pItemPool,nAxisWhichPairs);
//BFS03		aSet.Put(SfxInt32Item(SCHATTR_AXIS_TICKS,CHAXIS_MARK_OUTER));
//BFS03		SetAttributes(CHOBJID_DIAGRAM_X_AXIS,aSet);
//BFS03		SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,aSet);
//BFS03	}
//BFS03	//Ende IOVersion 12
//BFS03
//BFS03
//BFS03	if(nVersion >= 14)
//BFS03	{
//BFS03		rIn >> nTmp;
//BFS03		aBarY1.SetGap(nTmp);
//BFS03		rIn >> nTmp;
//BFS03		aBarY1.SetOverlap(nTmp);
//BFS03		rIn >> nTmp;
//BFS03		aBarY2.SetGap(nTmp);
//BFS03		rIn >> nTmp;
//BFS03		aBarY2.SetOverlap(nTmp);
//BFS03	}
//BFS03	else
//BFS03	{
//BFS03/*		aBarY1.SetGap()
//BFS03		aBarY1.SetOverlap(nTmp)
//BFS03		aBarY2.SetGap(nTmp)
//BFS03		aBarY2.SetOverlap(nTmp)
//BFS03		*/
//BFS03	}
//BFS03
//BFS03	if(nVersion >= 15)
//BFS03	{
//BFS03		SfxItemSet	*	pAttributes;
//BFS03		bResizePie=FALSE;
//BFS03		rIn >> bDiagramHasBeenMovedOrResized; // FG: 12.3.97, Falls das Chart gespeichert wird
//BFS03
//BFS03		if(IsReal3D() && (IsPieChart()||IsLine())) //Hack wegen  #62363#, double-sided neu defaulten
//BFS03		{
//BFS03			long nMax;
//BFS03			nMax=aDataRowAttrList.Count();
//BFS03			for(i=0;i<nMax;i++)
//BFS03//-/				aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,TRUE));
//BFS03				aDataRowAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03			nMax=aDataPointAttrList.Count();
//BFS03			for(i=0;i<nMax;i++)
//BFS03			{
//BFS03				pAttributes = aDataPointAttrList.GetObject(i);
//BFS03				if (pAttributes != NULL)
//BFS03					pAttributes->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03			}
//BFS03			nMax=aSwitchDataPointAttrList.Count();
//BFS03			for(i=0;i<nMax;i++)
//BFS03			{
//BFS03				pAttributes = aSwitchDataPointAttrList.GetObject(i);
//BFS03				if (pAttributes != NULL)
//BFS03					pAttributes->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03			}
//BFS03		}
//BFS03	}
//BFS03	else
//BFS03	{
//BFS03		//altes 3D-Pie?
//BFS03		bResizePie=TRUE;
//BFS03		if(IsReal3D() && IsPieChart())
//BFS03		{
//BFS03			Matrix4D aTmp;        //Matrix auf default
//BFS03
//BFS03			aTmp.RotateZ((900 + nYAngle) * F_PI / 1800); //??? !!!
//BFS03			aTmp.RotateX(-F_PI/3);
//BFS03
//BFS03			aSceneMatrix=aTmp;
//BFS03		}
//BFS03
//BFS03		if(IsReal3D()) //#61923#
//BFS03		{
//BFS03			long nMax;
//BFS03			nMax=aDataRowAttrList.Count();
//BFS03			SfxItemSet	*	pAttributes;
//BFS03			
//BFS03			for(i=0;i<nMax;i++)
//BFS03			{
//BFS03				if(IsPieChart()||IsLine())
//BFS03//-/					aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,TRUE));
//BFS03					aDataRowAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03				aDataRowAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
//BFS03			}
//BFS03
//BFS03			nMax=aDataPointAttrList.Count();
//BFS03			for(i=0;i<nMax;i++)
//BFS03			{
//BFS03				pAttributes = aDataPointAttrList.GetObject(i);
//BFS03				if (pAttributes == NULL)
//BFS03					continue;
//BFS03				if(IsPieChart()||IsLine())
//BFS03					aDataPointAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03				aDataPointAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
//BFS03			}
//BFS03
//BFS03
//BFS03			nMax=aSwitchDataPointAttrList.Count();
//BFS03			for(i=0;i<nMax;i++)
//BFS03			{
//BFS03				pAttributes = aSwitchDataPointAttrList.GetObject(i);
//BFS03				if (pAttributes == NULL)
//BFS03					continue;
//BFS03				if(IsPieChart()||IsLine())
//BFS03					aSwitchDataPointAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(TRUE));
//BFS03				aSwitchDataPointAttrList.GetObject(i)->Put(XLineStyleItem(XLINE_NONE));
//BFS03			}
//BFS03		}
//BFS03	}
//BFS03
//BFS03	// ******************** LAST READ ********************
//BFS03
//BFS03
//BFS03	// ############# defaults erstellen, falls alte Fileversion ####################
//BFS03
//BFS03	if(nVersion < 13)
//BFS03	{
//BFS03		if(IsXYChart())
//BFS03			aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_X));
//BFS03	}
//BFS03	//#54870# restaurieren der line-attribute
//BFS03	if( nVersion < 10)
//BFS03	{
//BFS03	   SetupLineColors(SETLINES_COMPAT);
//BFS03	}
//BFS03	if( nVersion < 16) //Automatische 2.YAchse in Items umsetzten
//BFS03	{
//BFS03		const SfxPoolItem* pPoolItem=NULL;
//BFS03		for(long n=0;n<GetRowCount();n++)
//BFS03			if(GetDataRowAttr(n).GetItemState(SCHATTR_AXIS,TRUE, &pPoolItem) == SFX_ITEM_SET)
//BFS03			if(((const SfxInt32Item*)pPoolItem)->GetValue()==CHART_AXIS_SECONDARY_Y)
//BFS03			{
//BFS03				n=GetRowCount();//abbruch
//BFS03				pChartBAxis->ShowDescr(TRUE);
//BFS03				pChartBAxis->ShowAxis(TRUE);
//BFS03			}
//BFS03	}
//BFS03
//BFS03	//dies ist immer moeglich (IoVersion<=16), in Zukunft sollten nur noch die Attr unterstuetzt werden, dann kann hier evtl. mit IOVersion geklammert werden!
//BFS03	pChartXAxis->ShowDescr(bShowXDescr);
//BFS03	pChartXAxis->ShowAxis(bShowXAxis);
//BFS03	pChartYAxis->ShowDescr(bShowYDescr);
//BFS03	pChartYAxis->ShowAxis(bShowYAxis);
//BFS03	pChartZAxis->ShowDescr(bShowZDescr);
//BFS03	pChartZAxis->ShowAxis(bShowZAxis);
//BFS03
//BFS03
//BFS03	//Bei unsortierten Charts machts keinen Sinn, nachdem Laden nochmal zu fragen
//BFS03	if( IsXYChart() )
//BFS03		SETFLAG( nChartStatus, CHS_USER_NOQUERY );
//BFS03	else
//BFS03		RESETFLAG( nChartStatus, CHS_USER_NOQUERY );
//BFS03
//BFS03	CHART_TRACE( "ChartModel::LoadAttributes END" );
//BFS03}

/*************************************************************************
|*
|* Titel aendern;
|* Liefert TRUE, wenn ein Titel geaendert wurde.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitle(BOOL bShowMain, const String& rMainTitle,
							 BOOL bShowSub, const String& rSubTitle,
							 BOOL bShowX, const String& rXAxisTitle,
							 BOOL bShowY, const String& rYAxisTitle,
							 BOOL bShowZ, const String& rZAxisTitle)
{
	BOOL bMainTitleChanged  = (bShowMain != bShowMainTitle || ! rMainTitle.Equals( aMainTitle ));
	BOOL bSubTitleChanged   = (bShowSub != bShowSubTitle || ! rSubTitle.Equals( aSubTitle ));
	BOOL bXAxisTitleChanged = (bShowX != bShowXAxisTitle || ! rXAxisTitle.Equals( aXAxisTitle ));
	BOOL bYAxisTitleChanged = (bShowY != bShowYAxisTitle || ! rYAxisTitle.Equals( aYAxisTitle ));
	BOOL bZAxisTitleChanged = (bShowZ != bShowZAxisTitle || ! rZAxisTitle.Equals( aZAxisTitle ));

	if (!bMainTitleChanged && !bSubTitleChanged &&
		!bXAxisTitleChanged && !bYAxisTitleChanged &&
		!bZAxisTitleChanged) return FALSE;
	else
	{
		if (bMainTitleChanged)
		{
			bShowMainTitle  = (bMainTitleChanged && (!rMainTitle.Len ()))
								  ? FALSE
								  : bShowMain;
			aMainTitle      = rMainTitle;
		}

		if (bSubTitleChanged)
		{
			bShowSubTitle   = (bSubTitleChanged && (!rSubTitle.Len ()))
								  ? FALSE
								  : bShowSub;
			aSubTitle       = rSubTitle;
		}

		if (bXAxisTitleChanged)
		{
			bShowXAxisTitle = (bXAxisTitleChanged && (!rXAxisTitle.Len ()))
								  ? FALSE
								  : bShowX;
			aXAxisTitle     = rXAxisTitle;
		}

		if (bYAxisTitleChanged)
		{
			bShowYAxisTitle = (bYAxisTitleChanged && (!rYAxisTitle.Len ()))
								  ? FALSE
								  : bShowY;
			aYAxisTitle     = rYAxisTitle;
		}

		if (bZAxisTitleChanged)
		{
			bShowZAxisTitle = (bZAxisTitleChanged && (!rZAxisTitle.Len ()))
								  ? FALSE
								  : bShowZ;
			aZAxisTitle     = rZAxisTitle;
		}

		if (bMainTitleChanged || bSubTitleChanged || bXAxisTitleChanged ||
			bYAxisTitleChanged || bZAxisTitleChanged) BuildChart(FALSE);

		return TRUE;
	}
}
/*************************************************************************
|*
|* Titel-Attribute setzen
|*
\************************************************************************/

void ChartModel::PutTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
	{
		pTitleAttr->ClearItem();
		pMainTitleAttr->ClearItem();
		pSubTitleAttr->ClearItem();
		pXAxisTitleAttr->ClearItem();
		pYAxisTitleAttr->ClearItem();
		pZAxisTitleAttr->ClearItem();
	}
	pTitleAttr->Put(rAttr);
	pMainTitleAttr->Put(rAttr);
	pSubTitleAttr->Put(rAttr);
	pXAxisTitleAttr->Put(rAttr);
	pYAxisTitleAttr->Put(rAttr);
	pZAxisTitleAttr->Put(rAttr);
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet & ChartModel::GetTitleAttr( UINT16 nChobjID ) const
{
    switch( nChobjID )
    {
        case CHOBJID_TITLE_MAIN:
            return *pMainTitleAttr;

        case CHOBJID_TITLE_SUB:
            return *pSubTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_X_AXIS:
            return *pXAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
            return *pYAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
            return *pYAxisTitleAttr;
    }
    return *pTitleAttr;
}

const SfxItemSet & ChartModel::GetTitleAttr( const SdrTextObj* pTextObj ) const
{
	if( pTextObj )
	{
		SchObjectId* pObjId = GetObjectId( * pTextObj );
        if( pObjId )
            return GetTitleAttr( pObjId->GetObjId() );
    }
    return *pTitleAttr;
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullTitleAttr(const SdrTextObj* pTextObj) const
{
	if (pTextObj)
	{
		SfxItemSet aAttr(*pItemPool, nTitleWhichPairs);

		aAttr.ClearItem ();

		SchObjectId* pObjId = GetObjectId(*pTextObj);

		if (pObjId) switch (pObjId->GetObjId())
					{
						case CHOBJID_TITLE_MAIN:
						{
							aAttr.Put(*pMainTitleAttr);
							break;
						}

						case CHOBJID_TITLE_SUB:
						{
							aAttr.Put(*pSubTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						{
							aAttr.Put(*pXAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						{
							aAttr.Put(*pYAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						{
							aAttr.Put(*pZAxisTitleAttr);
							break;
						}
					}
		return aAttr;
	}
	else
	{
		pTitleAttr->ClearItem ();
		pTitleAttr->Put (*pMainTitleAttr);
		CompareSets (*pSubTitleAttr, *pTitleAttr);
		CompareSets (*pXAxisTitleAttr, *pTitleAttr);
		CompareSets (*pYAxisTitleAttr, *pTitleAttr);
		CompareSets (*pZAxisTitleAttr, *pTitleAttr);

		return *pTitleAttr;
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rAttr,
								 SdrTextObj       *pTitleObj,
								 BOOL             bMerge)
{
	if (pTitleObj)
	{
		SchObjectId* pObjId = GetObjectId(*pTitleObj);

		if (!pObjId) return FALSE;
		else
		{
			SchObjectAdjust* pObjAdjust = GetObjectAdjust(*pTitleObj);
			DBG_ASSERT( pObjAdjust, "ChartModel::ChangeTitleAttr: no adjustment info in text obj") ;

			const SfxPoolItem  *pPoolItem = NULL;
			SvxChartTextOrient eOldOrient = pObjAdjust->GetOrient();
			SvxChartTextOrient eNewOrient = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
												? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
												: eOldOrient;

			switch (pObjId->GetObjId())
			{
				case CHOBJID_TITLE_MAIN:
					PutMainTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pMainTitleAttr,eOldOrient, eNewOrient);

					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_MAIN);
					else
//-/						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_TITLE_SUB:
					PutSubTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pSubTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_SUB);
					else
//-/						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					PutXAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pXAxisTitleAttr,eOldOrient, eNewOrient);
					 if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_X_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					PutYAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pYAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Y_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					PutZAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pZAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Z_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;
			}

			return TRUE;
		}
	}
	else
	{
		PutTitleAttr(rAttr,bMerge);
		return SetAllTitleAttributes (rAttr);
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rMainTitleAttr,
								 const SfxItemSet &rSubTitleAttr,
								 const SfxItemSet &rXAxisTitleAttr,
								 const SfxItemSet &rYAxisTitleAttr,
								 const SfxItemSet &rZAxisTitleAttr,
								 BOOL             bMerge)
{
	PutMainTitleAttr( rMainTitleAttr ,bMerge);
	PutSubTitleAttr(  rSubTitleAttr  ,bMerge);
	PutXAxisTitleAttr(rXAxisTitleAttr,bMerge);
	PutYAxisTitleAttr(rYAxisTitleAttr,bMerge);
	PutZAxisTitleAttr(rZAxisTitleAttr,bMerge);

	return SetAllTitleAttributes (*pMainTitleAttr);
}

/*************************************************************************
|*
|* Ermittelt, ob Legende angezeigt wird
|*
\************************************************************************/

BOOL ChartModel::GetShowLegend() const
{
	SvxChartLegendPos ePos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	switch (ePos)
	{
		case CHLEGEND_LEFT :
		case CHLEGEND_TOP :
		case CHLEGEND_RIGHT :
		case CHLEGEND_BOTTOM :
			return TRUE;

		default :
			return FALSE;
	}
}
/*************************************************************************
|*
|* Zeigt Legende an bzw. loescht sie.
|*
\************************************************************************/

void ChartModel::SetShowLegend(BOOL bShow)
{
	pLegendAttr->Put(SvxChartLegendPosItem(bShow
											   ? CHLEGEND_RIGHT
											   : CHLEGEND_NONE));
	bLegendVisible = bShow;
}
/*************************************************************************
|*
|* Legenden-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullLegendAttr() const
{
	SfxItemSet aAttr(*pItemPool, nLegendWhichPairs);
	aAttr.Put(*pLegendAttr);
	return aAttr;
}

/*************************************************************************
|*
|* Legenden-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeLegendAttr(const SfxItemSet& rAttr,
								  BOOL              bMerge)
{
	long nWEidth = ((XLineWidthItem &)rAttr.Get (XATTR_LINEWIDTH)).GetValue ();

	SdrPage* pPage = GetPage(0);
	DBG_ASSERT( pPage, "ChangeLegendAttr: page object is NULL" );

	const SfxPoolItem* pPoolItem = NULL;

	SvxChartLegendPos eOldPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	SvxChartLegendPos eNewPos;
	if (rAttr.GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eNewPos = ((const SvxChartLegendPosItem*)pPoolItem)->GetValue();
	else eNewPos = eOldPos;


	//#50913#: Legende hat neue Position? Wenn ja, dann relative Pos loeschen:
	if(eOldPos!=eNewPos)
		SetLegendHasBeenMoved(FALSE);

	PutLegendAttr(rAttr,bMerge);

	if ((eOldPos != CHLEGEND_NONE) && bLegendVisible)
	{
		SdrObjGroup *pLegendObj = (SdrObjGroup*)GetObjWithId(CHOBJID_LEGEND, *pPage);

		if ((eNewPos != CHLEGEND_NONE) && pLegendObj)
		{
			SdrObjList* pObjList = pLegendObj->GetSubList();
			SdrObject* pObj = GetObjWithId(CHOBJID_LEGEND_BACK, *pObjList);
			DBG_ASSERT(pObj, "ChartModel::ChangeLegendAttr: legend back obj not found");

//-/			pObj->SetAttributes(*pLegendAttr, FALSE);
            // #117446# (BM)
            SfxItemSet aLegendAttrClone( *pLegendAttr );
			pObj->SetMergedItemSetAndBroadcast( aLegendAttrClone );

			SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
			aTextAttr.Put(rAttr);

            // #117446# (BM)
            SfxItemSet aAttrClone( rAttr );
			SdrObjListIter aIterator(*pLegendObj->GetSubList(), IM_FLAT);
			while (aIterator.IsMore())
			{
				SdrObject* pObj = aIterator.Next();
				if (pObj->GetObjIdentifier() == OBJ_TEXT)
				{
					SetTextAttr(*(SdrTextObj*)pObj,aTextAttr);

//-/					pObj->SetAttributes(rAttr,0);
					pObj->SetMergedItemSetAndBroadcast( aAttrClone );
				}
			}
		}
	}
	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart(FALSE, CHOBJID_LEGEND);
}
/*************************************************************************
|*
|* Chart-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/
void ChartModel::ChangeChartAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	PutChartAttr(rAttr,bMerge);

	//Todo: Attr->eChartStyle
	BuildChart(FALSE);
}

/*************************************************************************
|*
|* Erstelle Symbole fuer Diagrammtypen mit Symbolen
|*
\************************************************************************/

BOOL ChartModel::TitleOrientChanged (const SdrTextObj   *pTitleObj,
									 const SfxItemSet   *pAttr,
									 SvxChartTextOrient eOldOrient,
									 SvxChartTextOrient eNewOrient)
{
	if (eOldOrient == eNewOrient) return TRUE;
	else
	{
		if( eNewOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( StackString( aTitle ) );
		}
		else if( eOldOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( UnstackString( aTitle ) );
		}

		long nOldHeight = GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();

		SetTextAttr(*((SdrTextObj *) pTitleObj),*pAttr);
		return nOldHeight != GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();
	}
}

/*************************************************************************
|*
|* Aendere die Attribute einer Achse
|*
\************************************************************************/

BOOL ChartModel::SetAllTitleAttributes(const SfxItemSet &rAttr)
{
	SdrPage          *pPage=GetPage(0);
	if (!pPage) return FALSE;
	else
	{
		BOOL               bBuildChart = FALSE;
		const SfxPoolItem  *pPoolItem  = NULL;
		SvxChartTextOrient eOldOrient  = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
											 ? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
											 : CHTXTORIENT_AUTOMATIC;

		if (bShowMainTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_MAIN, *pPage), pMainTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pMainTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart && bShowSubTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_SUB, *pPage), pSubTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pSubTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart)
		{
			SdrObjGroup *pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
			SdrObjList  *pList  = pGroup->GetSubList();

			if (bShowXAxisTitle)
				if (Is3DChart() ||                                                                     //TVMNEW: DEEP unoetig
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pXAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pXAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && bShowYAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage)//0,IM_DEEPWITHGROUPS)
																  , pYAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pYAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && Is3DChart() && bShowZAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pZAxisTitleAttr,eOldOrient,
										((const SvxChartTextOrientItem&)pZAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;
		}

		if (bBuildChart) BuildChart(FALSE);
		return TRUE;
	}
}

