/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_feflyole.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:16:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _IPOBJ_HXX
// auto strip #include <so3/ipobj.hxx>
// auto strip #endif
// auto strip #ifndef _EMBOBJ_HXX
// auto strip #include <so3/embobj.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_CLIENTSH_HXX
// auto strip #include <bf_sfx2/clientsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SCHDLL0_HXX
// auto strip #include <bf_sch/schdll0.hxx>
// auto strip #endif
#ifndef _SCH_DLL_HXX
#include <bf_sch/schdll.hxx>
#endif
// auto strip #ifndef _SCH_MEMCHRT_HXX
// auto strip #include <bf_sch/memchrt.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
// auto strip #include <svtools/moduleoptions.hxx>
// auto strip #endif

// auto strip #ifndef _FMTCNTNT_HXX
// auto strip #include <fmtcntnt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTANCHR_HXX
// auto strip #include <fmtanchr.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _FESH_HXX
#include <fesh.hxx>
#endif
// auto strip #ifndef _CNTFRM_HXX
// auto strip #include <cntfrm.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX
// auto strip #include <frmfmt.hxx>
// auto strip #endif
#ifndef _FLYFRM_HXX
#include <flyfrm.hxx>
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _EDIMP_HXX
// auto strip #include <edimp.hxx>
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
#ifndef _NOTXTFRM_HXX
#include <notxtfrm.hxx>
#endif
#ifndef _NDOLE_HXX
#include <ndole.hxx>
#endif
// auto strip #ifndef _SWCLI_HXX
// auto strip #include <swcli.hxx>
// auto strip #endif
namespace binfilter {

/*N*/ SwFlyFrm *SwFEShell::FindFlyFrm( const SvEmbeddedObject *pIPObj ) const
/*N*/ {
/*N*/ 	SwFlyFrm *pFly = FindFlyFrm();
/*N*/ 	if ( pFly && pFly->Lower() && pFly->Lower()->IsNoTxtFrm() )
/*N*/ 	{
/*?*/ 		SwOLENode *pNd = ((SwNoTxtFrm*)pFly->Lower())->GetNode()->GetOLENode();
/*?*/ 		if ( !pNd || &pNd->GetOLEObj().GetOleRef() != pIPObj )
/*?*/ 			pFly = 0;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pFly = 0;
/*N*/ 
/*N*/ 	if ( !pFly )
/*N*/ 	{
/*N*/ 		//Kein Fly oder der falsche selektiert. Ergo muessen wir leider suchen.
/*N*/ 		BOOL bExist = FALSE;
/*N*/ 		SwStartNode *pStNd;
/*N*/ 		ULONG nSttIdx = GetNodes().GetEndOfAutotext().StartOfSectionIndex() + 1,
/*N*/ 			  nEndIdx = GetNodes().GetEndOfAutotext().GetIndex();
/*N*/ 		while( nSttIdx < nEndIdx &&
/*N*/ 				0 != (pStNd = GetNodes()[ nSttIdx ]->GetStartNode()) )
/*N*/ 		{
/*N*/ 			SwNode *pNd = GetNodes()[ nSttIdx+1 ];
/*N*/ 			if ( pNd->IsOLENode() &&
/*N*/ 				//do not load Objects! must not be neccessary here
/*N*/ 				 ((SwOLENode*)pNd)->GetOLEObj().IsOleRef() &&
/*N*/ 				 &((SwOLENode*)pNd)->GetOLEObj().GetOleRef() == pIPObj )
/*N*/ 			{
/*N*/ 				bExist = TRUE;
/*N*/ 				SwFrm *pFrm = ((SwOLENode*)pNd)->GetFrm();
/*N*/ 				if ( pFrm )
/*N*/ 					pFly = pFrm->FindFlyFrm();
/*N*/ 				break;
/*N*/ 			}
/*N*/ 			nSttIdx = pStNd->EndOfSectionIndex() + 1;
/*N*/ 		}
/*N*/ 
/*N*/ 		ASSERT( bExist, "OLE-Object unknown and FlyFrm not found." );
/*N*/ 	}
/*N*/ 	return pFly;
/*N*/ }


//STRIP001 String SwFEShell::GetUniqueOLEName() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetUniqueOLEName();
//STRIP001 }


//STRIP001 String SwFEShell::GetUniqueFrameName() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetUniqueFrameName();
//STRIP001 }


//STRIP001 void SwFEShell::MakeObjVisible( const SvEmbeddedObject *pIPObj ) const
//STRIP001 {
//STRIP001 	SwFlyFrm *pFly = FindFlyFrm( pIPObj );
//STRIP001 	if ( pFly )
//STRIP001 	{
//STRIP001 		SwRect aTmp( pFly->Prt() );
//STRIP001 		aTmp += pFly->Frm().Pos();
//STRIP001 		if ( !aTmp.IsOver( VisArea() ) )
//STRIP001 		{
//STRIP001 			((SwFEShell*)this)->StartAction();
//STRIP001 			((SwFEShell*)this)->MakeVisible( aTmp );
//STRIP001 			((SwFEShell*)this)->EndAction();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*M*/ BOOL SwFEShell::FinishOLEObj()						// Server wird beendet
/*M*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 /*?*/ 	SfxInPlaceClient* pIPClient = GetSfxViewShell()->GetIPClient();
//STRIP001 /*?*/ 	BOOL bRet = pIPClient && pIPClient->IsInPlaceActive();
//STRIP001 /*?*/ 	if( bRet )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		if( CNT_OLE == GetCntType() )
//STRIP001 /*?*/ 	        ClearAutomaticContour();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//  Link fuer Daten-Highlighting im Chart zuruecksetzen
//STRIP001 /*?*/ 		SvtModuleOptions aMOpt;
//STRIP001 /*?*/ 		if( aMOpt.IsChart() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SvInPlaceObject* pObj = pIPClient->GetIPObj();
//STRIP001 /*?*/ 			SvGlobalName aObjClsId( *pObj->GetSvFactory() );
//STRIP001 /*?*/ 			SchMemChart* pMemChart;
//STRIP001 /*?*/ 			if( SchModuleDummy::HasID( aObjClsId ) &&
//STRIP001 /*?*/ 				0 != (pMemChart = SchDLL::GetChartData( pObj ) ))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pMemChart->SetSelectionHdl( Link() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ //ggfs. auch die Selektion restaurieren
//STRIP001 /*?*/ 				LockView( TRUE );	//Scrollen im EndAction verhindern
//STRIP001 /*?*/ 				ClearMark();
//STRIP001 /*?*/ 				LockView( FALSE );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( ((SwOleClient*)pIPClient)->IsCheckForOLEInCaption() !=
//STRIP001 /*?*/ 			IsCheckForOLEInCaption() )
//STRIP001 /*?*/ 			SetCheckForOLEInCaption( !IsCheckForOLEInCaption() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//InPlace beenden.
//STRIP001 /*?*/ 		pIPClient->GetProtocol().Reset2Open();
//STRIP001 /*?*/ 		SFX_APP()->SetViewFrame( GetSfxViewShell()->GetViewFrame() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	return bRet;
/*M*/ }




}
