<?php

/*************************************************************************\
* Bookkeeping (phpGroupWare app)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: tables_current.inc.php,v 1.6 2001/08/18 00:32:55 skeeter Exp $ */

$phpgw_baseline = array(
	'phpgw_bk_a' => array(
		'fd' => array(
			'account_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'account_type_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'bookkeeping_account_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'account' => array('type' => 'varchar', 'precision' => 255,'nullable' => False) 
		),
		'pk' => array('account_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_at' => array(
		'fd' => array(
			'account_type_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'account_type' => array('type' => 'varchar', 'precision' => 255,'nullable' => False)
		),
		'pk' => array('account_type_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_ba' => array(
		'fd' => array(
			'bookkeeping_account_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'bookkeeping_account' => array('type' => 'varchar', 'precision' => 255,'nullable' => False)
		),
		'pk' => array('bookkeeping_account_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_bm' => array(
		'fd' => array(
			'bookkeeping_account_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False),
			'module_id' => array('type' => 'int', 'precision' => 4,'nullable' => False)
		),
		'pk' => array(),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_c' => array(
		'fd' => array(
			'category_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'parent_category_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False),
			'bookkeeping_account_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'category' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'category' => array('type' => 'varchar', 'precision' => 255,'nullable' => False),
			'description' => array('type' => 'text')
		),
		'pk' => array('category_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_g' => array(
		'fd' => array(
			'group_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'group_' => array('type' => 'varchar', 'precision' => 255,'nullable' => False),
			'bookkeeping_account_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False)
		),
		'pk' => array('group_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_gpa' => array(
		'fd' => array(
		'group_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False),
			'phpgw_account_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False)
		),
		'pk' => array(),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_gr' => array(
		'fd' => array(
		'group_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False),
		'location_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False),
			'acl_right' => array('type' => 'int', 'precision' => 4, 'nullable' => False)
		),
		'pk' => array(),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_l' => array(
		'fd' => array(
			'location_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'location' => array('type' => 'varchar', 'precision' => 255,'nullable' => False),
			'module_id' => array('type' => 'int', 'precision' => 4, 'nullable' => False)
		),
		'pk' => array('location_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_m' => array(
		'fd' => array(
			'module_id' => array('type' => 'auto', 'precision' => 4, 'nullable' => False),
			'module' => array('type' => 'varchar', 'precision' => 255,'nullable' => False),
			'module_order' => array('type' => 'int', 'precision' => 4, 'nullable' => False)
		),
		'pk' => array('module_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	),
	'phpgw_bk_t' => array(
		'fd' => array(
			'transaction_id' => array('type' => 'auto','nullable' => False),
			'bookkeeping_account_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'date_transaction' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'category_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'description' => array('type' => 'text','nullable' => True),
			'amount' => array('type' => 'decimal', 'precision' => 20, 'scale' => 2, 'nullable' => False, 'default' => '0.00'),
			'currency_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'phpgw_account_id' => array('type' => 'int', 'precision' => 4,'nullable' => False),
			'account_id' => array('type' => 'int', 'precision' => 4,'nullable' => False)
		),
		'pk' => array('transaction_id'),
		'fk' => array(),
		'ix' => array(),
		'uc' => array()
	)
);

?>
