<?php
  /**************************************************************************\
  * phpGroupWare - Brewer styles                                             *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: styles.php,v 1.3 2001/09/11 12:38:28 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'brewer',
		'enable_nextmatchs_class' => True
	);

	include('../header.inc.php');

	$GLOBALS['phpgw']->template->set_file(array(
		'item_list_t' => 'listitem.tpl',
		'item_list'   => 'listitem.tpl'));
	$GLOBALS['phpgw']->template->set_block('item_list_t','item_list','list');

	$common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

	$GLOBALS['phpgw']->template->set_var('lang_action',lang('Styles List'));
	$GLOBALS['phpgw']->template->set_var('add_action',$GLOBALS['phpgw']->link('/brewer/add.php','type=style'));
	$GLOBALS['phpgw']->template->set_var('lang_add',lang('Add'));
	$GLOBALS['phpgw']->template->set_var('title',lang('Styles'));
	$GLOBALS['phpgw']->template->set_var('lang_search',lang('Search'));
	$GLOBALS['phpgw']->template->set_var('query',$query);
	$GLOBALS['phpgw']->template->set_var('actionurl',$GLOBALS['phpgw']->link('/brewer/styles.php'));
	$GLOBALS['phpgw']->template->set_var('lang_done',lang('Done'));
	$GLOBALS['phpgw']->template->set_var('doneurl',$GLOBALS['phpgw']->link('/brewer/index.php'));

	if (!$start)
	{
		$start = 0;
	}
	if (!$sort)
	{
		$sort = "ASC";
	}

	$b = CreateObject('brewer.brew','style');
	/* passed start, query, default sort and order, do limit */
	$styles = $b->style->get_list($start,$query,$sort,$order);
	$total_records = $b->style->total;

	//--------------------------------- nextmatch --------------------------------------------
	$left = $GLOBALS['phpgw']->nextmatchs->left('/brewer/styles.php',$start,$total_records);
	$right = $GLOBALS['phpgw']->nextmatchs->right('/brewer/styles.php',$start,$total_records);
	$GLOBALS['phpgw']->template->set_var('left',$left);
	$GLOBALS['phpgw']->template->set_var('right',$right);

	$GLOBALS['phpgw']->template->set_var('lang_showing',$GLOBALS['phpgw']->nextmatchs->show_hits($total_records, $start));

	//------------------------------ end nextmatch ------------------------------------------

	//------------------- list header variable template-declarations ------------------------- 
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('lang_name',$GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'name',$order,'/brewer/styles.php',lang('Style Name')));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_view',lang('View'));
	$GLOBALS['phpgw']->template->set_var('lang_delete',lang('Delete'));
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('th_text',$GLOBALS['phpgw_info']['theme']['th_text']);
	$GLOBALS['phpgw']->template->set_var('row_on',$GLOBALS['phpgw_info']['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);
	//-------------------------- end header declaration --------------------------------------
	@reset($style);
	while (list($key,$style) = @each($styles))
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);
		$GLOBALS['phpgw']->template->set_var(tr_color,$tr_color);
		$id = $style['id'];
		$name = $GLOBALS['phpgw']->strip_html($style['name']);
		//-------------------------- template declaration for list records ---------------------------
		$GLOBALS['phpgw']->template->set_var('name',$name);

		$GLOBALS['phpgw']->template->set_var('view',$GLOBALS['phpgw']->link('/brewer/view.php',"id=$id&type=style&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$GLOBALS['phpgw']->template->set_var('lang_view_entry',lang('View'));

		$GLOBALS['phpgw']->template->set_var('edit',$GLOBALS['phpgw']->link('/brewer/edit.php',"id=$id&type=style&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$GLOBALS['phpgw']->template->set_var('lang_edit_entry',lang('Edit'));

		$GLOBALS['phpgw']->template->set_var('delete',$GLOBALS['phpgw']->link('/brewer/delete.php',"id=$id&type=style&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$GLOBALS['phpgw']->template->set_var('lang_delete_entry',lang('Delete'));
		$GLOBALS['phpgw']->template->parse('list','item_list',True);
	}
	// ---------------------------- end record declaration -----------------------------------------

	$GLOBALS['phpgw']->template->parse('out','item_list_t',True);
	$GLOBALS['phpgw']->template->p('out');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
