<?php
/**
 * Generates page header.
 *
 * This file creates the "header" of the web page dependent on the 
 * theme being used by the user. If the user is not logged in, the 
 * default theme header is used.
 *
 * @module header
 * @modulegroup theme
 * @package phpWebSite
 */


/**
 * Global configuration file.
 */
include("config.php");

/**
 * Controls cacheing limits of browsers
 */
//CacheControl();

//#######################################################################
//  This if/else statement is for banner usage. We are not "offically"  #
//  supporting banners but we leave this code in for users who wish to  #
//  have banners on their site.                                         #
//#######################################################################
echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" 
\"DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">";
if ($banners)
{
  /**
   * Banner ad inclusion.
   */
	include("banners.php");
}

/**
 * Generates page header.
 *
 * The function checks if a user variable cookie is present, and 
 * determines the corresponding theme files (theme.php and header.php) 
 * to include.
 *
 * @param string
 * @param string
 */
function head($titletag="", $titlebar="")
{
  /**
   * Global configuration file.
   */
	include ("config.php");
	global $siteaddr, $user, $hr, $theme, $cookie, $admintest;
	global $menu;

	if(isset($user))
	{
		$user2 = base64_decode($user);
		$cookie = explode(":", $user2);

		if($cookie[9]=="") $cookie[9]="$default_theme";
		if(isset($theme)) $cookie[9]=$theme;

		// extra logic to override previous with $theme override var
	  /**
	   * theme.php of user theme.
	   */
		$theme_exists = @fopen("themes/$cookie[9]/theme.php", "r");
		if($theme_exists)
			include("themes/$cookie[9]/theme.php");
		else
			include("themes/$default_theme/theme.php");
	  /**
	   * header.php of user theme.
	   */
		$header_exists = @fopen("themes/$cookie[9]/header.php", "r");
		if($theme_exists && $header_exists)
			include("themes/$cookie[9]/header.php");
		else
			include("themes/$default_theme/header.php");
	}
	else
	{
	  /**
	   * theme.php of default theme.
	   */
		include("themes/$default_theme/theme.php");
	  /**
	   * header.php of default theme.
	   */
		include("themes/$default_theme/header.php");
	}
}

head($titletag, $titlebar);

/**
 * Does some statistics.
 */
include("counter.php");
?>
