#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <errno.h>

#include <config.h>
#include _PATH_CURSES_H

#include <support.h>
#include <xcio.h>
#include <msgcat.h>
#include <sysmsg.h>

#include "pform.h"
#include "smsg.h"

extern int ppxpFd;

static char *authTypes[]={
    "PAP CHAP/MD5 CHAP/MS",
    "PAP",
    "CHAP/MD5",
    "CHAP/MS",
}, *dialTypes[]={
    "Default",
    "Tone",
    "Pulse",
    "Isdn",
    "Piafs",
    "Piafs2",
    "Pte",
}, *modeTypes[]={
    "active",
    "passive",
    "kick",
};

static struct {
    char *dname;
    char *mname;
    char *number;
    char *uname;
    char *passwd1;
    char *passwd2;
    char *fname;
    char *idle;
    char *ipmasq;
    char *dns;
    bool_t vjc;
    bool_t resolv;
    int atype;
    int dtype;
    int mode;
} qSets;

static void
SetEnv(const char *name, char *value)
{
    struct xcio_s xc;
    char *p=NULL, *argv[10], *copy;
    int n, argc=1;

    if (!value || !*value) return;
    copy = Strdup(value);
    value = copy;
    argv[0] = (char *)name;
    while (argc < 9) {
	argv[argc] = value;
	argc ++;
	if ((p = strchr(value, ' ')) != NULL) {
	    *p = '\0';
	    p ++;
	    while (!*p && *p == ' ') p ++;
	    if (!*p) p = NULL;
	}
	if (p) value = p;
	else break;
    }
    argv[argc] = NULL;
    PPxPCommand(ppxpFd, XCMD_SET, argc, argv);
    while ((n = XcioRead(ppxpFd, &xc)) > 0 && n != XCIO_RETURN);
    Free(copy);
}

static int
QSave(char *name, int wx, int wy, int rw, int rh)
{
    struct pobj_s *fnam, *fok, *fcan, *obj;
    struct pwin_s *win;
    int x, y;
    char *bok, *bcancel;

    win = PwinOpen(name, wx, wy, &rw, &rh);

    x = rw/6;
    y = 0;
    fnam = PformNew(PFORM_INPUT, x, y += 2, MsgGet(MC_QDIAL_SAVEAS));
    PformReturnNext(fnam);

    y = rh - 1;
    bok = SysMsgGet(MS_T_OK);
    bcancel = SysMsgGet(MS_T_CANCEL);

    x = rw - strlen(bok) - strlen(bcancel) - 6;

    fok = PformNew(PFORM_BUTTON, x, y, bok);
    PformJumpKey(fok, KEY_CTRL('O'));
    PformActivate(fok, FALSE);
    x += strlen(bok) + 3;

    fcan = PformNew(PFORM_BUTTON, x, y, bcancel);
    PformJumpKey(fcan, KEY_CTRL('Q'));

    PformRealize(NULL);
    PformRealize(fnam);
    while ((obj = PformLoop()) != NULL) {
	bool_t check_ok=FALSE;
	char *tmp;

	if (obj == fnam) {
	    if (qSets.fname) Free(qSets.fname);
	    qSets.fname = ((tmp = PformInputGet(fnam)) != NULL) ?
		Strdup(tmp): NULL;
	    check_ok = TRUE;
	} else if (obj == fok) {
	    FILE *fp;
	    char *path, *dir;

	    dir = usrPPxP ? usrPPxP: sysPPxP;
	    if (qSets.uname && qSets.passwd1)
		PPxPwdSet(ppxpFd, qSets.fname, qSets.uname,
			  qSets.passwd1);
	    path = Malloc(strlen(dir) + sizeof("/conf/")
			  + strlen(qSets.fname) + 2);
	    sprintf(path, "%s/conf/%s", dir, qSets.fname);
	    fp = fopen(path, "w");
	    Free(path);
	    fprintf(fp, "source qdial\n"
		    "set MODE %s\n"
		    "set AUTH.PASSWD %s\n"
		    "set LOG.FILE %s.log\n", modeTypes[qSets.mode],
		    qSets.fname, qSets.fname);
	    if (qSets.dname) fprintf(fp, "set LINE %s\n", qSets.dname);
	    if (qSets.mname)
		fprintf(fp, "set SERIAL.MODEM %s\n", qSets.mname);
	    if (qSets.number)
		fprintf(fp, "set DIAL.LIST %s\n", qSets.number);
	    if (qSets.dtype) fprintf(fp, "set DIAL.TYPE %s\n",
			dialTypes[qSets.dtype]);
	    fprintf(fp, "set AUTH.PROTO %s\n", authTypes[qSets.atype]);
	    if (qSets.idle)
		fprintf(fp, "set IDLE.INIT %s\n", qSets.idle);
	    fprintf(fp, "set IP.VJ %s\n", qSets.vjc ? "yes": "no");
	    fprintf(fp, "set IP.RESOLV %s\n", qSets.resolv ? "yes": "no");
	    if (qSets.ipmasq && *qSets.ipmasq)
		fprintf(fp, "filter ip +mO -S %s\n", qSets.ipmasq);
	    if (qSets.dns && *qSets.dns)
		fprintf(fp, "set IP.DNS %s\n", qSets.dns);
	    fclose(fp);
	    break;
	} else if (obj == fcan) break;
	if (check_ok) {
	    PformActivate(fok, FALSE);
	    if (qSets.fname) PformActivate(fok, TRUE);
	}
    }
    PwinClose(win);
    return(0);
}

static int
FilterInputNum(struct pobj_s *obj, int c)
{
    return(isdigit(c) ? c: 0);
}

static int
QDetail(char *name, int wx, int wy, int rw, int rh)
{
    struct pobj_s *fath, *fmdm, *fmod, *fito, *fret, *fvjc, *fipm, *obj;
    struct pobj_s *fdns, *fres;
    struct pwin_s *win;
    struct list_s *mdmHp, *lp, *up;
    int x, y;
    unsigned int i, n;
    char *bret, *p;

    win = PwinOpen(name, wx, wy, &rw, &rh);

    x = rw/6;
    y = 0;

    fath = PformNew(PFORM_MENU, x, y += 2, MsgGet(MC_QDIAL_AUTH));
    PformReturnNext(fath);
    for (i = 0; i < sizeof(authTypes)/sizeof(authTypes[0]); i ++)
	PformMenuAdd(fath, authTypes[i]);
    PformMenuSet(fath, qSets.atype);

    fmod = PformNew(PFORM_MENU, x, y += 2, MsgGet(MC_QDIAL_PPPMODE));
    PformReturnNext(fmod);
    for (i = 0; i < sizeof(modeTypes)/sizeof(modeTypes[0]); i ++)
	PformMenuAdd(fmod, modeTypes[i]);
    PformMenuSet(fmod, qSets.mode);

    fmdm = PformNew(PFORM_MENU,  x, y += 2, MsgGet(MC_QDIAL_MODEM));
    PformReturnNext(fmdm);
    mdmHp = lp = FileList(sysPPxP, "modem");
    up = NULL;
    while (lp) {
	char *new;

	new = Malloc(strlen(lp->name) + 2);
	strcpy(new, "/");
	strcat(new, lp->name);
	Free(lp->name);
	lp->name = new;
	up = lp;
	lp = lp->next;
    }
    if (usrPPxP) {
	lp = FileList(usrPPxP, "modem");
	if (mdmHp) up->next = lp;
	else mdmHp = lp;
    }
    lp = SortList(mdmHp);
    mdmHp = lp;
    n = i = 0;
    if (!qSets.mname) qSets.mname = Strdup("/generic");
    while (lp) {
	PformMenuAdd(fmdm, lp->name);
	if (qSets.mname && !strcmp(lp->name, qSets.mname)) n = i;
	i ++;
	lp = lp->next;
    }
    PformMenuSet(fmdm, n);

    fito = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_IDLE));
    PformReturnNext(fito);
    PformInputFilter(fito, FilterInputNum);
    if (qSets.idle) PformInputSet(fito, qSets.idle);

    fipm = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_IPMASQ));
    PformReturnNext(fipm);
    if (!qSets.ipmasq) qSets.ipmasq = Strdup("");
    PformInputSet(fipm, qSets.ipmasq);

    fvjc = PformNew(PFORM_CHECK,  x, y += 2, MsgGet(MC_QDIAL_VJCOMP));
    PformReturnNext(fvjc);

    fres = PformNew(PFORM_CHECK,  x, y += 2, MsgGet(MC_QDIAL_RESOLV));
    PformReturnNext(fres);

    fdns = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_DNSERVER));
    PformReturnNext(fdns);
    if (!qSets.dns) qSets.dns = Strdup("");
    PformInputSet(fdns, qSets.dns);

    y = rh - 1;
    bret = SysMsgGet(MS_T_RETURN);

    x = rw - strlen(bret) - 3;
    fret = PformNew(PFORM_BUTTON, x, y, bret);
    PformJumpKey(fret, KEY_CTRL('Q'));

    PformRealize(NULL);
    PformRealize(fath);
    while ((obj = PformLoop()) != NULL) {
	char *tmp;

	if (obj == fath) {
	    qSets.atype = PformMenuGet(fath);
	} else if (obj == fmod) {
	    qSets.mode = PformMenuGet(fmod);
	} else if (obj == fvjc) {
	    qSets.vjc = PformCheckGet(fvjc);
	} else if (obj == fres) {
	    qSets.resolv = PformCheckGet(fres);
	} else if (obj == fmdm) {
	    n = PformMenuGet(fmdm);
	    lp = mdmHp;
	    i = 0;
	    while (lp) {
		if (i == n) {
		    if (qSets.mname) Free(qSets.mname);
		    qSets.mname = Strdup(lp->name);
		}
		lp = lp->next;
		i ++;
	    }
	} else if (obj == fdns) {
	    if (qSets.dns) Free(qSets.dns);
	    qSets.dns = ((tmp = PformInputGet(fdns)) != NULL) ?
		Strdup(tmp): NULL;
	} else if (obj == fipm) {
	    if (qSets.ipmasq) Free(qSets.ipmasq);
	    qSets.ipmasq = ((tmp = PformInputGet(fipm)) != NULL) ?
		Strdup(tmp): NULL;
	} else if (obj == fito) {
	    if (qSets.idle) Free(qSets.idle);
	    tmp = PformInputGet(fito);
	    qSets.idle = (tmp && atoi(tmp) > 0) ? Strdup(tmp): NULL;
	} else if (obj == fret) break;
    }
    PwinClose(win);
    DestroyList(mdmHp);
    return(0);
}

int
CmdQdial(int argc, char *argv[])
{
    struct pobj_s *fdev, *fdty, *fnum, *fusr,
	*fpw1, *fpw2, *fdgo, *fcan, *fsav, *fapy, *fdtl, *obj;
    int x, y, rw, rh, n;
    unsigned i;
    char *title, *bdial, *bsave, *bapply, *bcancel, *bdetail;

    title = MsgGet(MC_QDIAL_TITLE);
    PformOpen();

    rw = rh = 0;
    PwinOpen(title, 0, 0, &rw, &rh);

    x = rw/6;
    y = 0;
    fdev = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_DEVICE));
    PformReturnNext(fdev);
    if (!qSets.dname) qSets.dname = Strdup("/dev/modem");
    PformInputSet(fdev, qSets.dname);

    fdty = PformNew(PFORM_MENU,   x, y += 2, MsgGet(MC_QDIAL_DIAL));
    PformReturnNext(fdty);
    for (i = 0; i < sizeof(dialTypes)/sizeof(dialTypes[0]); i ++)
	PformMenuAdd(fdty, dialTypes[i]);
    PformMenuSet(fdty, qSets.dtype);

    fnum = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_NUMBER));
    PformReturnNext(fnum);
    if (qSets.number) PformInputSet(fnum, qSets.number);

    fusr = PformNew(PFORM_INPUT,  x, y += 2, MsgGet(MC_QDIAL_USER));
    PformReturnNext(fusr);
    if (qSets.uname) PformInputSet(fusr, qSets.uname);

    fpw1 = PformNew(PFORM_INPUT,  rw/2, y += 1,
		    MsgGet(MC_QDIAL_PASSWD1));
    PformReturnNext(fpw1);
    PformInputHide(fpw1, TRUE);
    fpw2 = PformNew(PFORM_INPUT,  rw/2, y += 1,
		    MsgGet(MC_QDIAL_PASSWD2));
    PformReturnNext(fpw2);
    PformInputHide(fpw2, TRUE);

    bdetail = MsgGet(MC_QDIAL_BDETAIL);
    fdtl = PformNew(PFORM_BUTTON, x, y += 2, bdetail);
    bsave = MsgGet(MC_QDIAL_BSAVE);
    fsav = PformNew(PFORM_BUTTON, x, y += 2, bsave);
    PformActivate(fsav, FALSE);

    y = rh - 1;
    bcancel = SysMsgGet(MS_T_CANCEL);
    bdial = MsgGet(MC_QDIAL_BDIAL);
    bapply = MsgGet(MC_QDIAL_BAPPLY);
    x = rw - strlen(bdial) - strlen(bcancel) - strlen(bapply) - 9;

    fdgo = PformNew(PFORM_BUTTON, x, y, bdial);
    PformJumpKey(fdgo, KEY_CTRL('D'));
    PformActivate(fdgo, FALSE);
    x += strlen(bdial) + 3;
    fapy = PformNew(PFORM_BUTTON, x, y, bapply);
    PformJumpKey(fapy, KEY_CTRL('A'));
    x += strlen(bapply) + 3;
    fcan = PformNew(PFORM_BUTTON, x, y, bcancel);
    PformJumpKey(fcan, KEY_CTRL('Q'));

    PformRealize(NULL);
    PformRealize(fdev);

    while ((obj = PformLoop()) != NULL) {
	bool_t check_go=FALSE, check_save=FALSE;
	char *tmp;

/*
	printw("%x %x\n", fcan, obj);refresh();
	usleep(5000000);
*/
	if (obj == fnum) {
	    if (qSets.number) Free(qSets.number);
	    qSets.number = ((tmp = PformInputGet(fnum)) != NULL) ?
		Strdup(tmp): NULL;
	    check_go = TRUE;
	} else if (obj == fusr) {
	    if (qSets.uname) Free(qSets.uname);
	    qSets.uname = ((tmp = PformInputGet(fusr)) != NULL) ?
		Strdup(tmp): NULL;
	    check_save = check_go = TRUE;
	} else if (obj == fpw1) {
	    if (qSets.passwd1) Free(qSets.passwd1);
	    qSets.passwd1 = ((tmp = PformInputGet(fpw1)) != NULL) ?
		Strdup(tmp): NULL;
	    check_save = check_go = TRUE;
	} else if (obj == fpw2) {
	    if (qSets.passwd2) Free(qSets.passwd2);
	    qSets.passwd2 = ((tmp = PformInputGet(fpw2)) != NULL) ?
		Strdup(tmp): NULL;
	    check_save = check_go = TRUE;
	} else if (obj == fdev) {
	    if (qSets.dname) Free(qSets.dname);
	    qSets.dname = ((tmp = PformInputGet(fdev)) != NULL) ?
		Strdup(tmp): NULL;
	    check_go = TRUE;
	} else if (obj == fdty) {
	    qSets.dtype = PformMenuGet(fdty);
	    check_go = TRUE;
	} else if (obj == fdgo || obj == fapy) {
	    struct xcio_s xc;

	    PPxPCommandv(ppxpFd, XCMD_DOT, "qdial", NULL);
	    while ((n = XcioRead(ppxpFd, &xc)) > 0 && n != XCIO_RETURN);
	    if (qSets.uname && qSets.passwd1)
		PPxPwdSet(ppxpFd, NULL, qSets.uname, qSets.passwd1);
	    SetEnv("MODE", modeTypes[qSets.mode]);
	    SetEnv("LINE", qSets.dname);
	    SetEnv("SERIAL.MODEM", qSets.mname);
	    SetEnv("DIAL.LIST", qSets.number);
	    if (qSets.dtype)
		SetEnv("DIAL.TYPE", dialTypes[qSets.dtype]);
	    SetEnv("AUTH.PROTO", authTypes[qSets.atype]);
	    SetEnv("IDLE.INIT", qSets.idle);
	    SetEnv("IP.VJ", qSets.vjc ? "yes": "no");
	    SetEnv("IP.RESOLV", qSets.resolv ? "yes": "no");
	    if (qSets.dns && *qSets.dns)
		SetEnv("IP.DNS", qSets.dns);
	    if (obj == fdgo) {
		PPxPCommandv(ppxpFd, XCMD_CONNECT, NULL);
		while ((n = XcioRead(ppxpFd, &xc)) > 0
		       && n != XCIO_RETURN);
	    }
	    break;
	} else if (obj == fsav)
	    QSave(bsave, 1, 1, rw - 2, rh - 2);
	else if (obj == fdtl)
	    QDetail(bdetail, 1, 1, rw - 2, rh - 2);
	else if (obj == fcan) break;

	if (check_go) {
	    PformActivate(fdgo, FALSE);
	    if (qSets.number && qSets.uname && qSets.passwd1
		&& qSets.passwd2 && qSets.dname
		&& !strcmp(qSets.passwd1, qSets.passwd2))
		PformActivate(fdgo, TRUE);
	}
	if (check_save) {
	    PformActivate(fsav, FALSE);
	    if (qSets.uname && qSets.passwd1 && qSets.passwd2
		&& !strcmp(qSets.passwd1, qSets.passwd2))
		PformActivate(fsav, TRUE);
	}
    }

    PformClose();
    return(0);
}
