#!@@PERL@@ @@PERLOPTS@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# split-config - convert the old config-file format to
#		the new config-dir form
# $Id: split-config.pl,v 1.4 2001/08/28 15:22:24 remstats Exp $

# - - -   Configuration   - - -

use strict;

# What is this program called, for error-messages and file-names
$main::prog = 'split-config';
# Which files need to be created, empty if necessary?
@main::files = ('alerts', 'archives', 'colors', 'general', 'groups', 
	'html', 'links', 'oids', 'remotepings', 'times', 'tools');
# Which directories need to get created?
@main::dirs = ('customgraphs', 'datapages', 'views', 'view-templates');

# - - -   Version History   - - -

(undef, $main::version) = split(' ', '$Revision: 1.4 $');

# - - -   Setup   - - -

use Getopt::Std;
use lib '.', '@@LIBDIR@@';
require "remstats.pl";

# Parse the command-line
# STRICT use vars qw( $opt_d $opt_h );
getopts('d:h');

if (defined $main::opt_h) { &usage; } # no return
if (defined $main::opt_d) { $main::debug = $main::opt_d; } else { $main::debug = 0; }

unless ($#ARGV == 1) { &usage; } # no return

my $config_file = shift @ARGV;
my $config_dir = shift @ARGV;

unless (-f $config_file) {
	&abort("no such configfile as $config_file");
}

if (-e $config_dir) {
	&abort("configdir $config_dir exists");
}
else {
	mkdir $config_dir, 0755 or
		&abort("can't mkdir $config_dir: $!");
}

# - - -   Mainline   - - -

open (OLD, "<$config_file") or &abort("can't open $config_file: $!");

my %done_files = ();
my %done_dir = ();
my $opened_new = 0;
my $saved_html = '';
my $saved_comments = '';
my ($section_type, $section_name, $section, $filename);
while (<OLD>) {
	chomp;
	&debug("old: $_") if ($main::debug>1);
	if (/^\[(\S+)(\s+(\S+))?\]\s*$/) {
		$section_type = $1;
		$section_name = $3;
		if ($section_type eq 'host' or $section_type eq 'script' or
				$section_type eq 'rrd' or $section_type eq 'remoteping' or
				$section_type eq 'customgraph') {
			$section_type .= 's';
		}
		$done_files{$section_type} = 1;
		if (defined $section_name and $section_name =~ /(.*)-\*$/) {
			$section_name = $1 .'-';
		}
		$section = $section_type . ((defined $section_name) ? ' '. $section_name : '');;
		&debug("starting $section") if ($main::debug);

		if (defined $section_name) {
			unless (-d ($config_dir .'/'. $section_type)) {
				&debug("mkdir for $config_dir/$section_type") if ($main::debug);
				mkdir $config_dir .'/'. $section_type, 0755 or
					&abort("can't mkdir $config_dir/$section_type: $!");
				$done_dir{$section_name} = 1;
			}
			$filename = $config_dir .'/'. $section_type .'/'. $section_name;
		}
		else {
			$filename = $config_dir .'/'. $section_type;
		}

		&debug("writing $filename") if ($main::debug);
		open (NEW, ">$filename") or &abort("can't open $filename: $!");
		$opened_new = 1;
	}
	else {
		if (/^#/ or /^\s*$/) {
			$saved_comments .= $_ ."\n";
			next;
		}
		if ($section_type eq 'general') {
			if (/^groups\s+(.*)/) {
				my @groups = &make_array($1);
				$filename = $config_dir . '/groups';
				open (GROUPS, ">$filename") or &abort("can't open $filename: $!");
				print GROUPS $saved_comments . join("\n", @groups) . "\n";
				close (GROUPS);
				$saved_comments = '';
			}
			elsif (/^[a-z]+(status|url)\s+.*/ or /^htmldir\s/ or /^rrdcgi\s/ or 
					/^imagetype\s/ or /^htmlrefresh\s/ or /^thumbnail\s/ or
					/^metadata\s/ or /^webmaster\s/ or /^pagesas\s/ or
					/^alertflag\s/ or /^uptimeflag\s/) {
				$saved_html .= $saved_comments . $_ . "\n";
				$saved_comments = '';
			}
			else {
				print NEW $saved_comments . $_ . "\n" if ($opened_new);
				$saved_comments = '';
			}
		}
		else {
			print NEW $saved_comments . $_ . "\n" if ($opened_new);
			$saved_comments = '';
		}
	}
}
close (NEW);
close (OLD);

# Write an html config-file
$filename = $config_dir . '/html';
open (HTML, ">$filename") or &abort("can't open $filename: $!");
print HTML <<"EOD_HTML";
# html - things relating to web-page generation

# override these to change the labels in the HTML, e.g. to translate
alertreport		Alert Report
comment			Comment
contact			Contact
customindex		Custom Index
description		Description
groupindex		Group Index
hardware		Hardware
hostindex		Host Index
indices			Indices
ipnumber		IP #
lastupdateon	This page last updated on
links			Links
logreport		Log Report
operatingsystem	Operating System
overallindex	Overall Index
pingindex		Ping Index
quickindex		Quick Index
status			Status
tools			Tools
uptime			Uptime

EOD_HTML
if ($saved_html) { print HTML $saved_html; }
close (HTML);


# Now make sure we got all the files we need
foreach (@main::files) {
	if (defined $done_files{$_}) {
		next;
	}
	else {
		$filename = $config_dir .'/'. $_;
		open (FILE, ">$filename") or &abort("can't open $filename: $!");
		print FILE "# $_ - placeholder for empty section\n";
		close (FILE);
	}
}

# Now make sure that certain directories get created
foreach (@main::dirs) {
	if (defined $done_dir{$_}) {
		next;
	}
	else {
		my $dir = $config_dir .'/'. $_;
		mkdir $dir, 0755 or &abort("can't mkdir $dir: $!");
	}
}

exit 0;

#----------------------------------------------------------------- usage ---
sub usage {
	print STDERR <<"EOD_USAGE";
$main::prog version $main::version
usage: $0 [options] configfile configdir
where options are:
	-d	enable debugging output
	-h	show this help
EOD_USAGE
	exit 0;
}

#----------------------------------------------------------------- debug ---
sub debug {
	my ($msg) = @_;

	if ($main::debug) { print STDERR "DEBUG: $msg\n"; }
0;
}

#------------------------------------------------------------------ abort ---
sub abort {
	my ($msg) = @_;
	print STDERR "main::prog: ABORT: $msg\n";
	exit 1;
}

#----------------------------------------------- keep_strict_happy ---
sub keep_strict_happy {
	$main::opt_h = 0;
}
