require 'test/unit'

class TestVariable < Test::Unit::TestCase
  class Gods
    @@rule = "Uranus"
    def ruler0
      @@rule
    end

    def self.ruler1		# <= per method definition style
      @@rule
    end
    class << self			# <= multiple method definition style
      def ruler2
	@@rule
      end
    end
  end

  module Olympians
    @@rule ="Zeus"
    def ruler3
      @@rule
    end
  end

  class Titans < Gods
    @@rule = "Cronus"			# do not affect @@rule in Gods
    include Olympians
    def ruler4
      @@rule
    end
  end

  def test_variable
    assert_instance_of(Fixnum, $$)
    
    # read-only variable
    assert_raises(NameError) do
      $$ = 5
    end

    foobar = "foobar"
    $_ = foobar
    assert_equal(foobar, $_)

    assert_equal("Uranus", Gods.new.ruler0)
    assert_equal("Uranus", Gods.ruler1)
    assert_equal("Uranus", Gods.ruler2)
    assert_equal("Uranus", Titans.ruler1)
    assert_equal("Uranus", Titans.ruler2)
    atlas = Titans.new
    assert_equal("Uranus", atlas.ruler0)
    assert_equal("Zeus", atlas.ruler3)
    assert_equal("Cronus", atlas.ruler4)
  end
end
