.TH sane-epson 5 "27-Dec-2000"
.IX sane-epson
.SH NAME
sane-epson - SANE backend for EPSON scanners
.SH DESCRIPTION
The
.B sane-epson
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Epson flatbed scanners.  Some functions of this 
backend should be considered
.B beta-quality
software! Most functions have been stable for a long time, but of 
course new development can not and will not function properly from
the very first day. Please report any strange behavior to the 
maintainer of the backend.
.PP
At present, the following scanners are known to work with this backend:
.PP
.RS
Model:                       Connection Type
.br
---------------------------  -------------------
.br
GT-5000                      parallel
.br
GT-6000                      parallel
.br
ActionScanner II             parallel
.br
GT-7000                      SCSI
.br
Perfection 636               SCSI
.br
Perfection 636U              USB
.br
Perfection 610               USB
.br
Perfection 640               USB
.br
Perfection 1200S             SCSI
.br
Perfection 1200U             USB
.br
Perfection 1240              USB, SCSI
.br
Perfection 1640              USB, SCSI
.br
Perfection 1650              USB
.br
Perfection 2450              USB
.br
Expression 636 / GT-9500     SCSI
.br
Expression 1600              USB, SCSI, IEEE-1394
.RE

For other scanners the software  may or may not work.  Please send mail to 
the backend author (khk@khk.net) to report successes or failures.
.SH OPTIONS
The options the backend supports can either be selected through command line
options to programs like scanimage or through GUI elements in xscanimage or xsane.

Valid command line options and their syntax can be listed by using 
.RS
scanimage --help -d epson
.RE
Not all devices support all options.
.TP
.I Scan Mode
The 
.I --mode 
switch selects the basic mode of operation of the scanner valid choices are 
.I Binary, Gray and Color. 
The Binary mode is black and white only, Gray will produce 256 levels of gray 
or more depending on the scanner and Color means 24 bit color mode or more 
depending on the scanner.  Some scanners will internally use 36 bit color, 
the external interface however does only support 24 bits.

The
.I --depth
option selects the bit depth the scanner is using. This option is only available
for scanners that support more than one bit depth. Older scanners will always
transfer the image in 8bit mode. Newer scanners allow to select either 8 bits 
or 12 or 14 bits per color channel. For a color scan this means an effective
color depth of 36 or 42 bits over all channels. The valid choice depend on 
the scanner model.

The 
.I --dropout 
option determines which color filters are used to scan in Binary mode. Valid choices
are None, Red, Green and Blue.

The
.I --halftoning
switch selects the mode that is used in Binary mode. Valid options are None, 
Halftone A (Hard Tone), Halftone B (Soft Tone), Halftone C (Net Screen), 
Dither A (4x4 Bayer), Dither B (4x4 Spiral), Dither C (4x4 Net Screen), 
Dither D (8x4 Net Screen), Text Enhanced Technology, Download pattern A, 
and Download pattern B.

The 
.I --dropout
switch selects the so called dropout color. Vald options are None, Red, Green 
and Blue. The default is None. The dropout color is used for 
monochrome scanning and selects the color that is not scanned. This can be used
to e.g. scan an original with a colored background.

The
.I --brightness
switch controls the brightness of the scan. Valid options are the numbers from -3 to 
3. The default is 0. The larger the brightness value, the brighter the image gets. If 
a user defined table for the gamma correction is selected, the brightness parameter is
not available.

The
.I --sharpness
switch sets the sharpness of the image data. Valid options are the numbers from -2 to 
2, with -2 meaning "Defocus", -1 "Defocus slightly", 0 "Normal", 1 "Sharpen slighly"
and 2 "Sharpen". 

The 
.I --gamma-correction
switch controls the scanne internal gamma correction. Valid options are "Default", "User
defined", "High density printing" "Low density printing" and "High contrast printing".

The 
.I --color-correction
switch controls the scanner internal color correction function. Valid options are "No 
Correction", "Impact-dot printers", "Thermal printers", "Ink-jet printers" and "CRT
monitors". The default is "CRT monitors". 

The 
.I --resolution
switch selects the resolution for a scan. Many EPSON scanners will scan in any resulution between
the lowest and highest possible value. The list reported by the scanner can be displayed using
the "--help -d epson" parameters to scanimage.

The 
.I --mirror
option controls the way the image is scanned. By reading the image data from right to left the
image is mirored. Valid options are "yes" and "no". The default is "no".

The 
.I --speed
option can improve the scan speed in monochrome mode. Valid options are "yes" or "no", the "yes"
option will speed up the scan if this option is supported.

The 
.I --auto-area-segmentation 
switch turns on the automatic area segmentation for monochrome scans. The scanner will try to 
determine which areas are text and which contain images. The image areas will be halftoned, 
and the text will be impoved. Valid options are "yes" and "no". The default is "yes".

The 
.I --gamma-table
parameter can be used to download a user defined gamma table. The options takes 256 values from
the range 0-255. In color mode this option equally affects the red, green, and blue channel.

The 
.I --red-gamma-table 
parameter can be used to download a user defined gamma table for the red channel. The valid
options are the same as for --gamma-table.

The 
.I --green-gamma-table 
parameter can be used to download a user defined gamma table for the green channel. The valid
options are the same as for --gamma-table.

The 
.I --blue-gamma-table 
parameter can be used to download a user defined gamma table for the blue channel. The valid
options are the same as for --gamma-table.

The color correction coefficients
.I --cct-1 --cct-2 --cct-3 ... --cct-9
will install color correction coefficients for the user defined color correction. Possible 
values are in the range -127..127.


The 
.I --preview
option requests a preview scan. The frontend software automatically selects a low 
resolution. Valid options are "yes" and "no". The default is "no".

The 
.I --preview-speed
options will increase the scan speed if this is supported by the scanner. Valid options
are "yes" and "no", the default is "no".
 

The geometry options
.I -l -t -x -y 
control the scan area: -l sets the top left x coordinate, -t the top left y coordinate, 
-x selects the width and -y the height of the scan aea. All parameters are specified in
milimeters.

The
.I --quick-format
option lets the user select a scan area with predefined sizes. Valid parameters are "CD", 
"A5 portrait", "A5 landscape", "Letter", "A4" and "max". The default is "max", which 
selects the largest possible area.

The
.I --source
option selects the scan source. Valid options depend on the installed options. The default
is "Flatbed".

The 
.I --auto-eject
option will eject a page after scanning from the document feeder. 

The
.I --film-type
option will select the film type for scans with the transparency unit. This
option is only activated of the TPU is selected as scan source. Valid options
are "Negative Film" and "Positive Film".

The
.I --focus-position
option selects the focus position for all scans. Valid options are "Focus 2.5mm above
glass" and "Focus on glass". The focus on the 2.5mm point above the glass is 
necessary for scans with the transparency unit, so that the scanner can focus on the
film if one of the film holders is used.



.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/epson.conf specifies the device(s) that the 
backend will use. The current version only supports one scanner per Epson 
backend. Possible connection types are:
.TP
.I SCSI
This is the default, and if nothing else is specified the backend software will
open a given patch as SCSI device. More information about valid syntax for SCSI
devices can be found in sane-scsi(5).
.TP
.I PIP - Parallel Interface
The parallel interface can be configured in two ways: An integer number starting
at the beginning of a line will be interpreted as the IO address of the parallel
port. To make it clearer that a configured IO address is a parallel port the 
port address can be preceded by the string "PIO". The PIO connection does not
use a special device file in the /dev directory.
.TP
.I USB
A device file that is preceded by the string "USB" is treated as a scanner 
connected via the Universal Serial Bus. The correct special device file has
to be created prior to using it with Sane. See the USB documentation for 
more information about how to set up the USB subsystem and the required 
device files.
.SH FILES
.TP
.I @LIBDIR@/libsane-epson.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-epson.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_EPSON
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.TP
.B SANE_EPSON_CMD_LVL
This allows to override the function or command level that the backend 
uses to communicate with the scanner. The function level a scanner
supports is determined during the initialization of the device. If
the backend does not recognize the function level reported by the 
scanner it will default to function level B5. Valid function levels
are A1, A2, B1, B2, B3, B4, B5, B6, B7, B8 and F5. Use this feature
only if you know what you are doing!

.SH "SEE ALSO"

sane\-scsi(5), scanimage(1), xscanimage(1), xsane(1)

.SH BUGS

None :-) At least none are currently known.

.SH UNSUPPORTED DEVICES
The backend may be used with Epson scanners that are not yet listed 
under the list of supported devices. A scanner that is not recognized
may default to the function level B3, which means that not all 
functions that the scanner may be capable of are accessible. 

If the scanner is not even recognized as an Epson scanner this is
probably because the device name reported by the scanner is not in the
correct format. Please send this information to the backend maintainer
(email address is in the AUTHOR section of this man page or in the
AUTHORS file of the SANE distribution). 

.SH AUTHOR

The package is actively maintained by Karl Heinz Kremer (khk@khk.net). The
software is based on work by Christian Bucher and Kazuhiro Sasayama
