<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */


function createDBIndex($db, $table, $field, $index_name)
{
   $sql = 'CREATE INDEX '.$index_name.' ON '.$table.' ('.$field.')';

   $db->acidExecute($sql, -1, -1, false);
   if ( $db->acidErrorMessage() != "" )
      ErrorMessage("Unable to CREATE INDEX for '".$field."' : ".$db->acidErrorMessage());
   else
      ErrorMessage("Successfully created INDEX for '".$field."'");
}

function verify_db($db, $alert_dbname, $alert_host)
{
  $msg = '<B>The underlying database '.$alert_dbname.'@'.$alert_host.' apears to be incomplete/invalid</B>';

  $sql = "SELECT ip_src FROM iphdr";
  $result = $db->acidExecute($sql, 0, 1, false);
  if ( $db->acidErrorMessage() != "" )
     return $msg.'<BR>'.$db->acidErrorMessage().'
            <P>It might be an older version.  Only alert databases created by Snort 1.7-beta0
            or later are supported';
 
  if ( !$db->acidTableExists("acid_ag") )
     return $msg.'.  <P>The database version is valid, but the ACID DB structure (table: acid_ag)
                     is not present. Use the <A HREF="acid_db_setup.php">Setup page</A> to configure
                     and optimize the DB.';

  if ( !$db->acidTableExists("acid_ag_alert") )
     return $msg.'.  <P>The database version is valid, but the ACID DB structure (table: acid_ag_alert)
                     is not present.  Use the <A HREF="acid_db_setup.php">Setup page</A> to configure
                     and optimize the DB.';

  if ( !$db->acidTableExists("acid_ip_cache") )
     return $msg.'.  <P>The database version is valid, but the ACID DB structure (table: acid_ip_cache)
                     is not present.  Use the <A HREF="acid_db_setup.php">Setup page</A> to configure
                     and optimize the DB.';
  
  return "";
}

function verify_php_build($DBtype)
/* Checks whether the neccessary libraries is built into PHP */
{
  /* Check PHP version >= 4.0.4 */
  $current_php_version = phpversion();
  $version = explode(".", $current_php_version);

  /* account for x.x.xXX subversions possibly having text like 4.0.4pl1 */
  if ( is_numeric(substr($version[2], 1, 1)) ) 
     $version[2] = substr($version[2], 0, 2);
  else
     $version[2] = substr($version[2], 0, 1);

  if ( !( ($version[0] >= 4) && ($version[1] >= 0) && ($version[2] >= 4) ) )
  {
     return "<FONT COLOR=\"#FF0000\">PHP ERROR</FONT>: ".
            "<B>Incompatible version</B>: <FONT>Version ".$current_php_version.
            " of PHP is too old.  Please upgrade to version 4.0.4 or later</FONT>";
  }

  if ( ($DBtype == "mysql") || ($DBtype == "mysqlt") )
  {
     if ( !(function_exists("mysql_connect")) )
     {
        return "<FONT COLOR=\"#FF0000\">PHP ERROR</FONT>: ".
               "<B>PHP build incomplete</B>: <FONT>the prerequisite MySQL support required to ".
               "read the alert database was not built into PHP.  ".
               "Please recompile PHP with the necessary library (<CODE>--with-mysql</CODE>)</FONT>";
     }
  }
  else if ( $DBtype == "postgres" )
  {
     if ( !(function_exists("pg_connect")) )
     {
        return "<FONT COLOR=\"#FF0000\">PHP ERROR</FONT>: ".
               "<B>PHP build incomplete</B>: <FONT>the prerequisite PostgreSQL support required to ".
               "read the alert database was not built into PHP.  ".
               "Please recompile PHP with the necessary library (<CODE>--with-pgsql</CODE>)</FONT>";
     }
  }
  else
     return "<B>Unknown Database type specified</B>:  a <CODE>DBtype</CODE> of ".
            " '$DBtype' was specified";

  if ( !(function_exists("bccomp")) )
  {
        return "<FONT COLOR=\"#FF0000\">PHP ERROR</FONT>: ".
               "<B>PHP build incomplete</B>: <FONT>the prerequisite BCMath support required to ".
               "manipulate IP addresses was not build into PHP.  ".
               "Please recompile PHP with the necessary library (<CODE>--enable-bcmath</CODE>)</FONT>";
  }

  return "";
}

function db_schema_version($db)
/* returns the version of the underlying database schema */
{
  if ( !$db->acidTableExists("schema") )
     return 0;
  else
  {
     $result = $db->acidExecute("SELECT vseq FROM schema");
     $myrow = $result->acidFetchRow();
     $result->acidFreeRows();

     return $myrow[0];
  }
}

/* ******************* DB Query Routines ************************************ */
function EventsByAddr($db, $i, $ip)
{
   $ip32 = acidIP2long($ip);

   $result = $db->acidExecute("SELECT signature FROM event LEFT JOIN iphdr ON ".
             "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
             "(ip_src=$ip32) OR (ip_dst=$ip32)");

   while ( $myrow = $result->acidFetchRow() ) 
      $sig[] = $myrow[0];

   $result->acidFreeRows();

   return $sig[$i];
}

function EventCntByAddr($db, $ip)
{
   $ip32 = acidIP2long($ip);

   $result = $db->acidExecute("SELECT count(ip_src) FROM iphdr WHERE ".
                  "(ip_src=$ip32) OR (ip_dst=$ip32)");

   $myrow = $result->acidFetchRow();
   $event_cnt = $myrow[0];
   $result->acidFreeRows();

   return $event_cnt;
}

function UniqueEventsByAddr($db, $i, $ip)
{
     $ip32 = acidIP2long($ip);
     $result = $db->acidExecute("SELECT DISTINCT signature FROM event INNER JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src=$ip32) OR (ip_dst=$ip32)");

   while ($myrow = $result->acidFetchRow())
      $sig[] = $myrow[0];

   $result->acidFreeRow();

   return $sig[$i];
}

function UniqueEventCntByAddr($db, $ip)
{
     $ip32 = acidIP2long($ip);
     $result = $db->acidExecute("SELECT DISTINCT signature FROM event INNER JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "(ip_src=$ip32) OR (ip_dst=$ip32)");

   while ($myrow = $result->acidFetchRow())
      $sig[] = $myrow[0];

   $result->acidFreeRows();

   return $sig;
}

function UniqueEventTotalsByAddr($db, $ip, $current_event)
{
   $ip32 = acidIP2long($ip);
   $result = $db->acidExecute("SELECT count(signature) FROM event INNER JOIN iphdr ON ". 
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "( (ip_src=$ip32 OR ip_dst=$ip32) AND signature='$current_event')"); 

   $myrow = $result->acidFetchRow();
   $tmp = $myrow[0];
   
   $result->acidFreeRows();
   return $tmp;
}

function UniqueSensorCntByAddr($db, $ip, $current_event)
{
   $ip32 = acidIP2long($ip);
   $result = $db->acidExecute("SELECT DISTINCT event.sid FROM event INNER JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "( (ip_src=$ip32 OR ip_dst=$ip32) AND signature='$current_event')");

   while ($myrow = $result->acidFetchRow())
      $sid[] = $myrow[0];

   $count = count($sid);
   $result->acidFreeRows();

   return $count;
}

function StartTimeForUniqueEventByAddr($db, $ip, $current_event)
{
   $ip32 = acidIP2long($ip);
   $result = $db->acidExecute("SELECT min(timestamp) FROM event INNER JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src=$ip32 OR ip_dst=$ip32) AND signature = '$current_event');");
   $myrow = $result->acidFetchRow();
   $start_time = $myrow[0];

   $result->acidFreeRows();
   return $start_time;
}

function StopTimeForUniqueEventByAddr($db, $ip, $current_event)
{
   $ip32 = acidIP2long($ip);
   $result = $db->acidExecute("SELECT max(timestamp) FROM event INNER JOIN iphdr ON ".
                  "event.cid=iphdr.cid AND event.sid=iphdr.sid WHERE ".
                  "((ip_src=$ip32 OR ip_dst=$ip32) AND signature = '$current_event');");

   $myrow = $result->acidFetchRow();
   $stop_time = $myrow[0];

   $result->acidFreeRows();
   return $stop_time;
}

?>
