/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;
import org.apache.taglibs.standard.tag.common.fmt.TimeZoneSupport;

public abstract class ParseDateSupport
extends BodyTagSupport {
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String DATETIME = "both";
    protected String value;
    protected boolean valueSpecified;
    protected String type;
    protected String pattern;
    protected Object timeZone;
    protected Locale parseLocale;
    protected String dateStyle;
    protected String timeStyle;
    private String var;
    private int scope;

    public ParseDateSupport() {
        this.init();
    }

    private void init() {
        this.timeStyle = null;
        this.dateStyle = null;
        this.type = null;
        this.var = null;
        this.pattern = null;
        this.value = null;
        this.valueSpecified = false;
        this.timeZone = null;
        this.scope = 1;
        this.parseLocale = null;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        String string = null;
        if (this.valueSpecified) {
            string = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            string = this.bodyContent.getString().trim();
        }
        if (string == null || string.equals("")) {
            if (this.var == null) return 6;
            this.pageContext.removeAttribute(this.var, this.scope);
            return 6;
        }
        Locale locale = this.parseLocale;
        if (locale == null) {
            locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, false, DateFormat.getAvailableLocales());
        }
        if (locale == null) {
            throw new JspException(Resources.getMessage("PARSE_DATE_NO_PARSE_LOCALE"));
        }
        DateFormat dateFormat = this.createParser(locale);
        if (this.pattern != null) {
            try {
                ((SimpleDateFormat)dateFormat).applyPattern(this.pattern);
            }
            catch (ClassCastException classCastException) {
                dateFormat = new SimpleDateFormat(this.pattern, locale);
            }
        }
        TimeZone timeZone = null;
        if (this.timeZone instanceof String && ((String)this.timeZone).equals("")) {
            this.timeZone = null;
        }
        if (this.timeZone != null) {
            if (this.timeZone instanceof String) {
                timeZone = TimeZone.getTimeZone((String)this.timeZone);
            } else {
                if (!(this.timeZone instanceof TimeZone)) throw new JspException(Resources.getMessage("PARSE_DATE_BAD_TIMEZONE"));
                timeZone = (TimeZone)this.timeZone;
            }
        } else {
            timeZone = TimeZoneSupport.getTimeZone(this.pageContext, (Tag)this);
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        Date date = null;
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new JspException(Resources.getMessage("PARSE_DATE_PARSE_ERROR", string), (Throwable)parseException);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)date, this.scope);
            return 6;
        }
        try {
            this.pageContext.getOut().print((Object)date);
            return 6;
        }
        catch (IOException iOException) {
            throw new JspTagException(iOException.toString(), (Throwable)iOException);
        }
    }

    public void release() {
        this.init();
    }

    private DateFormat createParser(Locale locale) throws JspException {
        DateFormat dateFormat = null;
        if (this.type == null || DATE.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getDateInstance(Util.getStyle(this.dateStyle, "PARSE_DATE_INVALID_DATE_STYLE"), locale);
        } else if (TIME.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getTimeInstance(Util.getStyle(this.timeStyle, "PARSE_DATE_INVALID_TIME_STYLE"), locale);
        } else if (DATETIME.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getDateTimeInstance(Util.getStyle(this.dateStyle, "PARSE_DATE_INVALID_DATE_STYLE"), Util.getStyle(this.timeStyle, "PARSE_DATE_INVALID_TIME_STYLE"), locale);
        } else {
            throw new JspException(Resources.getMessage("PARSE_DATE_INVALID_TYPE", this.type));
        }
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

