<?php
/*
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checkfield_new.php,v 1.4 2003/03/01 23:04:28 gokohnert Exp $
 *  $Author: gokohnert $
 *
 */

$tutos['base'] = "../..";
ini_set("include_path","..");
include_once "webelements.p3";
include_once "permission.p3";
include_once "checkfield.pinc";

/* Check if user is allowed to use it */
check_user();
loadmodule("checklist");
loadlayout();
/**
 * display a checkfield create/modify form
 */
class checkfield_new extends layout {
  /**
   *
   */
  Function info() {
    global $tutos,$lang;

    echo "<form name=\"checkfieldnew\" action=\"checkfield_ins.php\" method=\"post\">\n";
    echo $this->DataTableStart();

    echo "<tr><th colspan=\"4\">";
    if ( isset ($this->obj->id) && ( $this->obj->id != -1 ) ) {
      $this->addHidden("id", $this->obj->id );
      echo $lang['CheckfieldModify'];
      echo " </th></tr>\n";
      echo "<tr>\n";
      echo " <td colspan=\"3\">". sprintf ($lang['ProdCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
      echo " <td align=\"right\">". acl_link($this->obj) ."</td>";
      echo "</tr>\n";
    } else {
      echo $lang['CheckfieldCreation'];
      echo " </th></tr>\n";
    }

    echo "<tr>\n";
    echo $this->showfieldc($lang['CheckfieldName'],1,"name");
    echo " <td colspan=\"3\" valign=\"top\"><input size=\"30\" maxlength=\"30\" name=\"name\" value=\"". $this->obj->name ."\"></td>";
    echo "</tr>\n";

    echo "<tr>\n";
    echo $this->showfieldc($lang['CheckfieldType'],1,"type");
    echo " <td>". $this->obj->askType() ."</td>\n";
    echo "</tr>\n";

    echo "<tr>\n";
    echo $this->showfieldc($lang['CheckfieldReference'],1,"link_id");
    echo " <td colspan=\"5\">". $lang[$this->obj->ref->getType()] ." ". $this->obj->getRefLink() . "</td>\n";
    $this->addHidden("link_id", $this->obj->link_id );
    echo "</tr>\n";

    echo "<tr>\n";
    echo $this->showfieldc($lang['CheckfieldDescription'],1,"desc");
    echo " <td colspan=\"3\" valign=\"top\"><input size=\"60\" maxlength=\"200\" name=\"desc\" value=\"". $this->obj->description ."\"></td>";
    echo "</tr>\n";

    echo "<tr>\n";
    echo $this->showfieldc($lang['CheckfieldHelp'],0,"help");
    echo " <td colspan=\"3\" valign=\"top\"><input size=\"60\" maxlength=\"200\" name=\"help\" value=\"". $this->obj->help_text ."\"></td>";
    echo "</tr>\n";

    // References to modules
    module_addforms($this->user,$this->obj,4);

    if ( $this->obj->mod_ok() != 0 ) {
      echo "<tr>\n";
      if ($this->obj->id > 0 ) {
    submit_reset(0,1,1,1,1,0);
      } else {
    submit_reset(0,-1,1,1,1,0);
      }
      echo "</tr>\n";
    }
    echo $this->DataTableEnd();
    hiddenFormElements();
    echo $this->getHidden();
    echo "</form>\n";
    echo $lang['FldsRequired'] ."\n";
  }
  /**
   * navigate
   */
  Function navigate() {
    global $tutos,$lang;

    echo "<tr><td>";
    if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
      echo confirmlink("checklist/checkfield_del.php?id=". $this->obj->id ,$lang['Delete'],sprintf($lang['CheckfieldDelete'],$this->obj->getFullname())) ."&nbsp;<BR>";
    }
    echo "</td></tr>";
  }
  /**
   * prepare
   */
  Function prepare() {
    global $msg,$lang;

    $this->obj = new checkfield($this->dbconn);
    if ( isset($_GET['id']) ) {
      $this->obj->read($_GET['id']);
    }

    if ( $this->obj->id > 0 ) {
      $this->name = $lang['CheckfieldModify'] ." : ". $this->obj->getFullName();
    } else {
      $this->name = $lang['CheckfieldCreate'];
    }

    if ( isset($_GET['link_id']) ){
      $this->obj->link_id = $_GET['link_id'];
    }

    if ( isset($_GET['name']) ) {
      $this->obj->name = StripSlashes($_GET['name']);
    }
    if ( isset($_GET['desc']) ) {
      $this->obj->description = StripSlashes($_GET['desc']);
    }
    if ( isset($_GET['type']) ) {
      $this->obj->type = $_GET['type'];
    }
    if (! $this->obj->mod_ok() ) {
      $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
      $this->stop = true;
    }
    $this->obj->read_reference();
  }
}

$l = new checkfield_new($current_user);
$l->display();
$dbconn->Close();

// CVS Info:  $Id: checkfield_new.php,v 1.4 2003/03/01 23:04:28 gokohnert Exp $
//  $Author: gokohnert $

?>