# file-lib.pl
# Common functions for file manager CGIs

do '../web-lib.pl';
&ReadParse(\%prein, 'GET');
if ($prein{'trust'}) {
	dbmopen(%trustdb, "$ENV{'WEBMIN_CONFIG'}/file/trust", 0700);
	if ($trustdb{$prein{'trust'}}) {
		$trust_unknown_referers = 1;
		$trustdb{$prein{'trust'}} = time();
		}
	dbmclose(%trustdb);
	}
&init_config();
%access = &get_module_acl();
if ($access{'home'}) {
	local @u = getpwnam($remote_user);
	if (@u) {
		$access{'root'} .= ' ' if ($access{'root'});
		$access{'root'} .= $u[7];
		}
	}

$icon_map = (	"c", 1,    "txt", 1,
		"pl", 1,   "cgi", 1,
		"html", 1, "htm", 1,
		"gif", 2,  "jpg", 2,
		"tar", 3
		);

# file_info_line(path)
# Returns a line of text containing encoded details of some file
sub file_info_line
{
local @st = $access{'follow'} ? stat($_[0]) : lstat($_[0]);
local $ext = $_[0] =~ /\S+\.([^\.\/]+)$/ ? $1 : undef;
local $user = getpwuid($st[4]); $user = $st[4] if (!$user);
local $group = getgrgid($st[5]); $group = $st[5] if (!$group);
local $rl = readlink($_[0]);
return sprintf ("%s\t%d\t%s\t%s\t%d\t%d\t%d\t%s",
		$_[0],
		(-l $_[0] && !$access{'follow'} ? 5 :
		 -d $_[0] ? 0 :
		 -b $_[0] ? 6 :
		 -c $_[0] ? 6 :
		 -p $_[0] ? 7 :
		 -S $_[0] ? 7 :
		 defined($icon_map{$ext}) ? $icon_map{$ext} : 4),
		$user, $group,
		$st[7], $st[2], $st[9], -l $_[0] && !$rl ? "???" : $rl);
}

# switch_acl_uid()
sub switch_acl_uid
{
if ($access{'uid'}) {
	local @u = $access{'uid'} < 0 ? getpwnam($remote_user)
				      : getpwuid($access{'uid'});
	@u || &error($text{'switch_euser'});
	$( = $u[3]; $) = "$u[3] ".join(" ", $u[3], &other_groups($u[0]));
	($>, $<) = ($u[2], $u[2]);
	umask(oct($access{'umask'}));
	}
}

# can_access(file)
sub can_access
{
local @f = grep { $_ ne '' } split(/\//, $_[0]);
DIR: foreach $r (split(/\s+/, $access{'root'})) {
	return 1 if ($r eq '/' || $_[0] eq '/');
	local @a = grep { $_ ne '' } split(/\//, $r);
	local $i;
	for($i=0; $i<@a && $i<@f; $i++) {
		next DIR if ($a[$i] ne $f[$i]);
		}
	return 1;
	}
return 0;
}

1;

