#!/usr/local/bin/perl
# save_conf.cgi
# Save configuration options

require './heartbeat-lib.pl';
&ReadParse();
@conf = &get_ha_config();
&error_setup($text{'conf_err'});

# Parse and validate inputs
&save_directive(\@conf, 'serial', $in{'serial'} ? [ $in{'serial'} ] : [ ] );

if ($in{'baud_def'}) {
	&save_directive(\@conf, 'baud', [ ]);
	}
else {
	$in{'baud'} =~ /^\d+$/ || &error($text{'conf_ebaud'});
	&save_directive(\@conf, 'baud', [ $in{'baud'} ]);
	}

if ($in{'udp_def'}) {
	&save_directive(\@conf, 'udp', [ ]);
	}
else {
	$in{'udp'} =~ /^\S+\d+$/ || &error($text{'conf_eudp'});
	&save_directive(\@conf, 'udp', [ $in{'udp'} ]);
	}

if ($in{'udpport_def'}) {
	&save_directive(\@conf, 'udpport', [ ]);
	}
else {
	$in{'udpport'} =~ /^\d+$/ || &error($text{'conf_eudpport'});
	&save_directive(\@conf, 'udpport', [ $in{'udpport'} ]);
	}

if ($in{'keepalive_def'}) {
	&save_directive(\@conf, 'keepalive', [ ]);
	}
else {
	$in{'keepalive'} =~ /^\d+$/ || &error($text{'conf_ekeepalive'});
	&save_directive(\@conf, 'keepalive', [ $in{'keepalive'} ]);
	}

if ($in{'deadtime_def'}) {
	&save_directive(\@conf, 'deadtime', [ ]);
	}
else {
	$in{'deadtime'} =~ /^\d+$/ || &error($text{'conf_edeadtime'});
	&save_directive(\@conf, 'deadtime', [ $in{'deadtime'} ]);
	}

if ($in{'watchdog_def'}) {
	&save_directive(\@conf, 'watchdog', [ ]);
	}
else {
	-r $in{'watchdog'} || &error($text{'conf_ewatchdog'});
	&save_directive(\@conf, 'watchdog', [ $in{'watchdog'} ]);
	}

@node = split(/\s+/, $in{'node'});
@node || &error($text{'conf_enonode'});
$uname = `uname -n 2>/dev/null`;
$uname =~ s/\r|\n//g;
foreach $n (@node) {
	$found++ if ($n eq $uname);
	}
!$uname || $found || &error(&text('conf_ethisnode', "<tt>$uname</tt>"));
&save_directive(\@conf, 'node', \@node);

if ($in{'logfile_def'}) {
	&save_directive(\@conf, 'logfile', [ ]);
	}
else {
	$in{'logfile'} =~ /^\S+$/ || &error($text{'conf_elogfile'});
	&save_directive(\@conf, 'logfile', [ $in{'logfile'} ]);
	}

if ($in{'logfacility_def'}) {
	&save_directive(\@conf, 'logfacility', [ ]);
	}
else {
	&save_directive(\@conf, 'logfacility', [ $in{'logfacility'} ]);
	}

if ($in{'initdead_def'}) {
	&save_directive(\@conf, 'initdead', [ ]);
	}
else {
	$in{'initdead'} =~ /^\d+$/ || &error($text{'conf_einitdead'});
	$in{'deadtime_def'} || $in{'initdead'} >= $in{'deadtime'}*2 ||
		&error($text{'conf_einitdead2'});
	&save_directive(\@conf, 'initdead', [ $in{'initdead'} ]);
	}

&flush_file_lines();
&redirect("");

