#!/bin/sh

if [ $# -ne 2 ]; then
	echo usage: $0 directory extension
	exit 1
fi

if ! cd $1; then
	echo $0: can not cd to $1
	exit 1
fi

ext=$2

function fixman {
	if [ $# -lt 2 ]; then
		echo fixman: called with too few args
		exit 1
	fi

	if ! mv -f $1.$ext $2.$ext; then
		echo fixman: can not mv $1.$ext to $2.$ext
		exit 1
	fi

	local base=$2
	shift 2

	for f in $*; do
		if ! ln -sf $base.$ext $f.$ext; then
			echo fixman: cant ln $base.$ext to $f.$ext
		fi
	done
}

fixman 3DBorder Tk_Get3DBorder Tk_Draw3DRectangle Tk_Fill3DRectangle Tk_Draw3DPolygon Tk_Fill3DPolygon Tk_SetBackgroundFromBorder Tk_NameOf3DBorder Tk_Free3DBorder
fixman BackgdErr Tk_BackgroundError
fixman ClrSelect Tk_ClearSelection
fixman ConfigWidg Tk_ConfigureWidget Tk_Offset Tk_ConfigureInfo Tk_FreeOptions
fixman ConfigWind Tk_ConfigureWindow Tk_MoveWindow Tk_ResizeWindow Tk_MoveResizeWindow Tk_SetWindowBorderWidth Tk_ChangeWindowAttributes Tk_SetWindowBackground Tk_SetWindowBackgroundPixmap Tk_SetWindowBorder Tk_SetWindowBorderPixmap Tk_SetWindowColormap Tk_DefineCursor Tk_UndefineCursor
fixman CoordToWin Tk_CoordsToWindow
fixman CrtErrHdlr Tk_CreateErrorHandler Tk_DeleteErrorHandler
fixman CrtGenHdlr Tk_CreateGenericHandler Tk_DeleteGenericHandler
fixman CrtMainWin Tk_CreateMainWindow Tk_CreateWindow Tk_CreateWindowFromPath Tk_DestroyWindow Tk_MakeWindowExist
fixman CrtSelHdlr Tk_CreateSelHandler Tk_DeleteSelHandler
fixman DoOneEvent Tk_DoOneEvent Tk_MainLoop Tk_HandleEvent
fixman DoWhenIdle Tk_DoWhenIdle Tk_CancelIdleCall
fixman EventHndlr Tk_CreateEventHandler Tk_DeleteEventHandler
fixman FileHndlr Tk_CreateFileHandler Tk_DeleteFileHandler
fixman GeomReq Tk_GeometryRequest Tk_SetInternalBorder
fixman GetAnchor Tk_GetAnchor Tk_NameOfAnchor
fixman GetBitmap Tk_GetBitmap Tk_DefineBitmap Tk_NameOfBitmap Tk_SizeOfBitmap Tk_FreeBitmap Tk_GetBitmapFromData
fixman GetCapStyl Tk_GetCapStyle Tk_NameOfCapStyle
fixman GetColor Tk_GetColor Tk_GetColorByValue Tk_NameOfColor Tk_FreeColor
fixman GetCursor Tk_GetCursor Tk_GetCursorFromData Tk_NameOfCursor Tk_FreeCursor
fixman GetFontStr Tk_GetFontStruct Tk_NameOfFontStruct Tk_FreeFontStruct
fixman GetGC Tk_GetGC Tk_FreeGC
fixman GetJoinStl Tk_GetJoinStyle Tk_NameOfJoinStyle
fixman GetJustify Tk_GetJustify Tk_NameOfJustify
fixman GetOption Tk_GetOption
fixman GetPixels Tk_GetPixels Tk_GetScreenMM 
fixman GetRelief Tk_GetRelief Tk_NameOfRelief
fixman GetRootCrd Tk_GetRootCoord
fixman GetSelect Tk_GetSelection
fixman GetUid Tk_GetUid Tk_Uid
fixman GetVRoot Tk_GetVRootGeometry
fixman InternAtom Tk_InternAtom Tk_GetAtomName
fixman MainWin Tk_MainWindow
fixman ManageGeom Tk_ManageGeometry
fixman MapWindow Tk_MapWindow Tk_UnmapWindow
fixman MoveToplev Tk_MoveToplevelWindow
fixman Name Tk_Name Tk_PathName Tk_NameToWindow
fixman OwnSelect Tk_OwnSelection
fixman ParseArgv Tk_ParseArgv
fixman Preserve Tk_Preserve Tk_Release Tk_EventuallyFree
fixman RegInterp Tk_RegisterInterp 
fixman Restack Tk_RestackWindow
fixman RestrictEv Tk_RestrictEvents
fixman SetCModel Tk_SetColorModel Tk_GetColorModel
fixman SetClass Tk_SetClass Tk_Class
fixman SetGrid Tk_SetGrid
fixman SetVisual Tk_SetWindowVisual
fixman Sleep Tk_Sleep
fixman TimerHndlr Tk_CreateTimerHandler Tk_DeleteTimerHandler
fixman WindowId Tk_WindowId Tk_Parent Tk_Display Tk_DisplayName Tk_ScreenNumber Tk_Screen Tk_X Tk_Y Tk_Width Tk_Height Tk_Changes Tk_Attributes Tk_IsMapped Tk_IsTopLevel Tk_ReqWidth Tk_ReqHeight Tk_InternalBorderWidth Tk_Visual Tk_Depth Tk_Colormap
