/* array.h  03/23/91
 * Copyright 1983-1992   Albert Davis
 * fast access to sparse array
 * special case macros for: on diagonal (red, imd)
 *			    above diagonal (upper) (reu, imu)
 *			    below diagonal (lower) (rel, iml)
 * CAUTION: NO BOUNDS CHECKING
 */

#ifdef OPTIMIZE_SPACE

#define Red(row,col)	re(row,col)
#define Reu(row,col)	re(row,col)
#define Rel(row,col)	re(row,col)
#define Re(row,col)	re(row,col)

#define Imd(row,col)	im(row,col)
#define Imu(row,col)	im(row,col)
#define Iml(row,col)	im(row,col)
#define Im(row,col)	im(row,col)

#define AAd(row,col)	re(row,col)
#define AAu(row,col)	re(row,col)
#define AAl(row,col)	re(row,col)
#define AA(row,col)	re(row,col)

#define LUd(row,col)	im(row,col)
#define LUu(row,col)	im(row,col)
#define LUl(row,col)	im(row,col)

#else /* OPTIMIZE_SPEED */

extern double **rerow, **imrow ;    /* array of row pointers		    */
extern double **recol, **imcol ;    /* array of column pointers		    */
extern double **redia, **imdia ;    /* array of diagonal pointers	    */

#define Red(row,col)	(redia[row])
#define Reu(row,col)	(recol[col]+(row))
#define Rel(row,col)	(rerow[row]-(col))
#define Re(row,col)	(((col)>=(row))?(recol[col]+(row)):(rerow[row]-(col)))

#define Imd(row,col)	(imdia[row])
#define Imu(row,col)	(imcol[col]+(row))
#define Iml(row,col)	(imrow[row]-(col))
#define Im(row,col)	(((col)>=(row))?(imcol[col]+(row)):(imrow[row]-(col)))

#define AAd(row,col)	(redia[row])
#define AAu(row,col)	(recol[col]+(row))
#define AAl(row,col)	(rerow[row]-(col))
#define AA(row,col)	(((col)>=(row))?(recol[col]+(row)):(rerow[row]-(col)))

#define LUd(row,col)	(imdia[row])		/* part of L */
#define LUu(row,col)	(imcol[col]+(row))	/* not D */
#define LUl(row,col)	(imrow[row]-(col))	/* includes D */

#endif
