/* fanout.c  94.07.29
 * Copyright 1983-1992   Albert Davis
 * Prints out a list of all node connections.
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "io.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_fanout(const char*,int*);
static	void	checklist(const branch_t*,int);
/*--------------------------------------------------------------------------*/
extern       struct ioctrl io;
extern const struct status stats;
/*--------------------------------------------------------------------------*/
void cmd_fanout(const char *cmd, int *cnt)
{
 int nod;		/* the node we are trying to determine connections  */
 int start, stop;

 io.where |= io.mstdout;

 for (start = stop = -1;   ;    ){
    if (isdigit(cmd[*cnt])){
       int temp;
       temp = ctoi(cmd,cnt);
       if (cmd[*cnt] == '-'){
	  ++*cnt;
	  start = temp;
       }else if (start < 0){
	  start = temp;
	  if (stop < 0)
	     stop = start;
       }else{
	  stop = temp;
       }
    }else if (cmd[*cnt] == '-'){
       ++*cnt;
       skipbl(cmd,cnt);
       if (isdigit(cmd[*cnt]))
	  stop = ctoi(cmd,cnt);
    }else if (outset(cmd,cnt,"","")){
       /*nothing*/;
    }else{
       syntax_check(cmd,cnt,bWARNING);
       break;
    }
 }

 initio(io.where,(FILE*)NULL);
 if (start < 0) 
    start = 0;
 if (stop < 0  ||  stop > stats.total_nodes)
    stop = stats.user_nodes;
 if (!exists(firstbranch_all()))
    error(bERROR, "no circuit\n");
 if (start>stats.total_nodes)
    error(bERROR, "%u nodes\n", stats.total_nodes);

 mprintf(io.where,"Node:  Branches\n");
 for (nod = start;  nod <= stop;  ++nod){
    mprintf(io.where,"%4u:",nod);
    checklist(firstbranch_dev(),nod);
    mputc('\n',io.where);
 }
}
/*--------------------------------------------------------------------------*/
static void checklist(const branch_t *brh, int nod)
{
 const branch_t *stop;
 stop = brh;
 do {
    if (isdevice(brh)){
       int ii;
       for (ii = 0;  brh->n[ii].t != INVALIDNODE;  ii++){
          if (nod == brh->n[ii].t)
             mprintf(io.where," %s",printlabel(brh,NO));
       }
       if (brh->tracesubckt)
          checklist(brh->subckt,nod);
    }
 } while (brh = nextbranch_dev(brh),  brh != stop);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
