/* tr_adv.c  94.08.23
 * Copyright 1983-1992   Albert Davis
 * Functions to set up the next time step, and next iteration
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "mode.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	trsetup(branch_t*);
/*--------------------------------------------------------------------------*/
extern const int    sim_mode;
extern const int    sim_phase;
extern const double trtime0;	    /* transient analysis time		    */
/*--------------------------------------------------------------------------*/
/* trsetup: set up guesses for model evaluation
 * saves old model inputs, and computes new inputs (volts and current)
 * also saves old matrix parameters, for convergence checking
 */
void trsetup(branch_t *brh)
{
 brh->y2 = brh->y1;
 brh->y1 = brh->y0;
 if (sim_mode == sDC  ||  sim_phase == pINIT_DC){	/* initial dc */
    brh->mt1 = brh->m0;
    brh->time0 = trtime0;
    brh->time1 = brh->time2 = brh->time3 = 0.;
 }else if (brh->time0 != trtime0){	/* new time step */
    if (brh->time0 < trtime0){		/* forward */
       brh->mt1 = brh->m0;
       brh->yt3 = brh->yt2;
       brh->yt2 = brh->yt1;
       brh->yt1 = brh->y0;
       brh->time3 = brh->time2;
       brh->time2 = brh->time1;
       brh->time1 = brh->time0;
    }					/* else backward, don't save */
    brh->time0 = trtime0;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
