# Copyright (c) 1994 by Sanjay Ghemawat
##############################################################################
# Ical on-line help

class Ical_Doc {doc} {
    toplevel .$self
    set t .$self.text
    set s .$self.scroll

    focus_interest .$self
    bind .$self <Any-Enter> [list focus_restrict .$self]

    # Make controlling buttons
    make_buttons .$self.bot 0\
	[list [list {Okay} [list class_kill $self]]]

    # Move button to extreme right hand side.
    # XXX This depends on the internals of "make_buttons".
    pack .$self.bot.def0 -side right -expand 0
    pack .$self.bot -side bottom -fill x

    scrollbar $s -relief raised -bd 1 -orient vertical -command [list $t yview]
    text $t -borderwidth 1 -relief raised -setgrid 1\
	-wrap word -width 50 -height 30 -yscroll [list $s set]

    $t tag configure header1	-font [pref largeHeadingFont]
    $t tag configure header2	-font [pref smallHeadingFont] -underline 1
    $t tag configure header3	-font [pref smallHeadingFont]
    $t tag configure norm	-font [pref normFont]
    $t tag configure bold	-font [pref boldFont]
    $t tag configure italic	-font [pref italFont]
    $t tag configure fixed	-font [pref normFont]
    $t tag configure boldfixed	-font [pref boldFont]
    $t tag configure pre	-font [pref normFont]
    $t tag configure ref	-font [pref italFont]\
				-foreground [pref interestColor]\
				-underline 1

    # Insert documentation into text widget
    set text $t
    eval $doc
    $self make_toc

    $t configure -state disabled

    pack $t -expand 1 -fill both -side left
    pack $s -fill y -side right

    wm iconname .$self help
    wm protocol .$self WM_DELETE_WINDOW [list class_kill $self]
}

method Ical_Doc destructor {} {
    focus_disinterest .$self
    focus_unrestrict .$self
    destroy .$self
}

method Ical_Doc goto_toc {} {
    catch {.$self.text yview header_[lindex [.$self.toc curselection] 0]}
}

# effects Generate table of contents in listbox from the contents of
#	  a text widget.
method Ical_Doc make_toc {} {
    set t .$self.text
    set l .$self.toc

    listbox $l -relief raised -borderwidth 2 -exportselection 0\
	-font [pref boldFont]

    bind $l <ButtonRelease-1> [list $self goto_toc]

    # Prevent horizontal scrolling in toc
    bind $l <2> {%W scan mark 0 %y}
    bind $l <B2-Motion> {%W scan dragto 0 %y}

    tk_listboxSingleSelect $l

    # Collect all headers
    set headers {}

    foreach level {1 2} {
	set ranges [$t tag ranges header$level]
	while {[llength $ranges] > 1} {
	    set text [$t get [lindex $ranges 0] [lindex $ranges 1]]
	    set pad $level
	    while {$pad > 1} {
		set text "        $text"
		incr pad -1
	    }
	    lappend headers [list [lindex $ranges 0] $text]
	    set ranges [lrange $ranges 2 end]
	}
    }

    # Sort headers by position in text
    set headers [lsort -command "$self sort_by_pos" $headers]

    # Insert into box
    set i 0
    foreach h $headers {
	$l insert end [lindex $h 1]
	$t mark set header_$i [lindex $h 0]
	incr i
    }

    pack $l -fill y -side left
}

method Ical_Doc sort_by_pos {a b} {
    set a [lindex $a 0]
    set b [lindex $b 0]
    if {[.$self.text compare $a < $b]} {return -1}
    if {[.$self.text compare $a > $b]} {return  1}
    return 0
}
