/* This file is part of the KDE libraries
    Copyright (C) 1997 Sven Radej (sven.radej@iname.com)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <qcombo.h>
#include "kcombo.moc"
#include "kcombo.h"
#include <qkeycode.h>

KCombo::KCombo (bool rw, QWidget *parent, const char *name)
  : QComboBox (rw, parent, name)
{
  installEventFilter (this);
}

KCombo::~KCombo ()
{
  removeEventFilter (this);
}

void KCombo::cursorAtEnd ()
{
  QKeyEvent ev( Event_KeyPress, Key_End, 0, 0 );
  QComboBox::keyPressEvent( &ev );
}


bool KCombo::eventFilter (QObject *, QEvent *e)
{
  if (e->type() == Event_KeyPress)
    {
      QKeyEvent *k = (QKeyEvent *) e;
      if (k->state() == ControlButton)
		{
		  if (k->key() == Key_S)
			{
			  emit rotation ();
			  QKeyEvent ev( Event_KeyPress, Key_End, 0, 0 );
			  QComboBox::keyPressEvent( &ev );
			  return TRUE;
			}
		  if (k->key() == Key_D)
			{
			  emit completion ();
			  QKeyEvent ev( Event_KeyPress, Key_End, 0, 0 );
			  QComboBox::keyPressEvent( &ev );
			  return TRUE;
			}
		}
    }
  return FALSE;
}
