/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <ctype.h>

#include "xalloca.h"
#include "ftpclass.h"
#include "LocalAccess.h"
#include "lftp.h"
#include "xmalloc.h"
#include "alias.h"
#include "CmdExec.h"
#include "SignalHook.h"
#include "GetPass.h"

extern "C" {
#include "readline/readline.h"
#include "readline/history.h"
}

int   remote_completion=0;

void  hook_signals()
{
   SignalHook::DoCount(SIGHUP);
   SignalHook::DoCount(SIGPIPE);
//    SignalHook::DoCount(SIGCHLD);
   SignalHook::Ignore(SIGTTOU);
}

void WaitDone(CmdExec *exec)
{
   for(;;)
   {
      SMTask::Schedule();
      if(exec->Done())
	 break;
      SMTask::Block();
   }
}

class ReadlineFeeder : public CmdFeeder
{
   bool tty:1;
   bool add_newline:1;
public:
   ReadlineFeeder()
   {
      tty=isatty(0);
   }

   char *NextCmd(class CmdExec *exec,const char *prompt)
   {
      if(add_newline)
      {
	 add_newline=false;
	 return xstrdup("\n");
      }

      ::completion_shell=exec;
      ::remote_completion=exec->remote_completion;

      char *cmd_buf;
      if(tty)
      {
	 cmd_buf=xstrdup(readline(prompt));
	 if(cmd_buf && *cmd_buf)
	 {
	    if(exec->csh_history)
	    {
	       char *history_value;
	       int expanded = history_expand (cmd_buf, &history_value);

	       if (expanded)
	       {
		  if (expanded < 0);
		     fprintf (stderr, "%s\n", history_value);

		  /* If there was an error, return nothing. */
		  if (expanded < 0 || expanded == 2)	/* 2 == print only */
		  {
		     exec->block+=NoWait();  // and retry immediately
		     free (cmd_buf);
		     free (history_value);
		     return xstrdup("");
		  }

		  xfree(cmd_buf);
		  cmd_buf=history_value;
	       }
	    }
	    using_history();
	    HIST_ENTRY *temp=previous_history();
	    if(temp==0 || strcmp(temp->line,cmd_buf))
	       add_history(cmd_buf);
	    using_history();
	 }
      }
      else
	 cmd_buf=xstrdup(readline_from_file(stdin));

      ::completion_shell=0;

      if(cmd_buf &&
	    (*cmd_buf==0 || cmd_buf[strlen(cmd_buf)-1]!='\n'))
      {
	 exec->block+=NoWait();
	 add_newline=true;
      }
      return cmd_buf;
   }
};

int   main(int argc,char **argv)
{
   LocalAccess::ClassInit();
   Ftp::ClassInit();

   char  *home=getenv("HOME")?:".";

   CmdExec *top_exec=new CmdExec(new Ftp());
   top_exec->session->SetDebug(NULL,0);
   top_exec->jobno=-1;
   top_exec->status_line=new StatusLine(1);

   initialize_readline();

   hook_signals();

   if(access("/etc/lftp.conf",R_OK)!=-1)
      top_exec->FeedCmd("source /etc/lftp.conf\n");

   char	 *rc=(char*)alloca(7+strlen(home)+8+1);
   sprintf(rc,"source %s/.lftprc",home);
   if(access(rc+7,R_OK)!=-1)
   {
      top_exec->FeedCmd(rc);
      top_exec->FeedCmd("\n");
   }
   WaitDone(top_exec);

   top_exec->SetInteractive(isatty(0));
   top_exec->bootstrap=true;
   char *slash=strrchr(argv[0],'/');
   if(slash)
      memmove(argv[0],slash+1,strlen(slash));
   top_exec->ExecParsed(new ArgV(argc,argv));

   WaitDone(top_exec);
   top_exec->bootstrap=false;

   if(!top_exec->want_terminate)
   {
      top_exec->SetCmdFeeder(new ReadlineFeeder);
      WaitDone(top_exec);

      if(top_exec->interactive)
	 puts("exit");
   }
   top_exec->FeedCmd("exit\n");
   WaitDone(top_exec);
   return top_exec->ExitCode();
}
