/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include "mutt.h"

static char DaysPerMonth[12] = {
  31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

#define isLeapYear(x) ((x)%4 == 0 && (((x)%100 != 0) || ((x)%400 == 0)))

#define SECSPERDAY 86400
#define SECSPERYEAR 31536000

/* converts struct tm to time_t, but does not take the local timezone into
 * account
 */
time_t mutt_mktime (struct tm *t)
{
  int i;
  time_t g = 0;

  for (i=70; i < t->tm_year; i++)
  {
    g += SECSPERYEAR;
    if (isLeapYear (1900 + i))
      g += SECSPERDAY;
  }

  for (i=0; i < t->tm_mon; i++)
    g += DaysPerMonth [i] * SECSPERDAY;

  if (t->tm_mon > 1 && isLeapYear (1900 + t->tm_year))
    g += SECSPERDAY;

  g += (t->tm_mday - 1) * SECSPERDAY;
  g += t->tm_hour * 3600;
  g += t->tm_min * 60;
  g += t->tm_sec;

  return (g);
}
