/*
 * ProFTPD - FTP server daemon
 * Copyright (c) 1997, Public Flood Software
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* General options
 * $Id: proftpd.h,v 1.8 1997/11/11 17:17:22 flood Exp $
 */

#ifndef __PROFTPD_H
#define __PROFTPD_H

#ifndef TRUE
#define TRUE				1
#endif

#ifndef FALSE
#define FALSE				0
#endif

#define CALLBACK_FRAME			LPARAM p1,LPARAM p2,LPARAM p3,void *data
#define ASSERT(x)			assert(x)
#include <assert.h>
#define MAX_PATH_LEN			256

typedef unsigned long LPARAM;		/* Longest bitsize compatible with
                                         * a scalar and largest pointer
					 * (platform dependant)
					 */

typedef int (*callback_t)(CALLBACK_FRAME);


struct conn_struc;
struct cmd_struc;
struct IO_Request;
struct config_struc;

typedef struct {
  pool *pool;

  long flags;				/* Session & State flags */
  short data_port;			/* Remote data port */

  char *ident_user;			/* User identified by ident protocol */

  char cwd[MAX_PATH_LEN];		/* Current working directory */  
  struct config_struc *dir_config;	/* Closest matching configuration
                                         * for current operation
                                         */

  /* The uid/gids are manipulated by the PRIVS macros in
   * privs.h
   */

  int uid,ouid,gid;			/* Currently running uid, 
                                         * original (startup) uid and
                                         * current gid 
                                         */
  array_header *gids;
  array_header *groups;
  int fsgid;				/* Saved file gid */

  char *user,*group;			/* username/groupname after login */
  char *proc_prefix;			/* The "prefix" of our process name */

  struct conn_struc *c;			/* Control connection */
  struct conn_struc *d;			/* Data connection */

  struct IO_Request *d_req;		/* Active data connection request */

  char *anon_root;			/* Anonymous root directory */
  struct config_struc *anon_config;	/* Anonymous FTP configuration */
  char *anon_user;			/* E-mail address sent to us */
  
  unsigned long restart_pos;		/* Restart marked position */

  struct {
    struct pool *p;
    int direction;
    char *filename;			/* As shown to user */
    char *path;				/* As used in transfer */
    unsigned long tr_size;		/* Total data transmitted/received */

    char *bufstart,*buf;
    int bufsize,buflen;

    struct timeval start_time;		/* Time current transfer started */
    unsigned long file_size;		/* Total size of file (if known) */
    unsigned long total_bytes;		/* Total bytes transfered */

    int (*get_data)(struct IO_Request*,char*,int);
    int (*complete)(struct IO_Request*);
    int (*abort)(struct IO_Request*,int err);
  } xfer;

} session_t;

extern session_t	session;
extern char		ServerType;

/* Session/State flags */

#define SF_PASSIVE	(1 << 0)	/* Data connection is in passive mode */
#define SF_ABORT	(1 << 1)	/* Abort in progess */
#define SF_XFER		(1 << 2)	/* Transfer in progress */
#define SF_ASCII	(1 << 3)	/* ASCII mode transfer */
#define SF_ASCII_OVERRIDE (1 << 4)	/* ASCII override this xfer only */
#define SF_ANON		(1 << 5)	/* Anonymous (chroot) login */

#define SF_ALL		(SF_PASSIVE|SF_ABORT|SF_XFER|SF_ASCII| \
                        SF_ASCII_OVERRIDE|SF_ANON)

/* Server Types */
#define SERVER_INETD		0
#define SERVER_STANDALONE	1

/* Timers */
#define TIMER_LOGIN		1
#define TIMER_IDLE		2
#define TIMER_NOXFER		3

/* Misc Prototypes */

void set_proc_title(char *, ...);
void send_response_raw(const char *, ...);
void send_response_async(const char *, const char *, ...);
void send_response(const char *, const char *, ...);
void send_response_ml_start(const char *, const char *, ...);
void send_response_ml(const char *, ...);
void send_response_ml_end(const char *, ...);
void end_login(int);
void main_exit(void*,void*,void*,void*);
void main_set_idle();

#endif /* __PROFTPD_H */
