/*

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/* Required to tell conf.h not to include the standard ProFTPD
 * header files
 */

#define __PROFTPD_SUPPORT_LIBRARY

#include <conf.h>

#include <libsupp.h>

/* Comment out all this code if we are using the GNU C Library, and are not
   actually compiling the library itself.  This code is part of the GNU C
   Library, but also included in many other GNU distributions.  Compiling
   and linking in this code is a waste when using the GNU C library
   (especially if it is a shared library).  Rather than having every GNU
   program understand `configure --with-gnu-libc' and omit the object files,
   it is simpler to just do this in the source for each such file.  */

#undef _LIBC
#undef __GNU_LIBRARY__
#if defined (_LIBC) || !defined (__GNU_LIBRARY__)


#if !defined(__GNU_LIBRARY__) && !defined(STDC_HEADERS)
extern int errno;
#endif

#ifndef HAVE_VSNPRINTF

static FILE *devnull = NULL;


/* This is kludgy and very poor performance wise, but it works.  Get a
 * libc w/ vsnprintf().  :)
 */

int vsnprintf(char *str, size_t n, const char *format, va_list ap)
{
  char *tmp;
  int ret;

  if(!devnull) {
    devnull = fopen("/dev/null","w");
    if(!devnull)
      return -1;
  }

  ret = vfprintf(devnull,format,ap);

  if(ret > 0) {
    tmp = (char*)calloc(ret,1);
    if(!tmp) {
      errno = ENOMEM;
      return -1;
    }

    vsprintf(tmp,format,ap);
    strncpy(str,tmp,n);
    free(tmp);
  }

  return ret;
}

#endif  /* HAVE_VSNPRINTF */

#endif	/* _LIBC or not __GNU_LIBRARY__.  */
