
#ifndef	DEVTOOLS_MACROS_H
#define	DEVTOOLS_MACROS_H

/*
 * macros.h
 *
 * Macros to make life easier, compiles faster, execution warping
 *
 */
 
/*
 *
 * Copyright (C) 1993/94/95/96 Jim Geuther
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */
 
/* swapbytes-macro to swap the contents of two bytes		*/

#define	SWAPBYTES(x,y)	{	x^=y;	y^=x;	x^=y;	}

/* isodd() returns true when number is a odd digit		*/

#define	ISODD(x)	((x)%2)

/* Determine whether we are running under a PAL-machine or not	*/
/* Requires the GfxBase to be opened				*/

#define	ISPAL(x)	(x->DisplayFlags & PAL)

/* === System Macros === */

#define	SetFlag(v,f)		((v)|=(f))
#define	ClearFlag(v,f)		((v)&=~(f))
#define	ToggleFlag(v,f)		((v)^=(f))
#define	FlagIsSet(v,f)		((int)(((v)&(f))!=0))
#define	FlagIsClear(v,f)	((int)(((v)&(f))==0))
#define	ABS(n)			(((n)<0)?(-(n)):(n))
#define	BoundaryOff(r)		((r)->Flags&=~AREAOUTLINE)

#ifndef MAX
#define	MAX(a,b)		(((a)>(b))?(a):(b))
#endif

#ifndef MIN
#define	MIN(a,b)		(((a)<(b))?(a):(b))
#endif

/*
** screencolors() Return number of colors in screen. (May be greater
** then number of pens
*/

#define	screencolors(scr)	( scr ->ViewPort.ColorMap->Count )

#define	div2(x)				((x)>>1)
#define	div4(x)				((x)>>2)
#define	div8(x)				((x)>>3)
#define	div16(x)			((x)>>4)
#define	div32(x)			((x)>>5)
#define	div64(x)			((x)>>6)
#define	div128(x)			((x)>>7)
#define	div256(x)			((x)>>8)

#define	mul2(x)				((x)<<1)
#define	mul4(x)				((x)<<2)
#define	mul8(x)				((x)<<3)
#define	mul16(x)			((x)<<4)
#define	mul32(x)			((x)<<5)
#define	mul64(x)			((x)<<6)
#define	mul128(x)			((x)<<7)
#define	mul256(x)			((x)<<8)

/* modulus 8 (I hope)	*/

#define	mod8(a)		((a) - ((a)&0xFFFFFFF8))

#endif /* In case you wonder, yes this code comes from my Amiga */




