
/* stretch_fish.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Stretch selected rectangle to image size.
 * Author: 	Jim GEUTHER
 * Date:    	19-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin stretches the image into a Circle and creates
 * a sort of fisjeye effect.
 *
 * If a rectangle or ellipse area has been selected it will be used,
 * otherwise the entire image will be used.
 *
 * Processing options:
 *
 * Create new output image - Specifies whether the program should create
 * a new output image or not. If the program feels that it needs a new
 * output image, it will create one anyway.
 *
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"
#include "stretch.h"
#include "macros.h"

/* #define	_DEBUG  */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/* Declare a local function.
 */
static char *prog_name;
static void toggle_callback(int item_ID, void *client_data, void *call_data);

static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);

int	dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
long	type;
int 	group_ID, output_ID, new_image;
int	radius,xc,yc,new_width,new_height,x1,x2,y1,y2;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
		type = gimp_image_type( input );
	  switch ( type )
	    {

    	    case GRAY_IMAGE:
	    case RGB_IMAGE:
	    case INDEXED_IMAGE:
	    	dialog_ID = gimp_new_dialog("FishEye");
	    	group_ID = gimp_new_row_group( dialog_ID, DEFAULT, NORMAL, "");
	    	output_ID = gimp_new_check_button( dialog_ID, group_ID, "Create new output image");
	    	new_image = 1;
		gimp_change_item( dialog_ID, output_ID, sizeof(new_image), &new_image);

		gimp_add_callback( dialog_ID, output_ID, toggle_callback, &new_image);
	      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      	gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
	    	if( gimp_show_dialog( dialog_ID ) ) {

			gimp_image_area (input, &x1, &y1, &x2, &y2);
			
			radius = (MIN( gimp_image_width(input), gimp_image_height(input) ) / 2 ) -2;	    	
			radius = MIN( x2-x1, y2-y1 ) / 2;
			xc = (x1 + ( (x2-x1)/2 ));
			yc = (y1 + ( (y2-y1)/2 ));
			if(  xc + (radius/2) >=  gimp_image_width(input) ) {
				new_width = xc + radius/2 + 1;
				new_image = 1;
			} else {
				new_width = gimp_image_width(input);
			}
			if( yc + (radius/2) >= gimp_image_height ) {
				new_height = yc + radius/2 + 1;
				new_image = 1;
			} else {
				new_height = gimp_image_height(input);
			}
			
	    		if( new_image ) {
				output = gimp_new_image( 0, new_width,
							new_height, gimp_image_type(input) );
				gimp_set_image_colors(output,gimp_image_cmap(input),
				      			gimp_image_colors(input));
			} else {
				output = gimp_get_output_image( 0 );
			}   
		      	gimp_display_image( output );
			CircleStretch( input, output, 
				0, gimp_image_width(output)-1, 
				xc, yc, radius );
		      	gimp_update_image (output);
		    }
	      break;
	    default:
	      gimp_message ("fish: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}


static void toggle_callback(
int item_ID, void *client_data, void *call_data)
{
  *((int *) client_data) = *((long *) call_data);

}

static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
 
 /* fillmethod=(int)client_data;  */

}

static void
item_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

#ifdef	OBSOLETE
static void
fish(input, output, radius )
Image input, output;
{

int x1, y1, x2, y2;

gimp_image_area (input, &x1, &y1, &x2, &y2);

r = (MIN( gimp_image_width(output), gimp_image_height(output) ) / 2 ) -2;
CircleStretch( input, output, 
		0, gimp_image_width(output)-1, 
		x1 + ( (x2-x1)/2 ), y1 + ( (y2-y1)/2 ),
		r /*(x2-x1)/2*/
		);
   
return;    	
}
#endif

/* Agree, I don't like my coding style? either 	*/
/* Feel free to optimize this code!		*/





