/* All things that the query tools have in common.
   Copyright (C) 1994 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

/* The normal format for a PR.  */
#define FORMAT_REG	(1<<4)
/* A summarized, one-line result.  */
#define FORMAT_SUMM	(1<<3)
/* If 1, print the whole PR out, not just the choice bits.  */
#define FORMAT_FULL	(1<<2)
/* If 1, emit info for a SQL database.  */
#define FORMAT_SQL	(1<<1)

/* Query the list of categories.  */
#define LIST_CATEGORIES	(1<<1)
/* Query the list of submitters.  */
#define LIST_SUBMITTERS	(1<<2)
/* Query the list of responsible.  */
#define LIST_RESPONSIBLE (1<<3)

#define MAXLINE 512

/* How we should print out the format of the PR.  */
extern unsigned int query_format;

/* What list we're interested in seeing.  */
extern unsigned int list_format;

/* The different types for SQL output.  */
typedef enum { Severity, Priority, State, Class } Sql_Types;

/* Look for PRs before this date.  */
extern time_t before;

/* Look for PRs after this date.  */
extern time_t after;

/* If specified, search for the originator of this PR.  */
extern char *originator;

/* If specified, search for the class of this PR.  */
extern char *class;

#ifdef GNATS_RELEASE_BASED
/* If specified, search for the class of this PR.  */
extern char *quarter;

/* If specified, search for the class of this PR.  */
extern char *keywords;
#endif

/* Whether or not to search the text fields, and the regexp to
   search for.  */
extern char *text_search;

/* Whether or not to search the multitext fields, and the regexp to
   search for.  */
extern char *m_text_search;

/* If 1, don't talk about closed PRs.  */
extern int skip_closed;

/* If 1, print a string like "/gnats/GNATS/g++/145:0:" for the
   emacs next-error function.  */
extern int print_path;

/* Whether or not we're searching more than one (or every) PR.  */
extern int searching;

/* If 1, don't emit any errors from get_pr.  */
extern int quiet;

/* The definition of GNATS_SERVER as generated for config.c.  */
extern char *gnats_server;

/* The definition of GNATS_SERVICE as generated for config.c.  */
extern char *gnats_service;

/* The definition of GNATS_SERVER_PORT as generated for config.c.  */
extern int gnats_server_port;

/* For the GNATS server we'll be talking with.  */
extern FILE *serv_write, *serv_read;

/* The descriptor for talking to the server in non-stdio ways.  */
extern int sockfd;

/* What results should be written to.  */
extern FILE *outfp;

/* The name of the GNATS server.  */
extern char *name;

/* The name of the host talking with us.  */
extern char *current_host;

/* In each query C file.  */
extern void start_data			PARAMS((void));

/* query.c */
extern char *disbar			PARAMS((char *));
extern int sql_types			PARAMS((char *, Sql_Types));
extern char *sql_time			PARAMS((char *));
extern char *make_path			PARAMS((char *, char *));
extern int numeric			PARAMS((char *));
extern int regcmp			PARAMS((char *, char *));
extern int regfind			PARAMS((char *, char *));
extern char *get_category		PARAMS((char *));
extern int pr_matches			PARAMS((Index *, Index *));
extern int check_text			PARAMS((void));
extern int get_pr			PARAMS((char *, char *, int));
extern int do_pr			PARAMS((Index *));
extern int do_pr_internal		PARAMS((char *, char *));
extern void print_pr			PARAMS((char *, char *, int));
