/* Part of the BitchX distribution */

/* usage:
 *   create a file ~/.BitchX/ircnames
 *   First line is the number of ircnames you have in it
 *   all other lines are your IRCNAMEs
 * 
 *   add ircname to your .login or .profile (whatever), ex (in bash)
 *       export IRCNAME=`ircname`
 *       export IRCNAME=`ircname /home/edwards/.ircnames` <-- incase you don't like 
 *                                                            the default path.
 *   make sure ircname is somewhere in the path
 *
 * if you have a problem email at pje120@mail.usask.ca
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#define NAMEFILE "/.BitchX/ircnames"

int main(int argc, char **argv) {
   char *homedir = getenv("HOME");
   FILE *f;
   unsigned long num_lines, x, target;
   char strbuf[100];
   
   if (argc == 1) {
      if (homedir)
	 f = fopen(strcat(homedir, NAMEFILE), "r");
      else {
	 printf("No $HOME in environment\n");
	 exit(1);
      }
   } else
      f = fopen(argv[1], "r");
   
   if (!f) {
      printf("File not found\n");
      exit(1);
   }
   
   fscanf(f, "%lu\n", &num_lines);
   srand(time(NULL) & getpid());
   target = 1+(1.0*num_lines*rand())/(RAND_MAX+1.0);

   x = 0;
   while (!feof(f)) {
      fgets(strbuf, 1000, f);
      x++;
      if (x == target) break;
   }
   
   printf("%s", strbuf);
   return 0;
}
