.\" $Id: newsx.man,v 1.12 1996/11/26 12:49:26 src Exp $
.\"
.\" NewsX man page
.\"
.\" copyright 1996 Egil Kvaleberg, egilk@sn.no
.\" Husebybakken 14A, N-0379 Oslo, Norway         
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License.
.\"
.SH NAME
.I newsx
\- news server exchange \- post and fetch news articles

.SH SYNOPSIS
.I newsx
[
.B \-a
.I authfile
] [
.B \-b
.I minspool
] [
.B \-e
.I end_tag
] [
.B \-f
.I folder
] [
.B \-g
] [
.B \-h
] [
.B \-v
] [
.B \-r
] [
.B \-c
] [
.B \-i
] [
.B \-d
] [
.B \-n
] [
.B \-m
] [
.B \-k
] [
.B \-p
] [
.B \-t
.I timeout
] [
.B \-u
] [
.B \-l
.I logfile
] [
.B \-s
.I spooldir
] [
.B \-w
.I chatfile
.B \-x
.I command
.B \-y
.I program
] [
.B \-z
]
.I spoolname
[ [
.I hostname
]
.I port
]

.SH DESCRIPTION
.PP
.I NewsX
is an client connecting to a
remote NNTP server, posting outgoing articles batched by the news system,
while also fetching new incoming articles from the same newsserver.
It provides the NNTP capabilities required for maintaining a small news
spool such as those that may be found on installations with NNTP access 
through limited ISP accounts only.

.SH OPTIONS
.TP
.BI -a " authfile"
If specified, the username and password combination found in
.I authfile
will be sent to the server as part of the simple authorization protocol
when the connection is first made. The file should consist of a line
with two blank-separated words, the first being the username, the second
the password. Do ensure that this file only has read access only for
those users that need to know.
.TP
.BI -f " folder"
Posted articles will be appended to the standard
mail folder indicated. 
Note that the article will be added to the
folder the first time posting of an article is attempted. 
The actual status of the posting will appear in the
log file.
.TP
.B -r
A 'MODE READER' command is sent to the remote server. This is used when
connecting to remote INN hosts that needs it. 
.B -c
Set to Cnews mode as opposed to INN. Controls
details regarding handling of spool and lock files.
.TP
.B -i
Set to INN mode as opposed to Cnews. Controls
details regarding handling of spool and lock files.
.TP
.B -k
Keep the "Path" when posting. Normally, the "Path" is stripped together with
the "NNTP-Posting-Host" and "Xref" header items, so that the path of the
news article as posted will appear to start at the actual posting host.
.TP
.BI -l " logfile"
Log information about successfully posted articles to the file indicated.
.TP
.BI -w " chatfile"
Use
.I chatfile
to control any special connect sequence that may be required before the
NNTP protocol is connected. Only implemented for the "telnet" protocol.
.TP
.I spoolname
The name of the outgoing spool queue. 
If not specified, the value of the 
NNTPSERVER environment variable will be used.
.TP
.I hostname
The hostname of the remote NNTP server to connect to. If not specified,
the name of the spool will be used.
.TP
.I port
The port used for connecting to 
.I hostname.
Will usually not need to be specified, and port "nntp" will be assumed.
The port name "telnet" will receive special treatment.

.SH OPTIONS FOR NEWS FETCHING 
.TP
.BI -e " end_tag"
Specify a tag in the host active file. Fetching of news will end when
the tag indicated has been reached. This is a useful tool for dividing
the newsgroups into several categories. Only a few newsgroups may be
fetched during prime time, whereas the full list can be fetched once
every night, for instance.
.TP
.BI -b " minspool"
Specify the minimum incoming spool size. After every new group, if the
spool file has reached the byte size specified, a new spool batch will
be made. Setting this value to 1 will cause every newsgroup to be placed 
in a separate spool.
.TP
.B -z
Omit actual pulling of news articles. Instead, simply update
the server active file to synchronize with the currently highest available
article numbers from the server in question. This option may be useful if
a fresh local spool is initiated. No article posting will be attempted.

.SH OPTIONS MOSTLY FOR TESTING
.TP
.B -p
Do not attempt to do any posting. 
.TP
.B -g 
Do not attempt to get (pull) any news articles.
.TP
.B -h
When fetching news, do not refer to the news history database to check for
news articles that are already present in the spool.
.TP
.BI -x " command"
If specified, the 
.I command
will be executed after the host port has been opened. This option is used
in rare cases when special tricks has to be employed to get an NNTP
connection activated.
.TP
.BI -y " program"
If specified, connect via a bidirectional pipe to
.I program
instead of to a socket. The hostname and port arguments will be ignored.
.TP
.B -d
Enable debugging. This diverts reporting to stderr instead of syslog
and turns on extra debugging output. 
Use twice to log NNTP commands,
use three times for additional debug output,
and four times to log all NNTP communications.
.TP
.B -n
No-action flag, will "fake" an NNTP connection, and leave the outgoing
batch untouched.
Probably useful only with -d for debugging and dry-testing.
.TP
.B -m
Remove any message-ID header field from the posted message. This should 
cause the receiving end to generate a fresh message-ID.
.TP
.B -o
Keep the previous outgoing spool in an ".old" file. This might seem like
a useful option for ordinary use, but the problem is that a non-empty
file might cause a news watch program to believe there is a stale 
outgoing spool.
.TP
.BI -s " spooldir"
Use 
.I spooldir
as a outgoing spool directory instead of the default
.BR "\*a" .
.TP
.BI -t " timeout"
Specify timeout for TCP/IP and lockfile operations, in seconds. The
default value is 600.
.TP
.B -u
After the timeout of lockfile operations, just give up and
do not attempt to unlock the lockfiles and remove the stale process.
.TP
.B -v
Display version info. Include this when reporting bugs.

.SH OPERATION
.PP
The program should only be run by user
.IR \*u "."
When run,
.I NewsX
will go through the	      
.I spoolname
outgoing spool queue, and attempt to post all
articles therein to the NNTP server 
.IR hostname "."
.PP
If a username and password for use with the simple authorization protocol
have been supplied, they will be sent to the server. If the
.B -r
option is specified, then a 'MODE READER' command will be sent.
.PP
When the outgoing transfer is finished, articles will be removed from the
outgoing spool queue if successful transfer has been acknowledged by 
the NNTP host, if the article was specified by the host as a duplicate
(already posted), or if a spooled article can no longer be found.
.PP
Articles available from the newsserver will then be
fetched and placed in the incoming spool, ready to be injected into
the news system by the 
.I newsrun
process.
.PP
The newsgroups will be visited in the order that they appear in the    
host active file. This may be used actively to prioritize between 
newsgroups.
A tag mechanism controlled by the
.B "-e"
option is available to limit the number of groups that will be fetched.
.PP
The pull phase can be omitted in its entirety by using the
.BR -g
option. 
.PP
Statistics on the connection will be logged to syslog (or stderr with
.BR -d ")."
The posted article count is the total number of
articles actually posted. 
The duplicate count is how many message IDs from posted messages
that were found to already exist on the remote system.
The missing count is those posted articles that could no longer be found
locally, usually because they were canceled locally, or perhaps since
they were expired already. 
.PP
The connection time and the total number of characters transferred via
the NNTP layer is logged, in addition to the
average speed of article transfer.
The speed given is the net rate, the calculation being
based on the actual number of characters belonging to news article head
and body parts.
.PP
A log file may be specified with the 
.B -l
option, and a folder of posted messages maintained with the
.B -f
option.

.SH SPECIAL CONNECT SEQUENCE
.PP
The 
.B -w
option specifies that a special connect sequence is required, and that
a script for this sequence can be found in the
.I "chatfile."
This file consists of lines that contains pattern receive and send pairs,
separated by blanks. The patterns may be enclosed in quotes.
The script is currently only available for the "telnet" protocol.
.PP
A typical invocation line would be:
.br
.na
.nf
	newsx -w chat.acme acme login.acme.net telnet
.PP
The file chat.acme could look like this:
.br
.na
.nf
	# login for acme.net NNTP
	login:		myusername
	Password:	mypassword
	$		"exec telnet news.acme.net nntp"
	ECHO
.PP
The script will have to be adapted for local conditions, of course. 
.PP
The special tag 
.B "ECHO"
specifies that line echo should be suppressed, required since the host 
telnet operates in line mode.
.PP
Since this file usually contains passwords and other sensitive information,
ensure that read access to it is limited.

.SH LOG FILE FORMAT
.PP
The 
.I "-l"
log file of posted articles will contain one line for each article.
Each field is separated by a blank:
.IP "Month"
Standard 3 letter abbreviation. 
.IP "Date"
2 digits
.IP "HH:MM:SS"
Local time.			
.IP "Year"
4 digits.			
.IP "Spool"
Name of outgoing spool.        
.IP "<Msgid>"
Within angle brackets.	       
.IP "Filename"
As it appears in the spool file.
.IP "Sender"
The value of the Sender-field, or From-field if no Sender is available.
.IP "Status"
"OK" for successfully posted items, "Duplicate" for items already posted.
.IP "Lines"
Number of lines in the posting, separated from the status by a comma.

.SH HOST ACTIVE FILE FORMAT
.PP
For each incoming news source, there must be an 
.I active
file that describes what the latest article is that has been fetched from
that particular host. The format of this file is simple:
.PP
Blank lines and lines starting with a '#' will be treated as comments.
.PP
Lines starting with a ':' indicates a tag for use with the 
.B "-e"
option.
.PP
Otherwise, each line consists of a newsgroup name and the first unread
article number, separated by whitespace. A missing article number 
corresponds to zero, meaning that all available articles on the
server will be read.
.PP
It is important to realize that one file belongs to one newsserver alone, and
should not be mixed.
.\" .PP
.\" BUG: It is in fact possible to use an existing ".newsrc" file directly as basis
.\" for constructing a host
.\" .I active
.\" file; any ':' and '!' that occurs will cause the article number
.\" to be interpreted as zero.

.SH INCOMING SPOOL FORMAT
.PP
The incoming spool consists of files with the file name ending by ".t".
Each file can contain many articles. Each article is prefixed by the following
header: 
.br
.nf
.na
	#! rnews \fBN\fP
.PP
The number \fBN\fP is the number of bytes of the article proper, not counting
the header line. The article follows after the header line. 
It appears exactly as received from the news server except that CR/LF 
sequences are replaced by proper newlines, and the terminating full stop is
not included.

.SH DIAGNOSTICS
.PP
NewsX returns error codes as follows:
.RS
0 - Successful completion
.br
1 - General system error
.br
2 - Incorrect arguments supplied.
.br
3 - Error connecting to remote host
.br
4 - NNTP Protocol error
.br
5 - Errors accessing outgoing spool file.
.br
6 - Errors accessing host active file.
.br
7 - Errors accessing incoming spool file.
.br
8 - Errors accessing local 
.I active 
and 
.I sys
files.
.br
9 - Socket access error (connection timeout, usually)
.br
10 - Errors accessing
.I authinfo
file.
.br
11 - Connect script failure.
.RE

.SH BUGS
.PP
News fetching works for Cnews according to the
.I rnews
convention. 
Some details re. fetching remain to get it working fully with Inn.
.PP
There should have been a maximum retry count on article posting,
depending on the nature of the error.
.PP
The pull mode is new, and may need some further refinement.
.PP
Beta test version, various bugs might occur. 

.SH FILES
.PP
For Cnews:
.IP "\*a/out.going/\fIspoolname\fP/togo"
Spool file 
.IP "\*a/out.going/\fIspoolname\fP/togo.old"
Previous spool file 
.IP "\*a/out.going/\fIspoolname\fP/LOCKb"
Lock file 
.IP "\*a/in.hosts/\fIspoolname\fP"
Incoming spool, host 
.I active 
file. There should be one of these per external
news server.
.IP "\*a/in.hosts/\fIspoolname\fP.tmp"
Incoming spool, temporary (while news are being pulled).
.IP "\*a/in.hosts/\fIspoolname\fP.old"
Previous generation of the external host 
.I active
file.
.IP "\*a/in.coming/.tmp.$$"
Incoming spool, temporary file. 
.I "$$"
is the process ID.
.IP "\*a/in.coming/T.$$.S.t"
Incoming spool, when finished and ready for newsrun. 
.I "T"
is the current Unix time, 
.I $$
is the process ID, and, 
.I S
is a sequence number.
.IP "\*c/active"
Local active file, contains a list over all currently active
newsgroups in the local spool. This is used as a basis for
constructing a list over which newsgroups will actually be requested.
The basic format of each specification is:
.br
	site/exclusions:grouplist/distlist:flags:cmd
.IP
Only the site and the grouplist fields are used. The site is the name
of the spool, whereas the group list is a comma-separated list of group
pattern names. A !-prefix signifies exclusions, and the name "all" 
matches anything.
.IP "\*c/sys"
Newsserver configuration file. 
This is used as a filter against the local
.I active
list, deciding which newsgroups which will actually be pulled.
.IP "\*c/history"
.IP "\*c/history.pag"
.IP "\*c/history.dir"
Local news spool database.
.PP
For INN:
.IP "\*a/out.going/\fIspoolname\fP"
Spool file
.IP "\*a/out.going/\fIspoolname\fP.old"
Previous spool file
.IP "\*c/LOCK.\fIspoolname\fP"
Lock file
.IP "\*c/active"
Local active file, contains a list over all currently active
newsgroups in the local spool. This is used as a basis for
constructing a list over which newsgroups will actually be requested.
.IP "\*c/newsfeeds"
Newsserver configuration file. 
This is used as a filter against the local
.I active
list, deciding which newsgroups which will actually be pulled.
The basic format of each specification is:
.br
	site/exclusions:grouplist/distlist:flags:param
.IP
Only the site and the grouplist fields are used. The site is the name
of the spool, whereas the group list is a comma-separated list of group
pattern names. A !-prefix signifies exclusions, and the name "*" matches
anything.
.IP "\*c/history"
.IP "\*c/history.pag"
.IP "\*c/history.dir"
Local news spool database.

.SH AUTHOR
Egil Kvaleberg <egilk@sn.no>

.SH "SEE ALSO"
.IR news (5),
.IR newsfeeds (5),
.IR rnews (8),
.IR relaynews (8)
.br
RFC-977 \- Network News Transfer Protocol (NNTP)
.br
RFC-1036 \- Usenet Article Format
