.TH MP 1 "28 April 1995"
.\"=====================================================================
.if n .ds MP MetaPost
.if t .ds MP MetaPost
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP\" for troff
.el .ds OX TeX\" for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
mp, inimp, virmp \- MetaPost, a system for drawing pictures
.SH SYNOPSIS
.B mp
[
.B \-T
] 
[ first-line ]
.PP
.B inimp
[
.B \-T
] 
[ first-line ]
.PP
.B virmp
[ 
.B \-T 
] 
[ first-line ]
.\"=====================================================================
.SH DESCRIPTION
\*(MP interprets the \*(MP language and produces PostScript
pictures.  The \*(MP language is similar to Knuth's \*(MF
with additional features for including
.BR tex (1)
or
.BR troff (1)
commands and accessing features of PostScript not found in \*(MF. 
The
.B -T
flag selects
.I troff
instead of
.IR tex .
.PP
Like \*(TX and \*(MF, \*(MP
is normally used with a large body of precompiled macros.  The basic
program as compiled is called
.BR inimp ;
it can be used to precompile macros into a
.I .mem
file.  The
.B virmp
variant is used to reload the
.I .mem
files quickly.  Typically,
.B virmp
has links to it by the names of the various mem files.
For example, if you link
.B virmp
to
.B mp
and then execute the program
.BR mp ,
you get the mem file
.IR mp.mem .
You can load a different base by saying, e.g.,
.IR "virmp \\\\\|&mymem" .
.PP
An argument given on the command line
behaves as the first input line.
That can be either a (possibly truncated) file name
or a sequence \*(MP commands starting with \\
and including an
.I input
command.  Thus
.I mp figs
processes the file
.IR figs.mp .
The basename of
.I figs
becomes the ``jobname'',
and is used in forming output file names.  If no file is named, the
jobname becomes
.IR mpout .
The default extension,
.IR .mp ,
can be overridden by specifying an extension explicitly.
.PP
There is normally one output file for each picture generated,
and the output files are named \fIjobname\fP\fB\^.\^\fP\fInnn\fP,
where \fInnn\fP 
is a number passed to the
.I beginfig
macro.  The output file name
can also be \fIjobname\fP\fB\^.\^\fP\fIps\fP
if this number is negative.
.PP
The output files can be used as figures in a \*(TX document by including
.ce
.BI "\especial{psfile=" jobname.nnn }
in the \*(TX document.  Alternatively, one can
.B \einput epsf.tex
and then use the macro
.ce
.BI "\eepsfbox{" jobname.nnn }
to produce a box of the appropriate size containing the figure.
.TP
.BI btex " TeX commands " etex
This causes
.I mp
to generate a \*(MP picture expression that corresponds to the
\*(TX commands.  If the \*(TX commands generate
more than one line of text, it must be in a
.I \evbox
or a minipage environment.
.TP
.BI verbatimtex " TeX commands " etex
This is ignored by
.I mp
except that the \*(TX commands are passed on to \*(TX.  When using \*(LX
instead of \*(TX the input file must start with a
.I verbatimtex
block that gives the
.I \edocumentstyle
and
.I "\ebegin{document}"
commands.
.PP
Since most \*(TX fonts have to be downloaded as bitmaps, the
.I btex
feature works best when the output of
.I mp
is to be included in a \*(TX document so that
.BR dvips (1)
can download the fonts.  For self-contained PostScript output that can be
used directly or included in a
.I troff
document, start your \*(MP input file with the command
.I "prologues:=1"
and stick to standard PostScript fonts.  \*(TX and \*(MP use the names in the
third column of the file
.IR @MPINPUTDIR@/support/trfonts.map .
.PP
\*(MP output can be included in a
.I troff
document via the
.I "-m pictures"
macro package.  In this case
.I mp
should be invoked with the
.B -T
flag so that the commands between
.I btex
and
.I etex
or between
.I verbatimtex
and
.I etex
are interpreted as
.I troff
instead of \*(TX.  (This automatically sets
.I "prologues:=1"
).
.\"=====================================================================
.SH ENVIRONMENT
The default values for all environment variables are set at the
time of compilation in the file
.IR kpathsea/paths.h .
See the Kpathsearch library documentation (the `Path specifications'
node) 
for the details of the searching.
.PP
If the environment variable
TEXMFOUTPUT is set, \*(MP attempts to put its output
files in it, if they cannot be put in the current directory.
.PP
Here is a list of the environment variables affect the behavior of
.IR mp :
.TP \w'MPXCOMMAND'u+2n
.TP
MPINPUTS
Search path for
.I input
files.
It should be colon-separated,
and start with dot.  Default:
.I @DEFAULT_MP_PATH@
.TP
MFINPUTS
Auxiliary search path for
.I input
files with
.I .mf
extensions.  Default:
.I @DEFAULT_MF_PATH@
.TP
TEXFONTS
Search path for font metric (\fI.tfm\fP) files.  Default:
.I @DEFAULT_TFM_PATH@
.TP
VFONTS
Search path for virtual font (\fI.vf\fP) files.  Default:
.I @DEFAULT_VF_PATH@
.TP
MPMEMS
Search path for
.I .mem
files. Default:
.I @DEFAULT_MEM_PATH@
.TP
MPPOOL
Search path for internal \*(MP strings.  (Used by 
.B inimp
only.)  Default:
.I @DEFAULT_MPPOOL_PATH@
.TP
MPSUPPORT
Directory for various tables for handling included
.I tex
and
.IR troff .
Default:
.I @MPINPUTDIR@/support
.TP
MPXCOMMAND
The name of a shell script that converts embedded typesetting commands
to a form that \*(MP understands.  Defaults:
.I makempx
for
.I tex
and
.I troffmpx
for
.IR troff .
.TP
TEX
The version of \*(TX \- or \*(LX \- to use when processing
.I btex
and
.I verbatimtex
commands.  Default:
.I tex
.TP
TROFF
The
.I troff
pipeline for
.I btex
and
.I verbatimtex
commands.  Default:
.I eqn -d\e$\e$ | troff
.TP
MPEDIT
A command template for invoking an editor.  Default:
.I "@EDITOR@"
.PP
A
.I .mem
file is a binary file that permits fast loading of macro packages.
.I mp
reads the default
.I plain.mem
unless another
.I .mem
file is specified at the start of the first line with an
.I &
just before it.  There is also an
.F mfplain.mem
that simulates plain \*(MF so that
.I mp
can read
.I .mf
fonts.  (Plain \*(MF is described in
.IR "The \*(MF\^book" ).
.PP
Experts can create
.I .mem
files be invoking
.I inimp
and giving macro definitions followed by a
.I dump
command.
.PP
The \*(MP language is similar to \*(MF, but the manual
.I A User's Manual for \*(MP
assumes no knowledge of \*(MF.  \*(MP does not have bitmap
output commands or \*(MF's online display mechanism.
.\"=====================================================================
.SH FILES
.TP \w'@TEXMF@'u+2n
.I "@MPPOOLDIR@/mp.pool"
Encoded text of \*(MP's messages.
.TP
.I "@MEMDIR@/*.mem"
Predigested \*(MP mem files.
.TP
.I "@plain.mp@"
The standard mem file.  This is loaded when
.I virmp
is invoked via a symbolic link as
.IR mp .
.TP
.I "@mfplain.mp@"
The \*(MF-compatible mem file.  This is loaded when 
.I virmp
is invoked via a symbolic link as
.IR mfmp .
.TP
.I "@MPINPUTDIR@/base/*.mp"
The standard \*(MP macros included in the original distribution.
.TP
.I "@MPINPUTDIR@/support/*"
Various tables for handling included
.I tex
and
.IR troff .
.TP
.I "@MPINPUTDIR@/support/trfonts.map"
Table of corresponding font names for
.I troff 
and PostScript.
.TP
.I "@FONTMAPDIR@/psfonts.map"
Table of corresponding font names for
.I tex
and PostScript.
.TP
.I "@TEXMF@/doc/mp/examples.mp"
The source file for a few sample figures
that are part of a \*(LX document
.I "@TEXMF@/doc/mp/mpintro.tex" 
that describes the \*(MP system 
in a little more detail.
.\"=====================================================================
.SH "SUGGESTED READING"
Donald E. Knuth,
.I "The \*(MF\^book"
(Volume C of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13445-4.
.br
John D. Hobby,
.IR "A User's Manual for \*(MP" ,
CSTR 162, AT&T Bell Labs,
.br
John D. Hobby,
.IR "Drawing Graphs with \*(MP" ,
CSTR 164, AT&T Bell Labs,
.br
.I TUGboat
(the journal of the \*(TX Users Group).
.\"=====================================================================
.SH "SEE ALSO"
.BR tex (1),
.BR mf (1),
.BR dvips (1).
.\"=====================================================================
.SH AUTHORS
\*(MP was designed by John D. Hobby, incorporating algorithms from 
\*(MF by Donald E. Knuth.  It was originally implemented on Unix,
incorporating system-dependent routines from
.BR web2c ,
while not relying on it except for the actual \*(WB-to-C translator.
.PP
Ulrik Vieth adapted \*(MP to take advantage of the advanced path 
searching features in more recent versions of
.B web2c
and worked towards fully integrating \*(MP into the canonical Unix 
\*(TX distribution.  He also updated and extended this manual page.
.\"=====================================================================
.SH TRIVIA
Unlike \*(TX and \*(MF, \*(MP originally didn't use any fancy logo.
John Hobby says he prefers the spelling ``MetaPost'', yet Don Knuth 
has updated the \*(MF 
.I logo.mf
font to be able to typeset a proper \*(MP logo similar to the \*(MF 
logo.  Feel free to use whatever you think is more appropriate!
