/************************************************************************
Copyright Notice

Copyright (c) MCNC, Clearinghouse for Networked Information Discovery and
Retrieval, 1994. 

Permission to use, copy, modify, distribute, and sell this software and
its documentation, in whole or in part, for any purpose is hereby granted
without fee, provided that

1. The above copyright notice and this permission notice appear in all
copies of the software and related documentation. Notices of copyright
and/or attribution which appear at the beginning of any file included in
this distribution must remain intact. 

2. Users of this software agree to make their best efforts (a) to return
to MCNC any improvements or extensions that they make, so that these may
be included in future releases; and (b) to inform MCNC/CNIDR of noteworthy
uses of this software. 

3. The names of MCNC and Clearinghouse for Networked Information Discovery
and Retrieval may not be used in any advertising or publicity relating to
the software without the specific, prior written permission of MCNC/CNIDR. 

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY
OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 

IN NO EVENT SHALL MCNC/CNIDR BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE
POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
************************************************************************/

/*@@@
File:		ztags.hxx
Version:	1.00
Description:	Z39.50 Tag definitions
Author:		Kevin Gamiel, kevin.gamiel@cnidr.org
@@@*/

#ifndef _ZTAGS_HXX_
#define _ZTAGS_HXX_

// Attribute set oids
#define BIB1_ATTRSET_OID "1.2.840.10003.3.1"
#define STAS_ATTRSET_OID "1.2.840.10003.3.1000.6.1"

// Diagnostic set oids
#define BIB1_DIAG_OID "1.2.840.10003.4.1"

// Record syntax oids
#define EXTENDEDSERVICES_OID "1.2.840.10003.5.106"
#define SUTRS_OID "1.2.840.10003.5.101"
#define USMARC_OID "1.2.840.10003.5.10"
#define HTML_OID "1.2.840.10003.5.1000.34.1"
#define SGML_OID "1.2.840.10003.5.1000.34.2"
#define GRS1_OID "1.2.840.10003.5.105"


#define INTERNATIONALSTRING_TAG 27	// Same as GENERALSTRING


#define REFERENCEID_TAG 2
#define RESULTSETID_TAG 31
#define ELEMENTSETNAME_TAG 103
#define SMALLSETELEMENTSETNAMES_TAG 100
#define MEDIUMSETELEMENTSETNAMES_TAG 101
#define PREFERREDMESSAGESIZE_TAG 5
#define EXCEPTIONALRECORDSIZE_TAG 6
#define IDAUTHENTICATION_TAG 7
#define IMPLEMENTATIONID_TAG 110
#define IMPLEMENTATIONNAME_TAG 111
#define IMPLEMENTATIONVERSION_TAG 112
#define USERINFORMATIONFIELD_TAG 11
#define PREFERREDMESSAGESIZE_TAG 5
#define EXCEPTIONALRECORDSIZE_TAG 6
#define RESULT_TAG 12
#define IMPLEMENTATIONID_TAG 110
#define IMPLEMENTATIONNAME_TAG 111
#define IMPLEMENTATIONVERSION_TAG 112
#define USERINFOFIELD_TAG 11
#define OTHERINFO_TAG 201
#define SMALLSETUPPERBOUND_TAG 13
#define LARGESETLOWERBOUND_TAG 14
#define MEDIUMSETPRESENTNUMBER_TAG 15
#define REPLACEINDICATOR_TAG 16
#define RESULTSETNAME_TAG 17
#define PREFERREDRECORDSYNTAX_TAG 104
#define ADDITIONALSEARCHINFO_TAG 203
#define RESULTCOUNT_TAG 23
#define NUMBEROFRECORDSRETURNED_TAG 24
#define NEXTRESULTSETPOSITION_TAG 25
#define SEARCHSTATUS_TAG 22
#define RESULTSETSTATUS_TAG 26
#define PRESENTSTATUS_TAG 27
#define ADDITIONALSEARCHINFO_TAG 203
#define RESULTSETSTARTPOINT_TAG 30
#define NUMBEROFRECORDSREQUESTED_TAG 29
#define PREFERREDRECORDSYNTAX_TAG 104
#define MAXSEGMENTCOUNT_TAG 204
#define MAXRECORDSIZE_TAG 206
#define MAXSEGMENTSIZE_TAG 207
#define NUMBEROFRECORDSRETURNED_TAG 24
#define NEXTRESULTSETPOSITION_TAG 25
#define PRESENTSTATUS_TAG 27
#define OPTIONS_TAG 4
#define PROTOCOLVERSION_TAG 3
#define INITREQUEST_TAG 20
#define INITRESPONSE_TAG 21
#define SEARCHREQUEST_TAG 22
#define SEARCHRESPONSE_TAG 23
#define PRESENTREQUEST_TAG 24
#define PRESENTRESPONSE_TAG 25
#define ELEMENTSETNAMES_TAG 

#define TARGETINFO_TAG 0
#define NONSURROGATEDIAGNOSTIC_TAG 130
#define SURROGATEDIAGNOSTIC_TAG 2
#define MULTIPLENONSURDIAGNOSTICS_TAG 205
#define PRESENTREQUEST_TAG 24
#define SUTRS_TAG 27
#define DATABASENAME_TAG 105
#define DATABASENAMES_TAG 18
#define RESPONSERECORDS_TAG 28
#define RECORD_TAG 1
#define RETRIEVALRECORD_TAG 1
#define SINGLE_ASN1_TYPE_TAG 0
#define DIRECTREFERENCE_TAG 6
#define OBJECTIDENTIFIER_TAG 6
#define SIMPLE_TAG 19
#define GENERICELEMENTSETNAME_TAG 0
#define QUERY_TAG 21
#define ATTRIBUTESETID_TAG 6
#define ATTRIBUTELIST_TAG 44
#define ATTRIBUTESPLUSTERM_TAG 102
#define RESULTSETPLUSATTRIBUTES_TAG 214
#define TYPE0_TAG 0
#define TYPE1_TAG 1
#define TYPE2_TAG 2
#define TYPE100_TAG 100
#define TYPE101_TAG 101
#define TYPE102_TAG 102
#define OP_TAG 0
#define RPNRPNOP_TAG 1
#define ATTRIBUTETYPE_TAG 120
#define NUMERIC_TAG 121
#define TERMGENERAL_TAG 45
#define OPERATOR_TAG 46
#define AND_TAG 0
#define OR_TAG 1
#define ANDNOT_TAG 2
#define PROX_TAG 3
#define PREFERREDRECORDSYNTAX_TAG 104

#define AUTHENTICATION_TAG 7
#define GROUPID_TAG 0
#define USERID_TAG 1
#define PASSWORD_TAG 2

#define DELETERESULTSETREQUEST_TAG 26
#define DELETERESULTSETRESPONSE_TAG 27
#define ACCESSCONTROLREQUEST_TAG 28
#define ACCESSCONTROLRESPONSE_TAG 29
#define RESOURCECONTROLREQUEST_TAG 30 
#define RESOURCECONTROLRESPONSE_TAG 31
#define TRIGGERRESOURCECONTROLREQUEST_TAG 32
#define RESOURCEREPORTREQUEST_TAG 33
#define RESOURCEREPORTRESPONSE_TAG 34
#define SORTREQUEST_TAG 43
#define SORTRESPONSE_TAG 44
#define SEGMENTREQUEST_TAG 45
#define EXTENDEDSERVICESREQUEST_TAG 46
#define EXTENDEDSERVICESRESPONSE_TAG 47
#define CLOSE_TAG 48

// Scan-specific tags
#define SCANREQUEST_TAG 35
#define SCANRESPONSE_TAG 36
#define STEPSIZE_TAG 5
#define NUMBEROFTERMSREQUESTED_TAG 6
#define PREFERREDPOSITIONINRESPONSE_TAG 7
#define NUMBEROFENTRIESRETURNED_TAG 5

// Extended service specific tags

// -- Request

#define ES_FUNCTION_TAG 3

#  define ES_CREATE_FUNCTION 1
#  define ES_DELETE_FUNCTION 2
#  define ES_MODIFY_FUNCTION 3

#define ES_PACKAGETYPE_TAG 4

#  define ES_UPDATE_OID "1.2.840.10003.9.5"

#define ES_PACKAGENAME_TAG 5
#define ES_USERID_TAG 6
#define ES_RETENTIONTIME_TAG 7
#define ES_PERMISSIONS_TAG 8
#define ES_DESCRIPTION_TAG 9
#define ES_TASKSPECIFIC_TAG 10
#define ES_WAITACTION_TAG 11

#  define ES_WAIT_WAITACTION 1
#  define ES_WAIT_IF_POSSIBLE_WAITACTION 2
#  define ES_DONT_WAIT_WAITACTION 3
#  define ES_DONT_RETURN_PACKAGE_WAITACTION 4

// -- Response

#define ES_OPERATIONSTATUS_TAG 3

#  define ES_DONE_OPERATIONSTATUS 1
#  define ES_ACCEPTED_OPERATIONSTATUS 2
#  define ES_FAILURE_OPERATIONSTATUS 3

#define ES_DIAGNOSTICS_TAG 4
#define ES_TASKPACKAGE_TAG 5

#  define ES_TP_PACKAGETYPE_TAG 1
#  define ES_TP_PACKAGENAME_TAG 2
#  define ES_TP_USERID_TAG 3
#  define ES_TP_RETENTIONTIME_TAG 4
#  define ES_TP_PERMISSIONS_TAG 5
#  define ES_TP_DESCRIPTION_TAG 6
#  define ES_TP_TARGETREFERENCE_TAG 7
#  define ES_TP_CREATATIONDATETIME_TAG 8
#  define ES_TP_TASKSTATUS_TAG 9

#    define ES_TP_PENDING_TASKSTATUS 0
#    define ES_TP_ACTIVE_TASKSTATUS 1
#    define ES_TP_COMPLETE_TASKSTATUS 2
#    define ES_TP_ABORTED_TASKSTATUS 3

#  define ES_TP_PACKAGEDIAGNOSTICS_TAG 10
#  define ES_TP_TASKSPECIFIC_TAG 11

// Extended service task specific tags

// -- Request

#define ES_TS_ESREQUEST_TAG 1

#  define ES_TS_TOKEEP_TAG 1
#  define ES_TS_NOTTOKEEP_TAG 2

#define ES_UPDATE_ACTION_TAG 1

#  define ES_UPDATE_RECORD_INSERT_ACTION 1
#  define ES_UPDATE_RECORD_REPLACE_ACTION 2
#  define ES_UPDATE_RECORD_DELETE_ACTION 3
#  define ES_UPDATE_ELEMENT_UPDATE_ACTION 4

#define ES_UPDATE_DATABASENAME_TAG 2
#define ES_UPDATE_SCHEMA_TAG 3

#define ES_UPDATE_RECORDID_TAG 1

#  define ES_UPDATE_NUMERIC_RECORDID_TAG 1
#  define ES_UPDATE_STRING_RECORDID_TAG 2
#  define ES_UPDATE_OPAQUE_RECORDID_TAG 3

#define ES_UPDATE_SUPPLEMENTALID_TAG 2
#define ES_UPDATE_CORRELATIONINFO_TAG 3
#define ES_UPDATE_RECORD_TAG 4

// -- Response

#define ES_TS_TASKPACKAGE_TAG 2

#  define ES_TS_ORIGINPART_TAG 1
#  define ES_TS_TARGETPART_TAG 2

#define ES_UPDATE_UPDATESTATUS_TAG 1

#  define ES_UPDATE_SUCCESS_UPDATESTATUS 1
#  define ES_UPDATE_PARTIAL_UPDATESTATUS 2
#  define ES_UPDATE_FAILURE_UPDATESTATUS 3

#define ES_UPDATE_GLOBALDIAGNOSTICS_TAG 2
#define ES_UPDATE_TASKPACKAGERECORDS_TAG 3

// Close
#define CLOSEREASON_TAG 211

#endif

