50 DIM ATT(195)
51 DIM X(195)
52 DIM Y(195)
200 CLS:PRINT"                  T-NETWORK DESIGN AND ANTENNA TUNER"
205 PRINT"                  ---------------------------------"
207 PRINT"                           W4ULD 5-23-93"
210 PRINT:PRINT:PRINT"              PRESS A FOR ANTENNA TUNER CALCULATION"
212 PRINT:PRINT"              PRESS N TO DESIGN NETWORK BASED ON OUTPUT CAPACITOR"
213 PRINT:PRINT"              PRESS Q TO DESIGN NETWORK BASED ON AVERAGE Q"
217 PRINT:PRINT"              PRESS D FOR DISCUSSION OF PROGRAM"
218 PRINT:PRINT"              PRESS E TO EXIT PROGRAM"
220 A$=INKEY$:IF A$="" THEN 220
222 IF A$="A" THEN 300
230 IF A$="N" THEN 6800
235 IF A$="Q" THEN 7100
240 IF A$="D" THEN 8100
242 IF A$="E" THEN 9000
250 GOTO 220
300 CLS
305 D=0:REM IDENTIFIER TO SELECT TUNER OR REGULAR CALCULATION
310 PRINT:INPUT"ENTER LOAD RESISTANCE, RL, OHMS       ";RL
320 INPUT"ENTER LOAD REACTANCE, XL, +/-OHMS           ";XL
330 INPUT"ENTER INPUT RESISTANCE, RI, OHMS      ";RI
340 INPUT"ENTER FREQUENCY, F, MHz.              ";F
400 PI=3.141593
402 A=(1-RL/RI):B=-32
404 C=256-RL/RI+1
405 QO=(-B-SQR(B^2-4*A*C))/2/A
406 XS=QO*RL:XOS=XL-XS
408 C=-1000000!/(2*PI*F*XOS)
409 PRINT"DESIRED C FOR Q= 8 IS";C
410 IF C>235 THEN 750
411 IF C<25 THEN 760
415 PRINT"STARTING C OUT=";:PRINT USING "###.#";C;:PRINT" PF"
417 CC=0:REM CC IS A REFERENCE USED TO STOP Q ADJUSTMENT. SEE 900
420 GOTO 2000
422 CIN=-1000000!/(2*PI*F*XI)
424 COUT=-1000000!/(2*PI*F*XOS)
426 QI=ABS(XI/RI)
427 QO=ABS(XS/RL)
428 QA=(QI+QO)/2
429 IF D=1 THEN 438
430 IF D=2 THEN 438
431 IF QA>15 THEN 900
432 IF CIN<30 THEN 800
435 IF CIN>230 THEN 810
438 PRINT"C IN=";:PRINT USING "###.#";CIN;:PRINT" PF"
440 PRINT"C OUT=";:PRINT  USING "###.#";COUT;:PRINT" PF"
445 PRINT"XOS=";:PRINT USING "#####.###";XOS;:PRINT"  XS=";:PRINT USING "#####.###";XS
450 LT=XT/(2*PI*F):PRINT"L =";:PRINT USING "###.##";LT;:PRINT" uH"
460 PRINT"INPUT Q =";:PRINT USING "###.###";QI;
470 PRINT"  OUTPUT Q=";:PRINT USING "###.###";QO
480 PRINT"AVERAGE Q=";:PRINT USING "###.###";QA
600 PRINT:PRINT"PRESS ANY KEY FOR A NEW CALCULATION"
602 PRINT"PRESS C FOR CHECK CALCULATION"
604 PRINT"PRESS D FOR +/- 3 DB LIMITS"
605 PRINT"PRESS G FOR 3 DB ATTENUATION GRAPH"
606 PRINT"PRESS A  FOR 0 - 130 MHz. ATTENTUATION CHART"
608 PRINT"PRESS L TO CALCULATE LOSS IN NETWORK"
609 PRINT"PRESS M FOR CALCULATION MODE MENU"
610 A$=INKEY$:IF A$="" THEN 610
612 IF A$="C" THEN 2500
614 IF A$="D" THEN 2700
615 IF A$="G" THEN 3500
616 IF A$="M" THEN 8000
617 IF A$="A" THEN 5000
618 IF A$="L" THEN 6000
619 IF D=1 THEN 6890:REM SELECTS ENTRY MODE OF CALCULATION
620 IF D=2 THEN 7100
640 GOTO 300
750 C=C-5:GOTO 410
760 C=C+5:GOTO 410
800 IF COUT>230 THEN 820
805 C=C+10:GOTO 2000
810 IF COUT<30 THEN 820
815 C=C-10:GOTO 2000
820 PRINT:PRINT"LOAD IMPEDANCE IS OUT OF RANGE OF TUNER"
830 PRINT:PRINT"PRESS ANY KEY FOR ANOTHER CALCULATION"
840 A$=INKEY$:IF A$="" THEN 840
850 GOTO 300
900 IF CC=230 THEN 990:REM CC IS A REFERENCE TO STOP Q ADJUSTMENT
905 IF C=230 AND CIN<230 THEN 990
910 IF CIN<230 AND C<230 THEN 950
915 IF CIN>230 THEN 1000
920 IF C=230 AND CIN>230 THEN 1000
950 C=C+10
955 IF C>230 THEN C=230
960 GOTO 2000
990 PRINT"THE AVERAGE Q OF THIS NETWORK CANNOT BE REDUCED TO 15. LOSSES WILL BE HIGH AND"
991 PRINT"THE NETWORK MAY BE IMPRACTICAL."
995 GOTO 432
1000 C=C-10
1010 CC=230:GOTO 2000
2000 XOS=-1000000!/(2*PI*F*C)
2020 XS=XOS+XL
2040 RP=(RL^2+XS^2)/RL
2060 XP=(RL^2+XS^2)/XS
2080 XMI=-1000000!/(2*PI*F*230):REM MIN X FOR OUTPUT CAPACITOR
2090 XMA=-1000000!/(2*PI*F*25):REM MAX X FOR OUTPUT CAPACITOR
2100 XIP=XP
2120 GXP=1/RP:REM CONDUCTANCE OF RP
2130 BXP=-SQR((GXP-RI*GXP^2)/RI)
2150 XXP=-1/BXP
2170 XXS=-BXP/(GXP^2+BXP^2)
2180 XI=-XXS
2200 XT=1/(1/XXP-1/XIP)
2250 GOTO 422
2500 XS=XOS+XL
2510 RP=(RL^2+XS^2)/RL
2520 XIP=(RL^2+XS^2)/XS
2530 XT1=1/(1/XT+1/XIP)
2540 RS=RP/(1+(RP/XT1)^2)
2550 XI2=RS*RP/XT1
2551 CLS:PRINT"THE CHECK CALCULATION PERFORMS AN INDEPENDENT LADDER NETWORK ANALYSIS USING THE"
2552 PRINT"CALCULATED VALUES OF INPUT AND OUTPUT CAPACITANCES AND THE PARALLEL INDUCTANCE."
2553 PRINT"FOR THE CALCULATED VALUES TO BE VALID THE 'CALCULATED SERIES REACTANCE' AND THE"
2554 PRINT"'REACTANCE OF THE INPUT CAPACITOR' MUST BE EQUAL BUT OF OPPOSITE SIGN. THE"
2555 PRINT"'CALC. SERIES RESISTANCE' MUST ALSO EQUAL THE 'SOURCE RESISTANCE'."
2556 PRINT
2560 PRINT"REACTANCE OF INPUT CAPACITOR=";XI
2570 PRINT"SOURCE RESISTANCE, RI       =";RI
2580 PRINT"CALC. SERIES REACTANCE      =";XI2
2590 PRINT"CALC. SERIES RESISTANCE     =";RS
2600 GOTO 600
2700 CLS:PRINT"ATTENTUATION DATA WILL GO ONLY TO PRINTER. IS PRINTER READY?"
2701 PRINT"                                           ================="
2702 PRINT"THE PRINTED OUTPUT WILL BE FROM -10 MHz. TO +10 MHz. OF THE DESIGN FREQUENCY IN"
2704 PRINT"STEPS OF .1 MHz. OR UNTIL A -3 DB LEVEL IS REACHED. THUS THERE COULD BE 200"
2705 PRINT"DATA POINTS PRINTED IF THE Q IS QUITE LOW OR IF -3 DB IS NOT REACHED IN "
2706 PRINT"+/-10 MHz. IT IS RECOMMENDED THAT A 3 DB GRAPH BE PLOTTED BEFORE PRINTING THE"
2707 PRINT"DATA POINTS."
2720 PRINT:PRINT"PRESS P TO PRINT ATTENUATION DATA"
2730 PRINT:PRINT"PRESS ANY KEY TO RETURN TO CALCULATIONS"
2740 A$=INKEY$:IF A$="" THEN 2740
2750 IF A$="P" THEN 2770
2760 CLS:GOTO 600
2770 CLS:LPRINT"               T-NETWORK ATTENUATION DATA"
2810 LPRINT"               --------------------------"
2820 LPRINT:LPRINT"INPUT R=";RI;"OHMS";"  LOAD R=";RL;"OHMS";"  LOAD X= ";XL;"OHMS"
2830 LPRINT:LPRINT"INPUT C=";:LPRINT USING "####.##";CIN;:LPRINT" PF";
2831 LPRINT"  OUTPUT C=";:LPRINT USING "####.##";COUT;:LPRINT" PF";
2832 LPRINT"  INDUCTANCE=";:LPRINT USING "##.##";LT;:LPRINT" uH"
2833 LPRINT:LPRINT"AVERAGE Q=";:LPRINT USING "##.##";QA
2850 LPRINT:LPRINT"FREQUENCY, MHz." TAB(20)"ATTENUATION, DB"
2860 LPRINT"---------------" TAB(20)"---------------"
2870 FOR F1=F TO (F+10) STEP .1
2880 GOSUB 2960
2885 LPRINT USING "###.##";F1;:LPRINT TAB(22);:LPRINT USING "###.##";ATT
2890 IF ATT>=3 THEN 2910
2900 NEXT F1
2910 FOR F1=F TO (F-10) STEP -.1
2920 GOSUB 2960
2935 LPRINT USING "###.#";F1;:LPRINT TAB(22);:LPRINT USING "###.##";ATT
2937 IF ATT>=3 THEN 2950
2940 NEXT F1
2950 GOTO 600
2960 XOS1=-1000000!/(2*PI*F1*COUT)
2970 XT1=2*PI*F1*LT
2980 XI1=-1000000!/(2*PI*F1*CIN)
2990 XS1=XOS1+XL
3000 RP1=(RL^2+XS1^2)/RL
3010 XIP1=(RL^2+XS1^2)/XS1
3020 XT2=1/(1/XT1+1/XIP1)
3030 RS1=RP1/(1+(RP1/XT2)^2)
3040 XI2=RS1*RP1/XT2
3050 ATT=-10*LOG(4*RI*RS1/((RI+RS1)^2+(XI1+XI2)^2))/LOG(10)
3140 RETURN
3150 GOTO 600
3500 CLS
3502 PRINT"A GRAPH OF ATTENUATION VS. FREQUENCY WILL BE DRAWN ON THE SCREEN. THERE WILL "
3503 PRINT"NOT BE ANY FURTHER PROGRAM INSTRUCTIONS SO THAT THE GRAPH CAN BE PRINTED USING"
3504 PRINT"THE <PRINT SCREEN> KEY. WHILE THE GRAPH IS DISPLAYED, PRESS M TO RETURN TO THE"
3505 PRINT"MENU."
3506 PRINT:PRINT"PRESS ANY KEY TO CONTINUE"
3507 A$=INKEY$:IF A$="" THEN 3507
3508 CLS
3510 SCREEN 9
3520 LINE (48,16)-(48,286):REM LEFT VER
3525 LINE (48,16)-(568,16):REM TOP HOR
3530 LINE (48,286)-(568,286):REM BOT HOR
3535 LINE (168,16)-(168,286):REM 0 VERT
3540 LINE (48,16)-(54,16):REM LEFT VERT DIV
3550 LINE (48,61)-(54,61):REM DITTO
3560 LINE (48,106)-(54,106):REM DITTO
3570 LINE (48,151)-(54,151):REM DITTO
3580 LINE (48,196)-(54,196):REM DITTO
3590 LINE (48,241)-(54,241):REM DITTO
3600 LINE (48,151)-(568,151):REM 3 DB HOR LINE
3610 LOCATE 2,4:PRINT"0"
3620 LOCATE 5,3:PRINT"-1"
3630 LOCATE 8,3:PRINT"-2"
3640 LOCATE 11,3:PRINT"-3"
3650 LOCATE 15,3:PRINT"-4"
3660 LOCATE 18,3:PRINT"-5"
3670 LOCATE 21,3:PRINT"-6"
3680 LOCATE 13,2:PRINT"DB"
3690 LOCATE 2,74:PRINT"0"
3700 LINE (568,16)-(568,286):REM RIGHT VERT
3710 LINE (562,16)-(568,16):REM RIGHT VERT DIV
3720 LINE (562,61)-(568,61):REM DITTO
3730 LINE (562,106)-(568,106):REM DITTO
3740 LINE (562,151)-(568,151):REM DITTO
3750 LINE (562,196)-(568,196):REM DITTO
3760 LINE (562,241)-(568,241):REM DITTO
3770 LOCATE 5,73:PRINT"-1"
3780 LOCATE 8,73:PRINT"-2"
3790 LOCATE 11,73:PRINT"-3"
3800 LOCATE 15,73:PRINT"-4"
3810 LOCATE 18,73:PRINT"-5"
3820 LOCATE 21,73:PRINT"-6"
3830 LOCATE 13,75:PRINT"DB"
3840 LINE (88,286)-(88,280):REM BOT DIV
3845 LINE (88,151)-(88,157):REM 3 DB DIV
3850 LINE (128,286)-(128,280):REM BOT DIV
3855 LINE (128,151)-(128,157):REM 3 DB DIV
3860 LINE (168,286)-(168,280):REM BOT DIV
3865 LINE (168,151)-(168,157):REM 3DB DIV
3870 LINE (208,286)-(208,280):REM BOT DIV
3875 LINE (208,151)-(208,157):REM 3 DB DIV
3880 LINE (248,286)-(248,280):REM BOT DIV
3885 LINE (248,151)-(248,157):REM 3 DB DIV
3890 LINE (288,286)-(288,280):REM BOT DIV
3895 LINE (288,151)-(288,157):REM 3 DB DIV
3900 LINE (328,286)-(328,280):REM BOT DIV
3905 LINE (328,151)-(328,157):REM 3 DB DIV
3910 LINE (368,286)-(368,280):REM BOT DIV
3915 LINE (368,151)-(368,157):REM 3 DB DIV
3920 LINE (408,286)-(408,280):REM BOT DIV
3925 LINE (408,151)-(408,157):REM W DB DIV
3930 LINE (448,286)-(448,280):REM BOT DIV
3935 LINE (448,151)-(448,157):REM 3 DB DIV
3940 LINE (488,286)-(488,280):REM BOT DIV
3945 LINE (488,151)-(488,157):REM 3 DB DIV
3950 LINE (528,286)-(528,280):REM BOT DIV
3951 LINE (528,151)-(528,157):REM 3 DB DIV
3960 LOCATE 22,6:PRINT"-30"
3970 LOCATE 22,11:PRINT"-20"
3980 LOCATE 22,16:PRINT"-10"
3990 LOCATE 22,22:PRINT"0"
4000 LOCATE 22,26:PRINT"10"
4010 LOCATE 22,31:PRINT"20"
4020 LOCATE 22,36:PRINT"30"
4030 LOCATE 22,41:PRINT"40"
4040 LOCATE 22,46:PRINT"50"
4050 LOCATE 22,51:PRINT"60"
4060 LOCATE 22,56:PRINT"70"
4070 LOCATE 22,61:PRINT"80"
4080 LOCATE 22,66:PRINT"90"
4090 LOCATE 22,71:PRINT"100"
4100 LOCATE 23,21:PRINT"PERCENT DEVIATION FROM DESIGN FREQUENCY, MHZ."
4200 FOR A=0 TO 195
4210 F1=F+(A*F/150-.3*F)
4220 GOSUB 2960
4225 ATT(A)=ATT
4250 X(A)=48+A*520/195
4260 Y(A)=16+ATT(A)*276/6
4262 IF A=0 THEN 4280
4264 IF ATT(A-1)>6 THEN 4280
4266 IF ATT(A)>6 THEN 4280
4270 LINE (X(A-1),Y(A-1))-(X(A),Y(A))
4280 NEXT A
4500 A$=INKEY$:IF A$="" THEN 4500
4502 IF A$<>"M" THEN 4500
4505 IF A$="M" THEN 4510
4510 SCREEN 0
4520 GOTO 600
5000 CLS
5010 PRINT"A GRAPH OF ATTENUATION VS. FREQUENCY WILL BE DRAWN ON THE SCREEN. THERE WILL "
5020 PRINT"NOT BE ANY FURTHER PROGRAM INSTRUCTIONS SO THAT THE GRAPH CAN BE PRINTED USING"
5030 PRINT"THE <PRINT SCREEN> KEY. WHILE THE GRAPH IS DISPLAYED, PRESS M TO RETURN TO THE"
5040 PRINT"MENU."
5050 PRINT:PRINT"PRESS ANY KEY TO CONTINUE"
5060 A$=INKEY$:IF A$="" THEN 5060
5070 CLS
5080 SCREEN 9
5090 LINE (48,16)-(48,286):REM LEFT VER
5100 LINE (48,16)-(568,16):REM TOP HOR
5110 LINE (48,286)-(568,286):REM BOT HOR
5130 LINE (48,16)-(54,16):REM LEFT VERT DIV
5140 LINE (48,61)-(54,61):REM DITTO
5150 LINE (48,106)-(54,106):REM DITTO
5160 LINE (48,151)-(54,151):REM DITTO
5170 LINE (48,196)-(54,196):REM DITTO
5180 LINE (48,241)-(54,241):REM DITTO
5200 LOCATE 2,4:PRINT"0"
5210 LOCATE 5,3:PRINT"-10"
5220 LOCATE 8,3:PRINT"-20"
5230 LOCATE 11,3:PRINT"-30"
5240 LOCATE 15,3:PRINT"-40"
5250 LOCATE 18,3:PRINT"-50"
5260 LOCATE 21,3:PRINT"-60"
5270 LOCATE 13,2:PRINT"DB"
5280 LOCATE 2,74:PRINT"0"
5290 LINE (568,16)-(568,286):REM RIGHT VERT
5300 LINE (562,16)-(568,16):REM RIGHT VERT DIV
5310 LINE (562,61)-(568,61):REM DITTO
5320 LINE (562,106)-(568,106):REM DITTO
5330 LINE (562,151)-(568,151):REM DITTO
5340 LINE (562,196)-(568,196):REM DITTO
5350 LINE (562,241)-(568,241):REM DITTO
5360 LOCATE 5,73:PRINT"-10"
5370 LOCATE 8,73:PRINT"-20"
5380 LOCATE 11,73:PRINT"-30"
5390 LOCATE 15,73:PRINT"-40"
5400 LOCATE 18,73:PRINT"-50"
5410 LOCATE 21,73:PRINT"-60"
5420 LOCATE 13,75:PRINT"DB"
5430 LINE (88,286)-(88,280):REM BOT DIV
5450 LINE (128,286)-(128,280):REM BOT DIV
5470 LINE (168,286)-(168,280):REM BOT DIV
5490 LINE (208,286)-(208,280):REM BOT DIV
5510 LINE (248,286)-(248,280):REM BOT DIV
5530 LINE (288,286)-(288,280):REM BOT DIV
5550 LINE (328,286)-(328,280):REM BOT DIV
5570 LINE (368,286)-(368,280):REM BOT DIV
5590 LINE (408,286)-(408,280):REM BOT DIV
5610 LINE (448,286)-(448,280):REM BOT DIV
5630 LINE (488,286)-(488,280):REM BOT DIV
5650 LINE (528,286)-(528,280):REM BOT DIV
5670 LOCATE 22,6:PRINT"0"
5680 LOCATE 22,11:PRINT"10"
5690 LOCATE 22,16:PRINT"20"
5700 LOCATE 22,22:PRINT"30"
5710 LOCATE 22,26:PRINT"40"
5720 LOCATE 22,31:PRINT"50"
5730 LOCATE 22,36:PRINT"60"
5740 LOCATE 22,41:PRINT"70"
5750 LOCATE 22,46:PRINT"80"
5760 LOCATE 22,51:PRINT"90"
5770 LOCATE 22,56:PRINT"100"
5780 LOCATE 22,61:PRINT"110"
5790 LOCATE 22,66:PRINT"120"
5800 LOCATE 22,71:PRINT"130"
5810 LOCATE 23,21:PRINT"FREQUENCY, MHz."
5820 FOR A=1 TO 195
5830 F1=.66667*A
5840 GOSUB 2960
5850 ATT(A)=ATT
5860 X(A)=48+A*520/195
5870 Y(A)=16+ATT(A)*276/60
5890 IF ATT(A-1)>60 THEN 5920
5900 IF ATT(A)>60 THEN 5920
5910 LINE (X(A-1),Y(A-1))-(X(A),Y(A))
5920 NEXT A
5930 A$=INKEY$:IF A$="" THEN 5930
5940 IF A$<>"M" THEN 5930
5950 IF A$="M" THEN 5960
5960 SCREEN 0
5970 GOTO 600
6000 CLS:INPUT"ENTER Q OF INDUCTANCE";QC
6015 XOS=-1000000!/(2*PI*F*COUT)
6020 XS=XOS+XL
6040 RP=(RL^2+XS^2)/RL
6060 XP=(RL^2+XS^2)/XS
6065 FOR X=1 TO 5
6070 RC=QC*XT
6080 RT=1/(1/RP+1/RC)
6100 XIP=XP
6120 GXP=1/RT
6130 BXP=-SQR((GXP-RI*GXP^2)/RI)
6150 XXP=-1/BXP
6170 XXS=-BXP/(GXP^2+BXP^2)
6180 XI=-XXS
6200 XT=1/(1/XXP-1/XIP)
6205 NEXT X
6350 PRINT"LOAD RESISTANCE, OHMS  =";RL
6360 PRINT"LOAD REACTANCE, OHMS   =";XL
6370 PRINT"SOURCE RESISTANCE, OHMS=";RI
6380 PRINT"FREQUENCY, MHz.        =";F
6390 PRINT
6400 PRINT"XOS=";XOS,"XS=";XS
6410 PRINT"RC=";RC,"RP=";RP
6420 PRINT"RT=";RT
6430 LOS=10*LOG((1/RT)/(1/RP))/LOG(10)
6440 PRINT"NETWORK LOSS, DB=";:PRINT USING "##.##";LOS
6450 CIN=-1000000!/(2*PI*F*XI):PRINT"C IN, PF= ";:PRINT USING "###.##";CIN
6460 COUT=-1000000!/(2*PI*F*XOS):PRINT"C OUT, PF=";:PRINT USING "###.##";COUT
6470 LT=XT/(2*PI*F):PRINT"PARALLEL INDUCTANCE, uH=";:PRINT USING "##.##";LT
6480 QI=ABS(XI/RI):QO=ABS(XS/RL)
6481 QA=(QI+QO)/2
6482 PRINT"INPUT Q=";:PRINT USING "##.###";QI;
6483 PRINT"  OUTPUT Q=";:PRINT USING "##.###";QO
6484 PRINT"AVERAGE Q OF NETWORK=";:PRINT USING "##.###";QA
6490 PRINT:PRINT"PRESS ANY KEY FOR MENU"
6500 A$=INKEY$:IF A$="" THEN 6500
6510 CLS
6520 GOTO 600
6800 CLS:PRINT"THE LADDER NETWORK ANALYSIS USED IN THIS PROGRAM STARTS AT THE LOAD AND WORKS"
6810 PRINT"BACK TO THE SOURCE. THUS ONLY THE OUTPUT CAPACITOR MAY BE CHOSEN AND THE INPUT"
6820 PRINT"CAPACITOR AND THE INDUCTANCE WILL BE CALCULATED. THE OTHER VARIABLE, Q, CAN BE"
6830 PRINT"VARIED BY VARYING THE OUTPUT CAPACITOR. IN ADDITION TO THE OUTPUT CAPACITOR,"
6840 PRINT"THE LOAD RESISTANCE, LOAD REACTANCE, AND SOURCE RESISTANCE ALL IN OHMS AND THE"
6850 PRINT"FREQUENCY IN MHz. MUST BE ENTERED."
6860 PRINT:PRINT"PRESS ANY KEY TO CALCULATE"
6870 A$=INKEY$:IF A$="" THEN 6870
6880 D=1:REM IDENTIFIER TO SELECT ENTRY VS TUNE MODE OF CALCULATION
6890 CLS:INPUT"ENTER THE LOAD RESISTANCE, RL, OHMS          ";RL
6900 INPUT"ENTER THE LOAD REACTANCE,XL, +/- OHMS        ";XL
6910 INPUT"ENTER THE SOURCE RESISTANCE, RI, OHMS        ";RI
6920 INPUT"ENTER THE OUTPUT CAPACITOR, C OUT, PF        ";C
6930 INPUT"ENTER THE FREQUENCY, F, MHz.                 ";F
6940 PI=3.141593
6950 GOTO 2000
7100 CLS
7110 INPUT"ENTER LOAD RESISTANCE, RL, OHMS";RL
7120 INPUT"ENTER LOAD REACTANCE, XL, +/-OHMS";XL
7130 INPUT"ENTER SOURCE RESISTANCE, RI, OHMS";RI
7140 INPUT"ENTER DESIRED AVERAGE Q";QA
7150 INPUT"ENTER FREQUENCY, MHz.";F
7160 PI=3.141593
7165 D=2:REM PROGRAM IDENTIFIER
7170 A=(1-RL/RI)
7180 B=-4*QA
7190 C=4*QA^2-RL/RI+1
7200 QO=(-B-SQR(B^2-4*A*C))/2/A
7210 PRINT"QO=";QO
7220 XS=-QO*RL
7230 XOS=XL-XS
7240 C=ABS(1000000!/(2*PI*F*XOS))
7245 PRINT"C 0UT=";C
7250 GOTO 2000
8000 CLS:GOTO 210
8100 CLS:PRINT"PROGRAM DESCRIPTION"
8105 PRINT"-------------------"
8108 PRINT:PRINT"THIS PROGRAM WAS ORIGINALLY WRITTEN TO DESCRIBE THE OPERATION OF A T-NETWORK"
8110 PRINT"ANTENNA TUNER HAVING VARIABLE CAPACITORS FOR THE SERIES ELEMENTS AND A VARIABLE"
8120 PRINT"INDUCTOR FOR THE PARALLEL ELEMENT. THE INPUT DATA ARE LOAD RESISTANCE, LOAD RE-"
8130 PRINT"ACTANCE, SOURCE RESISTANCE, AND FREQUENCY. THE OUTPUT DATA ARE VALUES FOR THE"
8140 PRINT"INPUT AND OUTPUT CAPACITORS, A VALUE FOR THE PARALLEL INDUCTOR, INPUT AND OUT-"
8150 PRINT"PUT Q, AND AVERAGE Q. IN ADDITION THE NETWORK LOSS IN dB IS CALCULATED"
8160 PRINT"WHEN THE Q OF THE INDUCTOR IS ENTERED. THE TUNER PARAMETERS ARE AUTOMATICALLY"
8170 PRINT"LIMITED WITHIN THE PROGRAM BY THE MINIMUM AND MAXIMUM VALUES OF THE CAPACITORS"
8180 PRINT"AND THE INDUCTOR, AND THE PROGRAM WILL INDICATE WHEN A LOAD IMPEDANCE IS OUT OF"
8190 PRINT"RANGE AND WHEN A MAXIMUM Q OF 15 IS EXCEEDED. OTHER OUTPUT OPTIONS INCLUDE A"
8200 PRINT"SCREEN GRAPH OR PRINTOUT FOR -3 DB ATTENUATION AND ATTENUATION VS. FREQUENCY "
8210 PRINT"UP TO 130 MHz."
8220 PRINT:PRINT"THE PROGRAM HAS BEEN EXPANDED FOR DESIGN OF THE SERIES C TYPE OF T-NETWORK "
8230 PRINT"BASED ON A CHOICE OF OUTPUT CAPACITOR OR Q."
8240 PRINT:PRINT"PRESS ANY KEY FOR FURTHER DISCUSSION."
8250 A$=INKEY$:IF A$="" THEN 8250
8260 CLS:PRINT"T-NETWORK DISCUSSION"
8270 PRINT"--------------------"
8280 PRINT"THE T-NETWORK IS AN EXTREMELY VERSATILE NETWORK CAPABLE OF MATCHING AN INFINITE"
8290 PRINT"RANGE OF IMPEDANCES. LIKE THE PI-NETWORK THERE ARE AN INFINITE NUMBER OF SOLU-"
8300 PRINT"TIONS TO A COMBINATION OF LOAD AND SOURCE IMPEDANCE. THUS AN ADDITIONAL FACTOR,"
8310 PRINT"Q, IS REQUIRED TO PINPOINT A SPECIFIC SOLUTION. THE SERIES CAPACITANCE CONFIG-"
8320 PRINT"URATION OF THE T-NETWORK IS A HIGH PASS SYSTEM. THUS, ATTENUATION OF HARMONICS"
8330 PRINT"MUST BE ACCOMPLISHED PRIOR TO THE MATCHING NETWORK."
8340 PRINT:PRINT"PROGRAM APPROACH"
8350 PRINT"----------------"
8360 PRINT"THE PROGRAM PERFORMS A LADDER NETWORK ANALYSIS STARTING AT THE LOAD AND WORK-"
8370 PRINT"ING BACK TO THE SOURCE. IN THE TUNER CALCULATIONS AN OUTPUT CAPACITOR IS"
8380 PRINT"CHOSEN AUTOMATICALLY TO PROVIDE A Q OF 10. IF THE AVAILABLE CAPCITANCE VALUES"
8390 PRINT"DO NOT PERMIT A Q OF 10, THE PROGRAM AUTOMATICALLY ADJUSTS THE VALUE OF THE"
8400 PRINT"OUTPUT CAPACITOR UNTIL THE INPUT AND OUTPUT CAPACITORS ARE WITHIN THE RANGE"
8410 PRINT"OF THE TUNER. THE RESULTING VALUE OF Q IS THEN PRESENTED. IF THE LOAD IS OUT OF"
8420 PRINT"THE RANGE OF THE TUNER, AN OUT OF RANGE MESSAGE WILL BE SHOWN. IN THE NETWORK"
8430 PRINT"DESIGN MODE THERE ARE NO LIMITATIONS. THE PROGRAM WILL CALCULATE COMPONENT"
8440 PRINT"VALUES BASED ON THE SELECTION OF EITHER Q OR A VALUE FOR THE OUTPUT CAPACITOR."
8450 PRINT"(THE OUTPUT CAPACITOR WILL FIX THE Q).
8460 PRINT:PRINT"PRESS ANY KEY TO CONTINUE.  PRESS 1 FOR FIRST SCREEN."
8470 A$=INKEY$:IF A$="" THEN 8470
8471 IF A$="1" THEN 8100
8480 CLS:PRINT"WHEN CALCULATING LOSS IN THE NETWORK, THE PROGRAM ASSUMES THAT ALL LOSS IS IN"
8490 PRINT"THE PARALLEL INDUCTOR. BASED ON THE SUPPLIED Q FOR THE INDUCTOR, THE VALUE OF "
8500 PRINT"THE EQUIVALENT RESISTANCE IN PARALLEL WITH THE INDUCTOR IS FIRST CALCULATED."
8510 PRINT"NEXT THE SERIES CIRCUIT CONSISTING OF THE OUTPUT CAPACITOR, LOAD REACTANCE, AND"
8520 PRINT"LOAD RESISTANCE IS TRANSFORMED TO ITS PARALLEL EQUIVALENT. THUS THE RESISTANCE"
8530 PRINT"OF THE INDUCTOR AND THE EQUIVALENT LOAD RESISTANCE ARE NOW IN PARALLEL AND THE"
8540 PRINT"RATIO OF POWER ABSORBED BY EACH RESISTANCE CAN BE CALCULATED. THE LOSS IS EX-"
8550 PRINT"PRESSED IN DB."
8560 PRINT:PRINT"DISCUSSION OF Q"
8570 PRINT"---------------"
8580 PRINT"THE INPUT Q IS DEFINED AS (X IN)/(R IN) AND THE OUTPUT Q AS (X OUT)/( R LOAD)."
8590 PRINT"THE OUTPUT REACTANCE (X OUT) IS DEFINED AS THE REACTANCE OF THE OUTPUT CAPACI-"
8600 PRINT"TOR PLUS THE LOAD REACTANCE (XL). THE LOAD REACTANCE MAY BE EITHER POSITIVE IF"
8610 PRINT"INDUCTIVE OR NEGATIVE IF CAPACITIVE. THE SHAPE OF THE ATTENUATION CURVE FOR THE"
8620 PRINT"NETWORK IS SKEWED. BELOW THE DESIGN FREQUENCY ATTENUATION INCREASES RAPIDLY."
8630 PRINT"ABOVE THE DESIGN FREQUENCY THE ATTENUATION INCREASES MORE SLOWLY AND MAY NOT"
8640 PRINT"REACH -3 DB AT LOW VALUES OF Q. NEITHER THE INPUT Q OR OUTPUT Q WILL DESCRIBE"
8650 PRINT"THE BANDWIDTH AROUND THE DESIGN FREQUENCY. HOWEVER, THE ARITHMETIC AVERAGE OF"
8660 PRINT"THE TWO IS A GOOD APPROXIMATION OF THE BANDWIDTH. THEREFORE, FOR DESIGN PUR-"
8670 PRINT"POSES, THIS PROGRAM USES AVERAGE Q."
8680 PRINT:PRINT"PRESS ANY KEY TO CONTINUE.  PRESS 1 FOR FIRST SCREEN."
8690 A$=INKEY$:IF A$="" THEN 8690
8691 IF A$="1" THEN 8100
8700 CLS:PRINT"CALCULATION OF ATTENUATION"
8710 PRINT"--------------------------"
8720 PRINT"THE VALUES USED IN THE ATTENUATION PLOTS IN THE PROGRAM WERE CALCULATED FROM"
8730 PRINT"THE EQUATION ON PAGE 2-38 OF 'THE 1990 ARRL HANDBOOK'. THE PLOTS DO NOT INCLUDE"
8740 PRINT"RESISTIVE LOSSES IN THE INDUCTOR."
8750 PRINT:PRINT"LIMITATIONS OF A TUNER"
8760 PRINT"----------------------"
8765 PRINT"THE MAIN LITATIONS OF COMMERCIAL TUNERS ARE THE INPUT AND OUTPUT CAPACITORS. IN"
8770 PRINT"THE AUTHORS MFJ TUNER THE CAPACITANCE RANGE OF EACH CAPACITOR IS ABOUT 21 PF TO"
8775 PRINT"ABOUT 240 PF. THUS THE LIMITATIONS IMPOSED IN THE PROGRAM ARE 230 PF MAXIMUM"
8780 PRINT"CAPACITANCE AND 30 PF MINIMUM CAPACITANCE. THE MAXIMUM INDUCTANCE IN THE MFJ IS"
8785 PRINT"ABOUT 39 uH. THIS VALUE APPEARS TO BE AMPLE; THUS NO PROGRAM LIMITATIONS WERE"
8790 PRINT"INCLUDED. HOWEVER, ONE SHOULD NOTE THE OUTPUT OF THE PROGRAM TO INSURE THAT THE"
8795 PRINT"MAXIMUM INDUCTANCE IS NOT EXCEEDED FOR THE LOAD IMPEDANCE IN QUESTION. THE "
8800 PRINT"EFFECT OF LIMITED CAPACITANCE AND INDUCTANCE IS TO LIMIT THE CHOICE OF Q. AT"
8805 PRINT"LOWER FREQUENCES THE Q MAY BE TOO HIGH (>15> IF THE LOAD RESISTANCE IS LESS"
8810 PRINT"THAN ABOUT 20 OHMS. THE TUNING WILL BE VERY SHARP AND THE LOSS MAY EXCEED 1 DB."
8815 PRINT"AT THE HIGHER FREQUENCIES THE Q MAY BE QUITE LOW AND THE MAXIMUM LOAD RESIS-"
8820 PRINT"TANCE MAY BE LIMITED TO A FEW HUNDRED OHMS."
8900 PRINT:PRINT"PRESS ANY KEY FOR THE MENU.  PRESS 1 FOR SCREEN 1"
8910 A$=INKEY$:IF A$="" THEN 8910
8915 IF A$="1" THEN 8100
8920 GOTO 200
9000 CLS:SYSTEM

