;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/typeof.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 18 11:19:01 1995                          */
;*    Last change :  Fri Dec  8 10:52:46 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements a function which returns the type         */
;*    of an `Ast'.                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_typeof
   (include "Ast/node.sch"
	    "Type/type.sch"
	    "Tvector/tvector.sch")
   (import  type_cache
	    type_env)
   (export  (get-switch-type <ast>)
	    (typeof          <ast>)))

;*---------------------------------------------------------------------*/
;*    get-switch-type ...                                              */
;*---------------------------------------------------------------------*/
(define (get-switch-type ast)
   [assert check (ast) (switch? ast)]
   (let ((clauses (switch-clauses ast)))
      (if (eq? (car (car clauses)) 'else)
	  *obj*
	  (let* ((test (car (car clauses)))
		 (val  (if (pair? test)
			   (car test)
			   test)))
	     (cond
		((integer? val)
		 *int*)
		((char? val)
		 *char*)
		(else
		 *obj*))))))
 
;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define (typeof ast)
   (cond
      ((variable? ast)
       (let ((type (variable-type ast)))
	  (cond
	     ((type? type)
	      type)
	     (else
	      *obj*))))
      ((type? (ast-type ast))
       ;; we have already computed the type of this expression
       (ast-type ast))
      (else
       (let ((type (get-typeof! ast)))
	  (if (and (type? type)
		   (not (eq? type *obj*)))
	      (ast-type-set! ast type))
	  type))))

;*---------------------------------------------------------------------*/
;*    get-typeof! ...                                                  */
;*---------------------------------------------------------------------*/
(define (get-typeof! ast)
   (if (type? (ast-type ast))
       (ast-type ast)
       (ast-case ast
	  ((atom)
	   (let ((atom (atom-value ast)))
	      (cond
		 ((null? atom)
		  *bnil*)
		 ((integer? atom)
		  *long*)
		 ((real? atom)
		  *real*)
		 ((boolean? atom)
		  *bool*)
		 ((char? atom)
		  *char*)
		 ((string? atom)
		  *string*)
		 ((eq? atom #unspecified)
		  *unspec*)
		 (else
		  *obj*))))
	  ((sequence)
	   (get-typeof! (car (last-pair (sequence-exp ast)))))
	  ((fun)
	   *procedure*)
	  ((kwote)
	   (let ((value (kwote-value ast)))
	      (cond
		 ((symbol? value)
		  *symbol*)
		 ((pair? value)
		  ;; we can't soundly say that an expression like
		  ;; '(1 2 ...) is a pair, it is a list and since
		  ;; this type does not exists, we say it is an obj
		  *obj*)
		 ((vector? value)
		  *vector*)
		 ((a-tvector? value)
		  (a-tvector-type value))
		 (else
		  *obj*))))
	  ((var)
	   (let ((var (var-variable ast)))
	      (if (type? (variable-type var))
		  (variable-type var)
		  *obj*)))
	  ((app)
	   (let* ((ast-fun (app-fun ast))
		  (var     (var-variable ast-fun))
		  (fun     (variable-value var)))
	      (let ((type (if (function? fun)
			      (function-type-res fun)
			      (ffunction-type-res fun))))
		 (if (type? type)
		     type
		     *obj*))))
	  ((funcall)
	   *obj*)
	  ((let-var)
	   (typeof (let-var-body ast)))
	  ((let-fun)
	   (typeof (let-fun-body ast)))
	  ((make-box)
	   *obj*)
	  ((box-ref)
	   *obj*)
	  ((box-set!)
	   *unspec*)
	  ((fail)
	   *magic*)
	  ((prag-ma)
	   ;; this is completely useless because when building the ast
	   ;; type are allocated for pragma. This clause is just to
	   ;; give an information on the default behaviour of pragma forms.
	   *unspec*)
	  (else
	   *obj*))))

