;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/app.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar  3 13:14:01 1995                          */
;*    Last change :  Fri Oct 27 14:39:31 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The cfa application process.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_app
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  cfa_ast
	    cfa_approx
	    cfa_cfa
	    cfa_special
	    cfa_top
	    cfa_vector
	    tools_args
	    tools_shape
	    tools_set
	    ast_pragma
	    ast_dump)
   (export  (cfa-app!        <ast> <ast> <approx>*)
	    (cfa-fun-app!    <variable>)
	    (app-type-error  <ast> <ast>)
	    (app-arity-error <ast> <ast>)))

;*---------------------------------------------------------------------*/
;*    cfa-app! ...                                                     */
;*---------------------------------------------------------------------*/
(define (cfa-app! call-ast var actuals-approx)
   [assert check (call-ast) (or (app? call-ast) (funcall? call-ast))]
   [assert check (var) (variable? var)]
   (trace (cfa loop)
	  "****> cfa-app        : " (shape var) #\Newline
	  "             call-ast: " (ast->sexp call-ast)
	  #\Newline)
   (let ((A (cond
	       ((is-special-call? call-ast)
		(cfa-special-app! call-ast var actuals-approx))
	       ((local? var)
		(if (>=fx (function-arity (local-value var)) 0)
		    (cfa-fx-app! call-ast var actuals-approx)
		    (cfa-va-app! call-ast var actuals-approx)))
	       ((eq? (global-import var) 'foreign)
		(cfa-foreign-app! call-ast var actuals-approx))
	       ((eq? (global-import var) 'import)
		(cfa-imported-app! call-ast var actuals-approx))
	       (else
		(if (>=fx (function-arity (global-value var)) 0)
		    (cfa-fx-app! call-ast var actuals-approx)
		    (cfa-va-app! call-ast var actuals-approx))))))
      [assert check (A) (approx? A)]
      (let ((call-A (get-approx call-ast)))
	 [assert check (A) (approx? A)]
	 [assert check (call-A) (approx? call-A)]
	 (union-approx! call-A A)
	 (trace (cfa loop) "<**** cfa-app (" (shape var) ")    : "
		(approx-shape call-A) #\Newline)
	 call-A)))

;*---------------------------------------------------------------------*/
;*    cfa-special-app! ...                                             */
;*---------------------------------------------------------------------*/
(define (cfa-special-app! call-ast var A-actuals)
   (let ((fun (var-variable (app-fun call-ast))))
      (cond
	 ((function? (global-value fun))
	  ((ispecial-app (function-cfa-info (global-value fun))) call-ast
							     var
							     A-actuals))
	 ((ffunction? (global-value fun))
	  ((ispecial-app (ffunction-cfa-info (global-value fun))) call-ast
							      var
							      A-actuals)))))

;*---------------------------------------------------------------------*/
;*    cfa-fx-app! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Arity error can occur only when we invoke this function          */
;*    from a funcall. In this case, we just have to return             */
;*    an empty approximation because in execution we can't reach       */
;*    this call.                                                       */
;*---------------------------------------------------------------------*/
(define (cfa-fx-app! call-ast var actuals-approx)
   (trace (cfa loop) "+-+->   cfa-fx-app! : " (shape var) #\Newline)
   (let ((fun (variable-value var)))
      (if (sound-arity? (function-arity fun) actuals-approx)
	  (begin
	     (for-each
	      (lambda (formal actual)
		 (trace (cfa loop)
			"     " (shape formal) #\: #\newline
			"        old: " (approx-shape (get-approx formal))
			#\Newline
			"        add: " (approx-shape actual) #\Newline)
		 (union-approx! (get-approx formal) actual)
		 (if (approx-type-locked? (get-approx formal))
		     (lock-vectors! actual)))
	      (function-args fun)
	      actuals-approx)
	     (let ((A (cfa-fun-app! var)))
		(trace (cfa loop) "<-+-+ cfa-fx-app (" (shape var) ")    : "
		       (approx-shape A) #\Newline)
		A))
	  (let ((A (app-arity-error call-ast var)))
	     (trace (cfa loop) "<-+-+ cfa-fx-app (" (shape var) ")    : "
		    (approx-shape A) #\Newline)
	     A))))

;*---------------------------------------------------------------------*/
;*    cfa-va-app! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Same remark as for `cfa-fx-app'                                  */
;*---------------------------------------------------------------------*/
(define (cfa-va-app! call-ast var actuals-approx)
   (trace (cfa loop) "+-+->   cfa-va-app! : " (shape var) #\Newline)
   (let ((fun (variable-value var)))
      (if (sound-arity? (function-arity fun) actuals-approx)
	  (begin
	     (let loop ((formals (function-args fun))
			(actuals actuals-approx))
		(cond
		   ((and (null? formals)
			 (null? actuals))
		    #unspecified)
		   ((null? actuals)
		    (loop formals (create-approx (list *nil*) '())))
		   (else
		    (let ((formal (car formals))
			  (actual (car actuals)))
		       (trace (cfa loop)
			      "     " (shape formal) #\: #\newline
			      "        old: "
			      (approx-shape (get-approx formal))
			      #\Newline
			      "        add: "
			      (approx-shape actual) #\Newline)
		       (if (approx-type-locked? (get-approx formal))
			   (lock-vectors! actual))      
		       (union-approx! (get-approx formal) actual)))))
	     (let ((A (cfa-fun-app! var)))
		(trace (cfa loop) "<-+-+ cfa-va-app (" (shape var) ")    : "
		       (approx-shape A) #\Newline)
		A))
	  (let ((A (app-arity-error call-ast var)))
	     (trace (cfa loop) "<-+-+ cfa-va-xapp (" (shape var) ")    : "
		    (approx-shape A) #\Newline)
	     A))))

;*---------------------------------------------------------------------*/
;*    cfa-foreign-app! ...                                             */
;*---------------------------------------------------------------------*/
(define (cfa-foreign-app! call-ast var actuals-approx)
   [assert check (var) (global? var)]
   (trace (cfa loop)
	  "~~~~> cfa-foreign-app: " (shape var) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((args (ffunction-type-args (global-value var))))
      (if (not (sound-arity? (ffunction-arity (global-value var))
			     actuals-approx))
	  (app-arity-error call-ast var)
	  (if (not (ast-pragma var '_no_cfa_top_))
	      (for-each (lambda (A-actual) (spread-top! A-actual))
			actuals-approx)))
      (let ((A (get-approx var)))
	 (trace (cfa loop) "<~~~~                : " (approx-shape A)
		#\Newline)
	 A)))

;*---------------------------------------------------------------------*/
;*    cfa-imported-app! ...                                            */
;*---------------------------------------------------------------------*/
(define (cfa-imported-app! call-ast var actuals-approx)
   [assert check (var) (global? var)]
   (trace (cfa loop)
	  "----> cfa-imported-app: " (shape var) " "
	  (map approx-shape actuals-approx)
	  #\Newline)
   (let ((args (function-args (global-value var))))
      (if (not (sound-arity? (function-arity (global-value var))
			     actuals-approx))
	  (app-arity-error call-ast var)
	  (begin
	     (for-each (lambda (A-actual) (spread-top! A-actual))
		       actuals-approx)
	     (let ((A (get-approx var)))
		(trace (cfa loop) "<~~~~                : " (approx-shape A)
		       #\Newline)
		A)))))

;*---------------------------------------------------------------------*/
;*    cfa-fun-app! ...                                                 */
;*    -------------------------------------------------------------    */
;*    When this function is called the arity check has already         */
;*    been performed. So we are sure to have compatible approximations */
;*    and formals. Furthermore, the approximations have already been   */
;*    added to the formals. We just have to go down the body.          */
;*---------------------------------------------------------------------*/
(define (cfa-fun-app! var)
   [assert check (var) (variable? var)]
   ;; we check if we have already scanned this function
   ;; during the current iteration.
   (trace (cfa loop) "====>   cfa-fun-app! : " (shape var) #\Newline)
   (if (eq? (ifun-stamp (variable-cfa-info var)) *cfa-stamp*)
       (begin
	  (trace (cfa loop) "<==== (" (shape var) ") : already ["
		 *cfa-stamp* #\]
		 " " (shape var)
		 #\Newline)
	  ;; we have already call this function during the current iteration
	  (let ((approx (get-approx var)))
	     (if (not (approx? approx))
		 (internal-error "cfa-fun-app!"
				 "No approximation for"
				 (shape var))
		 approx)))
       ;; ok, we have to walk into the body of this function
       (let ((ifun (variable-cfa-info var)))
	  (ifun-alive?-set! ifun #t)
	  ;; we mark the function to avoid multiples walk
	  ;; during one iteration
	  (ifun-stamp-set! ifun *cfa-stamp*)
	  (enter-function (shape var))
	  (let* ((A      (get-approx var))
		 (approx (cfa-ast! (function-body (variable-value var)))))
	     (union-approx! A approx)
	     (leave-function)
	     (trace (cfa loop) "<====  (" (shape var) ") : " (shape var) " "
		    (approx-shape approx)
		    #\Newline #a012 #\Newline)
	     A))))

;*---------------------------------------------------------------------*/
;*    app-type-error ...                                               */
;*    -------------------------------------------------------------    */
;*    Type error on funcall are bufferized and printed when all        */
;*    the cfa iteration is finished. At the moment, we just have       */
;*    to scan the funcall-list and check the type which are            */
;*    approximate.                                                     */
;*---------------------------------------------------------------------*/
(define (app-type-error call-ast fun-approx)
   (trace cfa "*** app-type-error: " (ast->sexp call-ast) #\Newline)
   (create-empty-approx))

;*---------------------------------------------------------------------*/
;*    app-arity-error ...                                              */
;*    -------------------------------------------------------------    */
;*    Same thing as `app-type-error', arity warning are delayed        */
;*    and printed when all the cfa is done.                            */
;*---------------------------------------------------------------------*/
(define (app-arity-error call-ast var)
   (trace cfa "*** app-arity-error: " (ast->sexp call-ast) "[var: "
	  (shape var) "]"#\Newline)
   (let ((ifun (variable-cfa-info var)))
      (if (ifun? ifun)
	  (ifun-alive?-set! ifun #t)))
   (create-empty-approx))

