;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/procedure.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 16:45:45 1995                          */
;*    Last change :  Fri Feb  9 10:09:30 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The procedure managment                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_procedure
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Cfa/stack.sch")
   (import  cfa_ast
	    cfa_approx
	    cfa_cfa
	    cfa_collect
	    cfa_cache
	    cfa_special
	    cfa_top
	    cfa_app
	    cfa_closure
	    cfa_stack
	    type_cache
	    tools_shape
	    tools_set
	    ast_typeof
	    ast_dump)
   (export  (start-cfa-procedure!)
	    (stop-cfa-procedure!)
	    (is-closure-alloc? <ast>)))

;*---------------------------------------------------------------------*/
;*    start-cfa-procedure! ...                                         */
;*---------------------------------------------------------------------*/
(define (start-cfa-procedure!)
   (ffunction-cfa-info-set! (global-value *make-fx-procedure*)
			    (ispecial make-make-procedure-init-approx
				      #t
				      spread-proc-top!
				      spread-proc-unstackable!
				      make-procedure-app!))
   (ffunction-cfa-info-set! (global-value *make-va-procedure*)
			    (ispecial make-make-procedure-init-approx
				      #t
				      spread-proc-top!
				      spread-proc-unstackable!
				      make-procedure-app!))
   (ffunction-cfa-info-set! (global-value *procedure-ref*)
			    (ispecial std-init
				      #f
				      #unspecified
				      #unspecified
				      proc-ref))
   (ffunction-cfa-info-set! (global-value *procedure-set!*)
			    (ispecial std-init
				      #f
				      #unspecified
				      #unspecified
				      proc-set!))
   #t)

;*---------------------------------------------------------------------*/
;*    stop-cfa-procedure! ...                                          */
;*---------------------------------------------------------------------*/
(define (stop-cfa-procedure!)
   (ffunction-cfa-info-set! (global-value *make-fx-procedure*) #unspecified)
   (ffunction-cfa-info-set! (global-value *make-va-procedure*) #unspecified)
   (ffunction-cfa-info-set! (global-value *procedure-ref*) #unspecified)
   (ffunction-cfa-info-set! (global-value *procedure-set!*) #unspecified)
   #t)

;*---------------------------------------------------------------------*/
;*    make-make-procedure-init-approx ...                              */
;*    -------------------------------------------------------------    */
;*    For procedure, we allocate an approximation vector for the       */
;*    environment.                                                     */
;*---------------------------------------------------------------------*/
(define (make-make-procedure-init-approx ast)
   (let ((num (let ((size (caddr (app-actuals ast))))
		 (ast-case size
		    ((atom)
		     (atom-value size))
		    (else
		     #unspecified)))))
      (if (integer? num)
	  ;; ok, we are able to compute good approximations for
	  ;; this closure
 	  (let ((env-approx (make-vector num)))
	     (let loop ((i (-fx num 1)))
		(if (=fx i -1)
		    (set-special-approx! ast env-approx)
		    (begin
		       (vector-set! env-approx i (create-approx (list *obj*)
								'()))
		       (loop (-fx i 1))))))
	  (set-special-approx! ast #f)))
   (let ((approx (create-approx (list (typeof ast)) (list ast))))
      (set-approx! ast approx)
      (type-lock-approx! approx)
      (top-lock-approx! approx)
      approx))
 
;*---------------------------------------------------------------------*/
;*    std-init ...                                                     */
;*---------------------------------------------------------------------*/
(define (std-init ast)
   (add-closure-access! ast)
   (create-approx (list (typeof ast)) '()))

;*---------------------------------------------------------------------*/
;*    make-procedure-app! ...                                          */
;*    -------------------------------------------------------------    */
;*    Allocator's approximation are just their call. This function     */
;*    is very simple (as for cons-app, make-vector-app, ...).          */
;*---------------------------------------------------------------------*/
(define (make-procedure-app! call-ast fun actuals-approx)
   [assert check (fun) (global? fun)]
   (trace (cfa loop)
	  "~ ~ >   make-proc-app: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   ;; all functional values are alive (otherwise the dead-code
   ;; elimination is very tricky).
   ;; we don't add any approximations to actuals,
   ;; we just return the approximation
   (let ((A (get-approx call-ast)))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A) #\Newline)
      A))

;*---------------------------------------------------------------------*/
;*    spread-proc-top! ...                                             */
;*---------------------------------------------------------------------*/
(define (spread-proc-top! app)
   (let ((approx (get-approx app)))
      (approx-exported?-set! approx #t)
      (trace (cfa loop) "!!! spread-proc-top!: " (ast->sexp app)
	     #\Newline
	     "              approx: " (approx-shape approx) #\Newline)
      (let ((clo (closure->function app)))
	 (if (not (eq? (global-import clo) 'import))
	     (begin
		;; we spread top for all the argument (excepted the first
		;; argument which is the environment). 
		(for-each (lambda (l)
			     (add-obj! (get-approx l))
			     (add-top! (get-approx l)))
			  (cdr (function-args (variable-value clo))))
		(spread-top! (cfa-fun-app! clo)))))))

;*---------------------------------------------------------------------*/
;*    spread-proc-unstackable! ...                                     */
;*---------------------------------------------------------------------*/
(define (spread-proc-unstackable! app min max mark age)
   (let* ((sinfo  (app-stack-info app))
	  (smark  (sinfo-mark sinfo))
	  (approx (get-approx app)))
      (trace (stack loop) "!!! spread-proc-unstackable!: "
	     (ast->sexp app)
	     #\Newline
	     "              approx: " (approx-shape approx) #\Newline)
      (let ((clo (closure->function app)))
	 (if (not (eq? (global-import clo) 'import))
	     (let ((astamp (sinfo-stamp sinfo))
		   (p-approx (get-special-approx app)))
		(if (case age
		       ((all)
			#t)
		       ((between)
			(and (>fx astamp min) (<=fx astamp max)))
		       (else
			(not (=fx astamp min))))
		    (mark-unstackable! app))
		(if (vector? p-approx)
		    (let liip ((l (-fx (vector-length p-approx) 1)))
		       (if (=fx l -1)
			   #unspecified
			   (let ((approx (vector-ref p-approx l)))
			      (for-each-set
			       (lambda (a)
				  (spread-unstackable/mark! a
							    min
							    max
							    mark
							    age))
			       (approx-alloc approx))
			      (liip (-fx l 1)))))))))))

;*---------------------------------------------------------------------*/
;*    is-closure-alloc? ...                                            */
;*---------------------------------------------------------------------*/
(define (is-closure-alloc? ast)
   [assert check (ast) (app? ast)]
   (let ((fun (var-variable (app-fun ast))))
      (or (eq? fun *make-fx-procedure*)
	  (eq? fun *make-s-fx-procedure*)
	  (eq? fun *make-va-procedure*)
	  (eq? fun *make-s-va-procedure*))))

;*---------------------------------------------------------------------*/
;*    proc-ref ...                                                     */
;*    -------------------------------------------------------------    */
;*    There is no need to add obj during `procedure-ref' invokation    */
;*    because this function has the type `procedure -> obj'.           */
;*---------------------------------------------------------------------*/
(define (proc-ref call-ast fun actuals-approx)
   [assert check (fun) (eq? fun *procedure-ref*)]
   (trace (cfa loop)
	  "~ ~ >   procedure-ref: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((A        (get-approx call-ast))
	 (p-approx (car actuals-approx))
	 (num      (cadr (app-actuals call-ast))))
      (if (integer? num)
	  (begin
	     (if (approx-top? p-approx)
		 (add-top! A))
	     (for-each-set
	      (lambda (alloc)
		 (cond
		    ((not (is-closure-alloc? alloc))
		     #unspecified)
		    ((not (vector? (get-special-approx alloc)))
		     (add-top! A))
		    ((<fx (vector-length (get-special-approx alloc)) num)
		     (internal-error "procedure-ref"
				     "index out of range"
				     num))
		    (else
		     (union-approx! A
				    (vector-ref (get-special-approx alloc)
						num)))))
	      (approx-alloc p-approx)))
	  (add-top! A))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A)
	     #\Newline)
      A))
    
;*---------------------------------------------------------------------*/
;*    proc-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (proc-set! call-ast fun actuals-approx)
   [assert check (fun) (eq? fun *procedure-set!*)]
   (trace (cfa loop)
	  "~ ~ >  procedure-set!: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((p-approx   (car actuals-approx))
	 (num        (cadr (app-actuals call-ast)))
	 (val-approx (caddr actuals-approx)))
      ;; all variable in procedure have to be of type obj, 
      ;; we add it now.
      (add-obj! val-approx)
      (if (integer? num)
	  (begin
	     (if (approx-top? p-approx)
		 (spread-top! val-approx))
	     (for-each-set
	      (lambda (alloc)
		 (cond
		    ((not (is-closure-alloc? alloc))
		     #unspecified)
		    ((not (vector? (get-special-approx alloc)))
		     (spread-top! val-approx))
		    ((<fx (vector-length (get-special-approx alloc)) num)
		     (internal-error "procedure-set!"
				     "int out of range"
				     num))
		    (else
		     (let ((vec (get-special-approx alloc)))
			(union-approx! (vector-ref vec num) val-approx)))))
	      (approx-alloc p-approx)))
	  (spread-top! val-approx))
      (let ((A (get-approx call-ast)))
	 (trace (cfa loop) "< ~ ~                : " (approx-shape A)
		#\Newline)
	 A)))
			  
       
