;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Integrate/kaptured.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 11:03:12 1995                          */
;*    Last change :  Fri May 12 15:48:24 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute the list of the kaptured variables for each           */
;*    globalized function. The used method is very close to            */
;*    the one of the Globalization pass.                               */
;*=====================================================================*/
   
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_kaptured
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    integrate_free
	    integrate_cto
	    ast_local)
   (export  (set-kaptured! <local>*)))

;*---------------------------------------------------------------------*/
;*    set-kaptured! ...                                                */
;*---------------------------------------------------------------------*/
(define (set-kaptured! local*)
   (for-each (lambda (local)
		(set-one-kaptured! local local))
	     local*))

;*---------------------------------------------------------------------*/
;*    set-one-kaptured! ...                                            */
;*    -------------------------------------------------------------    */
;*    This function computes the set of kaptured variables and         */
;*    the future globalized body.                                      */
;*    -------------------------------------------------------------    */
;*    Take care: `get-free-vars' also compute the list `cto'. There    */
;*    is `a priori' no reason for this but the reason we do it now     */
;*    is that we compute a restricted subset of the real `cto', we     */
;*    are just interested in computed cto of local globalized          */
;*    functions.                                                       */
;*---------------------------------------------------------------------*/
(define (set-one-kaptured! local locking)
   (trace (integrate loop) "set-one-kaptured: " (shape local) " [locking:"
	  (shape locking) #\]
	  #\Newline)
   (let* ((info     (local-info local))
	  (kaptured (ifun-kaptured info)))
      (cond
	 ((or (pair? kaptured) (null? kaptured))
	  (trace (integrate loop) "--> (or pair? null?) [" (shape local)
		 "] " (shape kaptured) #\Newline)
	  (vector #t locking kaptured))
	 ((local? kaptured)
	  (trace (integrate loop) "--> local? [" (shape local)
		 "] " (shape kaptured) #\Newline)
	  (vector #f locking '()))
	 (else
	  (let ((body (function-body (local-value local))))
	     (set-cto! body local)
	     (trace (integrate loop) "--> cto [" (shape local) "] "
		    (shape (ifun-cto info)) #\Newline)
	     ;; before entering the recursion we mark this function
	     ;; with it self.
	     (ifun-kaptured-set! info local)
	     ;; we walk across the call-graph
	     (let loop ((kaptured '())
			(cto      (ifun-cto info))
			(setter?  #t))
		(trace (integrate loop init)
		       "   [" (shape local)"].cto     : " (shape cto)
		       #\Newline
		       "   [" (shape local)"].kaptured: " (shape kaptured)
		       #\Newline)
		(cond
		   ((null? cto)
		    (let* ((free      (get-free-vars body local))
			   (fkaptured (free-from kaptured local))
			   (rkaptured (union (cons free fkaptured))))
		       (trace integrate
			      "    kaptured(" (local-shape local) ") : "
			      (shape kaptured) #\Newline)
		       (trace integrate
			      "   fkaptured(" (local-shape local) ") : "
			      (shape fkaptured) #\Newline)
		       (trace integrate
			      "   rkaptured(" (local-shape local) ") : "
			      (shape rkaptured) #\Newline)
		       (trace (loop integrate)
			      "       free(" (local-shape local) ") : "
			      (shape free) #\Newline)
		       (if setter?
			   (begin
			      ;; we store kaptured variables
			      (ifun-kaptured-set! info rkaptured)
			      ;; we mark kaptured variables
			      (for-each (lambda (local)
					   (ivar-kaptured?-set!
					    (local-info local)
					    #t))
					rkaptured))
			   ;; we restore the uncomputed value (see tools.scm)
			   (ifun-kaptured-set! info #unspecified))
		       (vector setter? locking rkaptured)))
		   ((eq? (car cto) local)
		    (loop kaptured
			  (cdr cto)
			  setter?))
		   ((ifun-G? (local-info (car cto)))
		    (let ((other-kaptured (set-one-kaptured! (car cto)
							     locking)))
		       (if (not (vector-ref other-kaptured 0))
			   (loop (cons (vector-ref other-kaptured 2) kaptured)
				 (cdr cto)
				 (and setter?
				      (eq? (vector-ref other-kaptured 1)
					   local)))
			   (loop (cons (vector-ref other-kaptured 2) kaptured)
				 (cdr cto)
				 setter?))))
		   (else
		    (loop kaptured
			  (cdr cto)
			  setter?)))))))))

;*---------------------------------------------------------------------*/
;*    *union-round* ...                                                */
;*---------------------------------------------------------------------*/
(define *union-round* 0)

;*---------------------------------------------------------------------*/
;*    union ...                                                        */
;*---------------------------------------------------------------------*/
(define (union sets)
   (set! *union-round* (+fx 1 *union-round*))
   (let loop ((sets  sets)
	      (union '()))
      (if (null? sets)
	  union
	  (let liip ((set   (car sets))
		     (union union))
	     (cond
		((null? set)
		 (loop (cdr sets) union))
		((eq? (ivar-u-mark (local-info (car set))) *union-round*)
		 (liip (cdr set) union))
		(else
		 (ivar-u-mark-set! (local-info (car set)) *union-round*)
		 (liip (cdr set) (cons (car set) union))))))))
		 

