;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Integrate/let-fun.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 09:38:46 1995                          */
;*    Last change :  Wed Oct 11 11:39:20 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements a function which remove displaced         */
;*    local functions and which adds the integrated ones.              */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_let-fun
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    ast_dump)
   (export  (displace-let-fun! <variable>)))

;*---------------------------------------------------------------------*/
;*    *stamp* ...                                                      */
;*---------------------------------------------------------------------*/
(define *stamp* 0)

;*---------------------------------------------------------------------*/
;*    bind-fun! ...                                                    */
;*---------------------------------------------------------------------*/
(define (bind-fun! var)
   (if (local? var)
       (ifun-istamp-set! (local-info var) *stamp*)))

;*---------------------------------------------------------------------*/
;*    free-fun? ...                                                    */
;*---------------------------------------------------------------------*/
(define (free-fun? local)
   (not (eq? (ifun-istamp (local-info local)) *stamp*)))

;*---------------------------------------------------------------------*/
;*    displace-let-fun! ...                                            */
;*---------------------------------------------------------------------*/
(define (displace-let-fun! var)
   (trace (integrate loop)
	  "   displace-let-fun!: " (shape var) #\Newline
	  "                 Led: " (shape (ifun-Led (variable-info var)))
	  #\Newline)
   (set! *stamp* (+fx 1 *stamp*))
   (displace-let-fun-ast! var (function-body (variable-value var)))
   ;; then we scan all local functions in order to remove from addition
   ;; nested functions in added functions as in the following example:
   ;;   (define (foo x)
   ;;      (labels ((f1 (a) (labels ((f2 (b) (f2 b)))
   ;;                          (f2 a))))
   ;;         (labels ((f3 (c) (f3 (f3 (f3 (f1 c))))))
   ;;            (f3 4))))
   (let ((Led (ifun-Led (variable-info var))))
      (for-each (lambda (l)
		   (if (free-fun? l)
		       ;; we _absolutely can't_ mark function as seen
		       ;; otherwise all this computation will be wrong
		       ;; but we can test if the function is nested.
		       ;; If the function is, the predicate `free-fun?'
		       ;; will be false.
		       (displace-let-fun-ast! var
					      (function-body
					       (variable-value l)))))
		Led)
      (let loop ((Led   Led)
		 (added '()))
	 (cond
	    ((null? Led)
	     ;; we set the new body.
	     (if (pair? added)
		 (let* ((old-body (function-body (variable-value var)))
			(new-body (ast-let-fun (ast-location old-body)
					       #f
					       #f
					       added
					       old-body)))
		    (trace (integrate loop)
			   "    j'ajoute les fonctions: " (shape added)
			   #\Newline)
		    (function-body-set! (variable-value var) new-body)
		    new-body)))
	    ((free-fun? (car Led))
	     ;; we have to add this local function.
	     (loop (cdr Led) (cons (car Led) added)))
	    (else
	     ;; this function is already defined in var
	     (loop (cdr Led) added))))))

;*---------------------------------------------------------------------*/
;*    displace-let-fun-ast! ...                                        */
;*    -------------------------------------------------------------    */
;*    This function only modify the list of the `let-fun'              */
;*    constructions. So, we don't need to perform mutation             */
;*    during all the pass. We just realize side-effects when           */
;*    managing a `let-fun' node.                                       */
;*---------------------------------------------------------------------*/
(define (displace-let-fun-ast! host ast)
   (let loop ((ast ast))
      (ast-case ast
	 ((atom)
	  #unspecified)
	 ((kwote)
	  #unspecified)
	 ((var)
	  #unspecified)
	 ((make-box)
	  #unspecified)
	 ((box-ref)
	  #unspecified)
	 ((box-set!)
	  #unspecified)
	 ((prag-ma)
	  (for-each loop (prag-ma-values ast))
	  #unspecified)
	 ((fail)
	  (loop (fail-proc ast))
	  (loop (fail-msg ast))
	  (loop (fail-obj ast)))
	 ((sequence)
	  (for-each loop (sequence-exp ast))
	  #unspecified)
	 ((conditional)
	  (loop (conditional-test ast))
	  (loop (conditional-then ast))
	  (loop (conditional-else ast)))
	 ((switch)
	  (loop (switch-test ast))
	  (for-each (lambda (clause) (loop (cdr clause)))
		    (switch-clauses ast)))
	 ((setq)
	  (loop (setq-val ast)))
	 ((let-var)
	  (let liip ((bindings (let-var-bindings ast)))
	     (if (null? bindings)
		 (loop (let-var-body ast))
		 (let* ((binding (car bindings))
			(var (car binding))
			(val (cdr binding)))
		    (loop val)
		    (liip (cdr bindings))))))
	 ((let-fun)
	  (let liip ((old (let-fun-locals ast))
		     (new '()))
	     (cond
		((null? old)
		 (let-fun-locals-set! ast new)
		 (loop (let-fun-body ast)))
		((eq? (ifun-L (local-info (car old))) host)
		 (let ((l (car old)))
		    (bind-fun! l)
		    (displace-let-fun-ast! host
					   (function-body (local-value l)))
		    (liip (cdr old) (cons l new))))
		(else
		 (liip (cdr old) new)))))
	 ((set-ex-it)
	  (loop (set-ex-it-body ast)))
	 ((jump-ex-it)
	  (loop (jump-ex-it-value ast))
	  (loop (jump-ex-it-exit ast)))
	 ((fun)
	  (internal-error "a-graph"
			  "Illegal node (see Globalize)"
			  (ast->sexp ast)))
	 ((app-ly)
	  (loop (app-ly-fun ast))
	  (loop (app-ly-value ast)))
	 ((funcall)
	  (loop (funcall-fun ast))
	  (let liip ((args (funcall-actuals ast)))
	     (if (null? args)
		 #unspecified
		 (begin
		    (loop (car args))
		    (liip (cdr args))))))
	 ((app)
	  (let liip ((args (app-actuals ast)))
	     (if (null? args)
		 #unspecified
		 (begin
		    (loop (car args))
		    (liip (cdr args)))))))))

