;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/include.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 11:37:11 1994                          */
;*    Last change :  Thu Dec  7 15:50:44 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse include files.                                          */
;*    An include file can contain:                                     */
;*      - top-level forms                                              */
;*      - directives (similar to module clauses)                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_include
   (import read_include)
   (export (parse-include files)))

;*---------------------------------------------------------------------*/
;*    parse-include ...                                                */
;*    name --> import x scheme                                         */
;*---------------------------------------------------------------------*/
(define (parse-include files)
   (let loop ((files   files)
	      (foreign '())
	      (import  '())
	      (body    '())
	      (type    '())
	      (export  '())
	      (use     '())
	      (with    '()))
      (if (null? files)
	  (vector import foreign body type export use with)
	  (let ((ri (read-include (car files))))
	     (loop ;; files (include)
	           (if (null? (cdr files))
		       (vector-ref ri 1)
		       (if (null? (vector-ref ri 1))
			   (cdr files)
			   (append (vector-ref ri 1) (cdr files))))
		   ;; foreign
		   (if (null? foreign)
		       (vector-ref ri 3)
		       (if (null? (vector-ref ri 3))
			   foreign
			   (append foreign (vector-ref ri 3))))
		   ;; import
		   (if (null? import)
		       (vector-ref ri 0)
		       (if (null? (vector-ref ri 0))
			   import
			   (append (vector-ref ri 0) import)))
		   ;; body
		   (append (reverse (vector-ref ri 2)) body)
		   ;; type
		   (if (null? type)
		       (vector-ref ri 4)
		       (if (null? (vector-ref ri 4))
			   type
			   (append (vector-ref ri 4)
				   foreign)))
		   ;; export
		   (if (null? export)
		       (vector-ref ri 5)
		       (if (null? (vector-ref ri 5))
			   export
			   (append (vector-ref ri 5) export)))
		   ;; use
		   (if (null? use)
		       (vector-ref ri 6)
		       (if (null? (vector-ref ri 6))
			   use
			   (append (vector-ref ri 6) use)))
		   ;; with
		   (if (null? with)
		       (vector-ref ri 7)
		       (if (null? (vector-ref ri 7))
			   with
			   (append (vector-ref ri 7) use))))))))


				   
				   
