;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Reduce/redex.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:29:17 1995                          */
;*    Last change :  Wed Oct 11 11:43:00 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The test reduction                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_redex
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    ast_dump
	    ast_env
	    ast_global
	    ast_pragma
	    ast_typeof
	    type_env
	    type_cache
	    effect_effect)
   (export  (reduce-redex! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-redex! ...                                                */
;*---------------------------------------------------------------------*/
(define (reduce-redex! globals)
   (verbose 2 "        beta redexes" #\Newline)
   (mark-reductible-functions!)
   (for-each (lambda (global)
		(let* ((fun (global-value global))
		       (ast (function-body fun))) 
		   (function-body-set! fun (ast-redex! ast))
		   #unspecified))
	     globals)
   (unmark-reductible-functions!))

;*---------------------------------------------------------------------*/
;*    ast-redex! ...                                                   */
;*---------------------------------------------------------------------*/
(define (ast-redex! ast)
   (ast-case ast
      ((atom)
       ast)
      ((kwote)
       ast)
      ((var)
       ast)
      ((make-box)
       (make-box-value-set! ast (ast-redex! (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (ast-redex! (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-value-set! ast (ast-redex! (box-set!-value ast)))
       ast)
      ((prag-ma)
       (let loop ((exp (prag-ma-values ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-redex! (car exp)))
		 (loop (cdr exp))))))
      ((fail)
       (fail-proc-set! ast (ast-redex! (fail-proc ast)))
       (fail-msg-set!  ast (ast-redex! (fail-msg ast)))
       (fail-obj-set!  ast (ast-redex! (fail-obj ast)))
       ast)
      ((sequence)
       (let loop ((exp (sequence-exp ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-redex! (car exp)))
		 (loop (cdr exp))))))
      ((conditional)
       (conditional-test-set! ast (ast-redex! (conditional-test ast)))
       (conditional-then-set! ast (ast-redex! (conditional-then ast)))
       (conditional-else-set! ast (ast-redex! (conditional-else ast)))
       ast)
      ((switch)
       (switch-test-set! ast (ast-redex! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (ast-redex! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((setq)
       (let ((var (var-variable (setq-var ast)))
	     (val (setq-val ast)))
	  (setq-val-set! ast (ast-redex! val)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (ast-redex! (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (ast-redex! (let-var-body ast)))
       ast)
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (ast-redex! (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (ast-redex! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (ast-redex! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (ast-redex! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (ast-redex! (jump-ex-it-value ast)))
       ast)
      ((fun)
       (fun-value-set! ast (ast-redex! (fun-value ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (ast-redex! (app-ly-fun ast)))
       (app-ly-value-set! ast (ast-redex! (app-ly-value ast)))
       ast)
      ((funcall)
       (funcall-fun-set! ast (ast-redex! (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (ast-redex! (car actuals)))
		 (loop (cdr actuals))))))
       ((app)
	(app-fun-set! ast (ast-redex! (app-fun ast)))
	(let loop ((actuals (app-actuals ast)))
	   (if (null? actuals)
	       #unspecified
	       (begin
		  (set-car! actuals (ast-redex! (car actuals)))
		  (loop (cdr actuals)))))
	(if (redex? ast)
	    (let ((res (remove-redex! ast)))
	       res)
	    (begin
	       ast)))))

;*---------------------------------------------------------------------*/
;*    remove-redex! ...                                                */
;*---------------------------------------------------------------------*/
(define (remove-redex! ast)
   (let ((fun  (var-variable (app-fun ast)))
	 (args (app-actuals  ast)))
      (global-occurrence-set! fun (-fx (global-occurrence fun) 1))
      (reduce! ast)))

;*---------------------------------------------------------------------*/
;*    reduction ...                                                    */
;*---------------------------------------------------------------------*/
(define-struct reduction reduce!)

;*---------------------------------------------------------------------*/
;*    unmark-reductible-functions! ...                                 */
;*---------------------------------------------------------------------*/
(define (unmark-reductible-functions!)
   (for-each-global! (lambda (global) (global-info-set! global '())))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    mark-reductible-functions! ...                                   */
;*---------------------------------------------------------------------*/
(define (mark-reductible-functions!)
   (for-each-global!
    (lambda (global)
       (let ((type (ast-pragma global '_type-checker_)))
	  (if type
	      (global-info-set!
	       global
	       (reduction
		(lambda (ast)
		   (let ((t (typeof (car (app-actuals ast)))))
		      (cond
			 ((eq? t *obj*)
			  ast)
			 (else
			  (ast-atom (ast-location ast)
				    (ast-type ast)
				    (ast-info ast)
				    (eq? (find-type (car type)) t))))))))))))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    redex? ...                                                       */
;*---------------------------------------------------------------------*/
(define (redex? ast)
   (let ((fun  (var-variable (app-fun ast)))
	 (args (app-actuals  ast)))
      (if (not (reduction? (variable-info fun)))
	  #f
	  (let loop ((args args))
	     (if (null? args)
		 #t
		 (if (side-effect-free? (car args))
		     (loop (cdr args))
		     #f))))))

;*---------------------------------------------------------------------*/
;*    reduce! ...                                                      */
;*---------------------------------------------------------------------*/
(define (reduce! ast)
   (let ((fun (var-variable (app-fun ast))))
      ((reduction-reduce! (variable-info fun)) ast)))

   


