;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tstruct/cgen.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Oct  4 16:28:10 1995                          */
;*    Last change :  Wed Oct  4 17:08:23 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C type generation (used by the Cgen pass).                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tstruct_cgen
   (include "Type/type.sch"
	    "Tstruct/tstruct.sch"
	    "Tools/trace.sch")
   (export (emit-tstruct-type port))
   (import tstruct_declare
	   type_env))

;*---------------------------------------------------------------------*/
;*    emit-tstruct-type ...                                            */
;*---------------------------------------------------------------------*/
(define (emit-tstruct-type port)
   (fprint port "/* The C generated type (for typed structures) */")
   (for-each (lambda (ts)
		(emit-one-tstruct-type ts port))
	     (get-tstruct-list)))

;*---------------------------------------------------------------------*/
;*    emit-one-tstruct-type ...                                        */
;*---------------------------------------------------------------------*/
(define (emit-one-tstruct-type ts port)
   (let* ((id            (type-id ts))
	  (info          (type-tinfo ts))
	  (ts-name       (tstruct-info-c-type-name info))
	  (slots-type-id (tstruct-info-slots-type-id info))
	  (slots-type    (map find-type slots-type-id))
	  (slots-name    (tstruct-info-slots-name info))
	  (obj           (find-type 'obj))
	  (u-struct      (let loop ((names (reverse slots-name))
				    (types (reverse slots-type))
				    (res   ""))
			    (if (null? names)
				res
				(let* ((name (car names))
				       (type (car types))
				       (new  (string-append (type-name type)
							    " "
							    (symbol->string
							     name)
							    ";")))
				   (loop (cdr names)
					 (cdr types)
					 (string-append new res)))))))
      (fprint port "typedef struct {" u-struct "} " ts-name ";")))
      
