/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Ieee/flonum.scm                                                   */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern double truncatefl___r4_numbers_6_5_flonum( double );
DEFINE_STRING( string1107___r4_numbers_6_5_flonum, aux1447, "sqrt", 4 );
extern double atan_1fl___r4_numbers_6_5_flonum_253( double );
extern obj_t _minfl___r4_numbers_6_5_flonum( obj_t, obj_t, obj_t );
extern double ceilingfl___r4_numbers_6_5_flonum( double );
extern double asinfl___r4_numbers_6_5_flonum( double );
extern obj_t string_to_bstring( char * );
extern obj_t _negfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _logfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _roundfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _atanfl___r4_numbers_6_5_flonum( obj_t, obj_t, obj_t );
extern obj_t __fl___r4_numbers_6_5_flonum_245( obj_t, obj_t, obj_t );
extern bool_t zerofl____r4_numbers_6_5_flonum_180( double );
extern double __fl___r4_numbers_6_5_flonum_145( double, double );
extern char * real_to_string( double );
extern double string__real___r4_numbers_6_5_flonum_238( char * );
static obj_t *__cnst;
extern bool_t ___fl___r4_numbers_6_5_flonum_53( double, double );
extern double absfl___r4_numbers_6_5_flonum( double );
extern obj_t _positivefl____r4_numbers_6_5_flonum_113( obj_t, obj_t );
extern double cosfl___r4_numbers_6_5_flonum( double );
extern obj_t _ceilingfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _floorfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern double logfl___r4_numbers_6_5_flonum( double );
extern obj_t _atan_2fl___r4_numbers_6_5_flonum_129( obj_t, obj_t, obj_t );
extern obj_t __fl___r4_numbers_6_5_flonum_233( obj_t, obj_t, obj_t );
extern double atan_2fl_ur___r4_numbers_6_5_flonum_133( double, double );
extern obj_t _zerofl____r4_numbers_6_5_flonum_36( obj_t, obj_t );
extern obj_t ___fl___r4_numbers_6_5_flonum_72( obj_t, obj_t, obj_t );
extern bool_t __fl___r4_numbers_6_5_flonum_94( double, double );
extern double atanfl___r4_numbers_6_5_flonum( double, obj_t );
static obj_t tvectors_declarations____r4_numbers_6_5_flonum_63();
extern obj_t __fl___r4_numbers_6_5_flonum_194( obj_t, obj_t, obj_t );
extern obj_t _sqrtfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t initialization___r4_numbers_6_5_flonum();
extern obj_t initialization___error();
extern obj_t _flonum____r4_numbers_6_5_flonum_237( obj_t, obj_t );
extern double floorfl___r4_numbers_6_5_flonum( double );
extern bool_t __fl___r4_numbers_6_5_flonum_249( double, double );
extern bool_t __fl___r4_numbers_6_5_flonum_203( double, double );
extern obj_t __fl___r4_numbers_6_5_flonum_14( obj_t, obj_t, obj_t );
extern double __fl___r4_numbers_6_5_flonum_179( double, double );
extern obj_t _atan_1fl___r4_numbers_6_5_flonum_58( obj_t, obj_t );
extern obj_t _real__string___r4_numbers_6_5_flonum_123( obj_t, obj_t );
extern bool_t flonum____r4_numbers_6_5_flonum_50( obj_t );
extern obj_t _cosfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _sqrtfl_ur___r4_numbers_6_5_flonum_135( obj_t, obj_t );
extern bool_t ___fl___r4_numbers_6_5_flonum_155( double, double );
extern bool_t negativefl____r4_numbers_6_5_flonum_177( double );
extern obj_t _absfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t __fl___r4_numbers_6_5_flonum_231( obj_t, obj_t, obj_t );
extern obj_t _truncatefl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern double sinfl___r4_numbers_6_5_flonum( double );
extern char * real__string___r4_numbers_6_5_flonum_69( double );
extern obj_t _atan_2fl_ur___r4_numbers_6_5_flonum_142( obj_t, obj_t, obj_t );
extern double minfl___r4_numbers_6_5_flonum( double, obj_t );
extern obj_t _max_2fl___r4_numbers_6_5_flonum_90( obj_t, obj_t, obj_t );
extern double min_2fl___r4_numbers_6_5_flonum_94( double, double );
extern obj_t _tanfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern obj_t _min_2fl___r4_numbers_6_5_flonum_63( obj_t, obj_t, obj_t );
extern double maxfl___r4_numbers_6_5_flonum( double, obj_t );
extern obj_t _real____r4_numbers_6_5_flonum_125( obj_t, obj_t );
extern obj_t __fl___r4_numbers_6_5_flonum_70( obj_t, obj_t, obj_t );
DEFINE_STRING( string1108___r4_numbers_6_5_flonum, aux1449, "Domain error", 12 );
extern obj_t _negativefl____r4_numbers_6_5_flonum_240( obj_t, obj_t );
extern obj_t _sinfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern double __fl___r4_numbers_6_5_flonum_16( double, double );
extern double max_2fl___r4_numbers_6_5_flonum_248( double, double );
DEFINE_STRING( string1109___r4_numbers_6_5_flonum, aux1450, "atanfl", 6 );
extern double exptfl___r4_numbers_6_5_flonum( double, double );
extern double __fl___r4_numbers_6_5_flonum_139( double, double );
extern double acosfl___r4_numbers_6_5_flonum( double );
extern obj_t _asinfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern double tanfl___r4_numbers_6_5_flonum( double );
static obj_t initialize_constants____r4_numbers_6_5_flonum_246();
extern obj_t _string__real___r4_numbers_6_5_flonum_76( obj_t, obj_t );
extern obj_t make_real( double );
extern double atan_2fl___r4_numbers_6_5_flonum_45( double, double );
extern double roundfl___r4_numbers_6_5_flonum( double );
extern bool_t real____r4_numbers_6_5_flonum_6( obj_t );
static obj_t initialize_imported_modules____r4_numbers_6_5_flonum_79();
extern obj_t _maxfl___r4_numbers_6_5_flonum( obj_t, obj_t, obj_t );
extern obj_t __fl___r4_numbers_6_5_flonum_163( obj_t, obj_t, obj_t );
extern obj_t ___fl___r4_numbers_6_5_flonum_5( obj_t, obj_t, obj_t );
extern obj_t _expfl___r4_numbers_6_5_flonum( obj_t, obj_t );
extern double sqrtfl_ur___r4_numbers_6_5_flonum_31( double );
DEFINE_REAL( real1110___r4_numbers_6_5_flonum, aux1451, 0.00000000000 );
extern double negfl___r4_numbers_6_5_flonum( double );
extern obj_t _exptfl___r4_numbers_6_5_flonum( obj_t, obj_t, obj_t );
static obj_t require_initialization____r4_numbers_6_5_flonum_101 = BUNSPEC;
extern double expfl___r4_numbers_6_5_flonum( double );
extern double sqrtfl___r4_numbers_6_5_flonum( double );
extern bool_t positivefl____r4_numbers_6_5_flonum_194( double );
extern obj_t _acosfl___r4_numbers_6_5_flonum( obj_t, obj_t );

DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_148, aux1452, __fl___r4_numbers_6_5_flonum_163, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( minfl_env___r4_numbers_6_5_flonum_160, aux1453, va_generic_entry, _minfl___r4_numbers_6_5_flonum, -2 );
DEFINE_EXPORT_PROCEDURE( string__real_env___r4_numbers_6_5_flonum_164, aux1456, _string__real___r4_numbers_6_5_flonum_76, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atan_1fl_env___r4_numbers_6_5_flonum_156, aux1457, _atan_1fl___r4_numbers_6_5_flonum_58, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ___fl_env___r4_numbers_6_5_flonum_137, aux1458, ___fl___r4_numbers_6_5_flonum_5, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( real__env___r4_numbers_6_5_flonum_39, aux1459, _real____r4_numbers_6_5_flonum_125, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( min_2fl_env___r4_numbers_6_5_flonum_252, aux1461, _min_2fl___r4_numbers_6_5_flonum_63, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( absfl_env___r4_numbers_6_5_flonum_237, aux1462, _absfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( exptfl_env___r4_numbers_6_5_flonum_185, aux1463, _exptfl___r4_numbers_6_5_flonum, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( cosfl_env___r4_numbers_6_5_flonum_22, aux1464, _cosfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_105, aux1465, __fl___r4_numbers_6_5_flonum_233, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_66, aux1468, __fl___r4_numbers_6_5_flonum_245, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( flonum__env___r4_numbers_6_5_flonum_113, aux1469, _flonum____r4_numbers_6_5_flonum_237, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atan_2fl_env___r4_numbers_6_5_flonum_109, aux1471, _atan_2fl___r4_numbers_6_5_flonum_129, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( tanfl_env___r4_numbers_6_5_flonum_221, aux1472, _tanfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atan_2fl_ur_env___r4_numbers_6_5_flonum_128, aux1473, _atan_2fl_ur___r4_numbers_6_5_flonum_142, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( sqrtfl_env___r4_numbers_6_5_flonum_132, aux1475, _sqrtfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( positivefl__env___r4_numbers_6_5_flonum_224, aux1477, _positivefl____r4_numbers_6_5_flonum_113, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( max_2fl_env___r4_numbers_6_5_flonum_212, aux1479, _max_2fl___r4_numbers_6_5_flonum_90, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( negativefl__env___r4_numbers_6_5_flonum_126, aux1480, _negativefl____r4_numbers_6_5_flonum_240, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( negfl_env___r4_numbers_6_5_flonum_150, aux1481, _negfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( maxfl_env___r4_numbers_6_5_flonum_43, aux1482, va_generic_entry, _maxfl___r4_numbers_6_5_flonum, -2 );
DEFINE_EXPORT_PROCEDURE( zerofl__env___r4_numbers_6_5_flonum_141, aux1483, _zerofl____r4_numbers_6_5_flonum_36, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( logfl_env___r4_numbers_6_5_flonum_58, aux1484, _logfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_152, aux1485, __fl___r4_numbers_6_5_flonum_231, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( acosfl_env___r4_numbers_6_5_flonum_45, aux1486, _acosfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( roundfl_env___r4_numbers_6_5_flonum_136, aux1488, _roundfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( atanfl_env___r4_numbers_6_5_flonum_141, aux1490, va_generic_entry, _atanfl___r4_numbers_6_5_flonum, -2 );
DEFINE_EXPORT_PROCEDURE( asinfl_env___r4_numbers_6_5_flonum_132, aux1491, _asinfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( expfl_env___r4_numbers_6_5_flonum_219, aux1492, _expfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_252, aux1493, __fl___r4_numbers_6_5_flonum_194, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( truncatefl_env___r4_numbers_6_5_flonum_108, aux1495, _truncatefl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( sinfl_env___r4_numbers_6_5_flonum_9, aux1496, _sinfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_191, aux1497, __fl___r4_numbers_6_5_flonum_70, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( ___fl_env___r4_numbers_6_5_flonum_13, aux1499, ___fl___r4_numbers_6_5_flonum_72, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( __fl_env___r4_numbers_6_5_flonum_57, aux1500, __fl___r4_numbers_6_5_flonum_14, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( real__string_env___r4_numbers_6_5_flonum_210, aux1501, _real__string___r4_numbers_6_5_flonum_123, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( sqrtfl_ur_env___r4_numbers_6_5_flonum_197, aux1502, _sqrtfl_ur___r4_numbers_6_5_flonum_135, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( floorfl_env___r4_numbers_6_5_flonum_90, aux1504, _floorfl___r4_numbers_6_5_flonum, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( ceilingfl_env___r4_numbers_6_5_flonum_234, aux1505, _ceilingfl___r4_numbers_6_5_flonum, 0L, 1 );

obj_t initialization___r4_numbers_6_5_flonum()
{if(CBOOL(require_initialization____r4_numbers_6_5_flonum_101)){require_initialization____r4_numbers_6_5_flonum_101 = BFALSE;
initialize_imported_modules____r4_numbers_6_5_flonum_79();
tvectors_declarations____r4_numbers_6_5_flonum_63();
initialize_constants____r4_numbers_6_5_flonum_246();
require_initialization____r4_numbers_6_5_flonum_101 = BFALSE;
return BUNSPEC;
} else {return BUNSPEC;
}}

obj_t initialize_imported_modules____r4_numbers_6_5_flonum_79()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____r4_numbers_6_5_flonum_246()
{return BUNSPEC;
}

obj_t tvectors_declarations____r4_numbers_6_5_flonum_63()
{return BUNSPEC;
}

bool_t real____r4_numbers_6_5_flonum_6(obj_t obj_670)
{if(INTEGERP(obj_670)){return ((bool_t)1);
} else {return REALP(obj_670);
}}

obj_t _real____r4_numbers_6_5_flonum_125(obj_t env_947, obj_t obj_948)
{return BBOOL(real____r4_numbers_6_5_flonum_6(obj_948));
}

bool_t flonum____r4_numbers_6_5_flonum_50(obj_t obj_671)
{return REALP(obj_671);
}

obj_t _flonum____r4_numbers_6_5_flonum_237(obj_t env_949, obj_t obj_950)
{return BBOOL(flonum____r4_numbers_6_5_flonum_50(obj_950));
}

bool_t __fl___r4_numbers_6_5_flonum_249(double r1_672, double r2_673)
{return (r1_672==r2_673);
}

obj_t __fl___r4_numbers_6_5_flonum_70(obj_t env_951, obj_t r1_952, obj_t r2_953)
{return BBOOL(__fl___r4_numbers_6_5_flonum_249(REAL_TO_DOUBLE(r1_952), REAL_TO_DOUBLE(r2_953)));
}

bool_t __fl___r4_numbers_6_5_flonum_203(double r1_674, double r2_675)
{return (r1_674<r2_675);
}

obj_t __fl___r4_numbers_6_5_flonum_163(obj_t env_954, obj_t r1_955, obj_t r2_956)
{return BBOOL(__fl___r4_numbers_6_5_flonum_203(REAL_TO_DOUBLE(r1_955), REAL_TO_DOUBLE(r2_956)));
}

bool_t __fl___r4_numbers_6_5_flonum_94(double r1_676, double r2_677)
{return (r1_676>r2_677);
}

obj_t __fl___r4_numbers_6_5_flonum_194(obj_t env_957, obj_t r1_958, obj_t r2_959)
{return BBOOL(__fl___r4_numbers_6_5_flonum_94(REAL_TO_DOUBLE(r1_958), REAL_TO_DOUBLE(r2_959)));
}

bool_t ___fl___r4_numbers_6_5_flonum_53(double r1_678, double r2_679)
{return (r1_678<=r2_679);
}

obj_t ___fl___r4_numbers_6_5_flonum_5(obj_t env_960, obj_t r1_961, obj_t r2_962)
{return BBOOL(___fl___r4_numbers_6_5_flonum_53(REAL_TO_DOUBLE(r1_961), REAL_TO_DOUBLE(r2_962)));
}

bool_t ___fl___r4_numbers_6_5_flonum_155(double r1_680, double r2_681)
{return (r1_680>=r2_681);
}

obj_t ___fl___r4_numbers_6_5_flonum_72(obj_t env_963, obj_t r1_964, obj_t r2_965)
{return BBOOL(___fl___r4_numbers_6_5_flonum_155(REAL_TO_DOUBLE(r1_964), REAL_TO_DOUBLE(r2_965)));
}

bool_t zerofl____r4_numbers_6_5_flonum_180(double r_682)
{return (r_682==0.00000000000);
}

obj_t _zerofl____r4_numbers_6_5_flonum_36(obj_t env_966, obj_t r_967)
{return BBOOL(zerofl____r4_numbers_6_5_flonum_180(REAL_TO_DOUBLE(r_967)));
}

bool_t positivefl____r4_numbers_6_5_flonum_194(double r_683)
{return (r_683>=0.00000000000);
}

obj_t _positivefl____r4_numbers_6_5_flonum_113(obj_t env_968, obj_t r_969)
{return BBOOL(positivefl____r4_numbers_6_5_flonum_194(REAL_TO_DOUBLE(r_969)));
}

bool_t negativefl____r4_numbers_6_5_flonum_177(double r_684)
{return (r_684<0.00000000000);
}

obj_t _negativefl____r4_numbers_6_5_flonum_240(obj_t env_970, obj_t r_971)
{return BBOOL(negativefl____r4_numbers_6_5_flonum_177(REAL_TO_DOUBLE(r_971)));
}

double __fl___r4_numbers_6_5_flonum_179(double r1_685, double r2_686)
{return (r1_685+r2_686);
}

obj_t __fl___r4_numbers_6_5_flonum_233(obj_t env_972, obj_t r1_973, obj_t r2_974)
{return make_real(__fl___r4_numbers_6_5_flonum_179(REAL_TO_DOUBLE(r1_973), REAL_TO_DOUBLE(r2_974)));
}

double __fl___r4_numbers_6_5_flonum_139(double r1_687, double r2_688)
{return (r1_687-r2_688);
}

obj_t __fl___r4_numbers_6_5_flonum_231(obj_t env_975, obj_t r1_976, obj_t r2_977)
{return make_real(__fl___r4_numbers_6_5_flonum_139(REAL_TO_DOUBLE(r1_976), REAL_TO_DOUBLE(r2_977)));
}

double __fl___r4_numbers_6_5_flonum_16(double r1_689, double r2_690)
{return (r1_689*r2_690);
}

obj_t __fl___r4_numbers_6_5_flonum_14(obj_t env_978, obj_t r1_979, obj_t r2_980)
{return make_real(__fl___r4_numbers_6_5_flonum_16(REAL_TO_DOUBLE(r1_979), REAL_TO_DOUBLE(r2_980)));
}

double __fl___r4_numbers_6_5_flonum_145(double r1_691, double r2_692)
{return (r1_691/r2_692);
}

obj_t __fl___r4_numbers_6_5_flonum_245(obj_t env_981, obj_t r1_982, obj_t r2_983)
{return make_real(__fl___r4_numbers_6_5_flonum_145(REAL_TO_DOUBLE(r1_982), REAL_TO_DOUBLE(r2_983)));
}

double negfl___r4_numbers_6_5_flonum(double r1_693)
{return NEG(r1_693);
}

obj_t _negfl___r4_numbers_6_5_flonum(obj_t env_984, obj_t r1_985)
{return make_real(negfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_985)));
}

double maxfl___r4_numbers_6_5_flonum(double r1_694, obj_t rn_695)
{{obj_t max_697;
obj_t rn_698;
{obj_t aux1324_1185;
max_697 = make_real(r1_694);
rn_698 = rn_695;
loop_696:
if(NULLP(rn_698))aux1324_1185 = max_697;
 else {if((REAL_TO_DOUBLE(CAR(rn_698))>REAL_TO_DOUBLE(max_697))){obj_t aux1093_700;
aux1093_700 = CAR(rn_698);
{obj_t aux1094_701;
aux1094_701 = CDR(rn_698);
{obj_t rn_1196;
obj_t max_1195;
max_1195 = aux1093_700;
rn_1196 = aux1094_701;
rn_698 = rn_1196;
max_697 = max_1195;
goto loop_696;
}}} else {obj_t aux1095_702;
aux1095_702 = CDR(rn_698);
{obj_t rn_1198;
rn_1198 = aux1095_702;
rn_698 = rn_1198;
goto loop_696;
}}}return REAL_TO_DOUBLE(aux1324_1185);
}}}

obj_t _maxfl___r4_numbers_6_5_flonum(obj_t env_986, obj_t r1_987, obj_t rn_988)
{return make_real(maxfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_987), rn_988));
}

double max_2fl___r4_numbers_6_5_flonum_248(double r1_703, double r2_704)
{if((r1_703>r2_704)){return r1_703;
} else {return r2_704;
}}

obj_t _max_2fl___r4_numbers_6_5_flonum_90(obj_t env_989, obj_t r1_990, obj_t r2_991)
{return make_real(max_2fl___r4_numbers_6_5_flonum_248(REAL_TO_DOUBLE(r1_990), REAL_TO_DOUBLE(r2_991)));
}

double min_2fl___r4_numbers_6_5_flonum_94(double r1_705, double r2_706)
{if((r1_705>r2_706)){return r2_706;
} else {return r1_705;
}}

obj_t _min_2fl___r4_numbers_6_5_flonum_63(obj_t env_992, obj_t r1_993, obj_t r2_994)
{return make_real(min_2fl___r4_numbers_6_5_flonum_94(REAL_TO_DOUBLE(r1_993), REAL_TO_DOUBLE(r2_994)));
}

double minfl___r4_numbers_6_5_flonum(double r1_707, obj_t rn_708)
{{obj_t min_710;
obj_t rn_711;
{obj_t aux1285_1154;
min_710 = make_real(r1_707);
rn_711 = rn_708;
loop_709:
if(NULLP(rn_711))aux1285_1154 = min_710;
 else {if((REAL_TO_DOUBLE(CAR(rn_711))<REAL_TO_DOUBLE(min_710))){obj_t aux1097_713;
aux1097_713 = CAR(rn_711);
{obj_t aux1098_714;
aux1098_714 = CDR(rn_711);
{obj_t rn_1165;
obj_t min_1164;
min_1164 = aux1097_713;
rn_1165 = aux1098_714;
rn_711 = rn_1165;
min_710 = min_1164;
goto loop_709;
}}} else {obj_t aux1103_715;
aux1103_715 = CDR(rn_711);
{obj_t rn_1167;
rn_1167 = aux1103_715;
rn_711 = rn_1167;
goto loop_709;
}}}return REAL_TO_DOUBLE(aux1285_1154);
}}}

obj_t _minfl___r4_numbers_6_5_flonum(obj_t env_995, obj_t r1_996, obj_t rn_997)
{return make_real(minfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_996), rn_997));
}

double absfl___r4_numbers_6_5_flonum(double r_716)
{if((r_716<0.00000000000)){return NEG(r_716);
} else {return r_716;
}}

obj_t _absfl___r4_numbers_6_5_flonum(obj_t env_998, obj_t r_999)
{return make_real(absfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_999)));
}

double floorfl___r4_numbers_6_5_flonum(double r_717)
{return floor(r_717);
}

obj_t _floorfl___r4_numbers_6_5_flonum(obj_t env_1000, obj_t r_1001)
{return make_real(floorfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_1001)));
}

double ceilingfl___r4_numbers_6_5_flonum(double r_718)
{return ceil(r_718);
}

obj_t _ceilingfl___r4_numbers_6_5_flonum(obj_t env_1002, obj_t r_1003)
{return make_real(ceilingfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_1003)));
}

double truncatefl___r4_numbers_6_5_flonum(double r_719)
{{bool_t test1248_1133;
{double r2_932;
r2_932 = 0.00000000000;
test1248_1133 = (r_719<r2_932);
}if(test1248_1133){return ceil(r_719);
} else {return floor(r_719);
}}}

obj_t _truncatefl___r4_numbers_6_5_flonum(obj_t env_1004, obj_t r_1005)
{return make_real(truncatefl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_1005)));
}

double roundfl___r4_numbers_6_5_flonum(double r_720)
{{double aux1104_721;
aux1104_721 = (r_720+0.500000000000);
return floor(aux1104_721);
}}

obj_t _roundfl___r4_numbers_6_5_flonum(obj_t env_1006, obj_t r_1007)
{return make_real(roundfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_1007)));
}

double expfl___r4_numbers_6_5_flonum(double x_722)
{return exp(x_722);
}

obj_t _expfl___r4_numbers_6_5_flonum(obj_t env_1008, obj_t x_1009)
{return make_real(expfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1009)));
}

double logfl___r4_numbers_6_5_flonum(double x_723)
{return log(x_723);
}

obj_t _logfl___r4_numbers_6_5_flonum(obj_t env_1010, obj_t x_1011)
{return make_real(logfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1011)));
}

double sinfl___r4_numbers_6_5_flonum(double x_724)
{return sin(x_724);
}

obj_t _sinfl___r4_numbers_6_5_flonum(obj_t env_1012, obj_t x_1013)
{return make_real(sinfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1013)));
}

double cosfl___r4_numbers_6_5_flonum(double x_725)
{return cos(x_725);
}

obj_t _cosfl___r4_numbers_6_5_flonum(obj_t env_1014, obj_t x_1015)
{return make_real(cosfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1015)));
}

double tanfl___r4_numbers_6_5_flonum(double x_726)
{return tan(x_726);
}

obj_t _tanfl___r4_numbers_6_5_flonum(obj_t env_1016, obj_t x_1017)
{return make_real(tanfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1017)));
}

double asinfl___r4_numbers_6_5_flonum(double x_727)
{return asin(x_727);
}

obj_t _asinfl___r4_numbers_6_5_flonum(obj_t env_1018, obj_t x_1019)
{return make_real(asinfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1019)));
}

double acosfl___r4_numbers_6_5_flonum(double x_728)
{return acos(x_728);
}

obj_t _acosfl___r4_numbers_6_5_flonum(obj_t env_1020, obj_t x_1021)
{return make_real(acosfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1021)));
}

double atanfl___r4_numbers_6_5_flonum(double x_729, obj_t y_730)
{if(NULLP(y_730)){return atan(x_729);
} else {obj_t y_731;
y_731 = CAR(y_730);
{double y_940;
y_940 = REAL_TO_DOUBLE(y_731);
return atan2(x_729, y_940);
}}}

obj_t _atanfl___r4_numbers_6_5_flonum(obj_t env_1022, obj_t x_1023, obj_t y_1024)
{return make_real(atanfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(x_1023), y_1024));
}

double atan_1fl___r4_numbers_6_5_flonum_253(double x_732)
{return atan(x_732);
}

obj_t _atan_1fl___r4_numbers_6_5_flonum_58(obj_t env_1025, obj_t x_1026)
{return make_real(atan_1fl___r4_numbers_6_5_flonum_253(REAL_TO_DOUBLE(x_1026)));
}

double atan_2fl___r4_numbers_6_5_flonum_45(double x_733, double y_734)
{{bool_t t_735;
if((x_733==0.00000000000)){t_735 = (y_734==0.00000000000);
} else {t_735 = ((bool_t)0);
}if(t_735){FAILURE(string1109___r4_numbers_6_5_flonum,string1108___r4_numbers_6_5_flonum,real1110___r4_numbers_6_5_flonum);} else {return atan2(x_733, y_734);
}}}

obj_t _atan_2fl___r4_numbers_6_5_flonum_129(obj_t env_1027, obj_t x_1028, obj_t y_1029)
{return make_real(atan_2fl___r4_numbers_6_5_flonum_45(REAL_TO_DOUBLE(x_1028), REAL_TO_DOUBLE(y_1029)));
}

double atan_2fl_ur___r4_numbers_6_5_flonum_133(double x_736, double y_737)
{return atan2(x_736, y_737);
}

obj_t _atan_2fl_ur___r4_numbers_6_5_flonum_142(obj_t env_1030, obj_t x_1031, obj_t y_1032)
{return make_real(atan_2fl_ur___r4_numbers_6_5_flonum_133(REAL_TO_DOUBLE(x_1031), REAL_TO_DOUBLE(y_1032)));
}

double sqrtfl___r4_numbers_6_5_flonum(double r_738)
{if((r_738<0.00000000000)){FAILURE(string1107___r4_numbers_6_5_flonum,string1108___r4_numbers_6_5_flonum,make_real(r_738));} else {return sqrt(r_738);
}}

obj_t _sqrtfl___r4_numbers_6_5_flonum(obj_t env_1033, obj_t r_1034)
{return make_real(sqrtfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r_1034)));
}

double sqrtfl_ur___r4_numbers_6_5_flonum_31(double r_739)
{return sqrt(r_739);
}

obj_t _sqrtfl_ur___r4_numbers_6_5_flonum_135(obj_t env_1035, obj_t r_1036)
{return make_real(sqrtfl_ur___r4_numbers_6_5_flonum_31(REAL_TO_DOUBLE(r_1036)));
}

double exptfl___r4_numbers_6_5_flonum(double r1_740, double r2_741)
{return pow(r1_740, r2_741);
}

obj_t _exptfl___r4_numbers_6_5_flonum(obj_t env_1037, obj_t r1_1038, obj_t r2_1039)
{return make_real(exptfl___r4_numbers_6_5_flonum(REAL_TO_DOUBLE(r1_1038), REAL_TO_DOUBLE(r2_1039)));
}

double string__real___r4_numbers_6_5_flonum_238(char * string_742)
{return strtod(string_742, 0);
}

obj_t _string__real___r4_numbers_6_5_flonum_76(obj_t env_1040, obj_t string_1041)
{return make_real(string__real___r4_numbers_6_5_flonum_238(BSTRING_TO_STRING(string_1041)));
}

char * real__string___r4_numbers_6_5_flonum_69(double real_743)
{return real_to_string(real_743);
}

obj_t _real__string___r4_numbers_6_5_flonum_123(obj_t env_1042, obj_t real_1043)
{return string_to_bstring(real__string___r4_numbers_6_5_flonum_69(REAL_TO_DOUBLE(real_1043)));
}

