;; ---------------------------------------------------------------------- ;;
;; FICHIER               : driver.scm                                     ;;
;; DATE DE CREATION      : Mon Jul  3 11:47:26 1995                       ;;
;; DERNIERE MODIFICATION : Thu Jul  6 10:44:58 1995                       ;;
;; ---------------------------------------------------------------------- ;;
;; Copyright (c) 1995 Dominique Boucher                                   ;;
;; ---------------------------------------------------------------------- ;;
;; Le moteur des analyseurs syntaxiques LALR(1)...                        ;;
;; ---------------------------------------------------------------------- ;;

(module __lalr_driver

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
            (__bigloo                  "Llib/bigloo.scm")
            (__tvector                 "Llib/tvector.scm")
            (__structure               "Llib/struct.scm")
            (__tvector                 "Llib/tvector.scm")
            (__rgc                     "Rgc/runtime.scm")
            (__r4_numbers_6_5          "Ieee/number.scm")
            (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
            (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
            (__r4_characters_6_6       "Ieee/char.scm")
            (__r4_equivalence_6_2      "Ieee/equiv.scm")
            (__r4_booleans_6_1         "Ieee/boolean.scm")
            (__r4_symbols_6_4          "Ieee/symbol.scm")
            (__r4_strings_6_7          "Ieee/string.scm")
            (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
            (__r4_input_6_10_2         "Ieee/input.scm")
            (__r4_control_features_6_9 "Ieee/control.scm")
            (__r4_vectors_6_8          "Ieee/vector.scm")
            (__r4_ports_6_10_1         "Ieee/port.scm")
            (__r4_output_6_10_3        "Ieee/output.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export (__push stack sp new-cat goto-table lval)
           (__make-parser action-table reduction-table)
           *debug-parser*))

(define *max-stack-size*       500)
(define *stack-size-increment* 200)
(define *debug-parser*         #f)

(define (grow-stack! v)
  (let* ((len (vector-length v))
	 (v2  (make-vector (+ len *stack-size-increment*) 0)))
    (let loop ((i 0))
      (if (< i len)
	  (begin
	    (vector-set! v2 i (vector-ref v i))
	    (loop (+ i 1)))
	  v2))))

(define (__push stack sp new-cat goto-table lval)
  (let* ((state     (vector-ref stack sp))
	 (new-state (cdr (assq new-cat (vector-ref goto-table state))))
	 (new-sp    (+ sp 2)))
    (vector-set! stack new-sp new-state)
    (vector-set! stack (- new-sp 1) lval)
    new-sp)))


(define (__make-parser action-table reduction-function)
  (lambda (rgc input-port is-eof?)
     
    (define (action x l)
      (let ((y (assq x l)))
	(if y 
	    (cdr y) 
	    (cdar l))))
  
    (let ((stack (make-vector *max-stack-size* 0))
	  (state   #f)
	  (input   #f)
	  (in      #f)
	  (attr    #f)
	  (acts    #f)
	  (act     #f)
	  (eof?    #f))
      
      (let loop ((sp 0))
	(set! state (vector-ref stack sp))
	(set! acts (vector-ref action-table state))
	
	(if (null? (cdr acts))
	    (set! act (cdar acts))
	    (begin
	      (if (not input)
		  (set! input (read/rp rgc input-port)))
	      
	      (cond 
	       ((is-eof? input)
		(set! in '*eoi*)
		(set! attr #f)
		(set! eof? #t))
	       ((pair? input)
		(set! in (car input))
		(set! attr (cdr input)))
	       (else
		(set! in input)
		(set! attr #f)))
	      
	      (set! act (action in acts))))
	  
	  (if *debug-parser*
	      (begin
		(display "** PARSER TRACE: input=") 
		(display in)
		(display "  state=") 
		(display state) 
		(display "  sp=")
		(display sp) 
		(newline)))

	  (cond

	   ;; Input succesfully parsed
	   ((eq? act 'accept)
	    (vector-ref stack 1))

	   ;; Syntax error in input
	   ((eq? act '*error*)
	    (let ((msg (string-append
			"parse error (unexpected token `"
			(if (symbol? in)
			    (symbol->string in)
			    (list->string (list in)))
			"')")))
	      (error "parser" msg input)))

	   ;; Shift current token on top of the stack
	   ((>= act 0)
	    (if (>= sp (- (vector-length stack) 2))
		(set! stack (grow-stack! stack)))
	    (vector-set! stack (+ sp 1) attr)
	    (vector-set! stack (+ sp 2) act)
	    (if (not eof?)
		(set! input #f))
	    (loop (+ sp 2)))

	   ;; Reduce by rule (- act)
	   (else 
	    (loop (reduction-function (- act) stack sp))))))))

