;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Llib/bexit.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 31 15:00:41 1995                          */
;*    Last change :  Mon Jul 10 14:36:54 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `bind-exit' manipulation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bexit

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro obj  push-exit! (exit bool) "PUSH_EXIT")
	    (macro obj  pop-exit! ()           "POP_EXIT")
	    (macro exit exitd->exit (obj)      "EXITD_TO_EXIT")
	    (macro bool exitd-user? (obj)      "EXITD_USERP")
	    
	    (export *exitd-top* "exitd_top"))

   (export  *exitd-top*
	    (val-from-exit?      ::obj)
	    (unwind-until! exitd ::obj)))

;*---------------------------------------------------------------------*/
;*    *exitd-top* ...                                                  */
;*---------------------------------------------------------------------*/
(define *exitd-top* #f)

;*---------------------------------------------------------------------*/
;*    *protected-val* ...                                              */
;*---------------------------------------------------------------------*/
(define *protected-val* (cons #unspecified #unspecified))

;*---------------------------------------------------------------------*/
;*    val-from-exit? ...                                               */
;*---------------------------------------------------------------------*/
(define (val-from-exit? val)
   (eq? val *protected-val*))

;*---------------------------------------------------------------------*/
;*    unwind-until! ...                                                */
;*---------------------------------------------------------------------*/
(define (unwind-until! exitd val)
   (let loop ()
      (if (eq? *exitd-top* #f)
	  (error "unwind-until!" "exit out of dynamic scope" #unspecified)
	  (let ((exit-top *exitd-top*))
	     (pop-exit!)
	     (cond
		((eq? exit-top exitd)
		 (jump-exit (exitd->exit exit-top) val))
		((not (exitd-user? exit-top))
		 (set-car! *protected-val* exitd)
		 (set-cdr! *protected-val* val)
		 (jump-exit (exitd->exit exit-top) *protected-val*))
		(else
		 (loop)))))))
