#include "cthugha.h"
#include "keys.h"

#include <vga.h>
#include <vgagl.h>
#include <stdio.h>
#undef COLORS
#include <ncurses.h>

/* This file is used for the "normal" cthugha-L and for the cthugha-X11.
 *
 * If CTH_X11 is defined, then the version for X11 should be generated.
 */


#ifdef CTH_X11

#include "libsx.h"

int x11_key = Z_NOKEY;
/*
 * Handler for key-board
 */
void keys_x11(Widget w, char *input, int up_or_down, void *data) {
    int key = Z_NOKEY;

    if ( !up_or_down)			/* 0 press, 1 release */
	return;

    x11_key = Z_NOKEY;

    /* check for keys in graph-window */
    if ( input[1] == '\0') 
	key = translate_key(input[0]);
    else {
	if ( strcasecmp( input, "F1") == 0)
	    key = Z_HELP;
	else if ( strcasecmp( input, "F2") == 0)
	    key = Z_DISPOPTION;
	else if ( strcasecmp( input, "F3") == 0)
	    key = Z_WAVEOPTION;
	else if ( strcasecmp( input, "F4") == 0)
	    key = Z_FLAMEOPTION;
	else if ( strcasecmp( input, "F5") == 0)
	    key = Z_TRANSOPTION;
	else if ( strcasecmp( input, "F6") == 0)
	    key = Z_PALOPTION;
	else if ( strcasecmp( input, "F7") == 0)
	    key = Z_PCXOPTION;
	else if ( strcasecmp( input, "Return") == 0)
	    key = Z_ENTER;
	else if ( strcasecmp( input, "Up") == 0)
	    key = Z_UP;
	else if ( strcasecmp( input, "Down") == 0)
	    key = Z_DOWN;
	else if ( strcasecmp( input, "Prior") == 0)
	    key = Z_PGUP;
	else if ( strcasecmp( input, "Next") == 0)
	    key = Z_PGDN;
    }

    x11_key = key;
}
#endif
 
int key_esc = 1;		/* disable/enable ESC-key. When enable it 
				   sometimes happens that when pressing
				   functions keys or cursor keys cthugha
				   only get the leading ESC and quits. */
int translate_key(int key) {

    switch(key) {
    case 0:	case -1:	return Z_NOKEY;
    case 27:			return (key_esc ? Z_ESC : Z_NOKEY);
    case KEY_F(1): case '?': case '': case '1':
				return Z_HELP;
    case KEY_F(2):		return Z_DISPOPTION;
    case KEY_F(3): case '3':	return Z_WAVEOPTION;
    case KEY_F(4):		return Z_FLAMEOPTION;
    case KEY_F(5):		return Z_TRANSOPTION;
    case KEY_F(6):		return Z_PALOPTION;
    case KEY_F(7):		return Z_PCXOPTION;

    case '8':			return Z_CD_PAUSE;
    case '9':			return Z_CD_NEXT;
    case '7':			return Z_CD_PREV;
    case '5':			return Z_CD_STOP;
    case '2':			return Z_CD_EJECT;
    case '6':			return Z_CD_FWD;
    case '4':			return Z_CD_REV;

    case KEY_UP:		return Z_UP;
    case KEY_DOWN:		return Z_DOWN;
    case KEY_PPAGE:		return Z_PGUP;
    case KEY_NPAGE:		return Z_PGDN;
    case KEY_HOME:		return Z_HOME;
    case KEY_END:		return Z_END;
    case KEY_RIGHT:		return Z_RIGHT;
    case KEY_LEFT:		return Z_LEFT;

    case KEY_PRINT: case '#':	return Z_SCREEN_DUMP;

    case 10:			return Z_ENTER;
    case 'q': case 'Q':		return Z_ESC;

    case 'w':			return Z_WAVE;
    case 'W':			return Z_WAVE_R;
    case 'b':			return Z_TABLE;
    case 'B':			return Z_TABLE_R;
    case 'p':			return Z_PALETTE;
    case 'P':			return Z_PALETTE_R;
    case 'd':			return Z_DISPLAY;
    case 'D':			return Z_DISPLAY_R;
    case 'f':			return Z_FLAME;
    case 'F':			return Z_FLAME_R;
    case 'g': case 'G':		return Z_FLAME_GENERAL;
    case 'x':	 		return Z_PCX;
    case 'X':			return Z_PCX_R;
    case 't':			return Z_TRANSLATE;
    case 'T':			return Z_TRANSLATE_R;
    case 'm':			return Z_MASSAGE;
    case 'M':			return Z_MASSAGE_R;
    case 's': case 'S':		return Z_FFT;
		
    case 'l': case 'L':		return Z_LOCK;		
    case 'i': case 'I':		return Z_INFORMATION;

    case 'c': case 'C':		return Z_CD;
		
    case '<': case ',':		return Z_NOISE_DN;
    case '>': case '.':		return Z_NOISE_UP;
		
    case '-': 			return Z_SAMPLE_DN;
    case '+':			return Z_SAMPLE_UP;
		
    case '*':			return Z_STEREO;
		
    case ' ':			return Z_SPACE;
		
    case 'a': case 'A':		return Z_ADDINI;

    case 'n': case 'N':		return Z_REQUEST_NET;

    case 'o': case 'O':		return Z_OPTIONS;
    }
    return Z_OTHERKEY; 
}

/* Now I'm using ncurses to read from the keyboard 
   In version 0.1 I used vga_getkey, but getch is much better.
   There is a 1 sec. delay when only ESC is pressed. 
   */

int getkey() {
    static int next_key = Z_NOKEY;
    int key;

#ifdef CTH_X11
    if ( x11_key != Z_NOKEY) {
	int key = x11_key; x11_key = Z_NOKEY;
	return key;
    }
#endif

    key = next_key;
    next_key = getch();

    if( (key == 27) && (next_key > 0)) {
	/* seems like an unrecognized special key. skip everything still 
	 waiting */
	while( (next_key = getch()) > 0);

	return Z_OTHERKEY;
    }

    return translate_key( key );
}





