#include "cthugha.h"
#include "sound.h"
#include "net_sound.h"

#include <errno.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>

int REQ_PORT = 5555;
int CLT_PORT = 5556;
int SRV_PORT = 5555;

/* 
 * create an PF_INET socket 
 */
int make_socket(int type, short port) {
    int sock;
    struct sockaddr_in s_addr;

    /* create socket for request */
    if( (sock = socket(PF_INET, type, 0)) < 0) {
	printfee("Can not create socket.");
	return -1;
    }

    /* bind socket */
    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(port);
    s_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if( bind(sock, (struct sockaddr*)&s_addr, sizeof(s_addr)) < 0) {
	printfee("Can not bind socket");
	close(sock);
	return -1;
    }

    return sock;
}

/*
 * Find local address
 */
long get_local_addr() {
    char name[255];
    char domain[255];
    struct hostent * hostinfo;

    /* construct name of local machine */
    gethostname( name, 255);
    strcat(name, ".");
    getdomainname( domain, 255);
    strcat(name, domain);

    printfv("  local name   : %s\n", name);

    /* lok up address */
    hostinfo = gethostbyname(name);

    printfv("  local address: %lx\n", *(long*)hostinfo->h_addr);

    return *(long*)hostinfo->h_addr;
}

/* 
 * create data-socket 
 */
int init_net_sound() {
    printfv("Initializing net-sound...\n");

    /* create socket */
    if( (dsp_des = make_socket(SOCK_DGRAM, CLT_PORT)) < 0)
	printfee("Can not create socket.");

    /* set to non-blocking mode */
    fcntl( dsp_des, F_SETFL, O_NONBLOCK);
	
    /* send request to server */
    net_request(0); 

    return 0;
}

/* 
 * send a request over the net 
 * request: 0: connect
 *          1: disconnect
 */
int net_request(int request) {
    struct sockaddr_in s_addr;
    struct hostent * hostinfo;
    int request_socket;
    char req[65];

    /* create request-string */
    switch( request) {
    case 0:			/* connect */
	/* request connection from host "dsp_file" */
	sprintf(req, "connect %ld %d", get_local_addr(), CLT_PORT);
	break;
    case 1:
	/* request for disconnect on exit */
	sprintf(req, "disconnect %ld %d", get_local_addr(), CLT_PORT);
	break;
    default:
	/* unknown request */
	return 1;
    }
    printfv("  Requesting: %c%s%c.\n", 34, req, 34);

    /* create socket for request */
    if( (request_socket = make_socket(SOCK_STREAM, CLT_PORT2)) < 0)
	printfee("Can not create request socket.");

    /* create address of server */
    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(SRV_PORT);
    hostinfo = gethostbyname( dsp_file );
    if ( hostinfo == NULL) {
	printfee("Could not find host %c%s%c.\n", 34,dsp_file,34);
	close(request_socket);
	return 1;
    } 
    s_addr.sin_addr = *(struct in_addr*)hostinfo->h_addr;
	
    /* connect to server */
    if( connect(request_socket, 
		(struct sockaddr*) &s_addr, 
		sizeof(struct sockaddr) ) < 0) {
	printfee("Can not connect to server %s.\n", dsp_file);
	close(request_socket);
	return 0;
    }

    /* sending request */
    printfv("  Sending request %c%s%c\n", 34,req,34);
    strcat( req, "\n");
    if( send(request_socket, req, 64, 0) <= 0) {
	printfee("Can not send request.");
    }

    sleep(1);

    /* closing socket */
    if( shutdown(request_socket, 2) )
	printfee("Can not shutdown request-socket.");

    if( close(request_socket) )
	printfee("Can not close request-socket.");

    return 0;
}


/* 
 * read sound from network 
 */
int net_sound_read() {
    int nr_read;

    while( (nr_read = recv(dsp_des, sound_data, 2 * BUFF_WIDTH, 0) ) >= 0);
    return 0;
}

/*
 * sent disconnect-request
 */
int exit_net_sound() {
    net_request(1);
    return 0;
}




