/*
    CTHUGHA-L							net_sound.h
	
    Funktions that deal with sound transmitted over a network.
	
*/

#ifndef __NET_SOUND_H__
#define __NET_SOUND_H__

int make_socket(int type, short port);

/*
 * stuff for the client
 */
int init_net_sound();				/* create data-socket */
int net_request(int req);			/* send request to server */
int net_sound_read();				/* read sound from network */
int exit_net_sound();	
extern int SRV_PORT;				/* port used by server */
extern int CLT_PORT;
#define CLT_PORT2	(CLT_PORT+1)

/*
 * stuff for the server
 */
extern int REQ_PORT;				/* port used by server */

int server_accept();
int init_server();
int exit_server();
int broadcast_sound();
int print_clients();

#define MAX_CLIENTS	255
extern struct sockaddr_in client_addrs[MAX_CLIENTS];
extern int nr_clients;

extern int srv_wait_time;
extern int server;

#endif
