/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** globSet.h
**
** based on set_template.h
*/

# ifndef globSet_H
# define globSet_H

abst_typedef sRefSet globSet;

/*@iter globSet_allElements (sef globSet s, yield exposed sRef el); @*/
# define globSet_allElements(x, m_el)  sRefSet_allElements(x, m_el)
# define end_globSet_allElements           end_sRefSet_allElements

extern int globSet_size (/*@sef@*/ globSet s);
# define globSet_size(s) (sRefSet_size (s))

extern bool globSet_isEmpty (/*@sef@*/ globSet s);
# define globSet_isEmpty(s) (globSet_size (s) == 0)

extern /*@only@*/ globSet globSet_new (void) /*@*/ ;
extern globSet globSet_insert (/*@returned@*/ globSet s, sRef el) 
   /*@modifies s@*/ ;
extern bool globSet_member (globSet s, sRef el) /*@*/ ;
extern /*@exposed@*/ sRef globSet_lookup (globSet s, sRef el) /*@*/ ;
extern void globSet_free (/*@only@*/ /*@only@*/ globSet s);
extern /*@only@*/ cstring globSet_unparse (globSet ll) /*@*/ ;
extern /*@only@*/ cstring globSet_dump (globSet ll) /*@*/ ;
extern /*@only@*/ globSet globSet_undump (char **s) /*@modifies *s@*/ ;
extern globSet 
  globSet_copy (/*@returned@*/ globSet s1, /*@exposed@*/ globSet s2) 
  /*@modifies s1@*/ ;

extern /*@only@*/ globSet globSet_newCopy (globSet s1) /*@*/ ;
extern bool globSet_hasStatic (globSet s) /*@*/ ;

extern int globSet_compare (globSet l1, globSet l2);
extern void globSet_clear (globSet g);

/*@constant null globSet globSet_undefined;@*/
# define globSet_undefined sRefSet_undefined

extern /*@falsenull@*/ bool globSet_isDefined (/*@null@*/ globSet s) /*@*/ ;
extern /*@truenull@*/ bool globSet_isUndefined (/*@null@*/ globSet s) /*@*/ ;

# define globSet_isDefined(s)   (sRefSet_isDefined (s))
# define globSet_isUndefined(s) (sRefSet_isUndefined (s))

# else
# error "Multiple include"
# endif

