/****************************************************************************
** $Id: qclipbrd.h,v 2.0 1996/09/24 10:15:47 agulbra Exp $
**
** Definition of QClipboard class
**
** Created : 960430
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QCLIPBRD_H
#define QCLIPBRD_H

#include "qobject.h"


class QClipboard : public QObject
{
    Q_OBJECT
private:
    QClipboard( QObject *parent=0, const char *name=0 );
   ~QClipboard();

public:
    void	clear();

    void       *data( const char *format ) const;
    void	setData( const char *format, void * );

    const char *text()	 const;
    void	setText( const char * );
    QPixmap    *pixmap() const;
    void	setPixmap( const QPixmap & );

signals:
    void	dataChanged();

private slots:
    void	ownerDestroyed();

protected:
    void	connectNotify( const char * );
    bool	event( QEvent * );

    friend class QApplication;

private:	// Disabled copy constructor and operator=
    QClipboard( const QClipboard & ) {}
    QClipboard &operator=( const QClipboard & ) { return *this; }
};


#endif // QCLIPBRD_H
